/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.topology;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.common.DataRetrievalException;
import com.sun.netstorage.mgmt.nsmui.topology.TopologyConstants;
import com.sun.netstorage.mgmt.nsmui.topology.ZoneUtil;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.NSMPages;
import com.sun.netstorage.mgmt.nsmui.util.SeverityColumnComparator;
import com.sun.netstorage.mgmt.nsmui.util.SmartColumnComparator;
import com.sun.netstorage.mgmt.nsmui.util.SmartComparator;
import com.sun.netstorage.mgmt.nsmui.util.TableColumn;
import com.sun.netstorage.mgmt.services.topology.FabricTopology;
import com.sun.netstorage.mgmt.services.topology.SanTopology;
import com.sun.netstorage.mgmt.services.topology.TSTopologyNode;
import com.sun.netstorage.mgmt.services.topology.TopologyGraph;
import com.sun.netstorage.mgmt.services.topology.Zone;
import java.util.Arrays;

public final class FabricInventoryCommand
implements TopologyConstants {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.topology.Localization";
    private static final TableColumn[] COLUMNS = new TableColumn[6];
    public static final int FABRIC_COLUMN = 0;
    public static final int STATUS_COLUMN = 1;
    public static final int SWITCHES_COLUMN = 2;
    public static final int HOSTS_COLUMN = 3;
    public static final int STORAGE_COLUMN = 4;
    public static final int ZONES_COLUMN = 5;
    static final int DEFAULT_SORT_COL = 1;
    private final SanTopology topology;
    private final boolean htmlOk;
    private String stubDB;
    private String[] fabricNames;
    private String[][] fabricData;
    private int hostCount;
    private int switchCount;
    private int storageCount;

    public static TableColumn[] getColumns() {
        if (COLUMNS[0] == null) {
            FabricInventoryCommand.COLUMNS[0] = new TableColumn(Localization.getString(BUNDLE, "fabricColumn"), true, "\"left\"", true);
            FabricInventoryCommand.COLUMNS[1] = new TableColumn(Localization.getString(BUNDLE, "statusColumn"), true, "\"right\"");
            FabricInventoryCommand.COLUMNS[2] = new TableColumn(Localization.getString(BUNDLE, "switchesColumn"), false, "\"left\"");
            FabricInventoryCommand.COLUMNS[3] = new TableColumn(Localization.getString(BUNDLE, "hostsColumn"), true, "\"right\"");
            FabricInventoryCommand.COLUMNS[4] = new TableColumn(Localization.getString(BUNDLE, "storageColumn"), true, "\"right\"");
            FabricInventoryCommand.COLUMNS[5] = new TableColumn(Localization.getString(BUNDLE, "zonesColumn"), false, "\"left\"");
        }
        return COLUMNS;
    }

    public FabricInventoryCommand(SanTopology sanTopology, boolean bl) {
        if (sanTopology == null) {
            throw new IllegalArgumentException("topology == null");
        }
        this.topology = sanTopology;
        this.htmlOk = bl;
    }

    public void setStubDB(String string) {
        this.stubDB = string;
    }

    public boolean run() throws DataRetrievalException {
        try {
            this.hostCount = 0;
            this.switchCount = 0;
            this.storageCount = 0;
            FabricTopology[] fabricTopologyArray = this.topology.getFabrics();
            boolean bl = this.htmlOk && fabricTopologyArray.length > 0;
            int n = bl ? 1 : 0;
            this.fabricData = new String[fabricTopologyArray.length + n][FabricInventoryCommand.getColumns().length];
            this.fabricNames = new String[fabricTopologyArray.length];
            int n2 = 0;
            while (n2 < fabricTopologyArray.length) {
                this.fabricNames[n2] = this.getFabricName(fabricTopologyArray[n2]);
                this.fabricData[n][0] = this.getFabricData(fabricTopologyArray[n2]);
                this.fabricData[n][1] = this.getStatusData(fabricTopologyArray[n2]);
                this.fabricData[n][2] = this.getSwitchesData(fabricTopologyArray[n2]);
                this.fabricData[n][3] = this.getHostsData(fabricTopologyArray[n2]);
                this.fabricData[n][4] = this.getStorageData(fabricTopologyArray[n2]);
                this.fabricData[n][5] = this.getZonesData(fabricTopologyArray[n2]);
                ++n2;
                ++n;
            }
            if (bl) {
                String string = NSMPages.getPageURL(NSMPages.TOPOLOGY_PAGE);
                if (this.stubDB != null) {
                    string = HTMLTags.modifyURLParameter(string, "stubDB", this.stubDB);
                }
                this.fabricData[0][0] = HTMLTags.getLinkTag(HTMLTags.modifyURLParameter(string, "fabric", "*"), Localization.getString(BUNDLE, "allFabricsRow"));
                TopologyGraph topologyGraph = this.topology.getAll();
                TSTopologyNode[] tSTopologyNodeArray = topologyGraph.getNodesByType("com.sun.netstorage.mgmt.component.model.domain.StorageHost");
                TSTopologyNode[] tSTopologyNodeArray2 = topologyGraph.getNodesByType("com.sun.netstorage.mgmt.component.model.domain.Switch");
                TSTopologyNode[] tSTopologyNodeArray3 = topologyGraph.getNodesByType("com.sun.netstorage.mgmt.component.model.domain.StorageSubSystem");
                this.hostCount = tSTopologyNodeArray == null ? 0 : tSTopologyNodeArray.length;
                this.switchCount = tSTopologyNodeArray2 == null ? 0 : tSTopologyNodeArray2.length;
                this.storageCount = tSTopologyNodeArray3 == null ? 0 : tSTopologyNodeArray3.length;
                this.fabricData[0][1] = "";
                this.fabricData[0][2] = String.valueOf(this.switchCount);
                this.fabricData[0][3] = String.valueOf(this.hostCount);
                this.fabricData[0][4] = String.valueOf(this.storageCount);
                this.fabricData[0][5] = "";
            }
            return true;
        }
        catch (Exception exception) {
            throw new DataRetrievalException(exception);
        }
    }

    public String getFabricName(int n) {
        return n < 0 || n >= this.fabricNames.length ? null : this.fabricNames[n];
    }

    private String getFabricName(FabricTopology fabricTopology) {
        return fabricTopology == null ? "" : fabricTopology.getFabricId().getFabricName();
    }

    private String getFabricData(FabricTopology fabricTopology) {
        if (fabricTopology == null) {
            return "";
        }
        String string = this.getFabricName(fabricTopology);
        String string2 = fabricTopology.getFabricId().getLogicalName();
        if (string2 == null) {
            string2 = string;
        }
        String string3 = NSMPages.getPageURL(NSMPages.TOPOLOGY_PAGE);
        if (this.stubDB != null) {
            string3 = HTMLTags.modifyURLParameter(string3, "stubDB", this.stubDB);
        }
        if (this.htmlOk && string3 != null) {
            return HTMLTags.getLinkTag(HTMLTags.modifyURLParameter(string3, "fabric", string), string2);
        }
        return string2;
    }

    private String getStatusData(FabricTopology fabricTopology) {
        if (fabricTopology == null) {
            return "";
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        TSTopologyNode[] tSTopologyNodeArray = fabricTopology.getPhysicalTopology().getNodes();
        int n5 = 0;
        while (n5 < tSTopologyNodeArray.length) {
            String string = tSTopologyNodeArray[n5].getType();
            if (string != null && (string.equals("com.sun.netstorage.mgmt.component.model.domain.NxPort") || string.equals("com.sun.netstorage.mgmt.component.model.domain.Switch") || string.equals("com.sun.netstorage.mgmt.component.model.domain.StorageHost") || string.equals("com.sun.netstorage.mgmt.component.model.domain.StorageSubSystem"))) {
                String string2 = HTMLTags.statusToAlarm((String)tSTopologyNodeArray[n5].getProperty("Status"));
                if (string2.equals("minor")) {
                    ++n;
                } else if (string2.equals("major")) {
                    ++n2;
                } else if (string2.equals("critical")) {
                    ++n3;
                } else if (string2.equals("down")) {
                    ++n4;
                }
            }
            ++n5;
        }
        if (n4 > 0) {
            return this.getAlarmData("down");
        }
        if (n3 > 0) {
            return this.getAlarmData("critical");
        }
        if (n2 > 0) {
            return this.getAlarmData("major");
        }
        if (n > 0) {
            return this.getAlarmData("minor");
        }
        return HTMLTags.getAlarmTitle("");
    }

    private String getAlarmData(String string) {
        return this.htmlOk ? HTMLTags.getAlarmImageTag(string) + "&nbsp;" + HTMLTags.getAlarmTitle(string) : HTMLTags.getAlarmTitle(string);
    }

    private String getSwitchesData(FabricTopology fabricTopology) {
        if (fabricTopology == null) {
            return "";
        }
        TSTopologyNode[] tSTopologyNodeArray = fabricTopology.getPhysicalTopology().getNodesByType("com.sun.netstorage.mgmt.component.model.domain.Switch");
        Arrays.sort(tSTopologyNodeArray, new SwitchNodeComparator());
        this.switchCount += tSTopologyNodeArray.length;
        String string = null;
        if (this.htmlOk) {
            string = NSMPages.getPageURL(NSMPages.SWITCH_DETAILS_PAGE);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < tSTopologyNodeArray.length) {
            if (n > 0) {
                stringBuffer.append(Localization.getString(BUNDLE, "itemSeparator"));
                stringBuffer.append(' ');
            }
            String string2 = (String)tSTopologyNodeArray[n].getProperty("Name");
            if (this.htmlOk && string != null) {
                stringBuffer.append(HTMLTags.getLinkTag(HTMLTags.modifyURLParameter(string, "id", tSTopologyNodeArray[n].getOid()), string2));
            } else {
                stringBuffer.append(string2);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private String getHostsData(FabricTopology fabricTopology) {
        if (fabricTopology == null) {
            return "";
        }
        TSTopologyNode[] tSTopologyNodeArray = fabricTopology.getPhysicalTopology().getNodesByType("com.sun.netstorage.mgmt.component.model.domain.StorageHost");
        this.hostCount += tSTopologyNodeArray.length;
        return Integer.toString(tSTopologyNodeArray.length);
    }

    private String getStorageData(FabricTopology fabricTopology) {
        if (fabricTopology == null) {
            return "";
        }
        TSTopologyNode[] tSTopologyNodeArray = fabricTopology.getPhysicalTopology().getNodesByType("com.sun.netstorage.mgmt.component.model.domain.StorageSubSystem");
        this.storageCount += tSTopologyNodeArray.length;
        return Integer.toString(tSTopologyNodeArray.length);
    }

    private String getZonesData(FabricTopology fabricTopology) {
        if (fabricTopology == null) {
            return "";
        }
        String string = null;
        if (this.htmlOk) {
            string = HTMLTags.modifyURLParameter(NSMPages.getPageURL(NSMPages.ZONE_DETAIL_PAGE), "fabric", fabricTopology.getFabricId().getFabricName());
            if (this.stubDB != null) {
                string = HTMLTags.modifyURLParameter(string, "stubDB", this.stubDB);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        Zone[] zoneArray = fabricTopology.getZones();
        String[] stringArray = new String[zoneArray.length];
        int n = 0;
        while (n < zoneArray.length) {
            stringArray[n] = zoneArray[n].getName();
            ++n;
        }
        Arrays.sort(stringArray, new SmartComparator());
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (n2 > 0) {
                stringBuffer.append(Localization.getString(BUNDLE, "itemSeparator"));
                stringBuffer.append(' ');
            }
            if (this.htmlOk && string != null) {
                stringBuffer.append(HTMLTags.getLinkTag(HTMLTags.modifyURLParameter(string, "zone", stringArray[n2]), ZoneUtil.localizeZoneName(stringArray[n2])));
            } else {
                stringBuffer.append(ZoneUtil.localizeZoneName(stringArray[n2]));
            }
            ++n2;
        }
        return stringBuffer.length() > 0 ? stringBuffer.toString() : Localization.getString(BUNDLE, "noZones");
    }

    public int getRowCount() {
        return this.fabricData != null ? this.fabricData.length : 0;
    }

    public String[][] getTableData(HTMLTags.TableInfo tableInfo) {
        Object object;
        int n;
        String[][] stringArray;
        String[][] stringArray2 = stringArray = this.fabricData != null ? this.fabricData : new String[0][0];
        if (tableInfo == null) {
            return stringArray;
        }
        if (tableInfo.sortColumn != 0) {
            n = Math.abs(tableInfo.sortColumn) - 1;
            object = null;
            if (n == 1) {
                object = new SeverityColumnComparator(tableInfo.sortColumn);
            } else if (n >= 0 && n <= FabricInventoryCommand.getColumns().length) {
                object = new SmartColumnComparator(tableInfo.sortColumn);
            }
            if (object != null) {
                Arrays.sort(stringArray, object);
            }
        }
        n = Math.min(tableInfo.pageSize, stringArray.length - tableInfo.firstRow);
        object = new String[n][];
        System.arraycopy(stringArray, tableInfo.firstRow, object, 0, n);
        return object;
    }

    public int getHostCount() {
        return this.hostCount;
    }

    public int getSwitchCount() {
        return this.switchCount;
    }

    public int getStorageCount() {
        return this.storageCount;
    }

    static class SwitchNodeComparator
    extends SmartComparator {
        SwitchNodeComparator() {
        }

        public int compare(Object object, Object object2) {
            try {
                return super.compare(((TSTopologyNode)object).getProperty("Name"), ((TSTopologyNode)object2).getProperty("Name"));
            }
            catch (Exception exception) {
                return ("" + object).compareTo("" + object2);
            }
        }
    }
}

