/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.topology;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.common.DataRetrievalException;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.topology.FabricInventoryCommand;
import com.sun.netstorage.mgmt.nsmui.topology.TopologyBaseServlet;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.NSMPages;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import com.sun.netstorage.mgmt.nsmui.util.UtilsWeb;
import com.sun.netstorage.mgmt.services.topology.SanTopology;
import com.sun.netstorage.mgmt.services.topology.TopologyServiceImpl;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class FabricInventoryServlet
extends TopologyBaseServlet {
    private static final String SINGLE_OK_PARAM = "singleOk";

    protected void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        int n = -123;
        try {
            n = Utils.getGuiPersistenceManager().getFabricCount();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 1 && httpServletRequest.getParameter(SINGLE_OK_PARAM) == null && httpServletRequest.getParameter("stubDB") == null) {
            String string = HTMLTags.modifyURLParameter(HTMLTags.createURL(httpServletRequest.getRequestURI(), httpServletRequest.getQueryString()), SINGLE_OK_PARAM, "true");
            HTMLTags.setBreadCrumbData(httpServletRequest.getSession(), NSMPages.FABRIC_INVENTORY_PAGE, string, null);
            String string2 = NSMPages.getPageURL(NSMPages.TOPOLOGY_PAGE);
            String string3 = httpServletRequest.getParameter("stubDB");
            if (string3 != null) {
                string2 = HTMLTags.modifyURLParameter(string2, "stubDB", string3);
            }
            UtilsWeb.redirect(string2, httpServletResponse);
            return;
        }
        if (!this.performSecurityCheck(httpServletRequest, httpServletResponse)) {
            return;
        }
        this.writeMasthead(httpServletRequest, httpServletResponse, NSMPages.FABRIC_INVENTORY_PAGE);
        PrintWriter printWriter = httpServletResponse.getWriter();
        try {
            TopologyServiceImpl topologyServiceImpl = TopologyServiceImpl.getInstance();
            SanTopology sanTopology = this.getSanTopology(topologyServiceImpl, httpServletRequest);
            FabricInventoryCommand fabricInventoryCommand = new FabricInventoryCommand(sanTopology, true);
            String string = httpServletRequest.getParameter("stubDB");
            fabricInventoryCommand.setStubDB(string);
            fabricInventoryCommand.run();
            HTMLTags.addTimestamp(httpServletRequest, "search for fabrics");
            int n2 = fabricInventoryCommand.getRowCount();
            HTMLTags.TableInfo tableInfo = HTMLTags.getTableInfo(httpServletRequest, 1, n2);
            String[][] stringArray = fabricInventoryCommand.getTableData(tableInfo);
            HTMLTags.addTimestamp(httpServletRequest, "get data from command");
            this.writeBreadCrumb(httpServletRequest, httpServletResponse, NSMPages.FABRIC_INVENTORY_PAGE, null, null);
            this.writePathsButton(printWriter, httpServletRequest, NSMPages.FABRIC_INVENTORY_PAGE, fabricInventoryCommand.getHostCount() > 0 && fabricInventoryCommand.getStorageCount() > 0, 16);
            printWriter.println(HTMLTags.getTableTitleTag(Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "fabricInventory"), tableInfo.firstRow, n2, tableInfo.pageSize));
            printWriter.println(HTMLTags.getTableTag(HTMLTags.createURL(httpServletRequest.getRequestURI(), httpServletRequest.getQueryString()), FabricInventoryCommand.getColumns(), stringArray, tableInfo.sortColumn, tableInfo.firstRow, n2, tableInfo.pageSize));
            HTMLTags.addTimestamp(httpServletRequest, "write table");
        }
        catch (NSMUIException nSMUIException) {
            printWriter.println(HTMLTags.getExceptionBoxTag(httpServletRequest, NSMPages.FABRIC_INVENTORY_PAGE, nSMUIException));
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            printWriter.println(HTMLTags.getExceptionBoxTag(httpServletRequest, NSMPages.FABRIC_INVENTORY_PAGE, new DataRetrievalException(throwable)));
        }
        this.writePageEnd(httpServletRequest, printWriter);
    }

    public String getServletInfo() {
        return "NSM Fabric Inventory Servlet";
    }
}

