/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.topology;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.common.DataRetrievalException;
import com.sun.netstorage.mgmt.nsmui.host.HostConstants;
import com.sun.netstorage.mgmt.nsmui.host.HostInventoryCommand;
import com.sun.netstorage.mgmt.nsmui.storage.StorageConstants;
import com.sun.netstorage.mgmt.nsmui.storage.StorageInventoryCommand;
import com.sun.netstorage.mgmt.nsmui.topology.TopologyBaseServlet;
import com.sun.netstorage.mgmt.nsmui.topology.TopologyCommand;
import com.sun.netstorage.mgmt.nsmui.topology.TopologyGraphModel;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.Masthead;
import com.sun.netstorage.mgmt.nsmui.util.NSMPages;
import com.sun.netstorage.mgmt.nsmui.util.SmartComparator;
import com.sun.netstorage.mgmt.services.topology.FabricTopology;
import com.sun.netstorage.mgmt.services.topology.SanTopology;
import com.sun.netstorage.mgmt.services.topology.TSTopologyNode;
import com.sun.netstorage.mgmt.services.topology.TopologyGraph;
import com.sun.netstorage.mgmt.services.topology.TopologyServiceImpl;
import com.sun.netstorage.mgmt.services.topology.Zone;
import com.sun.web.ui.servlet.topology.CCTopologyServlet;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class PathsServlet
extends TopologyBaseServlet {
    static final String RESULTS_PARAM = "results";
    private static final String BACK_BUTTON_DISABLED = "pathsBackDisabled";
    private static final String BACK_BUTTON = "pathsBack";
    private static final String NEXT_BUTTON = "pathsNext";
    private static final String FINISH_BUTTON = "pathsFinish";
    private static final String NAME_GROUP = "nameGroup";
    private static final String NAME_ITEM = "nameItem";
    private static final String NAME_FIELD = "nameField";
    private TopologyCommand topoCommand;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.topoCommand = new TopologyCommand();
    }

    protected PrintWriter writePageStart(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2, String string3, String string4) throws IOException, ServletException {
        String string5 = this.getParentPageName(httpServletRequest);
        HTMLTags.addTimestamp(httpServletRequest, "start");
        Masthead.getMasthead(this.getServletContext()).print(NSMPages.getPageTitle(NSMPages.SHOW_PATHS_PAGE), NSMPages.getPageSection(string5), NSMPages.getPageSubsection(string5), NSMPages.getPageHelp(NSMPages.SHOW_PATHS_PAGE), httpServletRequest, httpServletResponse);
        httpServletResponse.getWriter().flush();
        HTMLTags.addTimestamp(httpServletRequest, "masthead");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println(HTMLTags.getExtendedBreadCrumbTag(httpServletRequest, string5, NSMPages.getPageCrumbName(NSMPages.SHOW_PATHS_PAGE)));
        String string6 = NSMPages.getPageURL(NSMPages.SHOW_PATHS_PAGE);
        String string7 = httpServletRequest.getParameter("stubDB");
        if (string7 != null) {
            string6 = HTMLTags.modifyURLParameter(string6, "stubDB", string7);
        }
        printWriter.println(HTMLTags.getContentStartTags(string6));
        printWriter.println(HTMLTags.getPendingMessagesTag(httpServletRequest));
        printWriter.flush();
        HTMLTags.addTimestamp(httpServletRequest, "breadcrumb");
        if (string != null) {
            printWriter.print("<input type=hidden name=\"");
            printWriter.print("host");
            printWriter.print("\" value=\"");
            printWriter.print(string);
            printWriter.println("\">");
        }
        if (string2 != null) {
            printWriter.print("<input type=hidden name=\"");
            printWriter.print("device");
            printWriter.print("\" value=\"");
            printWriter.print(string2);
            printWriter.println("\">");
        }
        printWriter.print("<input type=hidden name=\"");
        printWriter.print("returnTo");
        printWriter.print("\" value=\"");
        printWriter.print(string5);
        printWriter.println("\">");
        string6 = HTMLTags.modifyURLParameter(string6, "host", string);
        string6 = HTMLTags.modifyURLParameter(string6, "device", string2);
        string6 = HTMLTags.modifyURLParameter(string6, "returnTo", string5);
        string6 = HTMLTags.modifyURLParameter(string6, "paths", RESULTS_PARAM);
        string6 = HTMLTags.modifyURLParameter(string6, "zone", string4);
        string6 = HTMLTags.modifyURLParameter(string6, "fabric", string3);
        HTMLTags.setBreadCrumbData(httpServletRequest.getSession(), NSMPages.SHOW_PATHS_PAGE, string6, null);
        return printWriter;
    }

    private String getParentPageName(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("returnTo");
        return string != null ? string : NSMPages.FABRIC_INVENTORY_PAGE;
    }

    protected void writePathsHostPage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2, String string3) throws IOException, ServletException {
        PrintWriter printWriter = this.writePageStart(httpServletRequest, httpServletResponse, string, string2, null, null);
        if (string != null) {
            string3 = TopologyCommand.getAssetName(string, "Host");
        }
        printWriter.println(Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Tags", "hostPageStart", new String[]{Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "step1"), Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "enterHostName"), Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "hostName"), Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "selectHost"), string3 != null ? string3 : ""}));
        printWriter.print("<input type=hidden name=\"");
        printWriter.print("paths");
        printWriter.print("\" value=\"");
        printWriter.print("host");
        printWriter.println("\">");
        try {
            HTMLTags.TableInfo tableInfo = HTMLTags.getTableInfo(httpServletRequest, 2, 0);
            HostInventoryCommand hostInventoryCommand = this.topoCommand.getHostInventoryCommand(tableInfo);
            hostInventoryCommand.run();
            String[][] stringArray = hostInventoryCommand.getValues();
            if (stringArray != null && stringArray.length > 0) {
                tableInfo = HTMLTags.getTableInfo(httpServletRequest, 2, stringArray.length);
                int n = Math.min(tableInfo.pageSize, stringArray.length - tableInfo.firstRow);
                String[][] stringArray2 = new String[n][];
                int n2 = 0;
                while (n2 < n) {
                    stringArray2[n2] = stringArray[n2 + tableInfo.firstRow];
                    stringArray2[n2][0] = HTMLTags.getInputRadioButtonTag(NAME_GROUP, stringArray2[n2][0], false);
                    ++n2;
                }
                printWriter.println(HTMLTags.getTableTag(this.getPageURL(httpServletRequest, "host", string, string2), HostConstants.COLUMNS, stringArray2, tableInfo.sortColumn, tableInfo.firstRow, stringArray.length, tableInfo.pageSize));
            } else {
                HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "noHosts"));
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            printWriter.println(HTMLTags.getExceptionBoxTag(httpServletRequest, NSMPages.SHOW_PATHS_PAGE, new DataRetrievalException(throwable)));
        }
        printWriter.println(Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Tags", "wizardButtons", new String[]{HTMLTags.getDisabledButtonTag(Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", BACK_BUTTON_DISABLED)), HTMLTags.getSubmitButtonTag(NEXT_BUTTON, Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", NEXT_BUTTON)), HTMLTags.getCancelButtonTag(httpServletRequest, this.getParentPageName(httpServletRequest))}));
        this.writePageEnd(httpServletRequest, printWriter);
    }

    private String getPageURL(HttpServletRequest httpServletRequest, String string, String string2, String string3) {
        String string4 = NSMPages.getPageURL(NSMPages.SHOW_PATHS_PAGE);
        string4 = HTMLTags.modifyURLParameter(string4, "paths", string);
        string4 = HTMLTags.modifyURLParameter(string4, "host", string2);
        string4 = HTMLTags.modifyURLParameter(string4, "device", string3);
        string4 = HTMLTags.modifyURLParameter(string4, "returnTo", this.getParentPageName(httpServletRequest));
        return string4;
    }

    protected void writePathsDevicePage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2, String string3) throws IOException, ServletException {
        PrintWriter printWriter = this.writePageStart(httpServletRequest, httpServletResponse, string, string2, null, null);
        String string4 = TopologyCommand.getAssetName(string, "Host");
        if (string2 != null) {
            string3 = TopologyCommand.getAssetName(string2, "Storage");
        }
        printWriter.println(Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Tags", "devicePageStart", new String[]{Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "step1Complete", string4), Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "step2"), Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "enterDeviceName"), Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "deviceName"), Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "selectDevice"), string3 != null ? string3 : ""}));
        printWriter.print("<input type=hidden name=\"");
        printWriter.print("paths");
        printWriter.print("\" value=\"");
        printWriter.println("\">");
        try {
            HTMLTags.TableInfo tableInfo = HTMLTags.getTableInfo(httpServletRequest, 2, 0);
            StorageInventoryCommand storageInventoryCommand = this.topoCommand.getStorageInventoryCommand(tableInfo);
            storageInventoryCommand.run();
            String[][] stringArray = storageInventoryCommand.getValues();
            if (stringArray != null && stringArray.length > 0) {
                tableInfo = HTMLTags.getTableInfo(httpServletRequest, 2, stringArray.length);
                int n = Math.min(tableInfo.pageSize, stringArray.length - tableInfo.firstRow);
                String[][] stringArray2 = new String[n][];
                int n2 = 0;
                while (n2 < n) {
                    stringArray2[n2] = stringArray[n2 + tableInfo.firstRow];
                    stringArray2[n2][0] = HTMLTags.getInputRadioButtonTag(NAME_GROUP, stringArray2[n2][0], false);
                    ++n2;
                }
                printWriter.println(HTMLTags.getTableTag(this.getPageURL(httpServletRequest, "device", string, string2), StorageConstants.COLUMNS, stringArray2, tableInfo.sortColumn, tableInfo.firstRow, stringArray.length, tableInfo.pageSize));
            } else {
                HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "noStorageDevices"));
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            printWriter.println(HTMLTags.getExceptionBoxTag(httpServletRequest, NSMPages.SHOW_PATHS_PAGE, new DataRetrievalException(throwable)));
        }
        printWriter.println(Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Tags", "wizardButtons", new String[]{HTMLTags.getSubmitButtonTag(BACK_BUTTON, Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", BACK_BUTTON)), HTMLTags.getSubmitButtonTag(FINISH_BUTTON, Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", FINISH_BUTTON)), HTMLTags.getCancelButtonTag(httpServletRequest, this.getParentPageName(httpServletRequest))}));
        this.writePageEnd(httpServletRequest, printWriter);
    }

    protected void writePathsResultsPage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) throws IOException, ServletException {
        String[] stringArray = this.processZoneMenu(httpServletRequest, httpServletResponse);
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        PrintWriter printWriter = this.writePageStart(httpServletRequest, httpServletResponse, string, string2, string3, string4);
        printWriter.print("<input type=hidden name=\"");
        printWriter.print("paths");
        printWriter.print("\" value=\"");
        printWriter.print(RESULTS_PARAM);
        printWriter.println("\">");
        try {
            TopologyServiceImpl topologyServiceImpl = TopologyServiceImpl.getInstance();
            SanTopology sanTopology = this.getSanTopology(topologyServiceImpl, httpServletRequest);
            if (sanTopology != null) {
                TopologyGraph topologyGraph;
                String string5;
                TSTopologyNode tSTopologyNode;
                String string6;
                HTMLTags.addTimestamp(httpServletRequest, "get topology from model");
                TSTopologyNode tSTopologyNode2 = topologyServiceImpl.findNode((Object)string);
                String string7 = tSTopologyNode2 == null ? TopologyCommand.getAssetName(string, "Host") : (string6 = (String)tSTopologyNode2.getProperty("Name"));
                if (string6 == null) {
                    string6 = string;
                }
                String string8 = (tSTopologyNode = topologyServiceImpl.findNode((Object)string2)) == null ? TopologyCommand.getAssetName(string2, "Storage") : (string5 = (String)tSTopologyNode.getProperty("Name"));
                if (string5 == null) {
                    string5 = string2;
                }
                HTMLTags.addTimestamp(httpServletRequest, "find host and device in topology");
                FabricTopology fabricTopology = null;
                Zone zone = null;
                if (string4 != null) {
                    TopologyGraph topologyGraph2;
                    if (string3 == null) {
                        topologyGraph2 = sanTopology.getFabrics();
                    } else {
                        FabricTopology[] fabricTopologyArray = new FabricTopology[1];
                        topologyGraph2 = fabricTopologyArray;
                        fabricTopologyArray[0] = sanTopology.getFabric(string3);
                    }
                    topologyGraph = topologyGraph2;
                    int n = 0;
                    while (zone == null && n < ((FabricTopology[])topologyGraph).length) {
                        if (topologyGraph[n] == null) {
                            HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "fabricNotFound"));
                        } else {
                            zone = topologyGraph[n].getZone(string4);
                            if (zone != null) {
                                fabricTopology = topologyGraph[n];
                            }
                        }
                        ++n;
                    }
                }
                if (string3 != null && fabricTopology == null) {
                    fabricTopology = sanTopology.getFabric(string3);
                }
                topologyGraph = null;
                TopologyGraphModel topologyGraphModel = null;
                TopologyGraphModel topologyGraphModel2 = null;
                if (tSTopologyNode2 != null && tSTopologyNode != null) {
                    topologyGraph = sanTopology.getPathsGraph(tSTopologyNode2, tSTopologyNode);
                    if (topologyGraph.getNodeCount() > 0) {
                        topologyGraphModel = new TopologyGraphModel(this.servletContext, topologyGraph, fabricTopology, zone);
                    }
                    HTMLTags.addTimestamp(httpServletRequest, "get SAN paths");
                    topologyGraphModel2 = new TopologyGraphModel(this.servletContext, sanTopology.getDasTopology(), tSTopologyNode2, tSTopologyNode);
                    HTMLTags.addTimestamp(httpServletRequest, "get DAS paths");
                } else {
                    if (tSTopologyNode2 == null) {
                        printWriter.println(HTMLTags.getInfoBoxTag(Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "hostNotFound", string6)));
                    }
                    if (tSTopologyNode == null) {
                        printWriter.println(HTMLTags.getInfoBoxTag(Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "deviceNotFound", string5)));
                    }
                }
                printWriter.println(Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Tags", "pathsTitle", HTMLTags.toNonBreakingString(Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "fabricPaths"))));
                printWriter.println("<blockquote>");
                if (topologyGraphModel == null) {
                    printWriter.println(HTMLTags.getInfoBoxTag(Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "noSANPathsFound")));
                } else {
                    String string9;
                    String[] stringArray2 = topologyGraph.getFabricNames();
                    FabricTopology[] fabricTopologyArray = new FabricTopology[stringArray2.length];
                    int n = 0;
                    int n2 = 0;
                    while (n2 < stringArray2.length) {
                        fabricTopologyArray[n2] = sanTopology.getFabric(stringArray2[n2]);
                        string9 = fabricTopologyArray[n2].getFabricId().getLogicalName();
                        if (string9 != null) {
                            stringArray2[n2] = string9;
                        }
                        n += fabricTopologyArray[n2].getZones().length;
                        ++n2;
                    }
                    Arrays.sort(stringArray2, new SmartComparator());
                    string9 = Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "fabricSeparator");
                    StringBuffer stringBuffer = new StringBuffer();
                    int n3 = 0;
                    while (n3 < stringArray2.length) {
                        if (n3 > 0) {
                            stringBuffer.append(string9);
                        }
                        stringBuffer.append(stringArray2[n3]);
                        ++n3;
                    }
                    String string10 = NSMPages.getPageURL(NSMPages.SHOW_PATHS_DETAIL_PAGE);
                    string10 = HTMLTags.modifyURLParameter(string10, "returnTo", httpServletRequest.getParameter("returnTo"));
                    string10 = HTMLTags.modifyURLParameter(string10, "host", string);
                    string10 = HTMLTags.modifyURLParameter(string10, "device", string2);
                    string10 = HTMLTags.modifyURLParameter(string10, "fabric", string3);
                    string10 = HTMLTags.modifyURLParameter(string10, "zone", string4);
                    string10 = HTMLTags.modifyURLParameter(string10, "stubDB", httpServletRequest.getParameter("stubDB"));
                    this.writePathsZoneMenu(printWriter, fabricTopologyArray, string4, string3, string10);
                    printWriter.println(CCTopologyServlet.getTopologyImageTags(httpServletRequest.getSession(), null, topologyGraphModel));
                    printWriter.println("\n<p>\n");
                }
                printWriter.println("</blockquote>");
                printWriter.println(Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Tags", "pathsTitle", HTMLTags.toNonBreakingString(Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "dasPaths"))));
                printWriter.println("<blockquote>");
                if (topologyGraphModel2 == null || topologyGraphModel2.getEdges().length == 0) {
                    printWriter.println(HTMLTags.getInfoBoxTag(Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "noDASPathFound")));
                } else {
                    printWriter.println(CCTopologyServlet.getTopologyImageTags(httpServletRequest.getSession(), null, topologyGraphModel2));
                }
                printWriter.println("</blockquote>");
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            printWriter.println(HTMLTags.getExceptionBoxTag(httpServletRequest, NSMPages.SHOW_PATHS_PAGE, new DataRetrievalException(throwable)));
        }
        this.writePageEnd(httpServletRequest, printWriter);
    }

    protected void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (!this.performSecurityCheck(httpServletRequest, httpServletResponse)) {
            return;
        }
        this.processShowPathsRequest(httpServletRequest, httpServletResponse);
    }

    protected void processShowPathsRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = HTMLTags.getFormSubmitter(httpServletRequest);
        if (string != null && string.startsWith("paths")) {
            if (string.equals(NEXT_BUTTON)) {
                String string2 = httpServletRequest.getParameter(NAME_GROUP);
                String string3 = null;
                if (NAME_ITEM.equals(string2)) {
                    string3 = httpServletRequest.getParameter(NAME_FIELD);
                    string2 = string3 != null && string3.length() > 0 ? TopologyCommand.getAssetId(string3, "Host") : null;
                }
                if (string2 != null) {
                    this.writePathsDevicePage(httpServletRequest, httpServletResponse, string2, httpServletRequest.getParameter("device"), null);
                } else {
                    HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "invalidHostName"));
                    this.writePathsHostPage(httpServletRequest, httpServletResponse, string2, httpServletRequest.getParameter("device"), string3);
                }
            } else if (string.equals(BACK_BUTTON)) {
                this.writePathsHostPage(httpServletRequest, httpServletResponse, httpServletRequest.getParameter("host"), httpServletRequest.getParameter("device"), null);
            } else if (string.equals(FINISH_BUTTON)) {
                String string4 = httpServletRequest.getParameter(NAME_GROUP);
                String string5 = null;
                if (NAME_ITEM.equals(string4)) {
                    string5 = httpServletRequest.getParameter(NAME_FIELD);
                    string4 = string5 != null && string5.length() > 0 ? TopologyCommand.getAssetId(string5, "Storage") : null;
                }
                String string6 = httpServletRequest.getParameter("host");
                if (string4 != null) {
                    this.writePathsResultsPage(httpServletRequest, httpServletResponse, string6, string4);
                } else {
                    HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "invalidDeviceName"));
                    this.writePathsDevicePage(httpServletRequest, httpServletResponse, string6, string4, string5);
                }
            }
        } else {
            String string7;
            String string8 = httpServletRequest.getParameter("host");
            String string9 = httpServletRequest.getParameter("device");
            String string10 = httpServletRequest.getParameter("id");
            if (string10 != null) {
                if (string9 == null && this.topoCommand.validateDevice(string10)) {
                    string9 = string10;
                } else if (string8 == null) {
                    string8 = this.topoCommand.validateHost(string10) ? string10 : this.topoCommand.getHbaHostId(string10);
                }
            }
            if ("host".equals(string7 = httpServletRequest.getParameter("paths"))) {
                this.writePathsHostPage(httpServletRequest, httpServletResponse, string8, string9, null);
            } else if ("device".equals(string7)) {
                this.writePathsDevicePage(httpServletRequest, httpServletResponse, string8, string9, null);
            } else if (RESULTS_PARAM.equals(string7)) {
                this.writePathsResultsPage(httpServletRequest, httpServletResponse, string8, string9);
            } else {
                boolean bl = this.topoCommand.validateHost(string8);
                boolean bl2 = this.topoCommand.validateDevice(string9);
                if (bl && bl2 || httpServletRequest.getParameter("stubDB") != null && string8 != null && string9 != null) {
                    this.writePathsResultsPage(httpServletRequest, httpServletResponse, string8, string9);
                } else {
                    this.writePathsHostPage(httpServletRequest, httpServletResponse, string8, string9, null);
                }
            }
        }
    }

    public String getServletInfo() {
        return "NSM Paths Servlet";
    }
}

