/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.topology;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.common.LoginException;
import com.sun.netstorage.mgmt.nsmui.common.Security;
import com.sun.netstorage.mgmt.nsmui.topology.TopologyConstants;
import com.sun.netstorage.mgmt.nsmui.topology.ZoneUtil;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.Masthead;
import com.sun.netstorage.mgmt.nsmui.util.NSMPages;
import com.sun.netstorage.mgmt.nsmui.util.SmartComparator;
import com.sun.netstorage.mgmt.nsmui.util.UtilsWeb;
import com.sun.netstorage.mgmt.services.topology.FabricTopology;
import com.sun.netstorage.mgmt.services.topology.SanTopology;
import com.sun.netstorage.mgmt.services.topology.TopologyElementNotFoundException;
import com.sun.netstorage.mgmt.services.topology.TopologyServiceImpl;
import com.sun.netstorage.mgmt.services.topology.Zone;
import com.sun.web.ui.servlet.topology.CCTopologyServlet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class TopologyBaseServlet
extends HttpServlet
implements TopologyConstants {
    protected static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.topology.Localization";
    protected static final String TAG_BUNDLE = "com.sun.netstorage.mgmt.nsmui.topology.Tags";
    protected static final String HEADLESS_BUG = "headlessBug";
    protected static final String HEADLESS_BUG_DETAIL = "headlessBugDetail";
    protected static final String ZONE_MENU = "zoneMenu";
    private static final String ZONE_VIEW = "zv_";
    private static final String NO_ZONES = "nz_";
    private static final String MENU_SEPARATOR = "-";
    private ByteArrayOutputStream debugStream;
    protected ServletContext servletContext;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.servletContext = servletConfig.getServletContext();
        CCTopologyServlet.setServletURI("/nsm/topoimage");
        CCTopologyServlet.setDefaultImageAreaMaximum(1000000);
    }

    public void destroy() {
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        UtilsWeb.setContentType(httpServletRequest, httpServletResponse);
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        UtilsWeb.setContentType(httpServletRequest, httpServletResponse);
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    protected void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
    }

    protected boolean performSecurityCheck(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        UtilsWeb.setContentType(httpServletRequest, httpServletResponse);
        try {
            Security.getSecurity().getAuthorization(httpServletRequest, httpServletResponse, HTMLTags.createURL(httpServletRequest.getRequestURI(), httpServletRequest.getQueryString()));
        }
        catch (LoginException loginException) {
            return false;
        }
        return true;
    }

    protected PrintWriter writePageStart(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2, String string3) throws IOException, ServletException {
        this.writeMasthead(httpServletRequest, httpServletResponse, string);
        this.writeBreadCrumb(httpServletRequest, httpServletResponse, string, string2, string3);
        return httpServletResponse.getWriter();
    }

    protected void writeMasthead(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException, ServletException {
        HTMLTags.addTimestamp(httpServletRequest, "start");
        Masthead.getMasthead(this.getServletContext()).printMasthead(httpServletRequest, httpServletResponse, string);
        httpServletResponse.getWriter().flush();
        HTMLTags.addTimestamp(httpServletRequest, "masthead");
    }

    protected void writeBreadCrumb(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2, String string3) throws IOException, ServletException {
        if (string3 == null) {
            string3 = HTMLTags.createURL(httpServletRequest.getRequestURI(), httpServletRequest.getQueryString());
        }
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println(HTMLTags.getBreadCrumbTag(httpServletRequest, string, string2, httpServletResponse.encodeURL(string3)));
        printWriter.println(HTMLTags.getContentStartTags(string3));
        printWriter.println(HTMLTags.getPendingMessagesTag(httpServletRequest));
        printWriter.flush();
        HTMLTags.addTimestamp(httpServletRequest, "breadcrumb");
    }

    protected void writePageEnd(HttpServletRequest httpServletRequest, PrintWriter printWriter) throws IOException, ServletException {
        printWriter.println(HTMLTags.getPendingMessagesTag(httpServletRequest));
        printWriter.println(HTMLTags.getTimestampTags(httpServletRequest));
        if (this.debugStream != null) {
            printWriter.println("<font size=-1 color=red><pre>");
            printWriter.println(this.debugStream.toString());
            printWriter.println("</pre></font>");
        }
        printWriter.println(HTMLTags.getContentEndTags());
        printWriter.close();
    }

    protected SanTopology getSanTopology(TopologyServiceImpl topologyServiceImpl, HttpServletRequest httpServletRequest) {
        SanTopology sanTopology = null;
        this.debugStream = null;
        try {
            String string = httpServletRequest.getParameter("stubDB");
            if (string != null) {
                sanTopology = topologyServiceImpl.getSanTopologySim(string);
            } else {
                boolean bl;
                boolean bl2 = bl = httpServletRequest.getParameter("debugDB") != null;
                if (bl) {
                    this.debugStream = new ByteArrayOutputStream();
                    sanTopology = topologyServiceImpl.getSanTopology("", new PrintWriter(this.debugStream, true));
                } else {
                    sanTopology = topologyServiceImpl.getSanTopology("");
                }
            }
        }
        catch (TopologyElementNotFoundException topologyElementNotFoundException) {
            try {
                sanTopology = topologyServiceImpl.getSanTopologyCached("");
                if (sanTopology != null) {
                    HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "usingCachedTopology"));
                }
            }
            catch (TopologyElementNotFoundException topologyElementNotFoundException2) {
                // empty catch block
            }
        }
        return sanTopology;
    }

    protected void writePathsButton(PrintWriter printWriter, HttpServletRequest httpServletRequest, String string, boolean bl, int n) {
        printWriter.println(HTMLTags.getContentSubSectionTags("\"right\""));
        if (bl) {
            String string2 = NSMPages.getPageURL(NSMPages.SHOW_PATHS_PAGE);
            String string3 = httpServletRequest.getParameter("stubDB");
            if (string3 != null) {
                string2 = HTMLTags.modifyURLParameter(string2, "stubDB", string3);
            }
            string2 = HTMLTags.modifyURLParameter(string2, "returnTo", string);
            printWriter.println(HTMLTags.getLinkButtonTag(string2, Localization.getString(BUNDLE, "pathsButton")));
        } else {
            printWriter.println(HTMLTags.getDisabledButtonTag(Localization.getString(BUNDLE, "pathsButton")));
        }
        printWriter.println(HTMLTags.getContentSubSectionTags("\"left\"", n));
        printWriter.flush();
    }

    protected void writeTopologyZoneMenu(PrintWriter printWriter, FabricTopology fabricTopology, String string, String string2) {
        Zone[] zoneArray = fabricTopology.getZones();
        String[] stringArray = new String[zoneArray.length];
        int n = 0;
        while (n < zoneArray.length) {
            stringArray[n] = zoneArray[n].getName();
            if (stringArray[n] == null) {
                stringArray[n] = "";
            }
            ++n;
        }
        Arrays.sort(stringArray, new SmartComparator());
        StringBuffer stringBuffer = new StringBuffer();
        this.addMenuItem(stringBuffer, NO_ZONES, Localization.getString(BUNDLE, "withoutZones"), string == null);
        if (stringArray.length > 0) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string3 = stringArray[n2];
                this.addMenuItem(stringBuffer, ZONE_VIEW + string3, Localization.getString(BUNDLE, "zoneTopology", ZoneUtil.localizeZoneName(string3)), string3.equals(string));
                ++n2;
            }
        } else {
            this.addMenuItem(stringBuffer, NO_ZONES, Localization.getString(BUNDLE, "noZonesExist"), false);
        }
        String string4 = string2 == null ? "" : HTMLTags.getLinkButtonTag(string2, Localization.getString(BUNDLE, "detailsButton"));
        printWriter.println(Localization.getString(TAG_BUNDLE, ZONE_MENU, new String[]{"'zoneMenu'", stringBuffer.toString(), string4}));
    }

    protected void writePathsZoneMenu(PrintWriter printWriter, FabricTopology[] fabricTopologyArray, String string, String string2, String string3) {
        Zone[] zoneArray;
        int n = 0;
        int n2 = 0;
        while (n2 < fabricTopologyArray.length) {
            n += fabricTopologyArray[n2].getZones().length;
            ++n2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.addMenuItem(stringBuffer, NO_ZONES, Localization.getString(BUNDLE, "withoutZones"), string == null && string2 == null);
        String string4 = "    ";
        int n3 = 0;
        while (n3 < fabricTopologyArray.length) {
            zoneArray = fabricTopologyArray[n3].getZones();
            String[] stringArray = new String[zoneArray.length];
            int n4 = 0;
            while (n4 < zoneArray.length) {
                stringArray[n4] = zoneArray[n4].getName();
                if (stringArray[n4] == null) {
                    stringArray[n4] = "";
                }
                ++n4;
            }
            Arrays.sort(stringArray, new SmartComparator());
            String string5 = fabricTopologyArray[n3].getFabricId().getFabricName();
            String string6 = "zv_zv_" + string5;
            this.addMenuItem(stringBuffer, string6, Localization.getString(BUNDLE, "fabricItem", fabricTopologyArray[n3].getFabricId().getLogicalName()), string == null && string2 != null && string2.equals(string5));
            if (stringArray.length > 0) {
                int n5 = 0;
                while (n5 < stringArray.length) {
                    this.addMenuItem(stringBuffer, ZONE_VIEW + stringArray[n5] + ZONE_VIEW + string5, string4 + Localization.getString(BUNDLE, "zoneTopology", ZoneUtil.localizeZoneName(stringArray[n5])), string5.equals(string2) && stringArray[n5].equals(string));
                    ++n5;
                }
            } else {
                this.addMenuItem(stringBuffer, string6, string4 + Localization.getString(BUNDLE, "noZonesExist"), false);
            }
            ++n3;
        }
        zoneArray = string3 == null ? "" : HTMLTags.getLinkButtonTag(string3, Localization.getString(BUNDLE, "detailsButton"));
        printWriter.println(Localization.getString(TAG_BUNDLE, ZONE_MENU, new String[]{"'zoneMenu'", stringBuffer.toString(), zoneArray}));
    }

    protected void addMenuItem(StringBuffer stringBuffer, String string, String string2, boolean bl) {
        stringBuffer.append("  <option ");
        if (bl) {
            stringBuffer.append("selected ");
        }
        stringBuffer.append("value=\"");
        stringBuffer.append(string);
        stringBuffer.append("\">");
        stringBuffer.append(string2);
        stringBuffer.append("</option>\n");
    }

    protected String[] processZoneMenu(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        String string2 = httpServletRequest.getParameter("fabric");
        String string3 = httpServletRequest.getParameter("zone");
        String string4 = HTMLTags.getFormSubmitter(httpServletRequest);
        if (string4 != null && string4.startsWith(ZONE_MENU) && (string = httpServletRequest.getParameter(string4)) != null) {
            if (string.startsWith(NO_ZONES)) {
                string3 = null;
            } else if (string.startsWith(ZONE_VIEW)) {
                int n = 0 + ZONE_VIEW.length();
                int n2 = string.indexOf(ZONE_VIEW, n);
                if (n2 != -1) {
                    int n3 = n2 + ZONE_VIEW.length();
                    string3 = string.substring(n, n2);
                    string2 = string.substring(n3);
                } else {
                    string3 = string.substring(n);
                }
            }
        }
        if (string2 != null && (string2.length() == 0 || "null".equals(string2))) {
            string2 = null;
        }
        if (string3 != null && (string3.length() == 0 || "null".equals(string3))) {
            string3 = null;
        }
        return new String[]{string2, string3};
    }
}

