/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.topology;

import com.sun.netstorage.mgmt.common.datamodel.Asset;
import com.sun.netstorage.mgmt.component.model.api.gui.HBAAsset;
import com.sun.netstorage.mgmt.nsmui.host.HostConstants;
import com.sun.netstorage.mgmt.nsmui.host.HostInventoryCommand;
import com.sun.netstorage.mgmt.nsmui.storage.StorageConstants;
import com.sun.netstorage.mgmt.nsmui.storage.StorageInventoryCommand;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import com.sun.netstorage.mgmt.services.topology.TSTopologyNode;
import com.sun.netstorage.mgmt.services.topology.TopologyElementNotFoundException;
import com.sun.netstorage.mgmt.services.topology.TopologyGraph;
import java.util.ArrayList;
import java.util.Arrays;

public final class TopologyCommand {
    public TSTopologyNode getHostNode(TopologyGraph topologyGraph, String string) {
        if (topologyGraph == null || string == null) {
            return null;
        }
        Object var3_3 = null;
        TSTopologyNode[] tSTopologyNodeArray = topologyGraph.getNodesByType("com.sun.netstorage.mgmt.component.model.domain.StorageHost");
        if (tSTopologyNodeArray != null) {
            int n = 0;
            while (n < tSTopologyNodeArray.length) {
                if (string.equals(tSTopologyNodeArray[n].getProperty("Name"))) {
                    return tSTopologyNodeArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    public TSTopologyNode getStorageNode(TopologyGraph topologyGraph, String string) {
        if (topologyGraph == null || string == null) {
            return null;
        }
        Object var3_3 = null;
        TSTopologyNode[] tSTopologyNodeArray = topologyGraph.getNodesByType("com.sun.netstorage.mgmt.component.model.domain.StorageSubSystem");
        if (tSTopologyNodeArray != null) {
            int n = 0;
            while (n < tSTopologyNodeArray.length) {
                if (string.equals(tSTopologyNodeArray[n].getProperty("Name"))) {
                    return tSTopologyNodeArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    public TSTopologyNode[][] getPathsBetween(TopologyGraph topologyGraph, String[] stringArray) {
        if (stringArray == null || stringArray.length != 2) {
            return new TSTopologyNode[0][0];
        }
        return this.getHostNode(topologyGraph, stringArray[0]) != null ? this.getPathsBetween(topologyGraph, stringArray[0], stringArray[1]) : this.getPathsBetween(topologyGraph, stringArray[1], stringArray[0]);
    }

    public TSTopologyNode[][] getPathsBetween(TopologyGraph topologyGraph, String string, String string2) {
        return this.getPathsBetween(topologyGraph, this.getHostNode(topologyGraph, string), this.getStorageNode(topologyGraph, string2));
    }

    public TSTopologyNode[][] getPathsBetween(TopologyGraph topologyGraph, TSTopologyNode tSTopologyNode, TSTopologyNode tSTopologyNode2) {
        if (topologyGraph == null || tSTopologyNode == null || tSTopologyNode2 == null) {
            return new TSTopologyNode[0][0];
        }
        ArrayList arrayList = new ArrayList();
        TSTopologyNode[] tSTopologyNodeArray = tSTopologyNode.getChildren();
        int n = 0;
        while (n < tSTopologyNodeArray.length) {
            try {
                TSTopologyNode[][] tSTopologyNodeArray2 = topologyGraph.getPathsBetween(tSTopologyNodeArray[n], tSTopologyNode2);
                if (tSTopologyNodeArray2 != null) {
                    arrayList.addAll(Arrays.asList(tSTopologyNodeArray2));
                }
            }
            catch (TopologyElementNotFoundException topologyElementNotFoundException) {
                // empty catch block
            }
            ++n;
        }
        return (TSTopologyNode[][])arrayList.toArray((T[])new TSTopologyNode[0][0]);
    }

    public HostInventoryCommand getHostInventoryCommand(HTMLTags.TableInfo tableInfo) {
        String string = tableInfo.sortColumn == 0 ? null : HostConstants.COLUMNS_SORT[Math.abs(tableInfo.sortColumn) - 1];
        boolean bl = tableInfo.sortColumn >= 0;
        return new HostInventoryCommand(string, bl, null);
    }

    public StorageInventoryCommand getStorageInventoryCommand(HTMLTags.TableInfo tableInfo) {
        String string = tableInfo.sortColumn == 0 ? null : StorageConstants.COLUMNS_SORT[Math.abs(tableInfo.sortColumn) - 1];
        boolean bl = tableInfo.sortColumn >= 0;
        return new StorageInventoryCommand(string, bl, null);
    }

    public boolean validateHost(String string) {
        return TopologyCommand.getAssetName(string, "Host") != null;
    }

    public boolean validateSwitch(String string) {
        return TopologyCommand.getAssetName(string, "Switch") != null;
    }

    public boolean validateDevice(String string) {
        return TopologyCommand.getAssetName(string, "Storage") != null;
    }

    public String getHbaHostId(String string) {
        if (string == null) {
            return null;
        }
        try {
            return ((HBAAsset)Utils.getAssetStorage().getAsset(string)).getHost().getKey();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getAssetName(String string, String string2) {
        String string3 = null;
        boolean bl = false;
        try {
            Asset asset;
            if (string != null && (asset = Utils.getAssetStorage().getAsset(string)) != null) {
                string3 = asset.getName();
                bl = string2 == null ? true : string2.equals(asset.getType());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl ? string3 : null;
    }

    public static String getAssetId(String string, String string2) {
        try {
            Asset[] assetArray = Utils.getAssetStorage().getAssets(string2, string, null, null);
            return assetArray != null && assetArray.length > 0 ? assetArray[0].getKey() : null;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

