/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.util;

import com.sun.netstorage.mgmt.common.clip.CommandException;
import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.datamodel.AssetStorage;
import com.sun.netstorage.mgmt.common.datamodel.PersistenceException;
import com.sun.netstorage.mgmt.common.datamodel.User;
import com.sun.netstorage.mgmt.component.model.api.gui.GuiPersistenceManager;
import com.sun.netstorage.mgmt.nsmui.common.Constants;
import com.sun.netstorage.mgmt.nsmui.common.DataRetrievalException;
import com.sun.netstorage.mgmt.nsmui.login.UnixUser;
import java.util.Locale;
import java.util.StringTokenizer;

public class Utils {
    private static final boolean debug = false;
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.login.Localization";
    static AssetStorage pm;

    public static GuiPersistenceManager getGuiPersistenceManager() throws DataRetrievalException {
        return (GuiPersistenceManager)Utils.getAssetStorage();
    }

    public static AssetStorage getAssetStorage() throws DataRetrievalException {
        if (pm == null) {
            String string = "";
            try {
                pm = GuiPersistenceManager.getInstance();
                if (pm == null) {
                    throw new RuntimeException("Unable to retrieve GuiPersistenceManager instance");
                }
            }
            catch (Exception exception) {
                throw new DataRetrievalException("Cannot connect to database, ", exception);
            }
        }
        return pm;
    }

    public static String parseSeverity(String string) {
        String string2 = "0";
        if (string.equals("severity <= 4")) {
            string2 = "4";
        } else if (string.equals("severity = 3 OR severity = 4")) {
            string2 = "4";
        } else if (string.equals("severity = 3")) {
            string2 = "3";
        } else if (string.equals("severity = 4")) {
            string2 = "4";
        } else if (string.equals("severity = 5")) {
            string2 = "5";
        } else if (string.equals("severity = 6")) {
            string2 = "6";
        } else if (string.equals("severity = 7")) {
            string2 = "7";
        }
        return string2;
    }

    public static String formatSeverity(String string) {
        String string2 = "";
        if (string.equals("4")) {
            string2 = "severity = 3 OR severity = 4";
        } else if (string.equals("5")) {
            string2 = "severity = 5";
        } else if (string.equals("6")) {
            string2 = "severity = 6";
        } else if (string.equals("7")) {
            string2 = "severity = 7";
        }
        return string2;
    }

    public static String formatSeverityFromToken(String string) {
        String string2 = "";
        if (string.equals("minor")) {
            string2 = "severity = 3 OR severity = 4";
        } else if (string.equals("major")) {
            string2 = "severity = 5";
        } else if (string.equals("critical")) {
            string2 = "severity = 6";
        } else if (string.equals("down")) {
            string2 = "severity = 7";
        }
        return string2;
    }

    public static String mapSeverityToToken(String string) {
        String string2 = "down";
        if (string.equals("0")) {
            string2 = "all";
        } else if (string.equals("3")) {
            string2 = "minor";
        } else if (string.equals("4")) {
            string2 = "minor";
        } else if (string.equals("5")) {
            string2 = "major";
        } else if (string.equals("6")) {
            string2 = "critical";
        } else if (string.equals("7")) {
            string2 = "down";
        }
        return string2;
    }

    public static String mapTokenToSeverity(String string) {
        String string2 = "0";
        if (string.equals("minor")) {
            string2 = "3";
        } else if (string.equals("major")) {
            string2 = "5";
        } else if (string.equals("critical")) {
            string2 = "6";
        } else if (string.equals("down")) {
            string2 = "7";
        }
        return string2;
    }

    public static String getMinutesValue(String string, String string2) {
        long l = Long.parseLong(string);
        if (string2.equals("days")) {
            l *= 1440L;
        } else if (string2.equals("hours")) {
            l *= 60L;
        }
        return String.valueOf(l);
    }

    public static String[] getTimeValue(String string) {
        String[] stringArray = new String[]{"0", "minutes"};
        long l = Long.parseLong(string);
        if (l != 0L) {
            if (l % 1440L == 0L) {
                stringArray[0] = String.valueOf(l / 1440L);
                stringArray[1] = "days";
            } else if (l % 60L == 0L) {
                stringArray[0] = String.valueOf(l / 60L);
                stringArray[1] = "hours";
            } else {
                stringArray[0] = String.valueOf(l);
                stringArray[1] = "minutes";
            }
        }
        return stringArray;
    }

    public static String getLocaleDisplayName(String string) {
        Locale locale;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        if (stringTokenizer.countTokens() == 0) {
            locale = Locale.getDefault();
        } else {
            String[] stringArray = new String[stringTokenizer.countTokens()];
            String string2 = (String)stringTokenizer.nextElement();
            String string3 = "";
            if (stringTokenizer.hasMoreElements()) {
                string3 = (String)stringTokenizer.nextElement();
            }
            locale = new Locale(string2, string3);
        }
        return locale.getDisplayName();
    }

    public static Locale formatStringToLocale(String string) {
        Locale locale;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        if (stringTokenizer.countTokens() == 0) {
            locale = Locale.getDefault();
        } else {
            String[] stringArray = new String[stringTokenizer.countTokens()];
            String string2 = (String)stringTokenizer.nextElement();
            String string3 = "";
            if (stringTokenizer.hasMoreElements()) {
                string3 = (String)stringTokenizer.nextElement();
            }
            locale = new Locale(string2, string3);
        }
        return locale;
    }

    public static String createDuplet(String string, String string2) {
        return string + "~" + (string2 == null ? "" : string2);
    }

    public static String parseKeyFromDuplet(String string) {
        if (string == null) {
            return "";
        }
        int n = string.indexOf("~");
        if (n < 0) {
            return "";
        }
        return string.substring(0, n);
    }

    public static String parseNameFromDuplet(String string) {
        if (string == null) {
            return "";
        }
        int n = string.indexOf("~");
        if (n < 0) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static boolean isRunningOnSolaris() {
        String string = System.getProperty("os.name");
        return string != null && (string.indexOf("Solaris") != -1 || string.indexOf("Sun") != -1);
    }

    public static String retrieveRoleForUser(String string) throws PersistenceException, DataRetrievalException {
        if (string == null) {
            return null;
        }
        GuiPersistenceManager guiPersistenceManager = Utils.getGuiPersistenceManager();
        User user = guiPersistenceManager.getUser(string);
        return user == null ? null : user.getRole();
    }

    public static String cliSecurityCheck(String string) throws CommandException {
        String string2 = null;
        try {
            string2 = Utils.retrieveRoleForUser(UnixUser.getUser());
        }
        catch (Exception exception) {
            throw new CommandException(exception, Localization.getString(BUNDLE, "auth_failed"), 99);
        }
        if (string2 == null) {
            throw new CommandException(Localization.getString(BUNDLE, "auth_failed"), 99);
        }
        if (string.equalsIgnoreCase("Admin") ? !"Admin".equalsIgnoreCase(string2) : string.equalsIgnoreCase("Operator") && "Guest".equalsIgnoreCase(string2)) {
            throw new CommandException(Localization.getString(BUNDLE, "auth_failed"), 99);
        }
        return string2;
    }

    public static String getVendorModel(String string, String string2) {
        boolean bl;
        boolean bl2 = string != null && string.trim().length() > 0;
        boolean bl3 = bl = string2 != null && string2.trim().length() > 0;
        return bl2 ? (bl ? string.trim() + Constants.VENDOR_MODEL_SEPARATOR + string2.trim() : string.trim()) : (bl ? string2.trim() : "");
    }
}

