/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.servlet.topology;

import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.servlet.topology.CCTopologyServlet;
import com.sun.web.ui.servlet.topology.TopologyRenderer;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import javax.imageio.ImageIO;

class TopologyImageData {
    private static final int TYPE = 0;
    private static final int BYTES = 1;
    private final TopologyRenderer renderer;
    private final Rectangle clipRegion;
    private final String imageFormat;
    private final Object[] imageData;

    public TopologyImageData(TopologyRenderer topologyRenderer, Rectangle rectangle, String string) {
        if (topologyRenderer == null) {
            throw new IllegalArgumentException("renderer == null");
        }
        if (!CCTopologyServlet.isValidImageFormat(string)) {
            throw new IllegalArgumentException("Unsupported format: " + string);
        }
        this.renderer = topologyRenderer;
        this.clipRegion = rectangle;
        this.imageFormat = string;
        this.imageData = new Object[2];
    }

    private TopologyImageData(Object[] objectArray) {
        this.renderer = null;
        this.clipRegion = null;
        this.imageFormat = null;
        this.imageData = objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static TopologyImageData createFromPrimitives(Object object) {
        Object object2;
        if (CCDebug.isOn()) {
            CCDebug.trace3((String)("primitives = " + object));
        }
        Object[] objectArray = null;
        try {
            objectArray = (Object[])object;
            object2 = (String)objectArray[0];
            object2 = (byte[])objectArray[1];
        }
        catch (Exception exception) {
            return null;
        }
        object2 = new TopologyImageData(objectArray);
        if (((TopologyImageData)object2).isEncoded()) {
            if (CCDebug.isOn()) {
                CCDebug.trace3((String)"case 1 image encoding is complete, return image data");
            }
            return object2;
        }
        Object object3 = object2;
        synchronized (object3) {
            long l = 100L;
            while (l < 160000L) {
                if (CCDebug.isOn()) {
                    CCDebug.trace3((String)"case 2: image encoding is in progress");
                }
                Object object4 = object;
                synchronized (object4) {
                    if (((TopologyImageData)object2).isEncoded()) {
                        Object object5 = object2;
                        return object5;
                    }
                }
                if (CCDebug.isOn()) {
                    CCDebug.trace3((String)("case 3: image encode has not yet started - wait " + l));
                }
                try {
                    object2.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l = (long)((double)l * 1.3);
            }
        }
        return null;
    }

    public Object asPrimitives() {
        return this.imageData;
    }

    public String getImageType() {
        return (String)this.imageData[0];
    }

    private void setImageType(String string) {
        this.imageData[0] = string;
    }

    public byte[] getImageBytes() {
        return (byte[])this.imageData[1];
    }

    private void setImageBytes(byte[] byArray) {
        this.imageData[1] = byArray;
    }

    public boolean isEncoded() {
        return this.getImageBytes() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void encodeImage() {
        Object object;
        BufferedImage bufferedImage = null;
        Object object2 = object = this.asPrimitives();
        synchronized (object2) {
            byte[] byArray;
            block7: {
                this.setImageType("image/" + this.imageFormat);
                byArray = new byte[]{};
                try {
                    bufferedImage = this.renderer.getImage(this.clipRegion);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)bufferedImage, this.imageFormat, byteArrayOutputStream);
                    byArray = byteArrayOutputStream.toByteArray();
                }
                catch (Exception exception) {
                    if (!CCDebug.isOn()) break block7;
                    CCDebug.trace1((String)"Image creation/encoding failed", (Throwable)exception);
                }
            }
            this.setImageBytes(byArray);
            if (CCDebug.isOn()) {
                CCDebug.trace3((String)("image bytes = " + byArray + " :" + byArray.length));
            }
        }
        if (bufferedImage != null) {
            bufferedImage.flush();
        }
    }
}

