/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.Assert;
import com.sun.slp.AttributeDescriptor;
import com.sun.slp.Opaque;
import com.sun.slp.ServiceLocationAttribute;
import com.sun.slp.ServiceLocationAttributeDescriptor;
import com.sun.slp.ServiceLocationAttributeVerifier;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.ServiceType;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

class AttributeVerifier
implements ServiceLocationAttributeVerifier {
    private static final String ESC_HASH = "\\23";
    private static final String HASH = "#";
    private static final int TEMPLATE_ATTR_NO = 5;
    private static final int SERVICE_MASK = 1;
    private static final int VERSION_MASK = 2;
    private static final int DESCRIPTION_MASK = 8;
    private static final int URL_PATH_RULES_MASK = 16;
    private static final int TEMPLATE_FOUND = 27;
    private static final String INTEGER_TYPE = "integer";
    private static final String STRING_TYPE = "string";
    private static final String BOOLEAN_TYPE = "boolean";
    private static final String OPAQUE_TYPE = "opaque";
    private static final String KEYWORD_TYPE = "keyword";
    static final String JAVA_STRING_TYPE = "java.lang.String";
    static final String JAVA_INTEGER_TYPE = "java.lang.Integer";
    static final String JAVA_BOOLEAN_TYPE = "java.lang.Boolean";
    static final String JAVA_OPAQUE_TYPE = "[B";
    private static final String TRUE_TOKEN = "true";
    private static final String FALSE_TOKEN = "false";
    private static final int FLAG_NO = 4;
    private static final String MULTIPLE_FLAG = "m";
    private static final String LITERAL_FLAG = "l";
    private static final String EXPLICIT_FLAG = "x";
    private static final String OPTIONAL_FLAG = "o";
    private static final byte MULTIPLE_MASK = 1;
    private static final byte LITERAL_MASK = 2;
    private static final byte EXPLICIT_MASK = 4;
    private static final byte OPTIONAL_MASK = 8;
    private static final char TT_COMMA = ',';
    private static final char TT_EQUALS = '=';
    private static final char TT_FIELD = '#';
    private static final char TT_ESCAPE = '\\';
    private static final char TT_PERIOD = '.';
    private static final char UPPER_START_CODE = 'A';
    private static final char UPPER_END_CODE = 'Z';
    private static final char LOWER_START_CODE = 'a';
    private static final char LOWER_END_CODE = 'z';
    private static final char NUMBER_START_CODE = '0';
    private static final char NUMBER_END_CODE = '9';
    private static final char EXTRA_CODE1 = '+';
    private static final char EXTRA_CODE2 = '/';
    private static final char PAD_CODE = '=';
    private static final char LENGTH_SEPERATOR = ':';
    private ServiceType serviceType;
    private Locale locale;
    private String version;
    private String URLSyntax;
    private String description;
    private Hashtable attributeDescriptors = new Hashtable();

    AttributeVerifier() {
    }

    /*
     * Enabled aggressive block sorting
     */
    private int checkAndAddFlag(String string, int n, AttributeDescriptor attributeDescriptor, int n2) throws ServiceLocationException {
        boolean bl;
        block13: {
            bl = false;
            if (string.equalsIgnoreCase(MULTIPLE_FLAG)) {
                if ((n & 1) != 0) {
                    bl = true;
                    break block13;
                } else {
                    if (attributeDescriptor.getValueType().equals(JAVA_BOOLEAN_TYPE)) {
                        throw new ServiceLocationException(2, "template_boolean_multi", new Object[]{Integer.toString(n2)});
                    }
                    attributeDescriptor.setIsMultivalued(true);
                    return 1;
                }
            }
            if (string.equalsIgnoreCase(LITERAL_FLAG)) {
                if ((n & 2) == 0) {
                    attributeDescriptor.setIsLiteral(true);
                    return 2;
                }
                bl = true;
            } else if (string.equalsIgnoreCase(EXPLICIT_FLAG)) {
                if ((n & 4) == 0) {
                    attributeDescriptor.setRequiresExplicitMatch(true);
                    return 4;
                }
                bl = true;
            } else {
                if (!string.equalsIgnoreCase(OPTIONAL_FLAG)) {
                    throw new ServiceLocationException(2, "template_invalid_attr_flag", new Object[]{Integer.toString(n2)});
                }
                if ((n & 8) == 0) {
                    attributeDescriptor.setIsOptional(true);
                    return 8;
                }
                bl = true;
            }
        }
        if (bl) {
            throw new ServiceLocationException(2, "template_dup_attr_flag", new Object[]{Integer.toString(n2)});
        }
        return 0;
    }

    private void checkAndAddType(String string, AttributeDescriptor attributeDescriptor, int n) throws ServiceLocationException {
        if (string.equalsIgnoreCase(STRING_TYPE)) {
            attributeDescriptor.setValueType(JAVA_STRING_TYPE);
        } else if (string.equalsIgnoreCase(INTEGER_TYPE)) {
            attributeDescriptor.setValueType(JAVA_INTEGER_TYPE);
        } else if (string.equalsIgnoreCase(BOOLEAN_TYPE)) {
            attributeDescriptor.setValueType(JAVA_BOOLEAN_TYPE);
        } else if (string.equalsIgnoreCase(OPAQUE_TYPE)) {
            attributeDescriptor.setValueType(JAVA_OPAQUE_TYPE);
        } else if (string.equalsIgnoreCase(KEYWORD_TYPE)) {
            attributeDescriptor.setIsKeyword(true);
        } else {
            throw new ServiceLocationException(2, "template_not_slp_type", new Object[]{Integer.toString(n)});
        }
    }

    private void checkDefaultValues(AttributeDescriptor attributeDescriptor) throws ServiceLocationException {
        Object object;
        if (attributeDescriptor.getIsKeyword()) {
            return;
        }
        Enumeration enumeration = attributeDescriptor.getDefaultValues();
        Enumeration enumeration2 = attributeDescriptor.getAllowedValues();
        Vector vector = new Vector();
        String string = attributeDescriptor.getValueType();
        while (enumeration2.hasMoreElements()) {
            object = enumeration2.nextElement();
            if (string.equals(JAVA_STRING_TYPE)) {
                object = ((String)object).toLowerCase();
            } else if (string.equals(JAVA_OPAQUE_TYPE)) {
                object = new Opaque((byte[])object);
            }
            vector.addElement(object);
        }
        if (vector.size() > 0) {
            if (!enumeration.hasMoreElements()) {
                throw new ServiceLocationException(2, "template_no_init", new Object[]{attributeDescriptor.getId()});
            }
            object = null;
            while (enumeration.hasMoreElements()) {
                Object object2 = enumeration.nextElement();
                object = object2;
                if (string.equals(JAVA_STRING_TYPE)) {
                    object2 = ((String)object2).toLowerCase();
                } else if (string.equals(JAVA_OPAQUE_TYPE)) {
                    object2 = new Opaque((byte[])object2);
                }
                if (vector.indexOf(object2) == -1) continue;
                return;
            }
            throw new ServiceLocationException(2, "template_wrong_init", new Object[]{object.toString(), attributeDescriptor.getId()});
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object convertValue(String string, String string2, int n) throws ServiceLocationException, IOException {
        String string3 = null;
        if (string.equals(JAVA_STRING_TYPE)) {
            string2 = this.unescapeHash(string2);
            return ServiceLocationAttribute.unescapeAttributeString(string2, false);
        }
        if (string.equals(JAVA_INTEGER_TYPE)) {
            try {
                return Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ServiceLocationException(2, "template_expect_int", new Object[]{Integer.toString(n), string2});
            }
        }
        if (string.equals(JAVA_BOOLEAN_TYPE)) {
            if (string2.equalsIgnoreCase(TRUE_TOKEN)) {
                return new Boolean(true);
            }
            if (!string2.equalsIgnoreCase(FALSE_TOKEN)) throw new ServiceLocationException(2, "template_expect_bool", new Object[]{Integer.toString(n), string2});
            return new Boolean(false);
        }
        if (string.equals(JAVA_OPAQUE_TYPE)) {
            return (String)Opaque.unescapeByteArray(string2);
        }
        Assert.assert(false, "template_attr_desc", new Object[0]);
        return string3;
    }

    public ServiceLocationAttributeDescriptor getAttributeDescriptor(String string) {
        return (ServiceLocationAttributeDescriptor)this.attributeDescriptors.get(string.toLowerCase());
    }

    public Enumeration getAttributeDescriptors() {
        return ((Hashtable)this.attributeDescriptors.clone()).elements();
    }

    public String getDescription() {
        return this.description;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public String getURLSyntax() {
        return this.URLSyntax;
    }

    public String getVersion() {
        return this.version;
    }

    private void initCommonToken(StreamTokenizer streamTokenizer) {
        streamTokenizer.wordChars(65, 90);
        streamTokenizer.wordChars(97, 122);
        streamTokenizer.wordChars(48, 57);
        streamTokenizer.wordChars(38, 38);
        streamTokenizer.wordChars(42, 42);
        streamTokenizer.wordChars(58, 58);
        streamTokenizer.wordChars(45, 45);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.wordChars(36, 36);
        streamTokenizer.wordChars(43, 43);
        streamTokenizer.wordChars(64, 64);
        streamTokenizer.wordChars(46, 46);
        streamTokenizer.wordChars(124, 124);
        streamTokenizer.wordChars(60, 60);
        streamTokenizer.wordChars(62, 62);
        streamTokenizer.wordChars(126, 126);
    }

    private void initFieldChar(StreamTokenizer streamTokenizer) {
        this.initForBase(streamTokenizer);
        streamTokenizer.wordChars(9, 9);
        streamTokenizer.wordChars(32, 47);
        streamTokenizer.wordChars(48, 57);
        streamTokenizer.wordChars(58, 64);
        streamTokenizer.wordChars(65, 90);
        streamTokenizer.wordChars(91, 96);
        streamTokenizer.wordChars(97, 122);
        streamTokenizer.wordChars(123, 126);
        streamTokenizer.whitespaceChars(13, 13);
        streamTokenizer.whitespaceChars(10, 10);
        streamTokenizer.eolIsSignificant(true);
    }

    private void initForBase(StreamTokenizer streamTokenizer) {
        streamTokenizer.resetSyntax();
        streamTokenizer.whitespaceChars(10, 10);
        streamTokenizer.lowerCaseMode(false);
    }

    private void initIdChar(StreamTokenizer streamTokenizer) {
        this.initForBase(streamTokenizer);
        this.initCommonToken(streamTokenizer);
        streamTokenizer.wordChars(92, 92);
        streamTokenizer.whitespaceChars(32, 32);
        streamTokenizer.whitespaceChars(9, 9);
        streamTokenizer.eolIsSignificant(false);
        streamTokenizer.lowerCaseMode(false);
    }

    private void initIntItemChar(StreamTokenizer streamTokenizer) {
        this.initForBase(streamTokenizer);
        streamTokenizer.wordChars(48, 57);
        streamTokenizer.wordChars(45, 45);
        streamTokenizer.wordChars(43, 43);
        streamTokenizer.whitespaceChars(32, 32);
        streamTokenizer.whitespaceChars(9, 9);
        streamTokenizer.whitespaceChars(13, 13);
        streamTokenizer.whitespaceChars(10, 10);
        streamTokenizer.eolIsSignificant(true);
    }

    private void initSchemeIdChar(StreamTokenizer streamTokenizer) {
        this.initForBase(streamTokenizer);
        streamTokenizer.wordChars(65, 90);
        streamTokenizer.wordChars(97, 122);
        streamTokenizer.wordChars(48, 57);
        streamTokenizer.wordChars(45, 45);
        streamTokenizer.wordChars(43, 43);
        streamTokenizer.wordChars(46, 46);
        streamTokenizer.wordChars(58, 58);
        streamTokenizer.whitespaceChars(32, 32);
        streamTokenizer.whitespaceChars(9, 9);
        streamTokenizer.eolIsSignificant(false);
        streamTokenizer.lowerCaseMode(false);
    }

    private void initStringItemChar(StreamTokenizer streamTokenizer) {
        this.initForBase(streamTokenizer);
        streamTokenizer.wordChars(9, 9);
        streamTokenizer.wordChars(32, 34);
        streamTokenizer.wordChars(36, 43);
        streamTokenizer.wordChars(45, 47);
        streamTokenizer.wordChars(48, 57);
        streamTokenizer.wordChars(58, 58);
        streamTokenizer.wordChars(60, 64);
        streamTokenizer.wordChars(65, 90);
        streamTokenizer.wordChars(91, 96);
        streamTokenizer.wordChars(97, 122);
        streamTokenizer.wordChars(123, 126);
        streamTokenizer.whitespaceChars(13, 13);
        streamTokenizer.whitespaceChars(10, 10);
        streamTokenizer.eolIsSignificant(true);
    }

    void initialize(Reader reader) throws ServiceLocationException {
        StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
        this.initFieldChar(streamTokenizer);
        this.parseTemplate(streamTokenizer);
    }

    void initializeAttributesOnly(Reader reader) throws ServiceLocationException {
        StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
        this.initFieldChar(streamTokenizer);
        this.parseAttributes(streamTokenizer);
    }

    private void parseAllowedValues(StreamTokenizer streamTokenizer, AttributeDescriptor attributeDescriptor, int n) throws ServiceLocationException, IOException {
        Vector vector = this.parseValueList(streamTokenizer, attributeDescriptor, n);
        attributeDescriptor.setAllowedValues(vector);
    }

    private AttributeDescriptor parseAttribute(StreamTokenizer streamTokenizer) throws ServiceLocationException {
        AttributeDescriptor attributeDescriptor = new AttributeDescriptor();
        int n = 0;
        try {
            StreamTokenizer streamTokenizer2;
            int n2;
            block31: {
                block32: {
                    String string;
                    int n3;
                    String string2;
                    block29: {
                        n = streamTokenizer.lineno();
                        n2 = streamTokenizer.nextToken();
                        if (n2 != -3) {
                            throw new ServiceLocationException(2, "template_attr_syntax", new Object[]{Integer.toString(streamTokenizer.lineno())});
                        }
                        streamTokenizer2 = new StreamTokenizer(new StringReader(streamTokenizer.sval));
                        this.initIdChar(streamTokenizer2);
                        this.parseId(streamTokenizer2, attributeDescriptor, n);
                        this.parseTypeAndFlags(streamTokenizer2, attributeDescriptor, n);
                        n2 = streamTokenizer.nextToken();
                        if (n2 == -1) {
                            throw new ServiceLocationException(2, "template_end_error", new Object[]{Integer.toString(streamTokenizer.lineno())});
                        }
                        if (n2 != 10) {
                            throw new ServiceLocationException(2, "template_unk_token", new Object[]{Integer.toString(streamTokenizer.lineno())});
                        }
                        if (!attributeDescriptor.getIsKeyword()) {
                            block30: {
                                string2 = "";
                                while (true) {
                                    n3 = n2;
                                    n = streamTokenizer.lineno();
                                    n2 = streamTokenizer.nextToken();
                                    if (n2 == -3) {
                                        string = streamTokenizer.sval.trim();
                                        if (string.charAt(0) == '#') {
                                            if (string2.length() > 0) {
                                                streamTokenizer2 = new StreamTokenizer(new StringReader(string2));
                                                this.parseDefaultValues(streamTokenizer2, attributeDescriptor, n);
                                            }
                                            streamTokenizer.pushBack();
                                            break block29;
                                        }
                                        string2 = String.valueOf(string2) + string;
                                        continue;
                                    }
                                    if (n2 != 10) break block30;
                                    if (n3 == 10) break;
                                }
                                if (string2.length() > 0) {
                                    streamTokenizer2 = new StreamTokenizer(new StringReader(string2));
                                    this.parseDefaultValues(streamTokenizer2, attributeDescriptor, n);
                                }
                                return attributeDescriptor;
                            }
                            if (n2 == -1) {
                                throw new ServiceLocationException(2, "template_end_error", new Object[]{Integer.toString(streamTokenizer.lineno())});
                            }
                            throw new ServiceLocationException(2, "template_unk_token", new Object[]{Integer.toString(streamTokenizer.lineno())});
                        }
                        attributeDescriptor.setDefaultValues(null);
                        attributeDescriptor.setAllowedValues(null);
                        n2 = streamTokenizer.nextToken();
                        if (n2 == 10) {
                            return attributeDescriptor;
                        }
                        if (n2 == -3) {
                            string2 = streamTokenizer.sval.trim();
                            if (string2.charAt(0) != '#') {
                                throw new ServiceLocationException(2, "template_attr_syntax", new Object[]{Integer.toString(streamTokenizer.lineno())});
                            }
                            streamTokenizer.pushBack();
                        } else {
                            if (n2 == -1) {
                                throw new ServiceLocationException(2, "template_end_error", new Object[]{Integer.toString(streamTokenizer.lineno())});
                            }
                            throw new ServiceLocationException(2, "template_unk_token", new Object[]{Integer.toString(streamTokenizer.lineno())});
                        }
                    }
                    string2 = "";
                    while (true) {
                        n3 = n2;
                        n = streamTokenizer.lineno();
                        n2 = streamTokenizer.nextToken();
                        if (n2 == -3) {
                            string = streamTokenizer.sval.trim();
                            if (string.charAt(0) == '#') {
                                string2 = String.valueOf(string2) + string.substring(1) + "\n";
                                continue;
                            }
                            if (string2.length() > 0) {
                                attributeDescriptor.setDescription(string2);
                            }
                            break block31;
                        }
                        if (n2 != 10 && n2 != -1) break block32;
                        if (n3 == 10) {
                            if (string2.length() > 0) {
                                attributeDescriptor.setDescription(string2);
                            }
                            if (attributeDescriptor.getIsKeyword()) {
                                attributeDescriptor.setAllowedValues(null);
                            }
                            return attributeDescriptor;
                        }
                        if (n2 == -1) break;
                    }
                    throw new ServiceLocationException(2, "template_end_error", new Object[]{Integer.toString(streamTokenizer.lineno())});
                }
                throw new ServiceLocationException(2, "template_unk_token", new Object[]{Integer.toString(streamTokenizer.lineno())});
            }
            streamTokenizer.pushBack();
            if (!attributeDescriptor.getIsKeyword()) {
                block33: {
                    String string = "";
                    while (true) {
                        int n4 = n2;
                        n = streamTokenizer.lineno();
                        n2 = streamTokenizer.nextToken();
                        if (n2 == -3) {
                            string = String.valueOf(string) + streamTokenizer.sval;
                            continue;
                        }
                        if (n2 != 10) break block33;
                        if (n4 == 10) break;
                    }
                    if (string.length() > 0) {
                        streamTokenizer2 = new StreamTokenizer(new StringReader(string));
                        this.parseAllowedValues(streamTokenizer2, attributeDescriptor, n);
                    }
                    return attributeDescriptor;
                }
                if (n2 == -1) {
                    throw new ServiceLocationException(2, "template_end_error", new Object[]{Integer.toString(streamTokenizer.lineno())});
                }
                throw new ServiceLocationException(2, "template_unk_token", new Object[]{Integer.toString(streamTokenizer.lineno())});
            }
            throw new ServiceLocationException(2, "template_attr_syntax", new Object[]{Integer.toString(streamTokenizer.lineno())});
        }
        catch (IOException iOException) {
            throw new ServiceLocationException(20, "template_io_error", new Object[]{Integer.toString(streamTokenizer.lineno()), iOException.getMessage()});
        }
    }

    private void parseAttributes(StreamTokenizer streamTokenizer) throws ServiceLocationException {
        try {
            int n;
            while ((n = streamTokenizer.nextToken()) != -1) {
                streamTokenizer.pushBack();
                AttributeDescriptor attributeDescriptor = this.parseAttribute(streamTokenizer);
                this.checkDefaultValues(attributeDescriptor);
                String string = attributeDescriptor.getId().toLowerCase();
                if (this.attributeDescriptors.get(string) != null) {
                    throw new ServiceLocationException(2, "template_dup_def", new Object[]{Integer.toString(streamTokenizer.lineno())});
                }
                this.attributeDescriptors.put(string, attributeDescriptor);
            }
        }
        catch (IOException iOException) {
            throw new ServiceLocationException(20, "template_io_error", new Object[]{Integer.toString(streamTokenizer.lineno())});
        }
    }

    private void parseDefaultValues(StreamTokenizer streamTokenizer, AttributeDescriptor attributeDescriptor, int n) throws ServiceLocationException, IOException {
        Vector vector = this.parseValueList(streamTokenizer, attributeDescriptor, n);
        if (!attributeDescriptor.getIsMultivalued() && vector.size() > 1) {
            throw new ServiceLocationException(2, "template_attr_syntax", new Object[]{Integer.toString(streamTokenizer.lineno() + n)});
        }
        attributeDescriptor.setDefaultValues(vector);
    }

    private void parseId(StreamTokenizer streamTokenizer, AttributeDescriptor attributeDescriptor, int n) throws ServiceLocationException, IOException {
        String string = this.parseWord(streamTokenizer, n);
        int n2 = streamTokenizer.nextToken();
        if (n2 != 61) {
            throw new ServiceLocationException(2, "template_attr_syntax", new Object[]{Integer.toString(streamTokenizer.lineno() + n)});
        }
        string = this.unescapeHash(string);
        string = ServiceLocationAttribute.unescapeAttributeString(string, true);
        attributeDescriptor.setId(string);
    }

    private void parseTemplate(StreamTokenizer streamTokenizer) throws ServiceLocationException {
        this.parseTemplateAttributes(streamTokenizer);
        this.parseAttributes(streamTokenizer);
    }

    private int parseTemplateAttribute(StreamTokenizer streamTokenizer, int n) throws ServiceLocationException, IOException {
        int n2;
        boolean bl;
        int n3;
        block33: {
            block38: {
                block39: {
                    block40: {
                        block31: {
                            int n4;
                            String string;
                            StringReader stringReader;
                            block35: {
                                block36: {
                                    block37: {
                                        block30: {
                                            StreamTokenizer streamTokenizer2;
                                            block34: {
                                                block32: {
                                                    n3 = streamTokenizer.nextToken();
                                                    if (n3 != -3) {
                                                        throw new ServiceLocationException(2, "template_assign_error", new Object[]{Integer.toString(streamTokenizer.lineno())});
                                                    }
                                                    stringReader = new StringReader(streamTokenizer.sval);
                                                    streamTokenizer2 = new StreamTokenizer(stringReader);
                                                    this.initIdChar(streamTokenizer2);
                                                    n3 = streamTokenizer.nextToken();
                                                    if (n3 == -1) {
                                                        throw new ServiceLocationException(2, "template_end_error", new Object[]{Integer.toString(streamTokenizer.lineno())});
                                                    }
                                                    if (n3 != 10) {
                                                        throw new ServiceLocationException(2, "template_unk_token", new Object[]{Integer.toString(streamTokenizer.lineno())});
                                                    }
                                                    n3 = streamTokenizer2.nextToken();
                                                    if (n3 != -3) {
                                                        throw new ServiceLocationException(2, "template_missing_id", new Object[]{Integer.toString(streamTokenizer.lineno())});
                                                    }
                                                    string = streamTokenizer2.sval;
                                                    bl = false;
                                                    n2 = 0;
                                                    n3 = streamTokenizer2.nextToken();
                                                    if (n3 != 61) {
                                                        throw new ServiceLocationException(2, "template_missing_eq ", new Object[]{Integer.toString(streamTokenizer.lineno())});
                                                    }
                                                    if (!string.equalsIgnoreCase("template-type")) break block32;
                                                    if ((n & 1) == 0) {
                                                        n3 = streamTokenizer2.nextToken();
                                                        if (n3 != -3) {
                                                            throw new ServiceLocationException(2, "template_srv_type_err", new Object[]{Integer.toString(streamTokenizer.lineno())});
                                                        }
                                                        StreamTokenizer streamTokenizer3 = new StreamTokenizer(new StringReader(streamTokenizer2.sval));
                                                        this.initSchemeIdChar(streamTokenizer3);
                                                        if (streamTokenizer3.nextToken() != -3 || !streamTokenizer2.sval.equals(streamTokenizer3.sval)) {
                                                            throw new ServiceLocationException(2, "template_srv_type_err", new Object[]{Integer.toString(streamTokenizer.lineno())});
                                                        }
                                                        String string2 = streamTokenizer3.sval;
                                                        if (!string2.startsWith("service:")) {
                                                            string2 = "service:" + string2;
                                                        }
                                                        this.serviceType = new ServiceType(string2);
                                                        n3 = streamTokenizer2.nextToken();
                                                        if (n3 != -1) {
                                                            throw new ServiceLocationException(2, "template_srv_type_err", new Object[]{Integer.toString(streamTokenizer.lineno())});
                                                        }
                                                        n2 = 1;
                                                    } else {
                                                        bl = true;
                                                    }
                                                    break block33;
                                                }
                                                if (!string.equalsIgnoreCase("template-version")) break block34;
                                                if ((n & 2) == 0) {
                                                    n3 = streamTokenizer2.nextToken();
                                                    if (n3 != -3) {
                                                        throw new ServiceLocationException(2, "template_vers_err", new Object[]{Integer.toString(streamTokenizer.lineno())});
                                                    }
                                                    String string3 = streamTokenizer2.sval;
                                                    if (string3.indexOf(46) == -1) {
                                                        throw new ServiceLocationException(2, "template_vers_mssing", new Object[]{Integer.toString(streamTokenizer.lineno())});
                                                    }
                                                    try {
                                                        new Float(string3);
                                                    }
                                                    catch (NumberFormatException numberFormatException) {
                                                        throw new ServiceLocationException(2, "template_vers_err", new Object[]{Integer.toString(streamTokenizer.lineno())});
                                                    }
                                                    this.version = string3;
                                                    n3 = streamTokenizer2.nextToken();
                                                    if (n3 != -1) {
                                                        throw new ServiceLocationException(2, "template_vers_err", new Object[]{Integer.toString(streamTokenizer.lineno())});
                                                    }
                                                    n2 = 2;
                                                } else {
                                                    bl = true;
                                                }
                                                break block33;
                                            }
                                            if (!string.equalsIgnoreCase("template-description")) break block35;
                                            if (streamTokenizer2.nextToken() != -1) {
                                                throw new ServiceLocationException(2, "template_attr_syntax", new Object[]{Integer.toString(streamTokenizer.lineno())});
                                            }
                                            if ((n & 8) != 0) break block36;
                                            String string4 = "";
                                            while (true) {
                                                int n5 = n3;
                                                n3 = streamTokenizer.nextToken();
                                                if (n3 == -3) {
                                                    string4 = String.valueOf(string4) + streamTokenizer.sval + "\n";
                                                    continue;
                                                }
                                                if (n3 != 10) break block30;
                                                if (n5 == 10) break;
                                            }
                                            if (string4.length() > 0) {
                                                this.description = string4;
                                            }
                                            break block37;
                                        }
                                        if (n3 == -1) {
                                            throw new ServiceLocationException(2, "template_end_error", new Object[]{Integer.toString(streamTokenizer.lineno())});
                                        }
                                        throw new ServiceLocationException(2, "template_unk_token", new Object[]{Integer.toString(streamTokenizer.lineno())});
                                    }
                                    streamTokenizer.pushBack();
                                    n2 = 8;
                                    break block33;
                                }
                                bl = true;
                                break block33;
                            }
                            if (!string.equalsIgnoreCase("template-url-syntax")) break block38;
                            if ((n & 0x10) != 0) break block39;
                            String string5 = "";
                            while ((n4 = stringReader.read()) != -1) {
                                string5 = String.valueOf(string5) + (char)n4;
                            }
                            string5 = String.valueOf(string5) + "\n";
                            n3 = 10;
                            while (true) {
                                int n6 = n3;
                                n3 = streamTokenizer.nextToken();
                                if (n3 == -3) {
                                    string5 = String.valueOf(string5) + streamTokenizer.sval + "\n";
                                    continue;
                                }
                                if (n3 != 10) break block31;
                                if (n6 == 10) break;
                            }
                            if (string5.length() > 0) {
                                this.URLSyntax = string5;
                            }
                            break block40;
                        }
                        if (n3 == -1) {
                            throw new ServiceLocationException(2, "template_end_error", new Object[]{Integer.toString(streamTokenizer.lineno())});
                        }
                        throw new ServiceLocationException(2, "template_unk_token", new Object[]{Integer.toString(streamTokenizer.lineno())});
                    }
                    streamTokenizer.pushBack();
                    n2 = 16;
                    break block33;
                }
                bl = true;
                break block33;
            }
            throw new ServiceLocationException(2, "template_nontattribute_err", new Object[]{Integer.toString(streamTokenizer.lineno())});
        }
        if (bl) {
            throw new ServiceLocationException(2, "template_dup_def", new Object[]{Integer.toString(streamTokenizer.lineno())});
        }
        n3 = streamTokenizer.nextToken();
        if (n3 != 10) {
            throw new ServiceLocationException(2, "template_attr_syntax", new Object[]{Integer.toString(streamTokenizer.lineno())});
        }
        return n2;
    }

    private void parseTemplateAttributes(StreamTokenizer streamTokenizer) throws ServiceLocationException {
        int n = 0;
        try {
            while ((n |= this.parseTemplateAttribute(streamTokenizer, n)) != 27) {
            }
        }
        catch (IOException iOException) {
            throw new ServiceLocationException(20, "template_io_error", new Object[]{Integer.toString(streamTokenizer.lineno())});
        }
    }

    private void parseTypeAndFlags(StreamTokenizer streamTokenizer, AttributeDescriptor attributeDescriptor, int n) throws ServiceLocationException, IOException {
        int n2 = 0;
        String string = this.parseWord(streamTokenizer, n);
        this.checkAndAddType(string, attributeDescriptor, streamTokenizer.lineno() + n);
        while (streamTokenizer.nextToken() != -1) {
            streamTokenizer.pushBack();
            int n3 = streamTokenizer.lineno();
            String string2 = this.parseWord(streamTokenizer, n);
            if (attributeDescriptor.getIsKeyword()) {
                throw new ServiceLocationException(2, "template_attr_syntax", new Object[]{Integer.toString(streamTokenizer.lineno() + n)});
            }
            n2 |= this.checkAndAddFlag(string2, n2, attributeDescriptor, n + n3);
        }
    }

    private Vector parseValueList(StreamTokenizer streamTokenizer, AttributeDescriptor attributeDescriptor, int n) throws ServiceLocationException, IOException {
        int n2;
        boolean bl;
        Vector<Object> vector;
        block12: {
            vector = new Vector<Object>();
            String string = attributeDescriptor.getValueType();
            if (string.equals(JAVA_STRING_TYPE) || string.equals(JAVA_OPAQUE_TYPE)) {
                this.initStringItemChar(streamTokenizer);
            } else if (string.equals(JAVA_INTEGER_TYPE)) {
                this.initIntItemChar(streamTokenizer);
            } else if (string.equals(JAVA_BOOLEAN_TYPE)) {
                this.initIdChar(streamTokenizer);
            }
            boolean bl2 = true;
            bl = false;
            String string2 = "";
            n2 = 0;
            while (true) {
                int n3 = streamTokenizer.nextToken();
                n2 = streamTokenizer.lineno() + n;
                if (n3 == -3) {
                    if (!bl2) {
                        bl = true;
                    }
                    string2 = streamTokenizer.sval.trim();
                    Object object = this.convertValue(string, string2, n);
                    vector.addElement(object);
                    bl2 = false;
                    continue;
                }
                if (n3 == -1) {
                    if (bl2) {
                        bl = true;
                    }
                    break block12;
                }
                if (n3 != 44) break;
                if (bl2) {
                    bl = true;
                    break block12;
                }
                bl2 = true;
            }
            bl = true;
        }
        if (bl) {
            throw new ServiceLocationException(2, "template_attr_syntax", new Object[]{Integer.toString(n2)});
        }
        return vector;
    }

    private String parseWord(StreamTokenizer streamTokenizer, int n) throws ServiceLocationException, IOException {
        int n2 = streamTokenizer.nextToken();
        if (n2 == -3) {
            return streamTokenizer.sval;
        }
        String string = "";
        string = n2 == -2 ? Double.toString(streamTokenizer.nval) : (n2 == 10 ? "<end of line>" : (n2 == -1 ? "<end of file>" : new Character((char)n2).toString()));
        throw new ServiceLocationException(2, "template_invalid_tok", new Object[]{Integer.toString(streamTokenizer.lineno() + n)});
    }

    private String unescapeHash(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = ESC_HASH.length();
        int n2 = 0;
        int n3 = string.indexOf(ESC_HASH, n2);
        while (n3 != -1) {
            stringBuffer.append(string.substring(n2, n3));
            stringBuffer.append(HASH);
            n2 = n3 + n;
            n3 = string.indexOf(ESC_HASH, n2);
        }
        n = string.length();
        if (n2 < n) {
            stringBuffer.append(string.substring(n2, n));
        }
        return stringBuffer.toString();
    }

    public void verifyAttribute(ServiceLocationAttribute serviceLocationAttribute) throws ServiceLocationException {
        String string = serviceLocationAttribute.getId().toLowerCase();
        ServiceLocationAttributeDescriptor serviceLocationAttributeDescriptor = (ServiceLocationAttributeDescriptor)this.attributeDescriptors.get(string);
        if (serviceLocationAttributeDescriptor == null) {
            throw new ServiceLocationException(2, "template_no_attribute", new Object[]{string});
        }
        String string2 = serviceLocationAttributeDescriptor.getValueType();
        Vector vector = serviceLocationAttribute.getValues();
        if (serviceLocationAttributeDescriptor.getIsKeyword()) {
            if (vector != null) {
                throw new ServiceLocationException(2, "template_not_null", new Object[]{string});
            }
        } else {
            Object object;
            if (vector == null) {
                throw new ServiceLocationException(2, "template_null", new Object[]{string});
            }
            int n = vector.size();
            if (n > 1 && !serviceLocationAttributeDescriptor.getIsMultivalued()) {
                throw new ServiceLocationException(2, "template_not_multi", new Object[]{string});
            }
            Vector<String> vector2 = null;
            Enumeration enumeration = serviceLocationAttributeDescriptor.getAllowedValues();
            if (enumeration.hasMoreElements()) {
                vector2 = new Vector<String>();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    if (string2.equals(JAVA_STRING_TYPE)) {
                        object = ((String)object).toLowerCase();
                    } else if (string2.equals(JAVA_OPAQUE_TYPE)) {
                        object = new Opaque((byte[])object);
                    }
                    vector2.addElement((String)object);
                }
            }
            object = serviceLocationAttributeDescriptor.getValueType();
            int n2 = 0;
            while (n2 < n) {
                Object object2 = vector.elementAt(n2);
                String string3 = object2.getClass().getName();
                if (!string3.equals(object)) {
                    throw new ServiceLocationException(2, "template_type_mismatch", new Object[]{string, string3, object});
                }
                if (string2.equals(JAVA_STRING_TYPE)) {
                    object2 = ((String)object2).toLowerCase();
                } else if (string2.equals(JAVA_OPAQUE_TYPE)) {
                    object2 = new Opaque((byte[])object2);
                }
                if (vector2 != null && !vector2.contains(object2)) {
                    throw new ServiceLocationException(2, "template_not_allowed_value", new Object[]{string, object2});
                }
                ++n2;
            }
        }
    }

    public void verifyRegistration(Vector vector) throws ServiceLocationException {
        Assert.nonNullParameter(vector, "attributeVector");
        if (vector.size() <= 0) {
            Enumeration enumeration = this.attributeDescriptors.elements();
            while (enumeration.hasMoreElements()) {
                ServiceLocationAttributeDescriptor serviceLocationAttributeDescriptor = (ServiceLocationAttributeDescriptor)enumeration.nextElement();
                if (serviceLocationAttributeDescriptor.getIsOptional()) continue;
                throw new ServiceLocationException(2, "template_missing_required", new Object[]{serviceLocationAttributeDescriptor.getId()});
            }
        } else {
            Object object;
            Object object2;
            int n = vector.size();
            Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
            int n2 = 0;
            while (n2 < n) {
                object2 = (ServiceLocationAttribute)vector.elementAt(n2);
                object = ((ServiceLocationAttribute)object2).getId().toLowerCase();
                if (hashtable.get(object) != null) {
                    throw new ServiceLocationException(2, "template_dup", new Object[]{((ServiceLocationAttribute)object2).getId()});
                }
                this.verifyAttribute((ServiceLocationAttribute)object2);
                hashtable.put(object, object2);
                ++n2;
            }
            object2 = this.attributeDescriptors.elements();
            while (object2.hasMoreElements()) {
                object = (ServiceLocationAttributeDescriptor)object2.nextElement();
                String string = object.getId();
                if (object.getIsOptional() || hashtable.get(string.toLowerCase()) != null) continue;
                throw new ServiceLocationException(2, "template_missing_required", new Object[]{string});
            }
        }
    }
}

