/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.AuthBlock;
import com.sun.slp.SLPConfig;
import com.sun.slp.SLPHeaderV2;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.ServiceType;
import com.sun.slp.ServiceURL;
import com.sun.slp.SrvLocMsgImpl;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Vector;

class CSrvMsg
extends SrvLocMsgImpl {
    Vector serviceURLs = new Vector();
    Hashtable URLSignatures = new Hashtable();

    protected CSrvMsg() {
    }

    CSrvMsg(SLPHeaderV2 sLPHeaderV2, DataInputStream dataInputStream) throws ServiceLocationException, IOException {
        super(sLPHeaderV2, 2);
        if (sLPHeaderV2.errCode != 0) {
            return;
        }
        this.parseServiceURLsIn(sLPHeaderV2, dataInputStream);
    }

    CSrvMsg(Locale locale, ServiceType serviceType, Vector vector, String string) throws ServiceLocationException {
        this.initialize(locale, serviceType, vector, string);
    }

    final Hashtable getURLSignature(ServiceURL serviceURL) {
        return (Hashtable)this.URLSignatures.get(serviceURL);
    }

    protected void initialize(Locale locale, ServiceType serviceType, Vector vector, String string) throws ServiceLocationException {
        LinkedList linkedList;
        SLPHeaderV2 sLPHeaderV2 = new SLPHeaderV2(1, false, locale);
        this.hdr = sLPHeaderV2;
        sLPHeaderV2.scopes = (Vector)vector.clone();
        sLPHeaderV2.previousResponders = new Vector();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        SLPHeaderV2.escapeScopeStrings(vector);
        String string2 = "";
        if (SLPConfig.getSLPConfig().getHasSecurity() && (linkedList = AuthBlock.getSPIList("sun.net.slp.SPIs")) != null && !linkedList.isEmpty()) {
            string2 = (String)linkedList.getFirst();
        }
        sLPHeaderV2.putString(serviceType.toString(), byteArrayOutputStream);
        sLPHeaderV2.parseCommaSeparatedListOut(vector, byteArrayOutputStream);
        sLPHeaderV2.putString(string, byteArrayOutputStream);
        sLPHeaderV2.putString(string2, byteArrayOutputStream);
        sLPHeaderV2.payload = byteArrayOutputStream.toByteArray();
    }

    protected void parseServiceURLsIn(SLPHeaderV2 sLPHeaderV2, DataInputStream dataInputStream) throws ServiceLocationException, IOException {
        int n = sLPHeaderV2.getInt(dataInputStream);
        int n2 = 0;
        while (n2 < n) {
            ServiceURL serviceURL = sLPHeaderV2.parseServiceURLIn(dataInputStream, this.URLSignatures, (short)2);
            this.serviceURLs.addElement(serviceURL);
            Hashtable hashtable = (Hashtable)this.URLSignatures.get(serviceURL);
            if (hashtable != null) {
                AuthBlock.verifyAll(hashtable);
            }
            ++n2;
        }
        sLPHeaderV2.iNumReplies = this.serviceURLs.size();
    }

    final void setURLSignature(ServiceURL serviceURL, Hashtable hashtable) throws IllegalArgumentException {
        if (hashtable == null) {
            this.URLSignatures.remove(serviceURL);
        } else {
            this.URLSignatures.put(serviceURL, hashtable);
        }
    }
}

