/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.SLPConfig;
import com.sun.slp.ServiceLocationException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class ServiceType
implements Serializable {
    boolean isServiceURL = true;
    private String type1 = "";
    private String type2 = "";
    private String na = "";
    static final String IANA = "iana";

    public ServiceType(String string) throws IllegalArgumentException {
        this.parse(string);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ServiceType)) {
            return false;
        }
        ServiceType serviceType = (ServiceType)object;
        return this.isServiceURL == serviceType.isServiceURL && this.type1.equals(serviceType.type1) && this.type2.equals(serviceType.type2) && this.na.equals(serviceType.na);
    }

    public String getAbstractTypeName() {
        if (this.isAbstractType()) {
            return "service:" + this.type1 + (this.na.length() > 0 ? "." + this.na : "");
        }
        return "";
    }

    public String getConcreteTypeName() {
        return this.type2;
    }

    public String getNamingAuthority() {
        return this.na;
    }

    public String getPrincipleTypeName() {
        return this.type1;
    }

    public int hashCode() {
        return this.type1.hashCode() + this.na.hashCode() + this.type2.hashCode() + (this.isServiceURL ? "service".hashCode() : 0);
    }

    public boolean isAbstractType() {
        return this.type2.length() > 0;
    }

    public boolean isNADefault() {
        return this.na.length() <= 0;
    }

    public boolean isServiceURL() {
        return this.isServiceURL;
    }

    private void parse(String string) {
        block12: {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":.", true);
            try {
                String string2 = stringTokenizer.nextToken();
                if (string2.equals(":") || string2.equals(".")) break block12;
                if (!string2.equalsIgnoreCase("service")) {
                    this.isServiceURL = false;
                    while (true) {
                        this.type1 = String.valueOf(this.type1) + string2.toLowerCase();
                        if (!stringTokenizer.hasMoreTokens()) break;
                        string2 = stringTokenizer.nextToken();
                    }
                    ServiceType.validateTypeComponentInternal(this.type1, true);
                    if (!stringTokenizer.hasMoreTokens()) {
                        return;
                    }
                    break block12;
                }
                string2 = stringTokenizer.nextToken();
                if (!string2.equals(":")) break block12;
                this.type1 = stringTokenizer.nextToken().toLowerCase();
                ServiceType.validateTypeComponent(this.type1);
                if (!stringTokenizer.hasMoreTokens()) {
                    return;
                }
                string2 = stringTokenizer.nextToken();
                if (string2.equals(".")) {
                    string2 = stringTokenizer.nextToken();
                    ServiceType.validateTypeComponent(string2);
                    if (string2.equalsIgnoreCase(IANA)) break block12;
                    this.na = string2.toLowerCase();
                    if (!stringTokenizer.hasMoreTokens()) {
                        return;
                    }
                    string2 = stringTokenizer.nextToken();
                }
                if (string2.equals(":")) {
                    string2 = stringTokenizer.nextToken();
                    ServiceType.validateTypeComponent(string2);
                    this.type2 = string2.toLowerCase();
                    if (!stringTokenizer.hasMoreTokens()) {
                        return;
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new IllegalArgumentException(SLPConfig.getSLPConfig().formatMessage("service_type_syntax", new Object[]{string}));
            }
            catch (ServiceLocationException serviceLocationException) {
                throw new IllegalArgumentException(serviceLocationException.getMessage());
            }
        }
        throw new IllegalArgumentException(SLPConfig.getSLPConfig().formatMessage("service_type_syntax", new Object[]{string}));
    }

    public String toString() {
        return String.valueOf(this.isServiceURL ? "service:" : "") + this.type1 + (this.na.length() > 0 ? "." + this.na : "") + (this.type2.length() > 0 ? ":" + this.type2 : "");
    }

    static void validateTypeComponent(String string) throws ServiceLocationException {
        ServiceType.validateTypeComponentInternal(string, false);
    }

    private static void validateTypeComponentInternal(String string, boolean bl) throws ServiceLocationException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (!Character.isLetterOrDigit(c) && c != '+' && c != '-') {
                boolean bl2 = true;
                if (bl && c == '.') {
                    bl2 = false;
                }
                if (bl2) {
                    throw new IllegalArgumentException(SLPConfig.getSLPConfig().formatMessage("service_type_syntax", new Object[]{string}));
                }
            }
            ++n2;
        }
    }
}

