/*
 * Decompiled with CFR 0.152.
 */
package dursley.tools;

import com.sun.slp.Locator;
import com.sun.slp.ServiceLocationAttribute;
import com.sun.slp.ServiceLocationEnumeration;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.ServiceLocationManager;
import com.sun.slp.ServiceType;
import com.sun.slp.ServiceURL;
import dursley.tools.CommandLine;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public final class Slippery {
    private Locator locator;
    private Vector scopes;
    private List serviceTypes;

    public static void main(String[] stringArray) {
        Arguments arguments = new Arguments();
        CommandLine.parseToObject(arguments, stringArray);
        if (arguments.help) {
            System.out.println("Usage: java -jar slippery.jar");
            System.out.println("\t[ -help ]");
            System.out.println("\t[ -scope <scope> ]");
            System.out.println("\t[ -type <service type> ]");
            System.exit(0);
        }
        try {
            Slippery slippery = new Slippery(arguments.scope, arguments.type);
            slippery.run();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Slippery(String string, String string2) {
        try {
            Object object;
            System.out.print("----------------------------------------");
            System.out.println("----------------------------------------");
            this.locator = ServiceLocationManager.getLocator(null);
            System.out.println("SLP Locator:  " + this.locator);
            if (this.locator == null) {
                System.out.println("Could not find a Locator");
                System.exit(0);
            }
            if (string != null) {
                this.scopes = new Vector();
                this.scopes.add(string);
            } else {
                this.scopes = ServiceLocationManager.findScopes();
                if (this.scopes == null) {
                    System.out.println("Could not find any Scopes");
                    System.exit(0);
                }
            }
            this.serviceTypes = new ArrayList();
            if (string2 != null) {
                try {
                    this.serviceTypes.add(new ServiceType(string2));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.out.println("Invalid service type: " + string2);
                    System.exit(0);
                }
            } else {
                object = this.locator.findServiceTypes("", this.scopes);
                if (object == null || !object.hasMoreElements()) {
                    System.out.println("Could not find any Service Types");
                    System.exit(0);
                }
                while (object.hasMoreElements()) {
                    this.serviceTypes.add((ServiceType)object.next());
                }
            }
            System.out.println("Scopes:");
            object = ((AbstractList)this.scopes).iterator();
            while (object.hasNext()) {
                System.out.println("\t" + object.next());
            }
            System.out.println("");
            System.out.println("ServiceTypes:");
            Iterator iterator = this.serviceTypes.iterator();
            while (iterator.hasNext()) {
                System.out.println("\t" + iterator.next());
            }
            System.out.println("");
        }
        catch (ThreadDeath threadDeath) {
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(0);
        }
    }

    private void run() {
        try {
            Iterator iterator = ((AbstractList)this.scopes).iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.printPerScope(string);
            }
        }
        catch (ThreadDeath threadDeath) {
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void printPerScope(String string) {
        try {
            Vector<String> vector = new Vector<String>();
            vector.add(string);
            Iterator iterator = this.serviceTypes.iterator();
            while (iterator.hasNext()) {
                System.out.print("--------------------");
                System.out.print("------------------------------");
                System.out.println("------------------------------");
                System.out.println("Scope:        " + string);
                ServiceType serviceType = (ServiceType)iterator.next();
                this.printPerServiceType(vector, serviceType);
            }
        }
        catch (ThreadDeath threadDeath) {
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void printPerServiceType(Vector vector, ServiceType serviceType) {
        try {
            System.out.println("Service Type: " + serviceType);
            ServiceLocationEnumeration serviceLocationEnumeration = this.locator.findServices(serviceType, vector, "");
            if (serviceLocationEnumeration == null || !serviceLocationEnumeration.hasMoreElements()) {
                System.out.println("");
                System.out.println("No Services");
                System.out.println("");
                return;
            }
            ServiceURL serviceURL = null;
            while (serviceLocationEnumeration.hasMoreElements()) {
                serviceURL = (ServiceURL)serviceLocationEnumeration.next();
                this.printPerServiceURL(serviceURL, vector);
            }
            System.out.println("");
        }
        catch (ServiceLocationException serviceLocationException) {
            serviceLocationException.printStackTrace();
        }
        catch (ThreadDeath threadDeath) {
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void printPerServiceURL(ServiceURL serviceURL, Vector vector) {
        try {
            ServiceLocationEnumeration serviceLocationEnumeration = this.locator.findAttributes(serviceURL, vector, new Vector());
            System.out.println("");
            System.out.println("Service URL: " + serviceURL);
            if (serviceLocationEnumeration == null || !serviceLocationEnumeration.hasMoreElements()) {
                System.out.println("\tNo ServiceAttributes");
                return;
            }
            ServiceLocationAttribute serviceLocationAttribute = null;
            while (serviceLocationEnumeration.hasMoreElements()) {
                serviceLocationAttribute = (ServiceLocationAttribute)serviceLocationEnumeration.next();
                System.out.println("\tAttribute: " + serviceLocationAttribute);
            }
        }
        catch (ServiceLocationException serviceLocationException) {
            serviceLocationException.printStackTrace();
        }
        catch (ThreadDeath threadDeath) {
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static class Arguments {
        public boolean help = false;
        public String scope;
        public String type;
    }
}

