/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esm.apps.diags.base;

import com.sun.dae.components.event.Delegate;
import com.sun.dae.components.util.ExceptionUtil;
import com.sun.dae.components.util.Localize;
import com.sun.dae.sdok.OID;
import com.sun.esm.apps.diags.base.DiagsHistoryEntry;
import com.sun.esm.apps.diags.base.DiagsHistoryEvent;
import com.sun.esm.apps.diags.base.DiagsHistoryListener;
import com.sun.esm.components.data.RowData;
import com.sun.esm.components.data.ValuePair;
import com.sun.esm.util.common.Debug;
import com.sun.esm.util.enclMgr.MediatedMessage;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractList;
import java.util.Date;
import java.util.EventListener;
import java.util.EventObject;
import java.util.ListIterator;
import java.util.Vector;

public class DiagsHistory
extends Vector
implements Serializable {
    private RowData summaryHdrs;
    private String component = " ";
    private String label = "`MCConstant.TRK_SUMMARY`";
    private int testIndex = 0;
    private int timeIndex = 1;
    private int progressIndex = 2;
    private int statusIndex = 3;
    private OID oid;
    private Delegate diagsHistoryListenerDelegate = new Delegate(class$com$sun$esm$apps$diags$base$DiagsHistoryListener != null ? class$com$sun$esm$apps$diags$base$DiagsHistoryListener : (class$com$sun$esm$apps$diags$base$DiagsHistoryListener = DiagsHistory.class$("com.sun.esm.apps.diags.base.DiagsHistoryListener")));
    private String conflictOp = "`T3hConstant.TRK_NOOP`";
    private String conflictComp = " ";
    private static final String sccs_id = "@(#)DiagsHistory.java 1.39\t 00/12/07 SMI";
    static /* synthetic */ Class class$com$sun$esm$apps$diags$base$DiagsHistoryListener;
    static /* synthetic */ Class class$com$sun$esm$util$common$MCConstant;

    public DiagsHistory(String string) {
        this.component = string;
        this.summaryHdrs = new RowData(4);
        this.summaryHdrs.setData((Object)this.localizeData("`MCConstant.TRK_DIAGNOSTIC`"), this.testIndex);
        this.summaryHdrs.setData((Object)this.localizeData("`MCConstant.TRK_START_TIME`"), this.timeIndex);
        this.summaryHdrs.setData((Object)this.localizeData("`MCConstant.TRK_PROGRESS`"), this.progressIndex);
        this.summaryHdrs.setData((Object)this.localizeData("`MCConstant.STATUS`"), this.statusIndex);
    }

    public void addDiagsHistoryListener(DiagsHistoryListener diagsHistoryListener) {
        Delegate delegate = this.diagsHistoryListenerDelegate;
        synchronized (delegate) {
            this.diagsHistoryListenerDelegate.addListener((EventListener)diagsHistoryListener);
        }
    }

    private synchronized void addHistoryEntry(DiagsHistoryEntry diagsHistoryEntry) {
        if (Debug.isDebugFlagOn((int)Debug.TRACE_MC)) {
            System.out.println("DiagsHistory: Add History entry: " + diagsHistoryEntry.test() + " for " + diagsHistoryEntry.component());
        }
        ValuePair valuePair = new ValuePair("`MCConstant.TRK_DIAGNOSTIC`", (Object)diagsHistoryEntry.test());
        this.reduceHistory(this.getEntries(valuePair, this.getComponentEntries(diagsHistoryEntry.component())));
        this.addElement(diagsHistoryEntry);
        this.pickle();
        this.notifyDiagsHistoryListeners();
    }

    public boolean anyRunningEntriesFor(String string) {
        return this.getRunningEntriesFor(string).isEmpty() ^ true;
    }

    public void beActive(String string, String string2) {
        Vector<ValuePair> vector = new Vector<ValuePair>();
        vector.addElement(new ValuePair("`MCConstant.STATUS`", (Object)"`MCConstant.TRK_ACTIVE`"));
        this.updateEntry(string, string2, vector);
    }

    public void beCancelled(String string, String string2) {
        Vector vector = this.getRunningEntriesFor(string);
        if (!vector.isEmpty()) {
            DiagsHistoryEntry diagsHistoryEntry = (DiagsHistoryEntry)vector.firstElement();
            this.finishProgress(string, string2);
            diagsHistoryEntry.setReason("`MCConstant.TRK_CANCELLED`", "`MCConstant.TRK_NONE`");
        }
    }

    public void beComplete(String string, String string2) {
        Vector vector = this.getRunningEntriesFor(string);
        if (!vector.isEmpty()) {
            Vector<ValuePair> vector2 = new Vector<ValuePair>();
            vector2.addElement(new ValuePair("`MCConstant.TRK_END_TIME`", (Object)new Date().toString()));
            DiagsHistoryEntry diagsHistoryEntry = (DiagsHistoryEntry)vector.firstElement();
            diagsHistoryEntry.update(vector2);
            this.finishProgress(string, string2);
            diagsHistoryEntry.setReason();
        }
    }

    public void beComplete(String string, String string2, String string3, String string4) {
        Vector vector = this.getRunningEntriesFor(string);
        if (!vector.isEmpty()) {
            Vector<ValuePair> vector2 = new Vector<ValuePair>();
            vector2.addElement(new ValuePair("`MCConstant.TRK_END_TIME`", (Object)new Date().toString()));
            DiagsHistoryEntry diagsHistoryEntry = (DiagsHistoryEntry)vector.firstElement();
            diagsHistoryEntry.update(vector2);
            this.finishProgress(string, string2);
            diagsHistoryEntry.setReason(string3, string4);
        }
    }

    public void beIncomplete(String string, String string2, String string3, String string4) {
        Vector vector = this.getRunningEntriesFor(string);
        if (!vector.isEmpty()) {
            DiagsHistoryEntry diagsHistoryEntry = (DiagsHistoryEntry)vector.firstElement();
            this.finishProgress(string, string2);
            this.finishTest(string, string2, "`MCConstant.TRK_INCOMPLETE`");
            diagsHistoryEntry.setReason(string3, string4);
        }
    }

    public void beInitiated(String string, String string2, Vector vector) {
        this.addHistoryEntry(new DiagsHistoryEntry(string, string2, vector));
    }

    public void beTerminating(String string, RowData rowData) {
        Vector vector = new Vector();
        vector.addElement(rowData);
        vector = this.getSelections(vector);
        if (!vector.isEmpty()) {
            DiagsHistoryEntry diagsHistoryEntry = (DiagsHistoryEntry)vector.firstElement();
            this.finishTest(string, diagsHistoryEntry.test(), "`MCConstant.TRK_TERMINATING`");
        }
    }

    public void beTracked(String string, String string2) {
        Vector<ValuePair> vector = new Vector<ValuePair>();
        vector.addElement(new ValuePair("`MCConstant.TRK_OPTIONS`", (Object)"`MCConstant.UNKNOWN`"));
        this.addHistoryEntry(new DiagsHistoryEntry(string, string2, vector));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void dispose() {
        Delegate delegate = this.diagsHistoryListenerDelegate;
        synchronized (delegate) {
            this.diagsHistoryListenerDelegate.removeAllListeners();
        }
    }

    public void finishProgress(String string, String string2) {
        Vector<ValuePair> vector = new Vector<ValuePair>();
        vector.addElement(new ValuePair("`MCConstant.TRK_PROGRESS`", (Object)"100"));
        this.updateEntry(string, string2, vector);
    }

    private void finishTest(String string, String string2, String string3) {
        Vector<ValuePair> vector = new Vector<ValuePair>();
        if (Debug.isDebugFlagOn((int)Debug.TRACE_MC)) {
            System.out.println("DiagsHistory: finish - " + string2 + " " + string3);
        }
        vector.addElement(new ValuePair("`MCConstant.STATUS`", (Object)string3));
        vector.addElement(new ValuePair("`MCConstant.TRK_END_TIME`", (Object)new Date().toString()));
        this.updateEntry(string, string2, vector);
    }

    public String getComponent() {
        return this.component;
    }

    private Vector getComponentEntries(String string) {
        return this.getEntries(new ValuePair("`MCConstant.TRK_COMPONENT`", (Object)string), this);
    }

    public String getConflictingComponent() {
        return this.conflictComp;
    }

    public String getConflictingOp() {
        return this.conflictOp;
    }

    private Vector getEntries(ValuePair valuePair, Vector vector) {
        Vector<DiagsHistoryEntry> vector2 = new Vector<DiagsHistoryEntry>();
        ListIterator listIterator = ((AbstractList)vector).listIterator();
        while (listIterator.hasNext()) {
            DiagsHistoryEntry diagsHistoryEntry = (DiagsHistoryEntry)listIterator.next();
            if (!diagsHistoryEntry.equalsProperty(valuePair)) continue;
            vector2.addElement(diagsHistoryEntry);
        }
        return vector2;
    }

    public Vector getMessages(Vector vector) {
        ListIterator listIterator = ((AbstractList)this.getSelections(vector)).listIterator();
        Vector vector2 = new Vector();
        while (listIterator.hasNext()) {
            Vector vector3 = ((DiagsHistoryEntry)listIterator.next()).getMessages();
            ListIterator listIterator2 = ((AbstractList)vector3).listIterator();
            while (listIterator2.hasNext()) {
                vector2.addElement(listIterator2.next());
            }
        }
        return vector2;
    }

    public int getProgress(String string, String string2) {
        Vector vector = this.getComponentEntries(string);
        if (!(vector = this.getEntries(new ValuePair("`MCConstant.TRK_DIAGNOSTIC`", (Object)string2), vector)).isEmpty()) {
            DiagsHistoryEntry diagsHistoryEntry = (DiagsHistoryEntry)vector.firstElement();
            ListIterator listIterator = ((AbstractList)vector).listIterator();
            while (listIterator.hasNext()) {
                DiagsHistoryEntry diagsHistoryEntry2 = (DiagsHistoryEntry)listIterator.next();
                diagsHistoryEntry = diagsHistoryEntry.current(diagsHistoryEntry2);
            }
            return diagsHistoryEntry.progress();
        }
        return 100;
    }

    public Vector getRowDataFor(String string) {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(this.summaryHdrs);
        ListIterator listIterator = ((AbstractList)this.getComponentEntries(string)).listIterator();
        while (listIterator.hasNext()) {
            vector.addElement(((DiagsHistoryEntry)listIterator.next()).getTableData());
        }
        return vector;
    }

    public Vector getRunningEntries() {
        ListIterator listIterator = ((AbstractList)this).listIterator();
        Vector<DiagsHistoryEntry> vector = new Vector<DiagsHistoryEntry>();
        while (listIterator.hasNext()) {
            DiagsHistoryEntry diagsHistoryEntry = (DiagsHistoryEntry)listIterator.next();
            if (!diagsHistoryEntry.isRunning()) continue;
            vector.addElement(diagsHistoryEntry);
        }
        return vector;
    }

    public Vector getRunningEntriesFor(String string) {
        ListIterator listIterator = ((AbstractList)this.getComponentEntries(string)).listIterator();
        Vector<DiagsHistoryEntry> vector = new Vector<DiagsHistoryEntry>();
        while (listIterator.hasNext()) {
            DiagsHistoryEntry diagsHistoryEntry = (DiagsHistoryEntry)listIterator.next();
            if (!diagsHistoryEntry.isRunning()) continue;
            vector.addElement(diagsHistoryEntry);
        }
        return vector;
    }

    private Vector getSelections(Vector vector) {
        Vector<DiagsHistoryEntry> vector2 = new Vector<DiagsHistoryEntry>();
        ListIterator listIterator = ((AbstractList)vector).listIterator();
        while (listIterator.hasNext()) {
            RowData rowData = (RowData)listIterator.next();
            ListIterator listIterator2 = ((AbstractList)this).listIterator();
            while (listIterator2.hasNext()) {
                DiagsHistoryEntry diagsHistoryEntry = (DiagsHistoryEntry)listIterator2.next();
                if (!diagsHistoryEntry.matches((String)rowData.getData(this.testIndex), (String)rowData.getData(this.timeIndex))) continue;
                vector2.addElement(diagsHistoryEntry);
            }
        }
        return vector2;
    }

    public int getStatusValue(String string, String string2) {
        Vector vector = this.getComponentEntries(string);
        if (!(vector = this.getEntries(new ValuePair("`MCConstant.TRK_DIAGNOSTIC`", (Object)string2), vector)).isEmpty()) {
            DiagsHistoryEntry diagsHistoryEntry = (DiagsHistoryEntry)vector.firstElement();
            ListIterator listIterator = ((AbstractList)vector).listIterator();
            while (listIterator.hasNext()) {
                DiagsHistoryEntry diagsHistoryEntry2 = (DiagsHistoryEntry)listIterator.next();
                diagsHistoryEntry = diagsHistoryEntry.current(diagsHistoryEntry2);
            }
            return diagsHistoryEntry.status();
        }
        return 7;
    }

    public int getStatusValueFor(String string, RowData rowData) {
        Vector vector = new Vector();
        vector.addElement(rowData);
        vector = this.getSelections(vector);
        if (!vector.isEmpty()) {
            DiagsHistoryEntry diagsHistoryEntry = (DiagsHistoryEntry)vector.firstElement();
            return diagsHistoryEntry.status();
        }
        return 7;
    }

    private int getSummaryIndex(String string) {
        int n = this.summaryHdrs.getNumColumn();
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            if (string == this.summaryHdrs.getData(n2)) {
                n3 = n2;
            }
            ++n2;
        }
        return n3;
    }

    public Vector getTableDataFor(Vector vector) {
        ListIterator listIterator = ((AbstractList)this.getSelections(vector)).listIterator();
        Vector<DiagsHistoryEntry> vector2 = new Vector<DiagsHistoryEntry>();
        while (listIterator.hasNext()) {
            vector2.addElement(((DiagsHistoryEntry)listIterator.next()).getTableData());
        }
        return vector2;
    }

    public boolean isForSystem(String string) {
        return string.equals(this.component);
    }

    public boolean isInactive() {
        Vector vector = this.getRunningEntries();
        boolean bl = true;
        if (!vector.isEmpty()) {
            bl = false;
        }
        return bl;
    }

    public boolean isInactive(String string, String string2) {
        Vector vector = this.getRunningEntriesFor(string);
        vector = this.getEntries(new ValuePair("`MCConstant.TRK_DIAGNOSTIC`", (Object)string2), vector);
        boolean bl = true;
        if (!vector.isEmpty()) {
            bl = false;
        }
        return bl;
    }

    public boolean isInactive(Vector vector) {
        Vector vector2 = new Vector();
        vector2 = this.getSelections(vector);
        boolean bl = true;
        ListIterator listIterator = ((AbstractList)vector2).listIterator();
        while (listIterator.hasNext()) {
            DiagsHistoryEntry diagsHistoryEntry = (DiagsHistoryEntry)listIterator.next();
            if (!diagsHistoryEntry.isRunning()) continue;
            bl = false;
        }
        return bl;
    }

    private String localizeData(String string) {
        return Localize.getString((Object)(class$com$sun$esm$util$common$MCConstant != null ? class$com$sun$esm$util$common$MCConstant : (class$com$sun$esm$util$common$MCConstant = DiagsHistory.class$("com.sun.esm.util.common.MCConstant"))), (String)string);
    }

    private void notifyDiagsHistoryListeners() {
        Delegate delegate = this.diagsHistoryListenerDelegate;
        synchronized (delegate) {
            DiagsHistoryEvent diagsHistoryEvent = new DiagsHistoryEvent(this);
            try {
                if (Debug.isDebugFlagOn((int)Debug.TRACE_MC)) {
                    System.err.println("DiagsHistory:Before event...");
                }
                this.diagsHistoryListenerDelegate.send((EventObject)diagsHistoryEvent, "diagsHistoryChanged", false);
                if (Debug.isDebugFlagOn((int)Debug.TRACE_MC)) {
                    System.err.println("DiagsHistory: after event...");
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                ExceptionUtil.printException((Throwable)illegalAccessException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ExceptionUtil.printException((Throwable)noSuchMethodException);
            }
            catch (InvocationTargetException invocationTargetException) {
                ExceptionUtil.printException((Throwable)invocationTargetException);
            }
            catch (Exception exception) {
                ExceptionUtil.printException((Throwable)exception);
            }
        }
    }

    private void pickle() {
    }

    private synchronized void reduceHistory(Vector vector) {
        while (vector.size() > 2) {
            ListIterator listIterator = ((AbstractList)vector).listIterator();
            DiagsHistoryEntry diagsHistoryEntry = null;
            while (listIterator.hasNext()) {
                if (diagsHistoryEntry == null) {
                    diagsHistoryEntry = (DiagsHistoryEntry)listIterator.next();
                }
                diagsHistoryEntry = ((DiagsHistoryEntry)listIterator.next()).oldest(diagsHistoryEntry);
            }
            this.removeElement(diagsHistoryEntry);
            vector.removeElement(diagsHistoryEntry);
            this.pickle();
            this.notifyDiagsHistoryListeners();
        }
    }

    public synchronized void removeComp(String string) {
        ListIterator listIterator = ((AbstractList)this.getComponentEntries(string)).listIterator();
        while (listIterator.hasNext()) {
            DiagsHistoryEntry diagsHistoryEntry = (DiagsHistoryEntry)listIterator.next();
            if (Debug.isDebugFlagOn((int)Debug.TRACE_MC)) {
                System.out.println("DiagsHistory: Remove History entry");
            }
            this.removeElement(diagsHistoryEntry);
        }
        this.pickle();
        this.notifyDiagsHistoryListeners();
    }

    public void removeDiagsHistoryListener(DiagsHistoryListener diagsHistoryListener) {
        Delegate delegate = this.diagsHistoryListenerDelegate;
        synchronized (delegate) {
            this.diagsHistoryListenerDelegate.removeListener((EventListener)diagsHistoryListener);
        }
    }

    public synchronized void removeHistoryEntries(Vector vector) {
        ListIterator listIterator = ((AbstractList)this.getSelections(vector)).listIterator();
        while (listIterator.hasNext()) {
            DiagsHistoryEntry diagsHistoryEntry = (DiagsHistoryEntry)listIterator.next();
            this.removeElement(diagsHistoryEntry);
            if (!Debug.isDebugFlagOn((int)Debug.TRACE_MC)) continue;
            System.out.println("DiagsHistory: Remove History entry");
        }
        this.pickle();
        this.notifyDiagsHistoryListeners();
    }

    public void setConflict(String[] stringArray) {
        if (stringArray[0].equals(this.conflictOp) && stringArray[1].equals(this.conflictComp)) {
            return;
        }
        this.conflictOp = stringArray[0];
        this.conflictComp = stringArray[1];
        this.notifyDiagsHistoryListeners();
    }

    public synchronized void updateEntry(String string, String string2, Vector vector) {
        if (Debug.isDebugFlagOn((int)Debug.TRACE_MC)) {
            System.out.println("DiagsHistory: Add History entry: " + string2 + " for " + string);
        }
        ListIterator listIterator = ((AbstractList)this.getRunningEntriesFor(string)).listIterator();
        while (listIterator.hasNext()) {
            DiagsHistoryEntry diagsHistoryEntry = (DiagsHistoryEntry)listIterator.next();
            if (diagsHistoryEntry.test() != string2) continue;
            diagsHistoryEntry.update(vector);
            this.pickle();
            this.notifyDiagsHistoryListeners();
        }
    }

    public synchronized void updateMessages(String string, String string2, MediatedMessage mediatedMessage) {
        ListIterator listIterator = ((AbstractList)this.getRunningEntriesFor(string)).listIterator();
        while (listIterator.hasNext()) {
            DiagsHistoryEntry diagsHistoryEntry = (DiagsHistoryEntry)listIterator.next();
            if (diagsHistoryEntry.test() != string2) continue;
            diagsHistoryEntry.updateMessages(mediatedMessage);
            if (Debug.isDebugFlagOn((int)Debug.TRACE_MC)) {
                System.out.println("DiagsHistory: update Messages - " + mediatedMessage.getMessage());
            }
            this.pickle();
        }
    }

    public void updateProgress(String string, String string2, int n) {
        String string3 = new Integer(n).toString();
        Vector<ValuePair> vector = new Vector<ValuePair>();
        vector.addElement(new ValuePair("`MCConstant.TRK_PROGRESS`", (Object)string3));
        this.updateEntry(string, string2, vector);
    }
}

