/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esm.apps.diags.base;

import com.sun.dae.components.util.Localize;
import com.sun.esm.components.data.RowData;
import com.sun.esm.components.data.TableData;
import com.sun.esm.components.data.ValuePair;
import com.sun.esm.util.common.Debug;
import com.sun.esm.util.enclMgr.MediatedMessage;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Date;
import java.util.ListIterator;
import java.util.Vector;

public class DiagsHistoryEntry
extends TableData
implements Serializable {
    private Date time;
    private Date finalTime;
    private String diagnostic;
    private String component;
    private Vector messages;
    public static final int INITIATING = 1;
    public static final int ACTIVE = 2;
    public static final int TERMINATING = 3;
    public static final int INCOMPLETE = 4;
    public static final int COMPLETE = 5;
    public static final int CANCELLED = 6;
    public static final int INACTIVE = 7;
    public static final int RUNNING = 8;
    public static Object[] statusTable = new Object[]{"`MCConstant.TRK_INITIATED`", new Integer(1), "`MCConstant.TRK_ACTIVE`", new Integer(2), "`MCConstant.TRK_TERMINATING`", new Integer(3), "`MCConstant.TRK_INCOMPLETE`", new Integer(4), "`MCConstant.TRK_COMPLETE`", new Integer(5), "`MCConstant.TRK_CANCELLED`", new Integer(6)};
    private static final String sccs_id = "@(#)DiagsHistoryEntry.java 1.21\t 00/12/07 SMI";
    static /* synthetic */ Class class$com$sun$esm$util$common$MCConstant;

    public DiagsHistoryEntry(String string, String string2, Date date) {
        super(Localize.getString((Object)(class$com$sun$esm$util$common$MCConstant != null ? class$com$sun$esm$util$common$MCConstant : (class$com$sun$esm$util$common$MCConstant = DiagsHistoryEntry.class$("com.sun.esm.util.common.MCConstant"))), (String)"`MCConstant.TRK_DIAGNOSTIC_DETAILS`"), Localize.getString((Object)(class$com$sun$esm$util$common$MCConstant != null ? class$com$sun$esm$util$common$MCConstant : (class$com$sun$esm$util$common$MCConstant = DiagsHistoryEntry.class$("com.sun.esm.util.common.MCConstant"))), (String)"`MCConstant.KEYWORD`"), Localize.getString((Object)(class$com$sun$esm$util$common$MCConstant != null ? class$com$sun$esm$util$common$MCConstant : (class$com$sun$esm$util$common$MCConstant = DiagsHistoryEntry.class$("com.sun.esm.util.common.MCConstant"))), (String)"`MCConstant.VALUE`"));
        this.time = date;
        this.finalTime = null;
        this.component = string;
        this.diagnostic = string2;
        this.messages = new Vector();
    }

    public DiagsHistoryEntry(String string, String string2, Date date, Date date2) {
        super(Localize.getString((Object)(class$com$sun$esm$util$common$MCConstant != null ? class$com$sun$esm$util$common$MCConstant : (class$com$sun$esm$util$common$MCConstant = DiagsHistoryEntry.class$("com.sun.esm.util.common.MCConstant"))), (String)"`MCConstant.TRK_DIAGNOSTIC_DETAILS`"), Localize.getString((Object)(class$com$sun$esm$util$common$MCConstant != null ? class$com$sun$esm$util$common$MCConstant : (class$com$sun$esm$util$common$MCConstant = DiagsHistoryEntry.class$("com.sun.esm.util.common.MCConstant"))), (String)"`MCConstant.KEYWORD`"), Localize.getString((Object)(class$com$sun$esm$util$common$MCConstant != null ? class$com$sun$esm$util$common$MCConstant : (class$com$sun$esm$util$common$MCConstant = DiagsHistoryEntry.class$("com.sun.esm.util.common.MCConstant"))), (String)"`MCConstant.VALUE`"));
        this.time = date;
        this.finalTime = date2;
        this.component = string;
        this.diagnostic = string2;
        this.messages = new Vector();
    }

    public DiagsHistoryEntry(String string, String string2, Vector vector) {
        super(Localize.getString((Object)(class$com$sun$esm$util$common$MCConstant != null ? class$com$sun$esm$util$common$MCConstant : (class$com$sun$esm$util$common$MCConstant = DiagsHistoryEntry.class$("com.sun.esm.util.common.MCConstant"))), (String)"`MCConstant.TRK_DIAGNOSTIC_DETAILS`"), Localize.getString((Object)(class$com$sun$esm$util$common$MCConstant != null ? class$com$sun$esm$util$common$MCConstant : (class$com$sun$esm$util$common$MCConstant = DiagsHistoryEntry.class$("com.sun.esm.util.common.MCConstant"))), (String)"`MCConstant.KEYWORD`"), Localize.getString((Object)(class$com$sun$esm$util$common$MCConstant != null ? class$com$sun$esm$util$common$MCConstant : (class$com$sun$esm$util$common$MCConstant = DiagsHistoryEntry.class$("com.sun.esm.util.common.MCConstant"))), (String)"`MCConstant.VALUE`"));
        this.time = new Date();
        this.finalTime = null;
        this.component = string;
        this.diagnostic = string2;
        this.messages = new Vector();
        ListIterator listIterator = ((AbstractList)vector).listIterator();
        this.setData("`MCConstant.TRK_COMPONENT`", this.component);
        this.setData("`MCConstant.TRK_DIAGNOSTIC`", this.diagnostic);
        this.setData("`MCConstant.TRK_START_TIME`", this.time.toString());
        this.setData("`MCConstant.TRK_END_TIME`", " ");
        this.setData("`MCConstant.STATUS`", "`MCConstant.TRK_INITIATED`");
        this.setData("`MCConstant.TRK_PROGRESS`", "0");
        while (listIterator.hasNext()) {
            this.setData((ValuePair)listIterator.next());
        }
        int n = 0;
        while (n < this.getDataSize()) {
            ValuePair valuePair = this.getData(n);
            valuePair.setKeyword(this.localizeData(valuePair.getKeyword()));
            valuePair.setValue((Object)this.localizeData((String)valuePair.getValue()));
            ++n;
        }
    }

    public RowData asRowData(RowData rowData) {
        RowData rowData2 = new RowData(rowData.getNumColumn());
        int n = 0;
        while (n < rowData.getNumColumn()) {
            String string = (String)rowData.getData(n);
            int n2 = 0;
            while (n2 < this.getDataSize()) {
                ValuePair valuePair = this.getData(n2);
                if (string.equals(valuePair.getKeyword())) {
                    rowData2.setData(valuePair.getValue(), n);
                }
                ++n2;
            }
            ++n;
        }
        return rowData2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String component() {
        return this.component;
    }

    public DiagsHistoryEntry current(DiagsHistoryEntry diagsHistoryEntry) {
        if (this.time().after(diagsHistoryEntry.time())) {
            return this;
        }
        return diagsHistoryEntry;
    }

    public Date endTime() {
        return this.finalTime;
    }

    public boolean equalsProperty(ValuePair valuePair) {
        int n = 0;
        while (n < this.getDataSize()) {
            ValuePair valuePair2 = this.getData(n);
            if (valuePair2.getKeyword().equals(valuePair.getKeyword())) {
                return valuePair2.getValue().equals(valuePair.getValue());
            }
            ++n;
        }
        return false;
    }

    public Vector getMessages() {
        if (Debug.isDebugFlagOn((int)Debug.TRACE_MC)) {
            System.out.println("DiagsHistoryEntry: getMessages");
        }
        return this.messages;
    }

    public ValuePair getProperty(String string) {
        int n = 0;
        while (n < this.getDataSize()) {
            ValuePair valuePair = this.getData(n);
            if (valuePair.getKeyword().equals(string)) {
                return valuePair;
            }
            ++n;
        }
        return new ValuePair(" ", (Object)" ");
    }

    public DiagsHistoryEntry getTableData() {
        DiagsHistoryEntry diagsHistoryEntry = this.endTime() != null ? new DiagsHistoryEntry(this.component(), this.test(), (Date)this.time().clone(), (Date)this.endTime().clone()) : new DiagsHistoryEntry(this.component(), this.test(), (Date)this.time().clone());
        int n = 0;
        while (n < this.getDataSize()) {
            String string = this.getData(n).getKeyword();
            String string2 = (String)this.getData(n).getValue();
            diagsHistoryEntry.setData(string, string2);
            ++n;
        }
        return diagsHistoryEntry;
    }

    public boolean isComponent(String string) {
        return string.equals(this.component);
    }

    public boolean isInactive() {
        return this.isRunning() ^ true;
    }

    public boolean isRunning() {
        int n = this.status();
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    private String localizeData(String string) {
        return Localize.getString((Object)(class$com$sun$esm$util$common$MCConstant != null ? class$com$sun$esm$util$common$MCConstant : (class$com$sun$esm$util$common$MCConstant = DiagsHistoryEntry.class$("com.sun.esm.util.common.MCConstant"))), (String)string);
    }

    public boolean matches(String string, String string2) {
        return string.equals(this.diagnostic) && string2.equals(this.time.toString());
    }

    public DiagsHistoryEntry oldest(DiagsHistoryEntry diagsHistoryEntry) {
        if (this.time().before(diagsHistoryEntry.time())) {
            return this;
        }
        return diagsHistoryEntry;
    }

    public int progress() {
        ValuePair valuePair = this.getProperty("`MCConstant.TRK_PROGRESS`");
        return Integer.parseInt((String)valuePair.getValue());
    }

    public void setReason() {
        ListIterator listIterator = ((AbstractList)this.messages).listIterator();
        String string = "`MCConstant.TRK_PASSED`";
        String string2 = "`MCConstant.TRK_NONE`";
        Vector<ValuePair> vector = new Vector<ValuePair>();
        while (listIterator.hasNext()) {
            MediatedMessage mediatedMessage = (MediatedMessage)listIterator.next();
            ValuePair valuePair = mediatedMessage.getStatus();
            ValuePair valuePair2 = mediatedMessage.getCondition();
            if (((String)valuePair.getValue()).equals("`MCConstant.TRK_INSPECT`") && string2.equals("`MCConstant.TRK_NONE`")) {
                string2 = (String)valuePair2.getValue();
                string = (String)valuePair.getValue();
            }
            if (((String)valuePair.getValue()).equals("`MCConstant.TRK_CANCELLED`")) {
                string2 = (String)valuePair2.getValue();
                this.setData("`MCConstant.TRK_HINT`", string2);
                vector.addElement(new ValuePair("`MCConstant.STATUS`", (Object)"`MCConstant.TRK_CANCELLED`"));
                this.update(vector);
                return;
            }
            if (!((String)valuePair.getValue()).equals("`MCConstant.TRK_FAILED`")) continue;
            string2 = (String)valuePair2.getValue();
            this.setData("`MCConstant.TRK_HINT`", string2);
            vector.addElement(new ValuePair("`MCConstant.STATUS`", (Object)"`MCConstant.TRK_FAILED`"));
            this.update(vector);
            return;
        }
        vector.addElement(new ValuePair("`MCConstant.STATUS`", (Object)string));
        this.update(vector);
        this.setData("`MCConstant.TRK_HINT`", string2);
    }

    public void setReason(String string, String string2) {
        this.setData("`MCConstant.TRK_HINT`", string2);
        Vector<ValuePair> vector = new Vector<ValuePair>();
        vector.addElement(new ValuePair("`MCConstant.STATUS`", (Object)string));
        this.update(vector);
    }

    public int status() {
        ValuePair valuePair = this.getProperty("`MCConstant.STATUS`");
        Integer n = new Integer(7);
        int n2 = 0;
        while (n2 < statusTable.length) {
            int n3 = n2 + 1;
            if (valuePair.getValue().equals((String)statusTable[n2])) {
                n = (Integer)statusTable[n3];
            }
            ++n2;
            ++n2;
        }
        if (Debug.isDebugFlagOn((int)Debug.TRACE_MC)) {
            System.out.println("DiagsHistoryEntry : Status = " + n.toString());
        }
        return n;
    }

    public String test() {
        return this.diagnostic;
    }

    public Date time() {
        return this.time;
    }

    public void update(Vector vector) {
        ListIterator listIterator = ((AbstractList)vector).listIterator();
        while (listIterator.hasNext()) {
            ValuePair valuePair = (ValuePair)listIterator.next();
            int n = 0;
            while (n < this.getDataSize()) {
                ValuePair valuePair2 = this.getData(n);
                if (Debug.isDebugFlagOn((int)Debug.TRACE_MC)) {
                    System.out.println("DiagsHistoryEntry: Key= " + valuePair.getKeyword() + " Key2 = " + valuePair2.getKeyword());
                    System.out.println("DiagsHistoryEntry: Value= " + valuePair.getValue() + " Value = " + valuePair2.getValue());
                }
                if (valuePair.getKeyword().equals("`MCConstant.TRK_END_TIME`") && !valuePair.getValue().equals(" ")) {
                    this.finalTime = new Date();
                }
                if (valuePair.getKeyword().equals(valuePair2.getKeyword())) {
                    valuePair2.setValue(valuePair.getValue());
                }
                ++n;
            }
        }
    }

    public void updateMessages(MediatedMessage mediatedMessage) {
        this.messages.addElement(mediatedMessage);
    }
}

