/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client;

import com.netscape.management.client.IFramework;
import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.ITaskModel;
import com.netscape.management.client.ITaskObject;
import com.netscape.management.client.MenuItemCategory;
import com.netscape.management.client.MenuItemSeparator;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.TaskModel;
import com.netscape.management.client.TaskObject;
import com.netscape.management.client.TaskPage;
import com.netscape.management.client.UIPermissions;
import com.netscape.management.client.ace.ACIManager;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.security.CertMigrateWizard;
import com.netscape.management.client.security.CertificateDialog;
import com.netscape.management.client.security.PKCSConfigDialog;
import com.netscape.management.client.topology.TopologyInitializer;
import com.netscape.management.client.util.ClassLoaderUtil;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;

public class LDAPTaskModel
extends TaskModel
implements IMenuInfo {
    public static String MENU_OPEN = "OPEN";
    public static String MENU_ACL = "ACL";
    public static String MENU_CERT_DIALOG = "CERTIFICATE SETUP WIZARD";
    public static String MENU_PKCS11_CONFIG = "CERTIFICATE MANAGEMENT";
    public static String MENU_IMPORT_CERT = "IMPORT CERTIFICATE";
    static ResourceSet _resource = new ResourceSet("com.netscape.management.client.default");
    protected ITaskObject _selection;
    private boolean canAccessSecurity = false;
    private TaskPage parentPage;

    public LDAPTaskModel(ConsoleInfo consoleInfo) {
        super(consoleInfo);
        this.setRoot(LDAPTaskModel.getTasksFromLDAP(consoleInfo));
        UIPermissions uIPermissions = new UIPermissions(LDAPUtil.getAdminGlobalParameterEntry());
        this.canAccessSecurity = uIPermissions.hasPermission(TopologyInitializer.PERMID_SECURITY);
    }

    public String[] getMenuCategoryIDs() {
        return new String[]{"FILE", "EDIT", "CONTEXT"};
    }

    public void setParentPage(TaskPage taskPage) {
        this.parentPage = taskPage;
    }

    public Frame getParentPage() {
        JFrame jFrame = null;
        if (this.parentPage != null) {
            IFramework iFramework = this.parentPage.getFramework();
            if (iFramework != null) {
                jFrame = iFramework.getJFrame();
                if (jFrame == null) {
                    Debug.println(6, "LDAPTaskModel.getParentPage frame=" + jFrame);
                }
            } else {
                Debug.println(6, "LDAPTaskModel.getParentPage framework=" + iFramework);
            }
        } else {
            Debug.println(6, "LDAPTaskModel.getParentPage parentPage=" + this.parentPage);
        }
        return jFrame;
    }

    public IMenuItem[] getMenuItems(String string) {
        if (string.equals("FILE")) {
            if (this._consoleInfo.get("CLUSTER") != null) {
                return new IMenuItem[]{new MenuItemSeparator(), new MenuItemText(MENU_OPEN, _resource.getString("menu", "FileOpen"), "TODO:description")};
            }
            MenuItemText menuItemText = new MenuItemText(MENU_OPEN, _resource.getString("menu", "FileOpen"), "TODO:description");
            if (this.canAccessSecurity) {
                MenuItemCategory menuItemCategory = new MenuItemCategory("security", _resource.getString("menu", "FileSecurity"));
                menuItemCategory.add(new MenuItemText(MENU_CERT_DIALOG, _resource.getString("menu", "FileManageCert"), "TODO:description", new SecurityAction(MENU_CERT_DIALOG)));
                menuItemCategory.add(new MenuItemText(MENU_PKCS11_CONFIG, _resource.getString("menu", "FilePKCS11Config"), "TODO:description", new SecurityAction(MENU_PKCS11_CONFIG)));
                menuItemCategory.add(new MenuItemText(MENU_IMPORT_CERT, _resource.getString("menu", "FileImportCert"), "TODO:description", new SecurityAction(MENU_IMPORT_CERT)));
                return new IMenuItem[]{menuItemCategory, new MenuItemSeparator(), menuItemText};
            }
            return new IMenuItem[]{menuItemText};
        }
        if (string.equals("EDIT")) {
            return new IMenuItem[]{new MenuItemText(MENU_ACL, _resource.getString("menu", "EditSetACL"), "TODO:description", false)};
        }
        if (string.equals("CONTEXT")) {
            return new IMenuItem[]{new MenuItemText(MENU_OPEN, _resource.getString("menu", "FileOpen"), "TODO:description"), new MenuItemText(MENU_ACL, _resource.getString("menu", "EditSetACL"), "TODO:description")};
        }
        return null;
    }

    public void actionObjectSelected(IPage iPage, ITaskObject iTaskObject, ITaskObject iTaskObject2) {
        super.actionObjectSelected(iPage, iTaskObject, iTaskObject2);
        this._selection = iTaskObject;
        if (iTaskObject == null) {
            this.fireDisableMenuItem(iPage, MENU_ACL);
        } else {
            this.fireEnableMenuItem(iPage, MENU_ACL);
        }
    }

    public void actionMenuSelected(IPage iPage, IMenuItem iMenuItem) {
        if (iMenuItem.getID().equals(MENU_OPEN)) {
            this.actionObjectRun(iPage, this._selection);
        } else if (iMenuItem.getID().equals(MENU_ACL)) {
            String string = this._selection.getConsoleInfo().getCurrentDN();
            JFrame jFrame = iPage.getFramework().getJFrame();
            ACIManager aCIManager = new ACIManager(jFrame, this._selection.getName(), string);
            aCIManager.show();
        }
    }

    public static TaskObject getTasksFromLDAP(ConsoleInfo consoleInfo) {
        ResourceSet resourceSet = new ResourceSet("com.netscape.management.client.default");
        TaskObject taskObject = new TaskObject("root", consoleInfo);
        taskObject.setAllowsChildren(true);
        LDAPTaskModel.getTasksFromLDAP(consoleInfo, taskObject);
        return taskObject;
    }

    public static void getTasksFromLDAP(ConsoleInfo consoleInfo, DefaultMutableTreeNode defaultMutableTreeNode) {
        block12: {
            LDAPSearchResults lDAPSearchResults = null;
            boolean bl = false;
            try {
                LDAPConnection lDAPConnection = consoleInfo.getLDAPConnection();
                if (lDAPConnection == null) break block12;
                UIPermissions uIPermissions = new UIPermissions(LDAPUtil.getAdminGlobalParameterEntry());
                bl = uIPermissions.hasPermission(TopologyInitializer.PERMID_SECURITY);
                LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
                lDAPSearchConstraints.setBatchSize(1);
                lDAPSearchResults = lDAPConnection.search(consoleInfo.getCurrentDN(), 2, "(ObjectClass=nstask)", null, false, lDAPSearchConstraints);
                while (lDAPSearchResults.hasMoreElements()) {
                    Object object;
                    Object object2;
                    LDAPEntry lDAPEntry;
                    try {
                        lDAPEntry = lDAPSearchResults.next();
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
                    Enumeration enumeration = lDAPAttributeSet.getAttributes();
                    String string = "";
                    String string2 = "";
                    String string3 = "";
                    while (enumeration.hasMoreElements()) {
                        object2 = (LDAPAttribute)enumeration.nextElement();
                        object = object2.getName();
                        if (((String)object).equalsIgnoreCase("nsTaskLabel")) {
                            string = LDAPUtil.flatting(object2.getStringValues());
                            continue;
                        }
                        if (((String)object).equalsIgnoreCase("cn")) continue;
                        if (((String)object).equalsIgnoreCase("nsclassname")) {
                            string2 = LDAPUtil.flatting(object2.getStringValues());
                            continue;
                        }
                        if (!((String)object).equalsIgnoreCase("Description")) continue;
                        string3 = LDAPUtil.flatting(object2.getStringValues());
                    }
                    if (string2.equals("")) {
                        Debug.println("LDAPTaskModel:getTasksFromLDAP:no nsClassName for " + lDAPEntry.getDN());
                        continue;
                    }
                    if (string2.indexOf("CertSetup") != -1 && !bl) continue;
                    try {
                        object2 = ClassLoaderUtil.getClass((ConsoleInfo)consoleInfo, (String)string2);
                        if (object2 != null) {
                            object = (TaskObject)((Class)object2).newInstance();
                            ConsoleInfo consoleInfo2 = (ConsoleInfo)consoleInfo.clone();
                            consoleInfo2.put("SIE", LDAPTaskModel.getSIE(consoleInfo));
                            consoleInfo2.setCurrentDN(lDAPEntry.getDN());
                            ((TaskObject)object).setConsoleInfo(consoleInfo2);
                            defaultMutableTreeNode.add((MutableTreeNode)object);
                            continue;
                        }
                        System.err.println("LdapTaskUtil:getTasksFromLDAP:could not load class for task entry:" + lDAPEntry.toString());
                    }
                    catch (Exception exception) {
                        Debug.println("LDAPTaskModel.getTasksFromLdap: Could not load class: " + string2);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static String getSIE(ConsoleInfo consoleInfo) {
        String string = consoleInfo.getCurrentDN();
        return string.substring(string.indexOf("cn=") + 3, string.indexOf(","));
    }

    public static ITaskModel createTaskModel(ConsoleInfo consoleInfo) {
        return new LDAPTaskModel(consoleInfo);
    }

    public static LDAPTaskModel createLDAPTaskModel(ConsoleInfo consoleInfo) {
        return new LDAPTaskModel(consoleInfo);
    }

    class SecurityAction
    implements ActionListener {
        String _id;

        public SecurityAction(String string) {
            this._id = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this._id.equals(MENU_CERT_DIALOG)) {
                Debug.println(6, "LDAPTaskModel.SecurityAction.actionPerformed: parentPage = " + LDAPTaskModel.this.parentPage);
                CertificateDialog certificateDialog = new CertificateDialog(LDAPTaskModel.this.getParentPage(), LDAPTaskModel.this._consoleInfo, (String)LDAPTaskModel.this._consoleInfo.get("SIE"));
                ((Component)certificateDialog).setVisible(true);
            } else if (this._id.equals(MENU_PKCS11_CONFIG)) {
                PKCSConfigDialog pKCSConfigDialog = new PKCSConfigDialog(null, LDAPTaskModel.this._consoleInfo, (String)LDAPTaskModel.this._consoleInfo.get("SIE"));
                pKCSConfigDialog.setVisible(true);
            } else if (this._id.equals(MENU_IMPORT_CERT)) {
                CertMigrateWizard certMigrateWizard = new CertMigrateWizard(null, LDAPTaskModel.this._consoleInfo, (String)LDAPTaskModel.this._consoleInfo.get("SIE"));
                certMigrateWizard.setVisible(true);
            }
        }
    }
}

