/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client;

import com.netscape.management.client.CloseVetoException;
import com.netscape.management.client.Framework;
import com.netscape.management.client.IFramework;
import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceModel;
import com.netscape.management.client.IResourceModelListener;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.IStatusItem;
import com.netscape.management.client.MenuData;
import com.netscape.management.client.MenuItemCategory;
import com.netscape.management.client.MenuItemCheckBox;
import com.netscape.management.client.ResourceCellRenderer;
import com.netscape.management.client.ResourceModelEvent;
import com.netscape.management.client.StatusItemProgress;
import com.netscape.management.client.preferences.PreferenceManager;
import com.netscape.management.client.preferences.Preferences;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ResourcePage
extends JPanel
implements IPage,
TreeSelectionListener,
MouseListener,
KeyListener,
TreeWillExpandListener,
IResourceModelListener,
Cloneable,
SuiConstants {
    public static final String MENU_CONTEXT = "CONTEXT";
    public static final String MENU_OBJECT = "OBJECT";
    public static final String STATUS_PROGRESS = "StatusItemProgress";
    public static final String PREFERENCES_RESOURCES = "ResourcePage";
    public static final String PREFERENCE_SHOW_TREE = "ShowTree";
    protected IFramework _framework = null;
    protected IResourceModel _model;
    protected JPanel _customPanel = null;
    protected Component _userComponent = null;
    protected JTree _tree = null;
    protected String _pageTitle = "";
    protected JPopupMenu _contextMenu = new JPopupMenu();
    protected IResourceObject[] _previousSelection = null;
    protected TreeCellRenderer _treeRenderer;
    protected JSplitPane _splitPanel;
    protected JScrollPane _treePanel;
    protected MenuInfoAction _menuInfoAction = new MenuInfoAction();
    protected Vector _menuData = new Vector();
    protected Vector _statusItems = new Vector();
    protected Vector _statusItemPositions = new Vector();
    protected boolean _isPageSelected = false;
    protected boolean _isTreeVisible = true;
    protected StatusItemProgress _statusItemProgress = new StatusItemProgress("StatusItemProgress", 0);

    public ResourcePage(IResourceModel iResourceModel) {
        this._treeRenderer = new ResourceCellRenderer();
        this._model = iResourceModel;
        this._pageTitle = Framework.i18n("page", "Resources");
        this.setLayout(new BorderLayout());
        this._splitPanel = this.createSplitPanel(iResourceModel);
    }

    public void setRootVisible(boolean bl) {
        this._tree.setRootVisible(bl);
        this._tree.setShowsRootHandles(false);
    }

    public void setTreeModel(TreeModel treeModel) {
        this._tree.setModel(treeModel);
    }

    public TreeModel getTreeModel() {
        return this._tree.getModel();
    }

    public boolean getRootVisible() {
        return this._tree.isRootVisible();
    }

    public void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        this._treeRenderer = treeCellRenderer;
        if (this._tree != null) {
            this._tree.setCellRenderer(treeCellRenderer);
        }
    }

    protected JSplitPane createSplitPanel(IResourceModel iResourceModel) {
        Component component = this.createTree(iResourceModel);
        this._customPanel = new EmptyPanel();
        this._customPanel.setLayout(new BorderLayout());
        this._customPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this._userComponent = new EmptyPanel();
        this._customPanel.add(this._userComponent);
        JSplitPane jSplitPane = new JSplitPane(1, component, this._customPanel);
        jSplitPane.setBorder(new EmptyBorder(6, 6, 6, 6));
        jSplitPane.setDividerLocation((int)component.getPreferredSize().getWidth());
        return jSplitPane;
    }

    protected Component createTree(IResourceModel iResourceModel) {
        this._tree = new JTree(iResourceModel);
        this._tree.addFocusListener(new TreeFocusListener());
        this._tree.setCellRenderer(this._treeRenderer);
        this._tree.addTreeSelectionListener(this);
        this._tree.addMouseListener(this);
        this._tree.addKeyListener(this);
        this._tree.addTreeWillExpandListener(this);
        this._treePanel = new JScrollPane();
        this._treePanel.getViewport().add(this._tree);
        this._treePanel.setBorder(new BevelBorder(1, UIManager.getColor("controlHighlight"), UIManager.getColor("control"), UIManager.getColor("controlDkShadow"), UIManager.getColor("controlShadow")));
        this._treePanel.setPreferredSize(new Dimension(200, 200));
        this._treePanel.setMinimumSize(new Dimension(1, 1));
        return this._treePanel;
    }

    public Object clone() {
        ResourcePage resourcePage = new ResourcePage(this._model);
        return resourcePage;
    }

    public IResourceModel getModel() {
        return this._model;
    }

    public String getPageTitle() {
        return this._pageTitle;
    }

    public void setPageTitle(String string) {
        this._pageTitle = string;
    }

    public void initialize(IFramework iFramework) {
        PreferenceManager preferenceManager = PreferenceManager.getPreferenceManager("Console", "4.0");
        Preferences preferences = preferenceManager.getPreferences(PREFERENCES_RESOURCES);
        this.setMainPanel(preferences.getBoolean(PREFERENCE_SHOW_TREE, true));
        this._framework = iFramework;
        this._model.addIResourceModelListener(this);
        MenuItemCategory menuItemCategory = new MenuItemCategory(MENU_OBJECT, Framework.i18n("menu", "Object"));
        this.addMenuItem("<top>", menuItemCategory);
        this.addMenuItem("VIEW", new MenuItemCheckBox(Framework.i18n("menu", "ViewToggleTree"), "TODO:description", new TreeToggleAction(), this._isTreeVisible));
        if (this._model instanceof IMenuInfo) {
            this.addMenuItems((IMenuInfo)((Object)this._model), this._menuInfoAction);
        }
        this.addStatusItem(this._statusItemProgress, "R");
    }

    public IFramework getFramework() {
        return this._framework;
    }

    public void setCustomPanel(Component component) {
        if (this._customPanel != null) {
            if (component != null && component.equals(this._userComponent)) {
                return;
            }
            this._customPanel.remove(this._userComponent);
            if (component != null) {
                this._userComponent = component;
            } else {
                if (this._userComponent instanceof EmptyPanel) {
                    return;
                }
                this._userComponent = new EmptyPanel();
            }
            this._customPanel.add(this._userComponent);
            this._customPanel.validate();
            this._customPanel.repaint();
        }
    }

    public IResourceObject[] getSelection() {
        IResourceObject[] iResourceObjectArray = null;
        TreePath[] treePathArray = this._tree.getSelectionPaths();
        if (treePathArray != null && treePathArray.length > 0) {
            iResourceObjectArray = new IResourceObject[treePathArray.length];
            int n = 0;
            while (n < treePathArray.length) {
                iResourceObjectArray[n] = (IResourceObject)treePathArray[n].getLastPathComponent();
                ++n;
            }
        }
        return iResourceObjectArray;
    }

    public IResourceObject[] getPreviousSelection() {
        return this._previousSelection;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        IResourceObject[] iResourceObjectArray = this.getSelection();
        if (iResourceObjectArray != null) {
            if (iResourceObjectArray.length == 0) {
                this.setCustomPanel(null);
            } else if (iResourceObjectArray.length == 1) {
                this.setCustomPanel(this._model.getCustomPanel(this, iResourceObjectArray[0]));
            }
        } else {
            this.setCustomPanel(null);
        }
        this._model.actionObjectSelected(this, iResourceObjectArray, this.getPreviousSelection());
        this._previousSelection = iResourceObjectArray;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        IResourceObject[] iResourceObjectArray = this.getSelection();
        if (iResourceObjectArray != null && mouseEvent.getClickCount() == 2) {
            if (iResourceObjectArray.length == 1 && !this._model.isLeaf(iResourceObjectArray[0])) {
                return;
            }
            this._model.actionObjectRun(this, iResourceObjectArray);
        }
    }

    public void runComplete(IResourceObject iResourceObject) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this._contextMenu != null && !this._contextMenu.isVisible() && SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.popupContextMenu(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this._contextMenu != null && !this._contextMenu.isVisible() && SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.popupContextMenu(mouseEvent);
        }
    }

    private void popupContextMenu(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (component == this._tree) {
            TreePath treePath = this._tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath != null && !this._tree.isPathSelected(treePath)) {
                this._tree.setSelectionPath(treePath);
            }
            if (this._contextMenu.getComponentCount() > 0) {
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                Point point = this._tree.getLocationOnScreen();
                int n = (int)dimension.getWidth();
                int n2 = this._contextMenu.getWidth();
                int n3 = mouseEvent.getX();
                int n4 = (int)point.getX();
                int n5 = (int)dimension.getHeight();
                int n6 = this._contextMenu.getHeight();
                int n7 = mouseEvent.getY();
                int n8 = (int)point.getY();
                if (n4 + n3 + n2 > n) {
                    n3 -= n2;
                }
                if (n8 + n7 + n6 > n5) {
                    n7 -= n6;
                }
                this._contextMenu.show(component, n3, n7);
            }
        }
    }

    private boolean isEventTarget(ResourceModelEvent resourceModelEvent) {
        IPage iPage = resourceModelEvent.getViewInstance();
        if (iPage == null) {
            return true;
        }
        return iPage == this;
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        TreeNode treeNode = (TreeNode)treeExpansionEvent.getPath().getLastPathComponent();
        try {
            int n = treeNode.getChildCount();
            if (n < 0) {
                throw new ExpandVetoException(treeExpansionEvent);
            }
        }
        catch (Exception exception) {
            Debug.println(0, "ResourcePage.treeWillExpand " + exception);
            throw new ExpandVetoException(treeExpansionEvent);
        }
    }

    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        TreePath treePath = treeExpansionEvent.getPath();
        if (treePath != null && treePath.getPathCount() <= 1) {
            throw new ExpandVetoException(treeExpansionEvent);
        }
    }

    public void addMenuItems(ResourceModelEvent resourceModelEvent) {
        if (this.isEventTarget(resourceModelEvent)) {
            this.addMenuItems(resourceModelEvent.getMenuInfo(), this._menuInfoAction);
        }
    }

    public void enableMenuItem(ResourceModelEvent resourceModelEvent) {
        if (this.isEventTarget(resourceModelEvent)) {
            MenuData.enableMenuItem(this._menuData, resourceModelEvent.getMenuID(), true);
        }
    }

    public void disableMenuItem(ResourceModelEvent resourceModelEvent) {
        if (this.isEventTarget(resourceModelEvent)) {
            MenuData.enableMenuItem(this._menuData, resourceModelEvent.getMenuID(), false);
        }
    }

    protected void addMenuItem(String string, IMenuItem iMenuItem) {
        MenuData menuData = new MenuData(string, iMenuItem, null);
        this.populateMenuItems(menuData);
        this._menuData.addElement(menuData);
    }

    private void populateMenuItems(MenuData menuData) {
        if (this.isPageSelected()) {
            if (menuData.getCategoryID().equals(MENU_CONTEXT)) {
                this._contextMenu.add(menuData.getIMenuItem().getComponent());
            } else {
                JMenu jMenu = MenuData.getMenu(this._contextMenu, menuData.getCategoryID());
                if (jMenu != null) {
                    jMenu.add(menuData.getIMenuItem().getComponent());
                } else {
                    this._framework.addMenuItem(menuData.getCategoryID(), menuData.getIMenuItem());
                }
            }
        }
    }

    private void populateMenuItems(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.populateMenuItems((MenuData)enumeration.nextElement());
        }
    }

    private void unpopulateMenuItems(Vector vector) {
        if (this.isPageSelected()) {
            int n = vector.size() - 1;
            while (n >= 0) {
                MenuData menuData = (MenuData)vector.elementAt(n);
                if (menuData.getCategoryID().equals(MENU_CONTEXT)) {
                    this._contextMenu.remove(menuData.getIMenuItem().getComponent());
                } else {
                    JMenu jMenu = MenuData.getMenu(this._contextMenu, menuData.getCategoryID());
                    if (jMenu != null) {
                        MenuData.removeMenuItem(jMenu, menuData.getIMenuItem());
                    } else {
                        this._framework.removeMenuItem(menuData.getIMenuItem());
                    }
                }
                --n;
            }
        }
    }

    protected void addMenuItems(IMenuInfo iMenuInfo, ActionListener actionListener) {
        Vector vector = MenuData.createMenuData(iMenuInfo, actionListener);
        this.populateMenuItems(vector);
        MenuData.addVectors(this._menuData, vector);
    }

    public void removeMenuItems(ResourceModelEvent resourceModelEvent) {
        if (this.isEventTarget(resourceModelEvent)) {
            Vector vector = MenuData.createMenuDataByID(this._menuData, MenuData.createMenuData(resourceModelEvent.getMenuInfo(), null));
            this.unpopulateMenuItems(vector);
            MenuData.substractVectors(this._menuData, vector);
        }
    }

    private void addStatusItem(IStatusItem iStatusItem, String string) {
        this._statusItems.addElement(iStatusItem);
        this._statusItemPositions.addElement(string);
    }

    private void removeStatusItem(IStatusItem iStatusItem) {
        int n = this._statusItems.indexOf(iStatusItem);
        this._statusItems.removeElementAt(n);
        this._statusItemPositions.removeElementAt(n);
    }

    protected void populateStatusItems() {
        if (this.isPageSelected()) {
            int n = 0;
            while (n < this._statusItems.size()) {
                IStatusItem iStatusItem = (IStatusItem)this._statusItems.elementAt(n);
                String string = (String)this._statusItemPositions.elementAt(n);
                this._framework.addStatusItem(iStatusItem, string);
                ++n;
            }
        }
    }

    protected void unpopulateStatusItems() {
        if (this.isPageSelected()) {
            int n = this._statusItems.size() - 1;
            while (n >= 0) {
                IStatusItem iStatusItem = (IStatusItem)this._statusItems.elementAt(n);
                this._framework.removeStatusItem(iStatusItem);
                --n;
            }
        }
    }

    public void addStatusItem(ResourceModelEvent resourceModelEvent) {
        if (this.isEventTarget(resourceModelEvent)) {
            IStatusItem iStatusItem = resourceModelEvent.getStatusItem();
            String string = resourceModelEvent.getStatusItemPosition();
            this.addStatusItem(iStatusItem, string);
            this._framework.addStatusItem(iStatusItem, string);
        }
    }

    public void removeStatusItem(ResourceModelEvent resourceModelEvent) {
        if (this.isEventTarget(resourceModelEvent)) {
            this.removeStatusItem(resourceModelEvent.getStatusItem());
            this._framework.removeStatusItem(resourceModelEvent.getStatusItem());
        }
    }

    public void changeStatusItemState(ResourceModelEvent resourceModelEvent) {
        if (this.isEventTarget(resourceModelEvent) && this.isPageSelected()) {
            this._framework.changeStatusItemState(resourceModelEvent.getStatusItemID(), resourceModelEvent.getStatusItemState());
        }
    }

    public void changeCustomPanel(ResourceModelEvent resourceModelEvent) {
        if (this.isEventTarget(resourceModelEvent)) {
            this.setCustomPanel(resourceModelEvent.getCustomPanel());
        }
    }

    public void changeFeedbackCursor(ResourceModelEvent resourceModelEvent) {
        if (this.isEventTarget(resourceModelEvent)) {
            if (resourceModelEvent.getCursor().getType() == 3 && this._framework instanceof Framework) {
                ((Framework)this._framework).setBusyCursor(true);
            } else if (resourceModelEvent.getCursor().getType() == 0 && this._framework instanceof Framework) {
                ((Framework)this._framework).setBusyCursor(false);
            } else {
                this._framework.setCursor(resourceModelEvent.getCursor());
            }
        }
    }

    public boolean isPageSelected() {
        return this._isPageSelected;
    }

    public void pageSelected(IFramework iFramework) {
        this._isPageSelected = true;
        this.populateMenuItems(this._menuData);
        this.populateStatusItems();
        if (this._tree.getComponentCount() > 0 && this.getSelection() == null) {
            this._tree.setSelectionRow(0);
        }
    }

    public void pageUnselected(IFramework iFramework) {
        this.unpopulateMenuItems(this._menuData);
        this.unpopulateStatusItems();
        this._isPageSelected = false;
    }

    public void actionViewClosing(IFramework iFramework) throws CloseVetoException {
        this.getModel().actionViewClosing(this);
    }

    private void setMainPanel(boolean bl) {
        this._isTreeVisible = bl;
        if (this._isTreeVisible) {
            this.remove(this._customPanel);
            this._splitPanel.setRightComponent(this._customPanel);
            this.add(this._splitPanel);
        } else {
            this.remove(this._splitPanel);
            this.add(this._customPanel);
        }
        PreferenceManager preferenceManager = PreferenceManager.getPreferenceManager("Console", "4.0");
        Preferences preferences = preferenceManager.getPreferences(PREFERENCES_RESOURCES);
        preferences.set(PREFERENCE_SHOW_TREE, this._isTreeVisible);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        IResourceObject[] iResourceObjectArray;
        if (keyEvent.getKeyCode() == 10 && (iResourceObjectArray = this.getSelection()) != null) {
            if (iResourceObjectArray.length == 1 && !this._model.isLeaf(iResourceObjectArray[0])) {
                return;
            }
            this._model.actionObjectRun(this, iResourceObjectArray);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void expandTreePath(TreePath treePath) {
        this._tree.expandPath(treePath);
    }

    public void expandTreeRow(int n) {
        this._tree.expandRow(n);
    }

    public void selectTreeRow(int n) {
        this._tree.setSelectionRow(n);
    }

    public void selectTreeNode(ResourceModelEvent resourceModelEvent) {
        if (this.isEventTarget(resourceModelEvent)) {
            this._tree.setSelectionPath(resourceModelEvent.getTreePath());
        }
    }

    public void expandTreeNode(ResourceModelEvent resourceModelEvent) {
        if (this.isEventTarget(resourceModelEvent)) {
            this._tree.expandPath(resourceModelEvent.getTreePath());
        }
    }

    class TreeToggleAction
    implements ActionListener {
        TreeToggleAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            ResourcePage.this.setMainPanel(jCheckBoxMenuItem.getState());
            ResourcePage.this.validate();
            ResourcePage.this.repaint();
        }
    }

    class MenuInfoAction
    implements ActionListener {
        MenuInfoAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            IMenuItem iMenuItem = (IMenuItem)actionEvent.getSource();
            IMenuInfo iMenuInfo = MenuData.findIMenuInfo(ResourcePage.this._menuData, iMenuItem);
            iMenuInfo.actionMenuSelected(ResourcePage.this, iMenuItem);
        }
    }

    class EmptyPanel
    extends JPanel {
        EmptyPanel() {
        }
    }

    class TreeFocusListener
    implements FocusListener {
        TreeFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            JTree jTree = (JTree)focusEvent.getSource();
            jTree.validate();
            jTree.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            JTree jTree = (JTree)focusEvent.getSource();
            jTree.validate();
            jTree.repaint();
        }
    }
}

