/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.acl;

import com.netscape.management.client.acl.AttributeList;
import com.netscape.management.client.util.Debug;
import java.io.EOFException;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Rule {
    public static final int QUOTE_CHAR = 34;
    protected boolean allow = true;
    protected boolean absolute = false;
    protected AttributeList rights = new AttributeList();
    protected Hashtable attr = new Hashtable();
    protected String syntax = null;

    public Rule() {
        this.setDefaults();
    }

    public Rule(StreamTokenizer streamTokenizer) throws IOException {
        this.parseRule(streamTokenizer);
    }

    protected void setDefaults() {
        this.setRight("all");
        this.setAttribute("user", "any");
        this.setAttribute("dns", "any");
    }

    protected void parseRule(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.quoteChar(34);
        this.parseAllow(streamTokenizer);
        this.parseAbsolute(streamTokenizer);
        this.parseRights(streamTokenizer);
        this.parseBody(streamTokenizer);
    }

    public void writeRule(Writer writer) throws IOException {
        if (this.attr.size() == 0) {
            return;
        }
        this.writeHeader(writer);
        this.writeContent(writer);
    }

    public boolean getAllow() {
        return this.allow;
    }

    public void setAllow(boolean bl) {
        this.allow = bl;
    }

    public void toggleAllow() {
        this.allow = !this.allow;
    }

    public boolean getAbsolute() {
        return this.absolute;
    }

    public void setAbsolute(boolean bl) {
        this.absolute = bl;
    }

    public void setRight(String string) {
        this.rights.setAttribute(string);
    }

    public void unSetRight(String string) {
        this.rights.removeAttribute(string);
    }

    public AttributeList getRightsList() {
        return this.rights;
    }

    public void setAttribute(String string, String string2) {
        AttributeList attributeList = this.getAttributeList(string);
        if (attributeList == null) {
            attributeList = new AttributeList();
            this.setAttributeList(string, attributeList);
        }
        attributeList.setAttribute(string2);
    }

    public void setAttribute(String string, String string2, String string3) {
        AttributeList attributeList = this.getAttributeList(string);
        if (attributeList == null) {
            attributeList = new AttributeList();
            this.setAttributeList(string, attributeList);
        }
        attributeList.setAttribute(string2, string3);
    }

    public void unSetAttribute(String string, String string2) {
        AttributeList attributeList = this.getAttributeList(string);
        if (attributeList == null) {
            return;
        }
        attributeList.removeAttribute(string2);
        if (attributeList.size() == 0) {
            this.removeAttributeList(string);
        }
    }

    public AttributeList getAttributeList(String string) {
        return (AttributeList)this.attr.get(string);
    }

    public void setAttributeList(String string, AttributeList attributeList) {
        this.attr.put(string, attributeList);
    }

    public void removeAttributeList(String string) {
        this.attr.remove(string);
    }

    public void updateAttributeList(String string, AttributeList attributeList) {
        AttributeList attributeList2 = this.getAttributeList(string);
        if (attributeList2 != null) {
            attributeList2.removeAll();
            this.removeAttributeList(string);
        }
        if (attributeList.size() > 0) {
            this.setAttributeList(string, attributeList);
        }
    }

    public String getSyntax() {
        StringWriter stringWriter = new StringWriter();
        try {
            this.writeContent(stringWriter);
            stringWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public void setSyntax(String string) {
        this.syntax = string;
    }

    public boolean syntaxOverrideSet() {
        return this.syntax != null;
    }

    protected void parseAllow(StreamTokenizer streamTokenizer) throws IOException {
        Debug.println("Rule.parseAllow: Parsing Rule Allow.");
        int n = streamTokenizer.nextToken();
        switch (n) {
            case -3: {
                if (streamTokenizer.sval.equals("allow")) {
                    Debug.println("Rule.parseAllow: allow set");
                    this.allow = true;
                    return;
                }
                if (streamTokenizer.sval.equals("deny")) {
                    Debug.println("Rule.parseAllow: deny set");
                    this.allow = false;
                    return;
                }
            }
            default: {
                throw new IOException("Unrecognized token in ACL rule allow/deny");
            }
            case -1: 
            case 41: 
        }
        Debug.println("Rule.parseAllow: Clean EOF");
        throw new EOFException("Clean EOF");
    }

    protected void parseAbsolute(StreamTokenizer streamTokenizer) throws IOException {
        Debug.println("Rule.parseAbsolute: Parsing Rule Absolute.");
        int n = streamTokenizer.nextToken();
        switch (n) {
            case 40: {
                Debug.println("Rule.parseAbsolute: absolute not set");
                this.absolute = false;
                streamTokenizer.pushBack();
                return;
            }
            case -3: {
                if (streamTokenizer.sval.equals("absolute")) {
                    Debug.println("Rule.parseAbsolute: absolute set");
                    this.absolute = true;
                    return;
                }
            }
            default: {
                throw new IOException("Unrecognized token in ACL rule absolute");
            }
            case -1: 
        }
        throw new EOFException("Unexpected EOF while parsing ACL rule absolute");
    }

    protected void parseRights(StreamTokenizer streamTokenizer) throws IOException {
        int n;
        Debug.println("Rule.parseAbsolute: Parsing Rule Rights.");
        while ((n = streamTokenizer.nextToken()) != -1) {
            switch (n) {
                case 40: 
                case 44: 
                case 124: {
                    break;
                }
                case 41: {
                    if (this.rights.size() != 0) {
                        return;
                    }
                    throw new IOException("No rights specified in ACL rule");
                }
                case -3: {
                    Debug.println("right: " + streamTokenizer.sval);
                    this.setRight(streamTokenizer.sval);
                    break;
                }
                default: {
                    throw new IOException("Unrecognized token in ACL rule rights");
                }
            }
        }
        throw new EOFException("Unexpected EOF while parsing ACL rule rights");
    }

    protected void parseBody(StreamTokenizer streamTokenizer) throws IOException {
        int n;
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        Debug.println("Rule.parseBody: Parsing Rule Body.");
        block7: while ((n = streamTokenizer.nextToken()) != -1) {
            switch (n) {
                case 40: 
                case 41: {
                    break;
                }
                case 33: 
                case 60: 
                case 61: 
                case 62: {
                    stringBuffer.append((char)n);
                    break;
                }
                case -3: {
                    if (streamTokenizer.sval.equalsIgnoreCase("and") || streamTokenizer.sval.equalsIgnoreCase("or") || streamTokenizer.sval.equalsIgnoreCase("not")) continue block7;
                    string = streamTokenizer.sval;
                    Debug.print("Rule.parseBody: " + string);
                    break;
                }
                case 59: {
                    return;
                }
                case 34: {
                    StringTokenizer stringTokenizer = new StringTokenizer(streamTokenizer.sval, "|");
                    while (stringTokenizer.hasMoreTokens()) {
                        this.setAttribute(string, stringTokenizer.nextToken(), stringBuffer.toString());
                    }
                    Debug.println("Rule.parseBody: " + stringBuffer.toString() + " " + streamTokenizer.sval);
                    string = null;
                    stringBuffer = new StringBuffer();
                    break;
                }
                default: {
                    throw new IOException("Unrecognized token in ACL rule body");
                }
            }
        }
        throw new EOFException("Unexpected EOF while parsing ACL rule body");
    }

    protected void writeHeader(Writer writer) throws IOException {
        writer.write((this.allow ? "allow" : "deny") + (this.absolute ? " absolute " : " "));
        writer.write("(" + this.rights.generateList(",") + ")" + this.newLine());
    }

    protected void writeContent(Writer writer) throws IOException {
        if (this.syntaxOverrideSet()) {
            writer.write(this.syntax + this.newLine());
            return;
        }
        if (this.attr.size() == 0) {
            return;
        }
        Enumeration enumeration = this.attr.keys();
        while (true) {
            String string = (String)enumeration.nextElement();
            writer.write(this.indent() + this.getAttributeList(string).generateExpression(string));
            if (!enumeration.hasMoreElements()) {
                writer.write(";" + this.newLine());
                return;
            }
            writer.write(" or" + this.newLine());
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        try {
            this.writeRule(stringWriter);
            stringWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    protected String newLine() {
        return "\n";
    }

    protected String indent() {
        return "\t";
    }
}

