/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.legacy.plugin;

import com.netscape.management.client.ResourceObject;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.legacy.plugin.LegacyServerLocNode;
import com.netscape.management.client.legacy.plugin.LegacyServerNode;
import com.netscape.management.client.legacy.plugin.LegacyServiceLocator;
import com.netscape.management.client.topology.INodeInfo;
import com.netscape.management.client.topology.NodeData;
import com.netscape.management.client.topology.NodeDataPanel;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiOptionPane;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;

public class LegacyAdminGroupNode
extends LegacyServerLocNode
implements INodeInfo {
    private static ResourceSet _resource = new ResourceSet("com.netscape.management.client.legacy.plugin.default");
    private static RemoteImage _icon = null;
    private static Vector _changeListeners = new Vector();
    private String _description;
    private String _adminURL;
    private String _groupName;
    public static final int SILENT_DELETE = 1;
    public static final int PROMPT_BEFORE_DELETE = 2;
    public static final String ID_DESCRIPTION = "DESCRIPTION";
    public static final String ID_ADMINURL = "ADMINURL";
    NodeData[] _nodeData;

    public LegacyAdminGroupNode(LegacyServiceLocator legacyServiceLocator, LDAPEntry lDAPEntry) {
        super(legacyServiceLocator);
        _icon = new RemoteImage(_resource.getString("tree", "folderIcon"));
        _icon.setDescription(_resource.getString("tree", "folderIcon-description"));
        this.initialize(lDAPEntry);
    }

    private void initialize(LDAPEntry lDAPEntry) {
        this.setIcon(_icon);
        if (lDAPEntry != null) {
            LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
            Enumeration enumeration = lDAPAttributeSet.getAttributes();
            this.setDN(lDAPEntry.getDN());
            this.setName(LDAPUtil.flatting(lDAPEntry.getAttribute("cn", LDAPUtil.getLDAPAttributeLocale())));
            while (enumeration.hasMoreElements()) {
                LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
                String string = lDAPAttribute.getName();
                if (string.equalsIgnoreCase("nsAdminGroupName") || string.equalsIgnoreCase("cn")) {
                    this._groupName = LDAPUtil.flatting(lDAPAttribute.getStringValues());
                    this.setName(LDAPUtil.flatting(lDAPAttribute.getStringValues()));
                    continue;
                }
                if (string.equalsIgnoreCase("description")) {
                    this._description = LDAPUtil.flatting(lDAPAttribute.getStringValues());
                    continue;
                }
                if (!string.equalsIgnoreCase("AdminURL")) continue;
                this._adminURL = LDAPUtil.flatting(lDAPAttribute.getStringValues());
            }
            this._nodeData = new NodeData[]{new NodeData(ID_DESCRIPTION, "Description", this._description, true), new NodeData(ID_ADMINURL, "Administration URL", this._adminURL, false)};
        }
    }

    public void reload() {
        String string = "";
        Vector vector = new Vector();
        ((DefaultMutableTreeNode)((Object)this)).removeAllChildren();
        super.reload();
        LDAPSearchResults lDAPSearchResults = (LDAPSearchResults)this.getServiceLocator().getProductType(this.getDN());
        try {
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
                Enumeration enumeration = this.getServiceLocator().getSIE(lDAPEntry.getDN());
                while (enumeration.hasMoreElements()) {
                    LDAPEntry lDAPEntry2 = (LDAPEntry)enumeration.nextElement();
                    LegacyServerNode legacyServerNode = new LegacyServerNode(this._serviceLocator, lDAPEntry2);
                    if (this.searchChildByName(legacyServerNode.getName()) != null) continue;
                    ((DefaultMutableTreeNode)((Object)this)).add((MutableTreeNode)((Object)legacyServerNode));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Component getCustomPanel() {
        return new NodeDataPanel(this.getIcon(), this.getName(), this);
    }

    public int deleteLDAPentry(int n) {
        LDAPConnection lDAPConnection;
        LegacyServiceLocator legacyServiceLocator = this.getServiceLocator();
        LDAPSearchResults lDAPSearchResults = null;
        LDAPSearchResults lDAPSearchResults2 = null;
        if (n == 2) {
            legacyServiceLocator.getConsoleInfo();
            int n2 = SuiOptionPane.showConfirmDialog((Component)ConsoleInfo.frame, (Object)_resource.getString("legacyplugin", "AGNdelConfirm"), (String)_resource.getString("legacyplugin", "AGNdelTitle"), (int)0);
            ModalDialogUtil.sleep();
            if (n2 == 1) {
                return -1;
            }
        }
        if ((lDAPConnection = legacyServiceLocator.getConsoleInfo().getLDAPConnection()) != null) {
            int n3;
            LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
            String string = new String("(objectclass=nsLegacyApplication)");
            try {
                lDAPSearchResults = lDAPConnection.search(this.getDN(), 1, string, null, false, lDAPSearchConstraints);
            }
            catch (LDAPException lDAPException) {
                n3 = lDAPException.getLDAPResultCode();
                Debug.println("LDAPException: B..return code:" + n3);
            }
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry;
                try {
                    lDAPEntry = lDAPSearchResults.next();
                }
                catch (Exception exception) {
                    continue;
                }
                String string2 = lDAPEntry.getDN();
                Debug.println("Entering Application --->" + string2);
                string = "(objectclass=nsLegacyServer)";
                try {
                    lDAPSearchResults2 = lDAPConnection.search(string2, 1, string, null, false, lDAPSearchConstraints);
                }
                catch (LDAPException lDAPException) {
                    n3 = lDAPException.getLDAPResultCode();
                    Debug.println("LDAPException: B..return code:" + n3);
                }
                while (lDAPSearchResults2.hasMoreElements()) {
                    LDAPEntry lDAPEntry2;
                    try {
                        lDAPEntry2 = lDAPSearchResults2.next();
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    String string3 = lDAPEntry2.getDN();
                    Debug.println("Entering SIEEntry --->" + string3);
                    try {
                        Debug.print("Deleting :::> " + string3);
                        lDAPConnection.delete(string3);
                        Debug.print("......Done!");
                    }
                    catch (LDAPException lDAPException) {
                        Debug.println("LDAP Error...C: " + (Object)((Object)lDAPException));
                        return -1;
                    }
                }
                try {
                    Debug.print("Deleting :::> " + string2);
                    lDAPConnection.delete(string2);
                    Debug.print("......Done!");
                }
                catch (LDAPException lDAPException) {
                    Debug.println("LDAP Error...D: " + (Object)((Object)lDAPException));
                    return -1;
                }
            }
            try {
                Debug.print("Deleting :::> " + this.getDN());
                lDAPConnection.delete(this.getDN());
                Debug.print("......Done!");
            }
            catch (LDAPException lDAPException) {
                Debug.println("LDAP Error:...E" + (Object)((Object)lDAPException));
                return -1;
            }
            return 0;
        }
        return -1;
    }

    public ResourceObject pruneParents(String string) {
        LDAPSearchResults lDAPSearchResults = null;
        LegacyServiceLocator legacyServiceLocator = this.getServiceLocator();
        LDAPConnection lDAPConnection = legacyServiceLocator.getConsoleInfo().getLDAPConnection();
        if (lDAPConnection != null) {
            LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
            String string2 = new String("(objectclass=nsLegacyAdminGroup)");
            try {
                lDAPSearchResults = lDAPConnection.search(string, 1, string2, null, false, lDAPSearchConstraints);
            }
            catch (LDAPException lDAPException) {
                int n = lDAPException.getLDAPResultCode();
                Debug.println("LDAPException: F..return code:" + n);
            }
            if (lDAPSearchResults.hasMoreElements()) {
                return this;
            }
            return (ResourceObject)((DefaultMutableTreeNode)((Object)this)).getParent();
        }
        Debug.println("Connection to Directory Server lost.  Internal Error");
        return this;
    }

    public int getNodeDataCount() {
        return this._nodeData.length;
    }

    public NodeData getNodeData(int n) {
        return this._nodeData[n];
    }

    public void replaceNodeDataValue(NodeData nodeData) {
        int n = 0;
        while (n < this._nodeData.length) {
            if (this._nodeData[n].getName().equals(nodeData.getName())) {
                this._nodeData[n].setValue(nodeData.getValue());
                return;
            }
            ++n;
        }
    }

    public void actionNodeDataChanged(NodeData nodeData) {
        this.replaceNodeDataValue(nodeData);
        if (!nodeData.getID().equals(ID_DESCRIPTION)) {
            return;
        }
        String string = "description";
        LDAPAttribute lDAPAttribute = new LDAPAttribute(string, (String)nodeData.getValue());
        LDAPModification lDAPModification = new LDAPModification(2, lDAPAttribute);
        LDAPConnection lDAPConnection = this.getServiceLocator().getConnection();
        try {
            lDAPConnection.modify(this.getDN(), lDAPModification);
        }
        catch (LDAPException lDAPException) {
            Debug.println("Could not modify Group entry.");
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        _changeListeners.addElement(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        _changeListeners.removeElement(changeListener);
    }
}

