/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.security;

import com.netscape.management.client.components.IDataCollectionModel;
import com.netscape.management.client.components.WizardPage;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.security.CertificateList;
import com.netscape.management.client.security.EditTrustDialog;
import com.netscape.management.client.security.KeyCertUtility;
import com.netscape.management.client.security.SecurityUtil;
import com.netscape.management.client.util.AdmTask;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.GridBagLayout;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

class CertInstallSetTrustPage
extends WizardPage
implements SuiConstants {
    JCheckBox clientTrust;
    JCheckBox serverTrust;

    public boolean nextInvoked() {
        boolean bl = false;
        try {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("formop", "INSTALL_CERT");
            hashtable.put("installmethod", "1");
            IDataCollectionModel iDataCollectionModel = this.getDataModel();
            hashtable.put("sie", iDataCollectionModel.getValue("sie"));
            hashtable.put("tokenname", iDataCollectionModel.getValue("tokenname"));
            hashtable.put("dercert", iDataCollectionModel.getValue("dercert"));
            hashtable.put("certtype", iDataCollectionModel.getValue("certtype"));
            hashtable.put("certname", iDataCollectionModel.getValue("certname"));
            int n = (this.clientTrust.isSelected() ? EditTrustDialog.TRUSTED_CLIENT_CA : 0) | (this.serverTrust.isSelected() ? EditTrustDialog.TRUSTED_CA : 0);
            hashtable.put("trust_flag", Integer.toString(n));
            ConsoleInfo consoleInfo = (ConsoleInfo)iDataCollectionModel.getValue("consoleInfo");
            AdmTask admTask = new AdmTask(new URL(consoleInfo.getAdminURL() + "admin-serv/tasks/configuration/SecurityOp"), consoleInfo.getAuthenticationDN(), consoleInfo.getAuthenticationPassword());
            admTask.setArguments(hashtable);
            admTask.exec();
            Debug.println(admTask.getResultString().toString());
            if (!SecurityUtil.showError(admTask)) {
                iDataCollectionModel.setValue("certlist", new CertificateList(admTask.getResultString().toString()));
                bl = true;
            }
        }
        catch (Exception exception) {
            SecurityUtil.printException("CertInstallSetTrustPage::nextInvoked()", exception);
        }
        return bl;
    }

    public void helpInvoked() {
        KeyCertUtility.getHelp().contextHelp("CertInstallSetTrustPage", "help");
    }

    public CertInstallSetTrustPage() {
        super(KeyCertUtility.getResourceSet().getString("CertInstallSetTrustPage", "pageTitle"));
        this.setLayout(new GridBagLayout());
        ResourceSet resourceSet = KeyCertUtility.getResourceSet();
        JLabel jLabel = new JLabel(resourceSet.getString("CertInstallSetTrustPage", "purposeLabel"));
        int n = 0;
        this.clientTrust = new JCheckBox(resourceSet.getString("CertInstallSetTrustPage", "trustClientLabel"), true);
        this.serverTrust = new JCheckBox(resourceSet.getString("CertInstallSetTrustPage", "trustServerLabel"), true);
        GridBagUtil.constrain(this, jLabel, 0, n, 1, 1, 1.0, 0.0, 11, 2, 0, 0, 6, 6);
        GridBagUtil.constrain(this, this.clientTrust, 0, ++n, 1, 1, 1.0, 0.0, 11, 2, 0, 0, 6, 6);
        GridBagUtil.constrain(this, this.serverTrust, 0, ++n, 1, 1, 1.0, 0.0, 11, 2, 0, 0, 6, 6);
        GridBagUtil.constrain(this, Box.createVerticalGlue(), 0, ++n, 1, 1, 1.0, 1.0, 11, 1, 0, 0, 0, 0);
        this.m_canMoveForward = true;
    }
}

