/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.security;

import com.netscape.management.client.security.IClientAuthOptions;
import com.netscape.management.client.security.SecurityUtil;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.GridBagUtil;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ClientAuthPanel
extends JPanel
implements ActionListener {
    IClientAuthOptions iClientAuthOption;
    ButtonModel resetValue;
    JRadioButton disabled;
    JRadioButton enabled;
    JRadioButton required;
    ButtonGroup buttonGroup;

    private static String i18n(String string) {
        return SecurityUtil.getResourceSet().getString("ClientAuthPanel", string);
    }

    public void reset() {
        this.buttonGroup.setSelected(this.resetValue, true);
        this.resetValue.setSelected(true);
        Debug.println("ClientAuthPanel.reset:" + this.resetValue);
    }

    public void setSaved() {
        this.resetValue = this.buttonGroup.getSelection();
        Debug.println("ClientAuthPanel.setSaved:" + this.resetValue);
    }

    public void setEnabled(boolean bl) {
        Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            ((JRadioButton)enumeration.nextElement()).setEnabled(bl);
        }
    }

    public ClientAuthPanel(IClientAuthOptions iClientAuthOptions) {
        this.setLayout(new GridBagLayout());
        this.iClientAuthOption = iClientAuthOptions;
        int[] nArray = this.iClientAuthOption.getClientAuthUIOption();
        this.buttonGroup = new ButtonGroup();
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            AbstractButton abstractButton = null;
            switch (nArray[n2]) {
                case 0: {
                    this.disabled = new JRadioButton(ClientAuthPanel.i18n("disableLabel"), this.iClientAuthOption.getClientAuthSetting() == 0);
                    this.disabled.setActionCommand("DISABLED");
                    abstractButton = this.disabled;
                    break;
                }
                case 1: {
                    this.enabled = new JRadioButton(ClientAuthPanel.i18n("allowLabel"), this.iClientAuthOption.getClientAuthSetting() == 1);
                    this.enabled.setActionCommand("ENABLED");
                    abstractButton = this.enabled;
                    break;
                }
                case 2: {
                    this.required = new JRadioButton(ClientAuthPanel.i18n("requireLabel"), this.iClientAuthOption.getClientAuthSetting() == 2);
                    this.required.setActionCommand("REQUIRED");
                    abstractButton = this.required;
                }
            }
            abstractButton.addActionListener(this);
            this.buttonGroup.add(abstractButton);
            GridBagUtil.constrain(this, abstractButton, 0, ++n, 1, 1, 1.0, 0.0, 11, 2, 0, 0, 0, 0);
            ++n2;
        }
        this.setSaved();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("ENABLED")) {
            this.iClientAuthOption.clientAuthSettingChanged(1);
        } else if (actionEvent.getActionCommand().equals("DISABLED")) {
            this.iClientAuthOption.clientAuthSettingChanged(0);
        } else if (actionEvent.getActionCommand().equals("REQUIRED")) {
            this.iClientAuthOption.clientAuthSettingChanged(2);
        }
    }
}

