/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.topology;

import com.netscape.management.client.Framework;
import com.netscape.management.client.topology.INodeInfo;
import com.netscape.management.client.topology.NodeData;
import com.netscape.management.client.topology.TopologyInitializer;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.JButtonFactory;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.SingleByteTextArea;
import com.netscape.management.client.util.SingleByteTextField;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;

public class NodeDataPanel
extends JPanel
implements SuiConstants,
SwingConstants {
    public static String ID_OPEN = "ID_OPEN";
    private INodeInfo _nodeInfo;
    private JButton _editButton;
    private JButton _okButton;
    private JButton _cancelButton;
    private JButton _helpButton;
    private Box _buttonPanel;
    private Component _helpHorizontalSpace = Box.createHorizontalStrut(12);
    private Component _horizontalSpace = Box.createHorizontalStrut(6);
    private EditableNodeData[] _editableArray;
    private Hashtable _valueTable = new Hashtable();
    private JLabel headingLabel = new JLabel();
    private ChangeKeyListener _keyChangeListener = new ChangeKeyListener();
    private JScrollPane _scrollPane;
    private String _title;
    private NodeDataChangeListener _changeListener;
    private static ResourceSet _resource = new ResourceSet("com.netscape.management.client.topology.topology");
    private String helpProduct = null;
    private String helpTopic = null;
    private FocusTransferer _focusTransferer;
    AncestorListener _ancestorListener = new AncestorListener(){

        public void ancestorAdded(AncestorEvent ancestorEvent) {
            Debug.println("topology.NodeDataPanel ancestorAdded() adds Change Listener");
            NodeDataPanel.this._nodeInfo.addChangeListener(NodeDataPanel.this._changeListener);
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            Debug.println("topology.NodeDataPanel ancestorRemoved() removes Change Listener");
            NodeDataPanel.this._nodeInfo.removeChangeListener(NodeDataPanel.this._changeListener);
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }
    };

    public NodeDataPanel(Icon icon, String string, INodeInfo iNodeInfo) {
        this(icon, string, iNodeInfo, false, true);
    }

    public NodeDataPanel(Icon icon, String string, INodeInfo iNodeInfo, boolean bl) {
        this(icon, string, iNodeInfo, bl, true);
    }

    public NodeDataPanel(Icon icon, String string, INodeInfo iNodeInfo, boolean bl, boolean bl2) {
        this._nodeInfo = iNodeInfo;
        this._title = string;
        this.setTitle(this._title);
        if (bl2) {
            bl2 = TopologyInitializer.canEditTopology();
        }
        this.createPanel(icon, iNodeInfo, bl, bl2);
        this.setMinimumSize(new Dimension(1, 1));
        this._changeListener = new NodeDataChangeListener();
        this.addAncestorListener(this._ancestorListener);
    }

    public void setTitle(String string) {
        this.headingLabel.setText(string);
        if (this.headingLabel.getParent() != null) {
            if (this.headingLabel.getParent().getParent() != null) {
                this.headingLabel.getParent().invalidate();
                this.headingLabel.getParent().getParent().validate();
            } else {
                this.headingLabel.getParent().validate();
            }
        }
        this.headingLabel.repaint();
    }

    public void setHelpTopic(String string, String string2) {
        this.helpProduct = string;
        this.helpTopic = string2;
    }

    public String getHelpTopic() {
        return this.helpTopic;
    }

    protected JPanel createPanel(Icon icon, INodeInfo iNodeInfo, boolean bl, boolean bl2) {
        NodeDataPanel nodeDataPanel = this;
        nodeDataPanel.setLayout(new GridBagLayout());
        Border border = BorderFactory.createEmptyBorder(9, 9, 9, 9);
        Border border2 = BorderFactory.createEtchedBorder();
        nodeDataPanel.setBorder(BorderFactory.createCompoundBorder(border2, border));
        this.headingLabel.setIcon(icon);
        this.headingLabel.setFont(UIManager.getFont("Title.font"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = -1;
        jPanel.add((Component)this.headingLabel, gridBagConstraints);
        JButton jButton = JButtonFactory.create(_resource.getString("General", "open"), new OpenButtonActionListener(), "OPEN");
        jButton.setToolTipText(_resource.getString("General", "open_tt"));
        JButtonFactory.resize(jButton);
        gridBagConstraints.gridwidth = 0;
        jButton.setVisible(bl);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 6;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)jButton, gridBagConstraints);
        GridBagUtil.constrain(nodeDataPanel, jPanel, 0, -1, 1, 1, 1.0, 0.0, 13, 2, 0, 0, 0, 0);
        JSeparator jSeparator = new JSeparator();
        jSeparator.setMinimumSize(jSeparator.getPreferredSize());
        jSeparator.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        GridBagUtil.constrain(nodeDataPanel, jSeparator, 0, -1, 1, 1, 1.0, 0.0, 17, 2, 6, 0, 9, 0);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        Vector<EditableNodeData> vector = new Vector<EditableNodeData>();
        int n = iNodeInfo.getNodeDataCount();
        this._focusTransferer = new FocusTransferer();
        int n2 = 0;
        while (n2 < n) {
            Object object;
            NodeData nodeData = iNodeInfo.getNodeData(n2);
            Object object2 = nodeData.getValue();
            if (object2 == null) {
                object2 = "";
            }
            if (object2 instanceof String) {
                JTextComponent jTextComponent;
                object = new JLabel(nodeData.getName() + ":");
                GridBagUtil.constrain(jPanel2, (Component)object, 0, -1, 1, 1, 0.0, 0.0, 12, 0, 0, 0, 6, 6);
                if (n2 == 1) {
                    jTextComponent = nodeData.is7Bit() ? new SingleByteTextArea((String)object2) : new JTextArea((String)object2);
                    ((JTextArea)jTextComponent).setEditable(false);
                    ((JTextArea)jTextComponent).addFocusListener(this._focusTransferer);
                } else {
                    if (nodeData.is7Bit()) {
                        jTextComponent = new SingleByteTextField();
                        ((JTextField)jTextComponent).setText((String)object2);
                    } else {
                        jTextComponent = new JTextField((String)object2);
                    }
                    ((JTextField)jTextComponent).setEditable(false);
                    ((JTextField)jTextComponent).addFocusListener(this._focusTransferer);
                    ((JTextField)jTextComponent).select(0, 0);
                    ((JTextField)jTextComponent).setBorder(BorderFactory.createEmptyBorder());
                    ((JTextField)jTextComponent).setMargin(new Insets(0, 0, 0, 0));
                }
                ((JLabel)object).setLabelFor(jTextComponent);
                this._valueTable.put(nodeData.getID(), jTextComponent);
                jTextComponent.setBackground(UIManager.getColor("Label.background"));
                GridBagUtil.constrain(jPanel2, jTextComponent, 1, -1, 1, 1, 1.0, 0.0, 17, 2, 0, 0, 6, 0);
                if (nodeData.isEditable()) {
                    vector.addElement(new EditableNodeData(nodeData.getID(), nodeData.getName(), jTextComponent));
                }
            } else if (object2 instanceof Component) {
                JComponent jComponent;
                object = nodeData.getName();
                boolean bl3 = false;
                if (object != null && !((String)object).equals("")) {
                    jComponent = new JLabel(nodeData.getName() + ":");
                    ((JLabel)jComponent).setLabelFor((Component)object2);
                    GridBagUtil.constrain(jPanel2, jComponent, 0, -1, 1, 1, 0.0, 0.0, 12, 0, 0, 0, 6, 6);
                    bl3 = true;
                }
                GridBagUtil.constrain(jPanel2, (Component)object2, bl3 ? 1 : 0, -1, bl3 ? 1 : 2, 1, 1.0, 0.0, bl3 ? 17 : 13, 2, 0, 0, 6, 0);
                if (nodeData.isEditable()) {
                    ((Component)object2).setEnabled(false);
                    if (object2 instanceof JTextField) {
                        jComponent = (JTextField)object2;
                        ((JTextComponent)jComponent).setEditable(false);
                        jComponent.addFocusListener(this._focusTransferer);
                        ((JTextComponent)jComponent).select(0, 0);
                        jComponent.setBorder(BorderFactory.createEmptyBorder());
                        ((JTextComponent)jComponent).setMargin(new Insets(0, 0, 0, 0));
                    }
                    vector.addElement(new EditableNodeData(nodeData.getID(), nodeData.getName(), (Component)object2));
                }
            } else {
                Debug.println("NodeDataPanel: unsupported NodeData type " + object2);
            }
            ++n2;
        }
        this._editableArray = new EditableNodeData[vector.size()];
        vector.copyInto(this._editableArray);
        GridBagUtil.constrain(jPanel2, Box.createVerticalGlue(), 0, -1, 2, 1, 1.0, 1.0, 16, 3, 0, 0, 0, 0);
        this._scrollPane = new JScrollPane(jPanel2);
        this._scrollPane.addComponentListener(new ScrollPaneComponentListener());
        this._scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this._scrollPane.setHorizontalScrollBarPolicy(30);
        this._scrollPane.setVerticalScrollBarPolicy(20);
        GridBagUtil.constrain(nodeDataPanel, this._scrollPane, 0, -1, 1, 1, 1.0, 1.0, 11, 1, 0, 0, 0, 0);
        if (vector.size() > 0) {
            this._buttonPanel = new HorizontalButtonPanel(bl2);
            GridBagUtil.constrain(nodeDataPanel, this._buttonPanel, 0, -1, 1, 1, 1.0, 0.0, 18, 2, 9, 0, 0, 0);
        }
        return nodeDataPanel;
    }

    private void removeEditButton() {
        this._buttonPanel.remove(this._editButton);
        this._buttonPanel.remove(this._helpHorizontalSpace);
        this._buttonPanel.remove(this._helpButton);
        this._buttonPanel.add(this._okButton);
        this.setDefaultButton(this._okButton);
        this._buttonPanel.add(this._horizontalSpace);
        this._buttonPanel.add(this._cancelButton);
        this._buttonPanel.add(this._helpHorizontalSpace);
        this._buttonPanel.add(this._helpButton);
        this.validate();
        this.repaint();
    }

    private void addEditButton() {
        this._buttonPanel.remove(this._okButton);
        this._buttonPanel.remove(this._horizontalSpace);
        this._buttonPanel.remove(this._cancelButton);
        this._buttonPanel.remove(this._horizontalSpace);
        this._buttonPanel.remove(this._helpButton);
        this._buttonPanel.add(this._editButton);
        this._buttonPanel.add(this._helpHorizontalSpace);
        this._buttonPanel.add(this._helpButton);
        this.validate();
        this.repaint();
    }

    public void setDefaultButton(JButton jButton) {
        this.getRootPane().setDefaultButton(jButton);
    }

    protected void helpInvoked() {
        if (this.helpProduct == null || this.helpTopic == null) {
            throw new IllegalStateException("Help product or token not set.");
        }
        URL uRL = this.getHelpAdminURL();
        if (uRL == null) {
            Help.showContextHelp(this.helpProduct, this.helpTopic);
        } else {
            Help.showContextHelp(this.helpProduct, this.helpTopic, uRL);
        }
    }

    private URL getHelpAdminURL() {
        URL uRL = null;
        Container container = this.getParent();
        while (!(container instanceof Framework) && container != null) {
            container = container.getParent();
        }
        if (container != null && container instanceof Framework) {
            uRL = ((Framework)container).getHelpAdminURL();
        }
        return uRL;
    }

    class FocusTransferer
    implements FocusListener {
        FocusTransferer() {
        }

        public void focusGained(FocusEvent focusEvent) {
            Object object = focusEvent.getSource();
            if (object instanceof Component) {
                ((Component)object).transferFocus();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    class OpenButtonActionListener
    implements ActionListener {
        OpenButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NodeDataPanel.this._nodeInfo.actionNodeDataChanged(new NodeData(ID_OPEN, null));
        }
    }

    class ChangeKeyListener
    extends KeyAdapter {
        ChangeKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                NodeDataPanel.this.validate();
                NodeDataPanel.this.repaint();
            }
        }
    }

    class NodeDataChangeListener
    implements ChangeListener {
        NodeDataChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object;
            NodeData nodeData = (NodeData)changeEvent.getSource();
            Object v = NodeDataPanel.this._valueTable.get(nodeData.getID());
            if (v != null && (object = nodeData.getValue()) instanceof String) {
                if (v instanceof JTextArea) {
                    ((JTextArea)v).setText((String)object);
                } else if (v instanceof JTextField && !(v instanceof JPasswordField)) {
                    ((JTextField)v).setText((String)object);
                }
            }
        }
    }

    class EditableNodeData
    extends NodeData {
        Component _component = null;
        Object _originalValue = null;

        public EditableNodeData(String string, String string2, Component component) {
            super(string, string2, null, true);
            this._component = component;
            if (this._component instanceof JTextArea) {
                JTextArea jTextArea = (JTextArea)this._component;
                jTextArea.setWrapStyleWord(true);
                jTextArea.setLineWrap(true);
                jTextArea.addKeyListener(NodeDataPanel.this._keyChangeListener);
            } else if (this._component instanceof JTextField && !(this._component instanceof JPasswordField)) {
                JTextField jTextField = (JTextField)this._component;
                jTextField.addKeyListener(NodeDataPanel.this._keyChangeListener);
            }
        }

        private void setEditable(boolean bl) {
            if (!bl) {
                if (this._component instanceof JTextArea) {
                    JTextArea jTextArea = (JTextArea)this._component;
                    jTextArea.setEditable(false);
                    jTextArea.setBackground(UIManager.getColor("Label.background"));
                    jTextArea.setSelectionColor(UIManager.getColor("control"));
                    jTextArea.removeFocusListener(NodeDataPanel.this._focusTransferer);
                    jTextArea.addFocusListener(NodeDataPanel.this._focusTransferer);
                    jTextArea.select(0, 0);
                    jTextArea.setBorder(BorderFactory.createEmptyBorder());
                    jTextArea.setMargin(new Insets(0, 0, 0, 0));
                } else if (this._component instanceof JTextField) {
                    JTextField jTextField = (JTextField)this._component;
                    jTextField.setEditable(false);
                    jTextField.setBackground(UIManager.getColor("Label.background"));
                    jTextField.removeFocusListener(NodeDataPanel.this._focusTransferer);
                    jTextField.addFocusListener(NodeDataPanel.this._focusTransferer);
                    jTextField.select(0, 0);
                    jTextField.setBorder(BorderFactory.createEmptyBorder());
                    jTextField.setMargin(new Insets(0, 0, 0, 0));
                } else if (this._component != null) {
                    this._component.setEnabled(false);
                }
            } else {
                Border border = BorderFactory.createEmptyBorder(0, 3, 0, 3);
                BevelBorder bevelBorder = new BevelBorder(1, UIManager.getColor("controlHighlight"), UIManager.getColor("control"), UIManager.getColor("controlDkShadow"), UIManager.getColor("controlShadow"));
                if (this._component instanceof JTextArea) {
                    JTextArea jTextArea = (JTextArea)this._component;
                    jTextArea.removeFocusListener(NodeDataPanel.this._focusTransferer);
                    jTextArea.setEditable(true);
                    jTextArea.setBackground(Color.white);
                    jTextArea.select(0, 0);
                    jTextArea.setBorder(BorderFactory.createCompoundBorder(bevelBorder, border));
                    this._originalValue = jTextArea.getText();
                } else if (this._component instanceof JTextField) {
                    JTextField jTextField = (JTextField)this._component;
                    jTextField.removeFocusListener(NodeDataPanel.this._focusTransferer);
                    jTextField.setEditable(true);
                    jTextField.setEnabled(true);
                    jTextField.setBackground(Color.white);
                    jTextField.select(0, 0);
                    jTextField.setBorder(BorderFactory.createCompoundBorder(bevelBorder, border));
                    this._originalValue = jTextField.getText();
                } else if (this._component instanceof JCheckBox) {
                    JCheckBox jCheckBox = (JCheckBox)this._component;
                    this._originalValue = new Boolean(jCheckBox.isSelected());
                    this._component.setEnabled(true);
                } else if (this._component != null) {
                    this._component.setEnabled(true);
                }
            }
            NodeDataPanel.this.validate();
            NodeDataPanel.this.repaint();
        }

        public Object getValue() {
            if (this._component instanceof JTextArea) {
                JTextArea jTextArea = (JTextArea)this._component;
                return jTextArea.getText();
            }
            if (this._component instanceof JTextField && !(this._component instanceof JPasswordField)) {
                JTextField jTextField = (JTextField)this._component;
                return jTextField.getText();
            }
            return this._component;
        }

        public void actionCancel() {
            if (this._component instanceof JTextArea) {
                JTextArea jTextArea = (JTextArea)this._component;
                jTextArea.setText((String)this._originalValue);
            } else if (this._component instanceof JTextField && !(this._component instanceof JPasswordField)) {
                JTextField jTextField = (JTextField)this._component;
                jTextField.setText((String)this._originalValue);
            } else if (this._component instanceof JCheckBox) {
                JCheckBox jCheckBox = (JCheckBox)this._component;
                jCheckBox.setSelected((Boolean)this._originalValue);
            }
            this.setEditable(false);
        }

        public void actionOK() {
            this.setEditable(false);
        }

        public void actionEdit() {
            this.setEditable(true);
        }
    }

    class CancelButtonListener
    implements ActionListener {
        CancelButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = 0;
            while (n < NodeDataPanel.this._editableArray.length) {
                NodeDataPanel.this._editableArray[n].actionCancel();
                ++n;
            }
            NodeDataPanel.this._scrollPane.setVerticalScrollBarPolicy(20);
            NodeDataPanel.this.addEditButton();
        }
    }

    class OKButtonListener
    implements ActionListener {
        OKButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = 0;
            while (n < NodeDataPanel.this._editableArray.length) {
                NodeDataPanel.this._editableArray[n].actionOK();
                NodeDataPanel.this._nodeInfo.actionNodeDataChanged(NodeDataPanel.this._editableArray[n]);
                ++n;
            }
            NodeDataPanel.this._scrollPane.setVerticalScrollBarPolicy(20);
            NodeDataPanel.this.addEditButton();
        }
    }

    class EditButtonListener
    implements ActionListener {
        EditButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = 0;
            while (n < NodeDataPanel.this._editableArray.length) {
                NodeDataPanel.this._editableArray[n].actionEdit();
                ++n;
            }
            NodeDataPanel.this._scrollPane.setVerticalScrollBarPolicy(21);
            NodeDataPanel.this.removeEditButton();
        }
    }

    class HorizontalButtonPanel
    extends Box {
        HorizontalButtonPanel(boolean bl) {
            super(0);
            Vector<JButton> vector = new Vector<JButton>();
            this.add(Box.createHorizontalGlue());
            NodeDataPanel.this._editButton = JButtonFactory.create(_resource.getString("General", "Edit"), new EditButtonListener(), "EDIT");
            NodeDataPanel.this._editButton.setToolTipText(_resource.getString("General", "Edit_tt"));
            if (bl) {
                this.add(NodeDataPanel.this._editButton);
                vector.addElement(NodeDataPanel.this._editButton);
            }
            NodeDataPanel.this._okButton = JButtonFactory.createOKButton(new OKButtonListener());
            NodeDataPanel.this._okButton.setToolTipText(_resource.getString("General", "OK_tt"));
            vector.addElement(NodeDataPanel.this._okButton);
            NodeDataPanel.this._cancelButton = JButtonFactory.createCancelButton(new CancelButtonListener());
            NodeDataPanel.this._cancelButton.setToolTipText(_resource.getString("General", "Cancel_tt"));
            vector.addElement(NodeDataPanel.this._cancelButton);
            this.add(NodeDataPanel.this._helpHorizontalSpace);
            NodeDataPanel.this._helpButton = JButtonFactory.createHelpButton(new ActionListener(this){
                private final /* synthetic */ HorizontalButtonPanel this$1;
                {
                    this.this$1 = horizontalButtonPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    HorizontalButtonPanel.access$800(this.this$1).helpInvoked();
                }
            });
            this.add(NodeDataPanel.this._helpButton);
            vector.addElement(NodeDataPanel.this._helpButton);
            Object[] objectArray = new JButton[vector.size()];
            vector.copyInto(objectArray);
            if (objectArray != null) {
                JButtonFactory.resize((JButton[])objectArray);
            }
        }

        static /* synthetic */ NodeDataPanel access$800(HorizontalButtonPanel horizontalButtonPanel) {
            return horizontalButtonPanel.NodeDataPanel.this;
        }
    }

    class ScrollPaneComponentListener
    extends ComponentAdapter {
        ScrollPaneComponentListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            NodeDataPanel.this.validate();
            NodeDataPanel.this.repaint();
        }
    }
}

