/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.ug;

import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.ug.GroupLanguageFactory;
import com.netscape.management.client.ug.ILanguageFactory;
import com.netscape.management.client.ug.ILocalize;
import com.netscape.management.client.ug.IResourceEditorPage;
import com.netscape.management.client.ug.LanguageModel;
import com.netscape.management.client.ug.OULanguageFactory;
import com.netscape.management.client.ug.PickerEditorResourceSet;
import com.netscape.management.client.ug.ResourceEditor;
import com.netscape.management.client.ug.ResourcePageObservable;
import com.netscape.management.client.ug.UserLanguageFactory;
import com.netscape.management.client.util.GridBagUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LanguagePage
extends JPanel
implements IResourceEditorPage,
Observer,
ListSelectionListener {
    static Vector _vUserSection = null;
    static Vector _vGroupSection = null;
    static Vector _vOUSection = null;
    private static Font fNormal = null;
    private static Font fBold = null;
    Vector _vMapping = null;
    PickerEditorResourceSet _resource = new PickerEditorResourceSet();
    LanguageModel _dataModel;
    Hashtable _hPages;
    Hashtable _languageTags;
    IResourceEditorPage _CurrentPage = null;
    static final int _USER = 1;
    static final int _GROUP = 2;
    static final int _OU = 3;
    ILanguageFactory _languageFactory;
    private int _objectType = 1;
    private String ID;
    private JPanel _containerPane;
    private JList _listLanguage;
    private int _oldSelection = 0;
    private JComboBox _preferredLangCombo;
    ResourceEditor _parent;
    ResourcePageObservable _observable;

    public LanguagePage() {
        super(true);
        this.setLayout(new GridBagLayout());
        this._hPages = new Hashtable();
        this._languageTags = new Hashtable();
        this.ID = this._resource.getString("languageTab", "ID");
    }

    public void update(Observable observable, Object object) {
        this._observable = (ResourcePageObservable)observable;
        Enumeration enumeration = this._hPages.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            IResourceEditorPage iResourceEditorPage = (IResourceEditorPage)this._hPages.get(string);
            if (iResourceEditorPage == null || !(iResourceEditorPage instanceof Observer)) continue;
            Observer observer = (Observer)((Object)iResourceEditorPage);
            observer.update(observable, object);
        }
    }

    public void initialize(ResourcePageObservable resourcePageObservable, ResourceEditor resourceEditor) {
        this._parent = resourceEditor;
        this._observable = resourcePageObservable;
        Vector vector = resourcePageObservable.get("objectclass");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.equalsIgnoreCase("person")) {
                this._objectType = 1;
                this._languageFactory = new UserLanguageFactory();
                break;
            }
            if (string.equalsIgnoreCase("groupofuniquenames")) {
                this._objectType = 2;
                this._languageFactory = new GroupLanguageFactory();
                break;
            }
            if (!string.equalsIgnoreCase("organizationalunit")) continue;
            this._objectType = 3;
            this._languageFactory = new OULanguageFactory();
            break;
        }
        this._dataModel = new LanguageModel();
        if (this._vMapping == null) {
            this.initMapping(resourceEditor.getConsoleInfo());
        }
        if (this._objectType == 1) {
            this._dataModel.setData(this._vMapping, this._languageTags, resourcePageObservable.get("PreferredLanguage"));
        } else {
            this._dataModel.setData(this._vMapping, null, null);
        }
        this.setupUI();
        this._listLanguage.setSelectedIndex(0);
    }

    private void setupUI() {
        this.removeAll();
        JLabel jLabel = new JLabel(this._resource.getString("languageTab", "label"));
        GridBagUtil.constrain(this, jLabel, 0, 0, 0, 1, 1.0, 0.0, 18, 2, 9, 9, 0, 9);
        this._listLanguage = new JList(this._dataModel);
        this._listLanguage.getSelectionModel().addListSelectionListener(this);
        this._listLanguage.getSelectionModel().setSelectionMode(0);
        int n = 1;
        if (this._objectType == 1) {
            jLabel = new JLabel(this._resource.getString("languageTab", "pref"));
            GridBagUtil.constrain(this, jLabel, 0, n++, 1, 1, 0.0, 0.0, 18, 2, 9, 9, 0, 0);
            this._preferredLangCombo = new JComboBox(this._dataModel);
            jLabel.setLabelFor(this._preferredLangCombo);
            GridBagUtil.constrain(this, this._preferredLangCombo, 0, n++, 1, 1, 0.0, 0.0, 18, 2, 9, 9, 0, 0);
        }
        jLabel = new JLabel(this._resource.getString("languageTab", "availLang"));
        jLabel.setLabelFor(this._listLanguage);
        GridBagUtil.constrain(this, jLabel, 0, n++, 1, 1, 0.0, 0.0, 18, 2, 9, 9, 0, 0);
        LangListCellRender langListCellRender = new LangListCellRender();
        this._listLanguage.setCellRenderer(langListCellRender);
        JScrollPane jScrollPane = new JScrollPane(this._listLanguage);
        jScrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
        GridBagUtil.constrain(this, jScrollPane, 0, n, 1, 0, 0.0, 1.0, 10, 1, 12, 9, 9, 0);
        this._containerPane = new JPanel();
        this._containerPane.setBorder(new TitledBorder(new EtchedBorder(), this._resource.getString("languageTab", "info")));
        this._containerPane.setSize(450, 400);
        this._containerPane.setLayout(new BorderLayout());
        GridBagUtil.constrain(this, this._containerPane, 1, 1, 0, 0, 1.0, 1.0, 10, 1, 6, 12, 9, 9);
    }

    private void selectPanel(String string) {
        this._containerPane.removeAll();
        Component component = (Component)this._hPages.get(string);
        if (component == null) {
            IResourceEditorPage iResourceEditorPage = this._languageFactory.getPage((String)this._languageTags.get(string));
            iResourceEditorPage.initialize(this._observable, this._parent);
            this._hPages.put(string, iResourceEditorPage);
            component = (Component)((Object)iResourceEditorPage);
        }
        this._containerPane.add("Center", component);
        this._CurrentPage = (IResourceEditorPage)((Object)component);
        this.validate();
        this.repaint();
    }

    private void removePanel() {
        this._containerPane.removeAll();
        this._CurrentPage = null;
        this.validate();
        this.repaint();
    }

    public String getID() {
        return this.ID;
    }

    public boolean afterSave(ResourcePageObservable resourcePageObservable) throws Exception {
        Enumeration enumeration = this._hPages.keys();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            IResourceEditorPage iResourceEditorPage = (IResourceEditorPage)this._hPages.get(string);
            if (iResourceEditorPage == null) continue;
            bl &= iResourceEditorPage.afterSave(resourcePageObservable);
        }
        return bl;
    }

    public boolean save(ResourcePageObservable resourcePageObservable) throws Exception {
        String string;
        Enumeration enumeration = this._hPages.keys();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            IResourceEditorPage iResourceEditorPage = (IResourceEditorPage)this._hPages.get(string);
            if (iResourceEditorPage == null) continue;
            bl &= iResourceEditorPage.save(resourcePageObservable);
        }
        if (this._objectType == 1) {
            string = null;
            if (this._dataModel.getSelectedItem() != null) {
                string = (String)this._languageTags.get(this._dataModel.getSelectedItem());
            }
            if (string == null) {
                resourcePageObservable.delete("preferredlanguage");
            } else {
                resourcePageObservable.replace("preferredlanguage", string);
            }
        }
        return bl;
    }

    public void clear() {
        Enumeration enumeration = this._hPages.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            IResourceEditorPage iResourceEditorPage = (IResourceEditorPage)this._hPages.get(string);
            if (iResourceEditorPage == null) continue;
            iResourceEditorPage.clear();
        }
    }

    public void reset() {
        Enumeration enumeration = this._hPages.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            IResourceEditorPage iResourceEditorPage = (IResourceEditorPage)this._hPages.get(string);
            if (iResourceEditorPage == null) continue;
            iResourceEditorPage.reset();
        }
    }

    public void setDefault() {
        Enumeration enumeration = this._hPages.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            IResourceEditorPage iResourceEditorPage = (IResourceEditorPage)this._hPages.get(string);
            if (iResourceEditorPage == null) continue;
            iResourceEditorPage.setDefault();
        }
    }

    public boolean isModified() {
        boolean bl = true;
        Enumeration enumeration = this._hPages.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            IResourceEditorPage iResourceEditorPage = (IResourceEditorPage)this._hPages.get(string);
            if (iResourceEditorPage == null) continue;
            bl &= iResourceEditorPage.isModified();
        }
        return bl;
    }

    public void setModified(boolean bl) {
        Enumeration enumeration = this._hPages.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            IResourceEditorPage iResourceEditorPage = (IResourceEditorPage)this._hPages.get(string);
            if (iResourceEditorPage == null) continue;
            iResourceEditorPage.setModified(bl);
        }
    }

    public boolean isReadOnly() {
        boolean bl = true;
        Enumeration enumeration = this._hPages.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            IResourceEditorPage iResourceEditorPage = (IResourceEditorPage)this._hPages.get(string);
            if (iResourceEditorPage == null) continue;
            bl &= iResourceEditorPage.isReadOnly();
        }
        return bl;
    }

    public void setReadOnly(boolean bl) {
        Enumeration enumeration = this._hPages.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            IResourceEditorPage iResourceEditorPage = (IResourceEditorPage)this._hPages.get(string);
            if (iResourceEditorPage == null) continue;
            iResourceEditorPage.setReadOnly(bl);
        }
    }

    public void setEnable(boolean bl) {
        Enumeration enumeration = this._hPages.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            IResourceEditorPage iResourceEditorPage = (IResourceEditorPage)this._hPages.get(string);
            if (iResourceEditorPage == null) continue;
            iResourceEditorPage.setEnable(bl);
        }
    }

    public boolean isComplete() {
        boolean bl = true;
        Enumeration enumeration = this._hPages.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            IResourceEditorPage iResourceEditorPage = (IResourceEditorPage)this._hPages.get(string);
            if (iResourceEditorPage == null) continue;
            bl &= iResourceEditorPage.isComplete();
        }
        return bl;
    }

    public String getDisplayName() {
        return this.ID;
    }

    private Vector getSectionPlugin(String string) {
        int n = Integer.parseInt(this._resource.getString(string, "pluginCount"));
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        while (n2 < n) {
            String string2 = this._resource.getString(string, "plugin" + n2);
            vector.addElement(string2);
            ++n2;
        }
        return vector;
    }

    Vector getLocalizeList() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this._observable.getAttributesList();
        while (enumeration.hasMoreElements()) {
            String string;
            int n;
            String string2;
            String string3 = (String)enumeration.nextElement();
            int n2 = string3.lastIndexOf(";lang-");
            if (n2 < 0 || vector.contains(string2 = (n = (string = string3.substring(n2 + 6)).indexOf(59)) >= 0 ? string.substring(0, n).toLowerCase() : string.toLowerCase())) continue;
            vector.addElement(string2);
        }
        return vector;
    }

    void initMapping(ConsoleInfo consoleInfo) {
        this._vMapping = new Vector();
        Vector vector = null;
        switch (this._objectType) {
            case 1: {
                if (_vUserSection == null) {
                    _vUserSection = this.getSectionPlugin("userPage");
                }
                vector = _vUserSection;
                break;
            }
            case 2: {
                if (_vGroupSection == null) {
                    _vGroupSection = this.getSectionPlugin("GroupPage");
                }
                vector = _vGroupSection;
                break;
            }
            case 3: {
                if (_vOUSection == null) {
                    _vOUSection = this.getSectionPlugin("OUPage");
                }
                vector = _vOUSection;
            }
        }
        Vector vector2 = this.getLocalizeList();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            IResourceEditorPage iResourceEditorPage;
            String string = (String)enumeration.nextElement();
            String string2 = this._resource.getString("userPage", string);
            this._languageTags.put(string2, string);
            this._vMapping.addElement(string2);
            if (!vector2.contains(string.toLowerCase()) || !((iResourceEditorPage = this._languageFactory.getPage(string)) instanceof ILocalize)) continue;
            ((ILocalize)((Object)iResourceEditorPage)).setLocalize(true);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this._oldSelection = this._listLanguage.getSelectedIndex();
        if (this._oldSelection >= 0) {
            String string = (String)this._vMapping.elementAt(this._oldSelection);
            this.selectPanel(string);
        } else {
            this.removePanel();
        }
    }

    public void help() {
        if (this._CurrentPage != null) {
            this._CurrentPage.help();
        }
    }

    class LangListCellRender
    extends JLabel
    implements ListCellRenderer {
        LangListCellRender() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object != null) {
                Object object2;
                if (fNormal == null || fBold == null) {
                    object2 = this.getFont();
                    fNormal = ((Font)object2).deriveFont(0);
                    fBold = ((Font)object2).deriveFont(1);
                }
                if (object instanceof String) {
                    object2 = (IResourceEditorPage)LanguagePage.this._hPages.get(object);
                    if (object2 == null) {
                        object2 = LanguagePage.this._languageFactory.getPage((String)LanguagePage.this._languageTags.get(object));
                    }
                    if (object2 instanceof ILocalize) {
                        this.setFont(((ILocalize)object2).isLocalize() ? fBold : fNormal);
                    }
                }
                this.setText((String)object);
                this.setBackground(bl ? UIManager.getColor("List.selectionBackground") : UIManager.getColor("List.background"));
                this.setForeground(bl ? UIManager.getColor("List.selectionForeground") : UIManager.getColor("List.foreground"));
            }
            return this;
        }
    }
}

