/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.panel;

import com.netscape.management.admserv.config.GBC;
import com.netscape.management.admserv.config.ValidationException;
import com.netscape.management.admserv.panel.CGISNMPSetup;
import com.netscape.management.admserv.panel.CommunityEditPanel;
import com.netscape.management.admserv.panel.EditableList;
import com.netscape.management.admserv.panel.SNMPCommunityPanel;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class CommunityList
extends EditableList {
    CommunityEditPanel _editPanel;
    JPanel _detailsPanel;
    JLabel _lblDetailsName;
    JLabel _lblDetailsOperation;
    Vector _communities;
    String _cmdSet = "SET";
    String _cmdGet = "GET";
    String _cmdAll = "ALL";
    static String _i18nEditCommunity = EditableList._resource.getString("snmpcom", "EditCommunityToolTip");
    static String _i18nAddCommunity = EditableList._resource.getString("snmpcom", "AddCommunityToolTip");
    static String _i18nRemoveCommunity = EditableList._resource.getString("snmpcom", "RemoveCommunityToolTip");

    public CommunityList(Vector vector) {
        this.setCommunities(vector);
    }

    public void setCommunities(Vector vector) {
        this._communities = vector;
        this.setList(this.getCommunityNames(this._communities));
    }

    Vector getCommunityNames(Vector vector) {
        Vector vector2 = new Vector(vector.size());
        int n = 0;
        while (n < vector.size()) {
            Hashtable hashtable = (Hashtable)vector.elementAt(n);
            vector2.addElement(hashtable.get("community"));
            ++n;
        }
        return vector2;
    }

    public JPanel getEditPanel() {
        this._editPanel = new CommunityEditPanel();
        JTextField[] jTextFieldArray = this._editPanel.getTextComponents();
        this.setEditPanelInitalFocusComponent(jTextFieldArray[0]);
        this.setEditPanelCommitOnEnterComponents(jTextFieldArray);
        return this._editPanel;
    }

    public String getEditTitle() {
        return SNMPCommunityPanel._i18nEditDialogTitle;
    }

    public String getAddTitle() {
        return SNMPCommunityPanel._i18nAddDialogTitle;
    }

    public String getEditToolTip() {
        return _i18nEditCommunity;
    }

    public String getAddToolTip() {
        return _i18nAddCommunity;
    }

    public String getRemoveToolTip() {
        return _i18nRemoveCommunity;
    }

    public ResourceSet getHelpResourceSet() {
        return SNMPCommunityPanel._resource;
    }

    public String getHelpToken() {
        return "editSNMPCommunityHelp";
    }

    public JPanel getDetailsPanel() {
        this._detailsPanel = this.createDetailsPanel();
        return this._detailsPanel;
    }

    public String getDetailsTitle() {
        return SNMPCommunityPanel._i18nDetailsGroupbox;
    }

    private JPanel createDetailsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GBC gBC = new GBC();
        JLabel jLabel = new JLabel(SNMPCommunityPanel._i18nDetailName, 2);
        gBC.setInsets(0, 0, 0, 0);
        gBC.setGrid(0, 0, 1, 1);
        gBC.setSpace(0.0, 0.0, 18, 1);
        jPanel.add((Component)jLabel, gBC);
        this._lblDetailsName = new JLabel(" ", 2);
        gBC.setInsets(0, 10, 0, 0);
        gBC.setGrid(1, 0, 1, 1);
        gBC.setSpace(1.0, 0.0, 18, 2);
        jPanel.add((Component)this._lblDetailsName, gBC);
        jLabel = new JLabel(SNMPCommunityPanel._i18nDetailOperations, 2);
        gBC.setInsets(10, 0, 0, 0);
        gBC.setGrid(0, 1, 1, 1);
        gBC.setSpace(0.0, 0.0, 18, 2);
        jPanel.add((Component)jLabel, gBC);
        this._lblDetailsOperation = new JLabel(" ", 2);
        gBC.setInsets(10, 10, 0, 0);
        gBC.setGrid(1, 1, 1, 1);
        gBC.setSpace(1.0, 0.0, 18, 2);
        jPanel.add((Component)this._lblDetailsOperation, gBC);
        return jPanel;
    }

    public void validateEdit() throws ValidationException {
        String string = this._editPanel.getCommunity();
        if (string.length() == 0) {
            throw new ValidationException(SNMPCommunityPanel._i18nEditDialogCommunity, SNMPCommunityPanel._i18nMsgEnterCommunity);
        }
    }

    public void setEditPanelParameters(String string) {
        if (string == null) {
            this._editPanel.setCommunity("");
            this._editPanel.setOperation(this._cmdAll);
        } else {
            int n = this.findCommunity(string);
            if (n >= 0) {
                Hashtable hashtable = (Hashtable)this._communities.elementAt(n);
                this._editPanel.setCommunity(string);
                this._editPanel.setOperation((String)hashtable.get("operation"));
            } else {
                Debug.println((String)("ERROR: Community not found: " + string));
            }
        }
    }

    public String getEditPanelItem() {
        return this._editPanel.getCommunity();
    }

    private int findCommunity(String string) {
        return CGISNMPSetup.findEntry(this._communities, "community", string);
    }

    public void createItem(String string) {
        this._communities.addElement(CGISNMPSetup.createCommunityEntry(new String(string), new String(this._editPanel.getOperation())));
    }

    public void removeItem(String string) {
        int n = this.findCommunity(string);
        if (n >= 0) {
            this._communities.removeElementAt(n);
        } else {
            Debug.println((String)("ERROR: Community not found: " + string));
        }
    }

    public void updateItem(String string, boolean bl) {
        int n = this.findCommunity(string);
        if (n >= 0) {
            Hashtable hashtable = CGISNMPSetup.createCommunityEntry(new String(this._editPanel.getCommunity()), new String(this._editPanel.getOperation()));
            this._communities.setElementAt(hashtable, n);
        } else {
            Debug.println((String)("ERROR: Community not found: " + string));
        }
    }

    private void dumpData() {
        if (this._communities.size() == 0) {
            Debug.println((String)"No entries");
            return;
        }
        int n = 0;
        while (n < this._communities.size()) {
            Hashtable hashtable = (Hashtable)this._communities.elementAt(n);
            String string = (String)hashtable.get("community");
            String string2 = (String)hashtable.get("operation");
            Debug.print((String)(n + "=[" + string + " " + string2 + "] "));
            ++n;
        }
        Debug.println((String)"");
    }

    public void selectItem(String string) {
        if (string == null) {
            this._lblDetailsName.setText("");
            this._lblDetailsOperation.setText("");
            return;
        }
        int n = this.findCommunity(string);
        if (n >= 0) {
            Hashtable hashtable = (Hashtable)this._communities.elementAt(n);
            String string2 = (String)hashtable.get("community");
            String string3 = (String)hashtable.get("operation");
            this._lblDetailsName.setText(string2);
            if (string3.equals(this._cmdAll)) {
                string3 = SNMPCommunityPanel._i18nOperationsAll;
            } else if (string3.equals(this._cmdGet)) {
                string3 = SNMPCommunityPanel._i18nOperationsGET;
            } else if (string3.equals(this._cmdSet)) {
                string3 = SNMPCommunityPanel._i18nOperationsSET;
            } else {
                Debug.println((String)("ERROR: Bad perrmissions: " + string));
            }
            this._lblDetailsOperation.setText(string3);
        } else {
            Thread.currentThread();
            Thread.dumpStack();
            Debug.println((String)("ERROR: Community not found: " + string));
        }
    }
}

