/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.panel;

import com.netscape.management.admserv.config.BaseConfigPanel;
import com.netscape.management.admserv.config.ConfigPanelException;
import com.netscape.management.admserv.config.EditMonitor;
import com.netscape.management.admserv.config.FilteredInputDocument;
import com.netscape.management.admserv.config.GBC;
import com.netscape.management.admserv.config.IConfigDataModel;
import com.netscape.management.admserv.config.PluginConfigPanel;
import com.netscape.management.admserv.config.RemoteRequestException;
import com.netscape.management.admserv.config.ValidationException;
import com.netscape.management.admserv.panel.AdminConfigData;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.MultilineLabel;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.SingleByteTextField;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class DirectoryConfigPanel
extends PluginConfigPanel
implements SuiConstants {
    IConfigDataModel _configData;
    String _defaultPort = "389";
    String _defaultSSLPort = "636";
    static ResourceSet _resource = new ResourceSet("com.netscape.management.admserv.panel.panel");
    static String _i18nHost;
    static String _i18nPort;
    static String _i18nDSGroupbox;
    static String _i18nUseSSL;
    static String _i18nEnterLdapHost;
    static String _i18nEnterLdapPort;
    static String _i18nPortRange;
    static String _i18nWarnMigrate;
    static String _i18nWarnCert;
    Help _help;
    public static final int topInset = 6;
    public static final int rghtColInset = 9;
    JLabel _lblHost;
    JLabel _lblPort;
    JCheckBox _cbSSL;
    JTextField _txtPort;
    SingleByteTextField _txtHost;
    ActionListener _cbSSLListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            if (DirectoryConfigPanel.this._cbSSL.isSelected() && DirectoryConfigPanel.this._txtPort.getText().equals(DirectoryConfigPanel.this._defaultPort)) {
                DirectoryConfigPanel.this._txtPort.setText(DirectoryConfigPanel.this._defaultSSLPort);
            } else if (!DirectoryConfigPanel.this._cbSSL.isSelected() && DirectoryConfigPanel.this._txtPort.getText().equals(DirectoryConfigPanel.this._defaultSSLPort)) {
                DirectoryConfigPanel.this._txtPort.setText(DirectoryConfigPanel.this._defaultPort);
            }
        }
    };

    public DirectoryConfigPanel(String string, IConfigDataModel iConfigDataModel) {
        super(string);
        this._configData = iConfigDataModel;
        this.setLayout(new BorderLayout());
        this.add((Component)this.makeConfigPanel(), "North");
        this._help = new Help(_resource);
    }

    public void showHelp() {
        this._help.contextHelp("ldapHelp");
    }

    public IConfigDataModel getDataModel() {
        return this._configData;
    }

    public void setDataModel(IConfigDataModel iConfigDataModel) {
        this._configData = iConfigDataModel;
        if (this._configData.isLoaded()) {
            this.setPanelContent(this._configData);
        }
    }

    public void initialize() throws RemoteRequestException {
        if (!this._configData.isLoaded()) {
            this._configData.load();
        }
        this.setPanelContent(this._configData);
        this._cbSSL.addActionListener(this._cbSSLListener);
    }

    public void resetContent() {
        this.setPanelContent(this._configData);
    }

    public void applyChanges() throws ConfigPanelException {
        this.getPanelContent(this._configData);
    }

    public void registerEditComponents(EditMonitor editMonitor) {
        editMonitor.monitor(this._txtPort);
        editMonitor.monitor((JTextComponent)this._txtHost);
        editMonitor.monitor(this._cbSSL);
    }

    public void setPanelContent(IConfigDataModel iConfigDataModel) {
        this.setLDAPHost(iConfigDataModel.getAttribute("dsconfig.host"));
        this.setLDAPPort(iConfigDataModel.getAttribute("dsconfig.port"));
        this.setSSL(iConfigDataModel.getAttribute("dsconfig.ssl"));
    }

    String getSSL() {
        return this._cbSSL.isSelected() ? "true" : "false";
    }

    void setSSL(String string) {
        this._cbSSL.setSelected(string != null && string.equals("true"));
    }

    void setLDAPHost(String string) {
        this._txtHost.setText(string == null ? "" : string);
    }

    void setLDAPPort(String string) {
        this._txtPort.setText(string == null ? "" : string);
    }

    public void getPanelContent(IConfigDataModel iConfigDataModel) throws ConfigPanelException {
        String string = this._txtHost.getText().trim();
        String string2 = this._txtPort.getText().trim();
        if (string.length() == 0) {
            throw new ValidationException("", _i18nEnterLdapHost);
        }
        if (string2.length() == 0) {
            throw new ValidationException("", _i18nEnterLdapPort);
        }
        int n = -1;
        try {
            n = Integer.parseInt(string2);
            if (n < 1 || n > 65535) {
                throw new ValidationException("", _i18nPortRange);
            }
        }
        catch (Exception exception) {
            throw new ValidationException("", _i18nPortRange);
        }
        try {
            LDAPUtil.validateLDAPParams((String)string, (int)n, (boolean)this._cbSSL.isSelected(), null, null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ValidationException("", illegalArgumentException.getMessage());
        }
        iConfigDataModel.setAttribute("dsconfig.host", string);
        iConfigDataModel.setAttribute("dsconfig.port", string2);
        iConfigDataModel.setAttribute("dsconfig.ssl", this.getSSL());
        if (iConfigDataModel instanceof AdminConfigData) {
            ((AdminConfigData)iConfigDataModel).setDialogParent(this);
        }
    }

    protected JComponent makeConfigPanel() {
        JPanel jPanel = new JPanel();
        GBC gBC = new GBC();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        gBC.setGrid(0, 0, 1, 1);
        gBC.setSpace(1.0, 0.0, 17, 2);
        jPanel.add((Component)this.createServerGroup(), gBC);
        return jPanel;
    }

    private JPanel createServerGroup() {
        GBC gBC = new GBC();
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setBorder(BaseConfigPanel.createGroupBorder(_i18nDSGroupbox));
        int n = 0;
        gBC.setInsets(0, 0, 0, 0);
        gBC.setGrid(0, n, 3, 1);
        gBC.setSpace(1.0, 0.0, 17, 2);
        jPanel.add((Component)this.createInfoMessage(), gBC);
        this._lblHost = new JLabel(_i18nHost);
        gBC.setInsets(0, 0, 0, 0);
        gBC.setGrid(0, ++n, 1, 1);
        gBC.setSpace(0.0, 0.0, 13, 0);
        jPanel.add((Component)this._lblHost, gBC);
        this._txtHost = new SingleByteTextField(16);
        gBC.setInsets(0, 9, 0, 0);
        gBC.setGrid(1, n, 2, 1);
        gBC.setSpace(0.0, 0.0, 17, 2);
        jPanel.add((Component)this._txtHost, gBC);
        this._lblHost.setLabelFor((Component)this._txtHost);
        this._lblPort = new JLabel(_i18nPort);
        gBC.setInsets(6, 0, 0, 0);
        gBC.setGrid(0, ++n, 1, 1);
        gBC.setSpace(0.0, 0.0, 13, 0);
        jPanel.add((Component)this._lblPort, gBC);
        this._txtPort = new JTextField("389", 6);
        ((JTextComponent)this._txtPort).setDocument(FilteredInputDocument.allowDigitsOnly());
        gBC.setInsets(6, 9, 0, 0);
        gBC.setGrid(1, n, 1, 1);
        gBC.setSpace(0.0, 0.0, 17, 2);
        jPanel.add((Component)this._txtPort, gBC);
        this._lblPort.setLabelFor(this._txtPort);
        this._cbSSL = new JCheckBox(_i18nUseSSL, false);
        gBC.setInsets(6, 18, 0, 0);
        gBC.setGrid(2, n, 1, 1);
        gBC.setSpace(1.0, 0.0, 17, 0);
        jPanel.add((Component)this._cbSSL, gBC);
        return jPanel;
    }

    private JPanel createInfoMessage() {
        GBC gBC = new GBC();
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        int n = 0;
        JLabel jLabel = new JLabel();
        gBC.setInsets(0, 6, 0, 0);
        gBC.setGrid(1, n, 1, 1);
        gBC.setSpace(1.0, 0.0, 17, 2);
        MultilineLabel multilineLabel = new MultilineLabel(_i18nWarnMigrate, 1, 36);
        jPanel.add((Component)multilineLabel, gBC);
        multilineLabel.setFont(jLabel.getFont());
        gBC.setInsets(6, 6, 9, 0);
        gBC.setGrid(1, ++n, 1, 1);
        gBC.setSpace(1.0, 0.0, 17, 2);
        multilineLabel = new MultilineLabel(_i18nWarnCert, 1, 36);
        jPanel.add((Component)multilineLabel, gBC);
        multilineLabel.setFont(jLabel.getFont());
        ++n;
        return jPanel;
    }

    public void setPort(String string) {
        this._txtPort.setText(string != null ? string : "");
    }

    public String getPort() {
        String string = this._txtPort.getText();
        return string;
    }

    public void setHost(String string) {
        this._txtHost.setText(string != null ? string : "");
    }

    public String getHost() {
        String string = this._txtHost.getText();
        return string;
    }

    static {
        _i18nDSGroupbox = _resource.getString("ldapds", "DSGroupbox");
        _i18nHost = _resource.getString("ldapds", "DSHost");
        _i18nPort = _resource.getString("ldapds", "Port");
        _i18nUseSSL = _resource.getString("ldapds", "UseSSL");
        _i18nEnterLdapHost = _resource.getString("ldapds", "EnterLdapHost");
        _i18nEnterLdapPort = _resource.getString("ldapds", "EnterLdapPort");
        _i18nPortRange = _resource.getString("common", "PortRange");
        _i18nWarnMigrate = _resource.getString("ldapds", "WarnMigrate");
        _i18nWarnCert = _resource.getString("ldapds", "WarnCert");
    }
}

