/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.panel;

import com.netscape.management.admserv.config.ConfigPanelException;
import com.netscape.management.admserv.config.EditMonitor;
import com.netscape.management.admserv.config.IConfigDataModel;
import com.netscape.management.admserv.config.IPluginConfigPanel;
import com.netscape.management.admserv.config.ValidationException;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.security.CipherPreferenceDialog;
import com.netscape.management.client.security.ClientAuthPanel;
import com.netscape.management.client.security.EncryptionOptions;
import com.netscape.management.client.security.EncryptionPanel;
import com.netscape.management.client.security.IClientAuthOptions;
import com.netscape.management.client.util.AdmTask;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiOptionPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.net.URL;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class TurnOnSSL
implements IPluginConfigPanel,
EncryptionOptions,
IClientAuthOptions {
    static ResourceSet _resource = new ResourceSet("com.netscape.management.admserv.panel.panel");
    EditMonitor _monitor = null;
    ConsoleInfo _consoleInfo;
    JPanel encryptionPanel = null;
    Hashtable securitySettings = new Hashtable();
    EncryptionPanel _adminEncryptionPanel;
    boolean _isDirty = false;
    boolean _domestic = false;
    ClientAuthPanel _clientAuthPanel;
    static final String SSLV3 = "-rsa_null_md5,+rsa_rc4_40_md5,+rsa_rc2_40_md5,+rsa_rc4_128_md5,+rsa_des_sha,+rsa_3des_sha";
    static String _i18nMsgNoSslPreferences = _resource.getString("TurnOnSSL", "MsgNoSslPreferences");
    static String _i18nMsgNoSslFamily = _resource.getString("TurnOnSSL", "MsgNoSslFamily");
    static String _i18nMsgNoCertificate = _resource.getString("TurnOnSSL", "MsgNoCertificate");

    public void clientAuthSettingChanged(int n) {
        Debug.println((String)("TurnOnSSL:clientAuthSettingChanged:" + n));
        this.securitySettings.put("clientauth", n == 2 ? "on" : "off");
        this.setDirty(true);
    }

    public int getClientAuthSetting() {
        return this.securitySettings.get("clientauth").equals("on") ? 2 : 0;
    }

    public int[] getClientAuthUIOption() {
        int[] nArray = new int[]{0, 2};
        return nArray;
    }

    private void setDirty(boolean bl) {
        if (this._monitor != null) {
            this._monitor.setDirtyFlag(bl);
            this._isDirty = bl;
        }
    }

    void changeSecuritySetting(String string, String string2) {
        try {
            this.securitySettings.put(string, string2);
            this.setDirty(true);
            if (string.equals("security")) {
                this._clientAuthPanel.setEnabled(string2.equals("on"));
            }
        }
        catch (Exception exception) {
            Debug.println((String)"TurnOnSSL: unable to change security setting");
        }
    }

    public void securityEnabledChanged(boolean bl) {
        this.changeSecuritySetting("security", bl ? "on" : "off");
        Debug.println((String)("Security enabled:" + (bl ? "on" : "off")));
    }

    public void cipherFamilyEnabledChanged(String string, boolean bl) {
        Object v = this.securitySettings.get("familyList");
        if (v == null || v.toString().indexOf(string) == -1) {
            String string2 = v.toString();
            this.securitySettings.put("familyList", string2.length() > 0 ? string2 + "," + string : string);
        }
        this.changeSecuritySetting(string + "-activated", bl ? "on" : "off");
        Debug.println((String)("Enable cipherFamily:" + string + ":" + bl));
    }

    public void selectedDeviceChanged(String string, String string2) {
        this.changeSecuritySetting(string + "-token", string2);
        Debug.println((String)("Selected device:" + string + ":" + string2));
    }

    public void selectedCertificateChanged(String string, String string2) {
        this.changeSecuritySetting(string + "-cert", string2);
        Debug.println((String)("Selected cert" + string + ":" + string2));
    }

    public void showCipherPreferenceDialog(String string) {
        Debug.println((String)("Show cipher preference dialog:" + string));
        CipherPreferenceDialog cipherPreferenceDialog = null;
        cipherPreferenceDialog = string.toLowerCase().equals("fortezza") ? new CipherPreferenceDialog(null, "", (String)this.securitySettings.get("ssl3"), ""){

            public void cipherStateChanged(String string, String string2, boolean bl) {
                TurnOnSSL.this.setDirty(true);
            }
        } : new CipherPreferenceDialog(null, (String)this.securitySettings.get("ssl2"), (String)this.securitySettings.get("ssl3"), ""){

            public void cipherStateChanged(String string, String string2, boolean bl) {
                TurnOnSSL.this.setDirty(true);
            }
        };
        cipherPreferenceDialog.setVisible(true);
        if (!cipherPreferenceDialog.isCancel()) {
            this.securitySettings.put("ssl2", cipherPreferenceDialog.getCipherPreference("V2"));
            this.securitySettings.put("ssl3", cipherPreferenceDialog.getCipherPreference("V3"));
            this.securitySettings.put("ssl2-activated", cipherPreferenceDialog.isSSLVersionEnabled("V2") ? "on" : "off");
            this.securitySettings.put("ssl3-activated", cipherPreferenceDialog.isSSLVersionEnabled("V3") ? "on" : "off");
        }
    }

    public void setSecurityIsDomestic(boolean bl) {
        this._domestic = bl;
        Object v = this.securitySettings.get("ssl2");
        Object v2 = this.securitySettings.get("ssl2");
        CipherPreferenceDialog cipherPreferenceDialog = new CipherPreferenceDialog(null, true, true, true, bl, false);
        if (v == null || v.toString().length() == 0 || v.toString().equals("blank")) {
            this.securitySettings.put("ssl2", cipherPreferenceDialog.getCipherPreference("V2"));
        }
        if (v2 == null || v2.toString().length() == 0 || v2.toString().equals("blank")) {
            this.securitySettings.put("ssl3", SSLV3);
        }
        Object v3 = this.securitySettings.get("ssl2-activated");
        Object v4 = this.securitySettings.get("ssl3-activated");
        if (v3 == null || v3.toString().equals("blank") || v3.toString().length() == 0) {
            this.securitySettings.put("ssl2-activated", "on");
        }
        if (v4 == null || v4.toString().equals("blank") || v4.toString().length() == 0) {
            this.securitySettings.put("ssl3-activated", "on");
        }
    }

    public boolean isSecurityEnabled() {
        boolean bl = false;
        try {
            bl = this.securitySettings.get("security").equals("on");
        }
        catch (Exception exception) {
            Debug.println((String)"TurnOnSSL: no security setting");
        }
        return bl;
    }

    public boolean isCipherFamilyEnabled(String string) {
        boolean bl = false;
        try {
            bl = this.securitySettings.get(string + "-activated").equals("on");
        }
        catch (Exception exception) {
            Debug.println((String)"TurnOnSSL: no security setting");
        }
        Debug.println((String)("Cipher family enabled:" + (bl ? "true" : "false")));
        return bl;
    }

    public String getSelectedCertificate(String string) {
        String string2 = "";
        try {
            string2 = (String)this.securitySettings.get(string + "-cert");
        }
        catch (Exception exception) {
            Debug.println((String)"TurnOnSSL: no security setting");
        }
        Debug.println((String)("Get selected cert:" + string2));
        return string2;
    }

    public String getSelectedDevice(String string) {
        String string2 = "";
        try {
            string2 = (String)this.securitySettings.get(string + "-token");
        }
        catch (Exception exception) {
            Debug.println((String)"TurnOnSSL: no security setting");
        }
        Debug.println((String)("Get selected device:" + string2));
        return string2;
    }

    public TurnOnSSL(ConsoleInfo consoleInfo) {
        this._consoleInfo = consoleInfo;
        Debug.println((String)"TurnOnSSL:TurnOnSSL()");
        _resource = new ResourceSet("com.netscape.management.admserv.panel.panel");
        try {
            AdmTask admTask = new AdmTask(new URL(this._consoleInfo.getAdminURL() + "admin-serv/tasks/configuration/SSLActivate"), this._consoleInfo.getAuthenticationDN(), this._consoleInfo.getAuthenticationPassword());
            admTask.exec();
            Debug.println((String)admTask.getResultString().toString());
            StringTokenizer stringTokenizer = new StringTokenizer(admTask.getResultString().toString(), "\n", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                int n = string.indexOf("=");
                if (n == -1) continue;
                String string2 = string.substring(0, n);
                Object v = this.securitySettings.get(string2);
                String string3 = string.substring(n + 1, string.length());
                if (v == null) {
                    this.securitySettings.put(string2, string3.toLowerCase().equals("null") ? "" : string3);
                    continue;
                }
                if (string3.toString().toLowerCase().equals("null")) continue;
                this.securitySettings.put(string2, v + "," + string3);
            }
        }
        catch (Exception exception) {
            Debug.println((String)exception.toString());
        }
        if (this.securitySettings.get("clientauth") == null || this.securitySettings.get("clientauth").toString().equals("")) {
            this.securitySettings.put("clientauth", "off");
        }
    }

    public String getTitleText() {
        return "";
    }

    public JPanel getPanel() {
        Debug.println((String)"TurnOnSSL:getPanel()");
        if (this.encryptionPanel == null) {
            this.encryptionPanel = new JPanel();
            this.encryptionPanel.setLayout(new GridBagLayout());
            this._adminEncryptionPanel = new EncryptionPanel(this._consoleInfo, (String)this._consoleInfo.get("SIE"), (EncryptionOptions)this);
            this.hackToSelectCertificate();
            GridBagUtil.constrain((Container)this.encryptionPanel, (Component)this._adminEncryptionPanel, (int)0, (int)0, (int)1, (int)1, (double)1.0, (double)0.0, (int)18, (int)2, (int)0, (int)0, (int)0, (int)0);
            this._clientAuthPanel = new ClientAuthPanel((IClientAuthOptions)this);
            this._clientAuthPanel.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(6, 6, 6, 6)));
            GridBagUtil.constrain((Container)this.encryptionPanel, (Component)this._clientAuthPanel, (int)0, (int)1, (int)1, (int)1, (double)1.0, (double)0.0, (int)18, (int)2, (int)6, (int)0, (int)0, (int)0);
            GridBagUtil.constrain((Container)this.encryptionPanel, (Component)Box.createVerticalGlue(), (int)0, (int)1, (int)1, (int)1, (double)1.0, (double)1.0, (int)17, (int)3, (int)0, (int)0, (int)0, (int)0);
            Object v = this.securitySettings.get("security");
            this._clientAuthPanel.setEnabled(v == null ? false : v.toString().equals("on"));
            this.setDirty(false);
        }
        return this.encryptionPanel;
    }

    public IConfigDataModel getDataModel() {
        return null;
    }

    public void setDataModel(IConfigDataModel iConfigDataModel) throws ConfigPanelException {
    }

    public void initialize() throws ConfigPanelException {
    }

    public void registerEditComponents(EditMonitor editMonitor) {
        this._monitor = editMonitor;
    }

    public void resetContent() throws ConfigPanelException {
        this._adminEncryptionPanel.reset();
        this._clientAuthPanel.reset();
        Object v = this.securitySettings.get("security");
        this._clientAuthPanel.setEnabled(v == null ? false : v.toString().equals("on"));
    }

    public void applyChanges() throws ValidationException {
        if (this._isDirty) {
            try {
                if (this.validEntries()) {
                    String string = this._consoleInfo.getAdminURL() + "admin-serv/tasks/configuration/SSLActivate";
                    AdmTask admTask = new AdmTask(new URL(string), this._consoleInfo.getAuthenticationDN(), this._consoleInfo.getAuthenticationPassword());
                    this.securitySettings.put("trustdb", (String)this._consoleInfo.get("SIE"));
                    Debug.printHashtable((String)"Security Setting", (Hashtable)this.securitySettings);
                    admTask.setArguments(this.securitySettings);
                    admTask.exec();
                    Debug.println((String)admTask.getResultString().toString());
                    StringTokenizer stringTokenizer = new StringTokenizer(admTask.getResultString().toString(), "\n", false);
                    if (admTask.getResult().get("NMC_Description") != null) {
                        this._adminEncryptionPanel.setSaved();
                        this._clientAuthPanel.setSaved();
                        SuiOptionPane.showMessageDialog((Component)new JFrame(), admTask.getResult().get("NMC_Description"));
                    } else if (admTask.getResult().get("NMC_ErrType") != null) {
                        SuiOptionPane.showMessageDialog((Component)new JFrame(), (Object)(admTask.getResult().get("NMC_ErrType") + "\n\n" + admTask.getResult().get("NMC_ErrInfo") + (admTask.getResult().get("NMC_ErrDetail") != null ? "\n" + admTask.getResult().get("NMC_ErrDetail") : "")));
                    }
                    this.setDirty(false);
                }
            }
            catch (ValidationException validationException) {
                throw validationException;
            }
            catch (Exception exception) {
                Debug.println((String)("TurnOnSSL.applyChanges: ERROR - " + exception.toString()));
            }
        }
    }

    private boolean validEntries() throws ValidationException {
        Object var1_1 = null;
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (this.securitySettings.get("security").equals("on")) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)this.securitySettings.get("familyList"), ",");
            if (stringTokenizer.countTokens() != 0) {
                while (stringTokenizer.hasMoreTokens()) {
                    try {
                        String string = stringTokenizer.nextToken();
                        String string2 = (String)this.securitySettings.get(string + "-activated");
                        if (string2 == null || !string2.equals("on")) continue;
                        ++n;
                        string2 = (String)this.securitySettings.get(string + "-token");
                        if (string2 == null) {
                            ++n2;
                        }
                        if ((string2 = (String)this.securitySettings.get(string + "-cert")) != null) continue;
                        ++n3;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        Debug.println((String)"TurnOnSSL.validateEntries: Unable to read family cipher token");
                    }
                }
            } else {
                Debug.println((String)"TurnOnSSL.validateEntries: no family ciphers");
            }
            if (n == 0) {
                bl = false;
                throw new ValidationException("", _i18nMsgNoSslFamily);
            }
            if (n2 >= 1) {
                bl = false;
                throw new ValidationException("", _i18nMsgNoSslPreferences);
            }
            if (n3 >= 1) {
                bl = false;
                throw new ValidationException("", _i18nMsgNoCertificate);
            }
        } else {
            Debug.println((int)6, (String)"TurnOnSSL.validateEntries: SSL is off");
        }
        return bl;
    }

    public void showHelp() {
        Help help = new Help(_resource);
        help.contextHelp("TurnOnSSL", "help");
    }

    private void hackToSelectCertificate() {
        try {
            Component[] componentArray = this._adminEncryptionPanel.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] instanceof JPanel) {
                    this.hackPane((JPanel)componentArray[n]);
                }
                ++n;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void hackPane(JPanel jPanel) {
        Component[] componentArray = jPanel.getComponents();
        JComboBox[] jComboBoxArray = new JComboBox[2];
        this.getComboBoxes(componentArray, jComboBoxArray);
        if (!jComboBoxArray[0].isEnabled() && jComboBoxArray[1].getItemCount() == 0) {
            jComboBoxArray[0].setSelectedItem(jComboBoxArray[0].getSelectedItem());
            if (jComboBoxArray[1].getSelectedItem() != null) {
                jComboBoxArray[1].setSelectedItem(jComboBoxArray[1].getSelectedItem());
            }
        }
    }

    private void getComboBoxes(Component[] componentArray, JComboBox[] jComboBoxArray) {
        int n = 0;
        while (n < componentArray.length && (jComboBoxArray[0] == null || jComboBoxArray[1] == null)) {
            if (componentArray[n] instanceof JComboBox) {
                if (jComboBoxArray[0] == null) {
                    jComboBoxArray[0] = (JComboBox)componentArray[n];
                } else {
                    jComboBoxArray[1] = (JComboBox)componentArray[n];
                }
            } else if (componentArray[n] instanceof Container) {
                this.getComboBoxes(((Container)componentArray[n]).getComponents(), jComboBoxArray);
            }
            ++n;
        }
    }
}

