/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.nmclf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class SuiTableHeaderBorder
extends AbstractBorder {
    public static final int RAISED = 0;
    public static final int LOWERED = 1;
    protected int bevelType;
    protected Color highlightOuter;
    protected Color highlightInner;
    protected Color shadowInner;
    protected Color shadowOuter;

    public SuiTableHeaderBorder(int n) {
        this.bevelType = n;
    }

    public SuiTableHeaderBorder(int n, Color color, Color color2) {
        this(n, color.darker(), color, color2, color2.brighter());
    }

    public SuiTableHeaderBorder(int n, Color color, Color color2, Color color3, Color color4) {
        this(n);
        this.highlightOuter = color;
        this.highlightInner = color2;
        this.shadowOuter = color3;
        this.shadowInner = color4;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.bevelType == 0) {
            this.paintRaisedBevel(component, graphics, n, n2, n3, n4);
        } else if (this.bevelType == 1) {
            this.paintLoweredBevel(component, graphics, n, n2, n3, n4);
        }
    }

    public Insets getBorderInsets(Component component) {
        return new Insets(0, 5, 1, 3);
    }

    public Color getHighlightOuterColor(Component component) {
        return this.highlightOuter != null ? this.highlightOuter : component.getBackground().brighter().brighter();
    }

    public Color getHighlightInnerColor(Component component) {
        return this.highlightInner != null ? this.highlightInner : component.getBackground().brighter();
    }

    public Color getShadowInnerColor(Component component) {
        return this.shadowInner != null ? this.shadowInner : component.getBackground().darker();
    }

    public Color getShadowOuterColor(Component component) {
        return this.shadowOuter != null ? this.shadowOuter : component.getBackground().darker().darker();
    }

    public int getBevelType() {
        return this.bevelType;
    }

    public boolean isBorderOpaque() {
        return true;
    }

    protected void paintRaisedBevel(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        int n5 = n4;
        int n6 = n3;
        graphics.translate(n, n2);
        graphics.setColor(this.getHighlightOuterColor(component));
        graphics.drawLine(n6 - 1, 0, n6 - 1, n5 - 1);
        graphics.setColor(this.getShadowInnerColor(component));
        graphics.drawLine(n6 - 2, 0, n6 - 2, n5 - 1);
        graphics.drawLine(0, n5 - 1, n6 - 2, n5 - 1);
        graphics.translate(-n, -n2);
        graphics.setColor(color);
    }

    protected void paintLoweredBevel(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        int n5 = n4;
        int n6 = n3;
        graphics.translate(n, n2);
        graphics.setColor(this.getHighlightOuterColor(component));
        graphics.drawLine(n6 - 1, 0, n6 - 1, n5 - 1);
        graphics.setColor(this.getShadowInnerColor(component));
        graphics.drawLine(n6, 0, n6, n5);
        graphics.drawLine(0, n5, n6, n5);
        graphics.translate(-n, -n2);
        graphics.setColor(color);
    }
}

