/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client;

import com.netscape.management.client.AboutDialog;
import com.netscape.management.client.IFrameworkInitializer;
import com.netscape.management.client.IPage;
import com.netscape.management.client.UIPermissions;
import com.netscape.management.client.UIPermissionsPreferencesTab;
import com.netscape.management.client.console.VersionInfo;
import com.netscape.management.client.preferences.IPreferencesTab;
import com.netscape.management.client.util.About;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UtilConsoleGlobals;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Image;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JFrame;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;

public abstract class FrameworkInitializer
implements IFrameworkInitializer {
    ResourceSet _resource = new ResourceSet("com.netscape.management.client.topology.topology");
    protected Vector pageList = new Vector();
    protected Vector tabList = new Vector();
    protected String frameTitle = null;
    protected Image minimizedImage = null;
    protected Image bannerImage = null;
    protected String bannerText = null;
    protected About about = null;
    protected AboutDialog aboutDialog = null;
    private UIPermissions uiPermissions = null;

    public void addPage(IPage iPage) {
        this.pageList.addElement(iPage);
    }

    public void removePage(IPage iPage) {
        this.pageList.removeElement(iPage);
    }

    public int getPageCount() {
        return this.pageList.size();
    }

    public IPage getPageAt(int n) {
        IPage iPage = (IPage)this.pageList.elementAt(n);
        return iPage;
    }

    public String getFrameTitle() {
        return this.frameTitle;
    }

    public Image getMinimizedImage() {
        return this.minimizedImage;
    }

    public void setFrameTitle(String string) {
        this.frameTitle = string;
    }

    public void setFrameTitle(LDAPConnection lDAPConnection, String string) {
        if (lDAPConnection == null || !lDAPConnection.isConnected()) {
            return;
        }
        try {
            LDAPEntry lDAPEntry = lDAPConnection.read(string);
            String string2 = LDAPUtil.getLDAPAttributeLocale();
            LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("serverproductname", string2);
            if (lDAPAttribute == null) {
                lDAPAttribute = lDAPEntry.getAttribute("cn", string2);
                if (lDAPAttribute != null) {
                    this.frameTitle = LDAPUtil.flatting((LDAPAttribute)lDAPAttribute);
                }
            } else {
                this.frameTitle = LDAPUtil.flatting((LDAPAttribute)lDAPAttribute);
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((int)0, (String)("FrameworkInitializer.setFrameTitle: " + (Object)((Object)lDAPException)));
        }
    }

    public void setMinimizedImage(Image image) {
        this.minimizedImage = image;
    }

    public void setBannerImage(Image image) {
        this.bannerImage = image;
    }

    public Image getBannerImage() {
        return this.bannerImage;
    }

    public void setBannerText(String string) {
        this.bannerText = string;
    }

    public void setBannerText(LDAPConnection lDAPConnection, String string) {
        if (lDAPConnection == null || !lDAPConnection.isConnected()) {
            return;
        }
        try {
            LDAPEntry lDAPEntry = lDAPConnection.read(string);
            String string2 = LDAPUtil.getLDAPAttributeLocale();
            LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("serverproductname", string2);
            if (lDAPAttribute == null) {
                lDAPAttribute = lDAPEntry.getAttribute("cn", string2);
                if (lDAPAttribute != null) {
                    this.bannerText = LDAPUtil.flatting((LDAPAttribute)lDAPAttribute);
                }
            } else {
                this.bannerText = LDAPUtil.flatting((LDAPAttribute)lDAPAttribute);
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((int)0, (String)("FrameworkInitializer.setFrameTitle: " + (Object)((Object)lDAPException)));
        }
    }

    public String getBannerText() {
        if (this.bannerText == null) {
            return this.frameTitle;
        }
        return this.bannerText;
    }

    public void setUIPermissions(UIPermissions uIPermissions) {
        this.uiPermissions = uIPermissions;
        this.addPreferencesTab((IPreferencesTab)new UIPermissionsPreferencesTab());
    }

    public UIPermissions getUIPermissions() {
        return this.uiPermissions;
    }

    public void addPreferencesTab(IPreferencesTab iPreferencesTab) {
        this.tabList.addElement(iPreferencesTab);
    }

    public void removePreferencesTab(IPreferencesTab iPreferencesTab) {
        this.tabList.removeElement(iPreferencesTab);
    }

    public IPreferencesTab getPreferencesTab(int n) {
        return (IPreferencesTab)this.tabList.elementAt(n);
    }

    public int getPreferencesTabCount() {
        return this.tabList.size();
    }

    public ResourceSet getAboutDialogResourceBoundle() {
        return null;
    }

    public void aboutInvoked(JFrame jFrame) {
        try {
            UtilConsoleGlobals.getActivatedFrame().setCursor(new Cursor(3));
            if (this.aboutDialog == null) {
                ResourceSet resourceSet = new ResourceSet("com.netscape.management.client.defaultLicense");
                this.aboutDialog = new AboutDialog((Frame)jFrame, resourceSet.getString("defaultAbout", "dialogTitle"), true);
                RemoteImage remoteImage = new RemoteImage(resourceSet.getString("defaultAbout", "productLogo"));
                remoteImage.setDescription(resourceSet.getString("defaultAbout", "productLogo-description"));
                String[] stringArray = new String[]{VersionInfo.getVersionNumber(), VersionInfo.getBuildNumber()};
                String string = resourceSet.getString("defaultAbout", "productInfo", stringArray);
                this.aboutDialog.setProduct((Icon)remoteImage, string, resourceSet.getString("defaultAbout", "productCopyright"), resourceSet.getString("defaultAbout", "productLicense"));
                StringTokenizer stringTokenizer = new StringTokenizer(resourceSet.getString("defaultAbout", "vendorsList"), ",", false);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    RemoteImage remoteImage2 = null;
                    try {
                        remoteImage2 = new RemoteImage(resourceSet.getString("defaultAbout", "vendor-" + string2 + "-logo"));
                        remoteImage2.setDescription(resourceSet.getString("defaultAbout", "vendor-" + string2 + "-logo-description"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.aboutDialog.addVendor((Icon)remoteImage2, resourceSet.getString("defaultAbout", "vendor-" + string2 + "-license"));
                }
            }
            this.aboutDialog.show();
            UtilConsoleGlobals.getActivatedFrame().setCursor(new Cursor(0));
        }
        catch (Exception exception) {
            Debug.println((String)("FrameworkInitializer:" + exception));
        }
    }
}

