/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.panel;

import com.netscape.management.admserv.config.BaseConfigPanel;
import com.netscape.management.admserv.config.EditMonitor;
import com.netscape.management.admserv.config.GBC;
import com.netscape.management.admserv.config.IConfigDataModel;
import com.netscape.management.admserv.config.PluginConfigPanel;
import com.netscape.management.admserv.config.RemoteRequestException;
import com.netscape.management.admserv.config.ValidationException;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.SingleBytePasswordField;
import com.netscape.management.client.util.SingleByteTextField;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;

public class AccessConfigPanel
extends PluginConfigPanel
implements SuiConstants {
    IConfigDataModel _configData;
    static ResourceSet _resource = new ResourceSet("com.netscape.management.admserv.panel.panel");
    static String _i18nUID;
    static String _i18nPWD;
    static String _i18nConfirmPWD;
    static String _i18nAdmSuperuser;
    static String _i18nMsgEnterUID;
    static String _i18nMsgEnterPWD;
    static String _i18nMsgPWDMismatch;
    Help _help;
    SingleByteTextField _txtUserName;
    SingleBytePasswordField _txtPassword;
    SingleBytePasswordField _txtConfirm;

    public AccessConfigPanel(String string, IConfigDataModel iConfigDataModel) {
        super(string);
        this._configData = iConfigDataModel;
        this.setLayout(new BorderLayout());
        this.add((Component)this.makeConfigPanel(), "North");
        this._help = new Help(_resource);
    }

    public void showHelp() {
        this._help.contextHelp("accessHelp");
    }

    public IConfigDataModel getDataModel() {
        return this._configData;
    }

    public void setDataModel(IConfigDataModel iConfigDataModel) {
        this._configData = iConfigDataModel;
        if (this._configData.isLoaded()) {
            this.setPanelContent(this._configData);
        }
    }

    public void initialize() throws RemoteRequestException {
        if (!this._configData.isLoaded()) {
            this._configData.load();
        }
        this.setPanelContent(this._configData);
    }

    public void resetContent() {
        this.setPanelContent(this._configData);
    }

    public void applyChanges() throws ValidationException {
        this.getPanelContent(this._configData);
    }

    public void registerEditComponents(EditMonitor editMonitor) {
        editMonitor.monitor((JTextComponent)this._txtUserName);
        editMonitor.monitor((JTextComponent)this._txtPassword);
        editMonitor.monitor((JTextComponent)this._txtConfirm);
    }

    public void setPanelContent(IConfigDataModel iConfigDataModel) {
        this.setUserName(iConfigDataModel.getAttribute("admpw.uid"));
        this._txtPassword.setText("");
        this._txtConfirm.setText("");
    }

    public void getPanelContent(IConfigDataModel iConfigDataModel) throws ValidationException {
        String string = this._txtUserName.getText();
        String string2 = this._txtPassword.getText();
        String string3 = this._txtConfirm.getText();
        String string4 = this._configData.getAttribute("admpw.uid");
        if (string.length() == 0) {
            throw new ValidationException("", _i18nMsgEnterUID);
        }
        if (!string4.equals(string)) {
            if (string2.length() == 0) {
                throw new ValidationException("", _i18nMsgEnterPWD);
            }
            if (!string2.equals(string3)) {
                throw new ValidationException("", _i18nMsgPWDMismatch);
            }
        } else if (string2.length() != 0 && !string2.equals(string3)) {
            throw new ValidationException("", _i18nMsgPWDMismatch);
        }
        if (!string.equals(string4)) {
            Debug.println((String)("CHANGE UID TO " + string));
            this._configData.setAttribute("admpw.uid", string);
        }
        if (string2.length() > 0) {
            Debug.println((String)"CHANGE PWD ");
            this._configData.setAttribute("admpw.pw", string2);
        }
    }

    private void setUserName(String string) {
        this._txtUserName.setText(string == null ? "" : string);
    }

    private JPanel makeConfigPanel() {
        JPanel jPanel = new JPanel();
        GBC gBC = new GBC();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        gBC.setGrid(0, 0, 1, 1);
        gBC.setSpace(1.0, 0.0, 17, 2);
        jPanel.add((Component)this.createSuperuserGroup(), gBC);
        return jPanel;
    }

    private JPanel createSuperuserGroup() {
        GBC gBC = new GBC();
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setBorder(BaseConfigPanel.createGroupBorder(_i18nAdmSuperuser));
        JLabel jLabel = new JLabel(_i18nUID);
        gBC.setInsets(0, 0, 0, 0);
        gBC.setGrid(0, 0, 1, 1);
        gBC.setSpace(0.0, 0.0, 13, 0);
        jPanel.add((Component)jLabel, gBC);
        this._txtUserName = new SingleByteTextField(16);
        gBC.setInsets(0, 9, 0, 0);
        gBC.setGrid(1, 0, 1, 1);
        gBC.setSpace(0.0, 0.0, 17, 2);
        jPanel.add((Component)this._txtUserName, gBC);
        jLabel.setLabelFor((Component)this._txtUserName);
        JLabel jLabel2 = new JLabel(_i18nPWD);
        gBC.setInsets(6, 0, 0, 0);
        gBC.setGrid(0, 1, 1, 1);
        gBC.setSpace(0.0, 0.0, 13, 0);
        jPanel.add((Component)jLabel2, gBC);
        this._txtPassword = new SingleBytePasswordField(16);
        gBC.setInsets(6, 9, 0, 0);
        gBC.setGrid(1, 1, 1, 1);
        gBC.setSpace(1.0, 0.0, 17, 2);
        jPanel.add((Component)this._txtPassword, gBC);
        jLabel2.setLabelFor((Component)this._txtPassword);
        JLabel jLabel3 = new JLabel(_i18nConfirmPWD);
        gBC.setInsets(9, 0, 0, 0);
        gBC.setGrid(0, 2, 1, 1);
        gBC.setSpace(0.0, 0.0, 13, 0);
        jPanel.add((Component)jLabel3, gBC);
        this._txtConfirm = new SingleBytePasswordField(16);
        gBC.setInsets(6, 9, 0, 0);
        gBC.setGrid(1, 2, 1, 1);
        gBC.setSpace(1.0, 0.0, 17, 2);
        jPanel.add((Component)this._txtConfirm, gBC);
        jLabel3.setLabelFor((Component)this._txtConfirm);
        return jPanel;
    }

    static {
        _i18nAdmSuperuser = _resource.getString("access", "AdmSuperuser");
        _i18nUID = _resource.getString("access", "UID");
        _i18nPWD = _resource.getString("access", "PWD");
        _i18nConfirmPWD = _resource.getString("access", "ConfirmPWD");
        _i18nMsgEnterUID = _resource.getString("access", "MsgEnterUID");
        _i18nMsgEnterPWD = _resource.getString("access", "MsgEnterPWD");
        _i18nMsgPWDMismatch = _resource.getString("access", "MsgPWDMismatch");
    }
}

