/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.panel;

import com.netscape.management.admserv.config.BaseConfigPanel;
import com.netscape.management.admserv.config.ButtonBar;
import com.netscape.management.admserv.config.ConfigErrorDialog;
import com.netscape.management.admserv.config.ValidationException;
import com.netscape.management.admserv.panel.ItemEditDialog;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class EditableList
extends JPanel
implements SuiConstants {
    static ResourceSet _resource = new ResourceSet("com.netscape.management.admserv.panel.panel");
    static String _i18nAddButton = _resource.getString("editlist", "AddButton");
    static String _i18nEditButton = _resource.getString("editlist", "EditButton");
    static String _i18nRemoveButton = _resource.getString("editlist", "RemoveButton");
    static String _i18nOKButton = _resource.getString("editlist", "OKButton");
    static String _i18nCancelButton = _resource.getString("editlist", "CancelButton");
    static String _i18nAddDefaultToolTip = _resource.getString("editlist", "AddDefaultToolTip");
    static String _i18nEditDefaultToolTip = _resource.getString("editlist", "EditDefaultToolTip");
    static String _i18nRemoveDefaultToolTip = _resource.getString("editlist", "RemoveDefaultToolTip");
    static String _i18nOKDefaultToolTip = _resource.getString("editlist", "OKDefaultToolTip");
    static String _i18nCancelDefaultToolTip = _resource.getString("editlist", "CancelDefaultToolTip");
    static String _i18nHelpDefaultToolTip = _resource.getString("editlist", "HelpDefaultToolTip");
    protected JList _list;
    protected DefaultListModel _listModel;
    protected JScrollPane _listScroller;
    protected ButtonBar _buttons;
    protected ItemEditDialog _editDialog;
    protected JPanel _detailsPanel;
    protected JPanel _editPanel;
    protected static String _cmdAdd = "add";
    protected static String _cmdEdit = "edit";
    protected static String _cmdRemove = "remove";
    protected JPanel _north;
    protected JPanel _south;
    public JComponent _initialFocusComponent;
    public JTextField[] _commitOnEnterComponents;
    ListSelectionListener _selectListener = new ListSelectionListener(){

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                EditableList.this.adjustSelection();
            }
        }
    };
    MouseListener _dblclkListener = new MouseAdapter(){

        public void mousePressed(MouseEvent mouseEvent) {
            JList jList;
            int n;
            if (mouseEvent.getClickCount() == 2 && (n = (jList = (JList)mouseEvent.getSource()).locationToIndex(mouseEvent.getPoint())) >= 0) {
                EditableList.this.createEditDialog(false);
                String string = (String)EditableList.this._listModel.getElementAt(n);
                EditableList.this.setEditPanelParameters(string);
                while (true) {
                    EditableList.this._editDialog.setVisible(true);
                    if (!EditableList.this._editDialog.getCommand().equals("ok")) break;
                    try {
                        EditableList.this.validateEdit();
                        String string2 = EditableList.this.getEditPanelItem().trim();
                        EditableList.this.processEditOperation(string2);
                    }
                    catch (ValidationException validationException) {
                        ConfigErrorDialog.showDialog(EditableList.this._north, validationException);
                        continue;
                    }
                    break;
                }
            }
        }
    };
    ActionListener _btnListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            block11: {
                int n = EditableList.this.getSelectedIndex();
                String string = actionEvent.getActionCommand();
                if (string.equals(_cmdAdd)) {
                    EditableList.this.createEditDialog(true);
                    EditableList.this.setEditPanelParameters(null);
                    while (true) {
                        EditableList.this._editDialog.setVisible(true);
                        if (!EditableList.this._editDialog.getCommand().equals("ok")) break block11;
                        try {
                            EditableList.this.validateEdit();
                            String string2 = EditableList.this.getEditPanelItem().trim();
                            EditableList.this.addItem(string2);
                            break block11;
                        }
                        catch (ValidationException validationException) {
                            ConfigErrorDialog.showDialog(EditableList.this._north, validationException);
                            continue;
                        }
                        break;
                    }
                }
                if (string.equals(_cmdEdit)) {
                    EditableList.this.createEditDialog(false);
                    if (n >= 0) {
                        String string3 = (String)EditableList.this._listModel.getElementAt(n);
                        EditableList.this.setEditPanelParameters(string3);
                        while (true) {
                            EditableList.this._editDialog.setVisible(true);
                            if (!EditableList.this._editDialog.getCommand().equals("ok")) break;
                            try {
                                EditableList.this.validateEdit();
                                String string4 = EditableList.this.getEditPanelItem().trim();
                                EditableList.this.processEditOperation(string4);
                            }
                            catch (ValidationException validationException) {
                                ConfigErrorDialog.showDialog(EditableList.this._north, validationException);
                                continue;
                            }
                            break;
                        }
                    }
                } else if (string.equals(_cmdRemove) && n >= 0) {
                    EditableList.this.removeItem((String)EditableList.this._listModel.getElementAt(n));
                    EditableList.this._listModel.removeElementAt(n);
                }
            }
            EditableList.this.adjustSelection();
        }
    };

    public EditableList() {
        this.setLayout(new BorderLayout(0, 12));
        this.createLayout();
    }

    protected void finalize() {
        if (this._editDialog != null) {
            this._editDialog.dispose();
            ModalDialogUtil.sleep();
        }
    }

    public void addListDataListener(ListDataListener listDataListener) {
        this._listModel.addListDataListener(listDataListener);
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        this._listModel.removeListDataListener(listDataListener);
    }

    private void createLayout() {
        this.setBorder(BorderFactory.createEmptyBorder(9, 0, 0, 0));
        this._north = new JPanel(new BorderLayout(9, 0));
        this._list = new JList();
        this._listModel = new DefaultListModel();
        this._list.setModel(this._listModel);
        this._list.addListSelectionListener(this._selectListener);
        this._list.addMouseListener(this._dblclkListener);
        this._list.setVisibleRowCount(5);
        this._list.setBackground(Color.white);
        this._listScroller = new JScrollPane();
        this._listScroller.getViewport().setView(this._list);
        this._listScroller.setBorder(BorderFactory.createLoweredBevelBorder());
        this._buttons = new ButtonBar(new String[]{_cmdAdd, _cmdEdit, _cmdRemove}, new String[]{_i18nAddButton, _i18nEditButton, _i18nRemoveButton}, new String[]{this.getAddToolTip(), this.getEditToolTip(), this.getRemoveToolTip()}, false);
        this._buttons.addActionListener(this._btnListener);
        this._buttons.getButton(_cmdEdit).setEnabled(false);
        this._buttons.getButton(_cmdRemove).setEnabled(false);
        this._north.add((Component)this._listScroller, "Center");
        this._north.add((Component)this._buttons, "East");
        this._detailsPanel = this.getDetailsPanel();
        this.add((Component)this._north, "Center");
        if (this._detailsPanel != null) {
            this._south = new JPanel(new BorderLayout());
            this._south.setBorder(BaseConfigPanel.createGroupBorder(this.getDetailsTitle()));
            this._south.add(this._detailsPanel);
            this.add((Component)this._south, "South");
        }
        this._editPanel = this.getEditPanel();
    }

    int findItemIndex(String string) {
        int n = 0;
        while (n < this._listModel.getSize()) {
            String string2 = (String)this._listModel.getElementAt(n);
            if (string2.equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    void addItem(String string) {
        if (string.length() == 0) {
            return;
        }
        if (this.findItemIndex(string) == -1) {
            this.createItem(string);
            this._listModel.addElement(string);
        } else {
            this.updateItem(string, false);
        }
        this.selectItem(string);
        this._list.setSelectedIndex(this.findItemIndex(string));
    }

    void processEditOperation(String string) {
        int n = this._list.getSelectedIndex();
        if (n < 0) {
            return;
        }
        if (string.length() == 0) {
            this._listModel.removeElementAt(n);
            this.removeItem(string);
        } else {
            String string2 = (String)this._listModel.getElementAt(n);
            boolean bl = !string2.equals(string);
            this._listModel.setElementAt(string, n);
            this.updateItem(string2, bl);
            this._list.setSelectedIndex(this.findItemIndex(string));
            if (bl) {
                this._list.repaint();
            }
        }
    }

    int getSelectedIndex() {
        int n = this._list.getSelectedIndex();
        return n < this._listModel.size() ? n : -1;
    }

    void adjustSelection() {
        int n = this.getSelectedIndex();
        this._buttons.getButton(_cmdEdit).setEnabled(n >= 0);
        this._buttons.getButton(_cmdRemove).setEnabled(n >= 0);
        this.selectItem(n >= 0 ? (String)this._listModel.getElementAt(n) : null);
    }

    protected void createEditDialog(boolean bl) {
        this._editDialog = bl ? new ItemEditDialog(this._north, this.getAddTitle(), this._editPanel, this) : new ItemEditDialog(this._north, this.getEditTitle(), this._editPanel, this);
        this._editDialog.setHelpResourceSet(this.getHelpResourceSet());
        this._editDialog.setHelpToken(this.getHelpToken());
    }

    public void setList(Vector vector) {
        this._listModel.removeAllElements();
        int n = 0;
        while (n < vector.size()) {
            this._listModel.addElement(vector.elementAt(n));
            ++n;
        }
        this._buttons.getButton(_cmdEdit).setEnabled(false);
        this._buttons.getButton(_cmdRemove).setEnabled(false);
        if (vector.size() > 0) {
            this._list.setSelectedIndex(0);
            this._buttons.getButton(_cmdEdit).setEnabled(true);
            this._buttons.getButton(_cmdRemove).setEnabled(true);
        }
    }

    public Vector getList() {
        Vector vector = new Vector();
        int n = 0;
        while (n < this._listModel.getSize()) {
            vector.addElement(this._listModel.getElementAt(n));
            ++n;
        }
        return vector;
    }

    public abstract JPanel getDetailsPanel();

    public abstract String getDetailsTitle();

    public abstract JPanel getEditPanel();

    public abstract String getEditTitle();

    public abstract String getAddTitle();

    public abstract ResourceSet getHelpResourceSet();

    public abstract String getHelpToken();

    public abstract void validateEdit() throws ValidationException;

    protected String getEditToolTip() {
        return _i18nEditDefaultToolTip;
    }

    protected String getAddToolTip() {
        return _i18nAddDefaultToolTip;
    }

    protected String getRemoveToolTip() {
        return _i18nRemoveDefaultToolTip;
    }

    public abstract void setEditPanelParameters(String var1);

    public abstract void createItem(String var1);

    public abstract void updateItem(String var1, boolean var2);

    public abstract void removeItem(String var1);

    public abstract void selectItem(String var1);

    public abstract String getEditPanelItem();

    public void setEditPanelInitalFocusComponent(JComponent jComponent) {
        this._initialFocusComponent = jComponent;
    }

    public void setEditPanelCommitOnEnterComponents(JTextField[] jTextFieldArray) {
        this._commitOnEnterComponents = jTextFieldArray;
    }
}

