/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.servlet;

import com.iplanet.server.http.servlet.NSPrincipal;
import com.iplanet.server.http.servlet.NSServletRequest;
import com.iplanet.server.http.servlet.NSServletSession;
import com.iplanet.server.http.servlet.NSServletWrapper;
import com.iplanet.server.http.servlet.RequestParameterCache;
import com.iplanet.server.http.servlet.WServletContext;
import com.iplanet.server.http.servlet.WebApplication;
import com.iplanet.server.http.session.IWSHttpSessionManager;
import com.iplanet.server.http.util.LogUtil;
import java.io.File;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class NSHttpServletRequest
extends NSServletRequest
implements HttpServletRequest {
    public static final int NORMAL = 0;
    public static final int INCLUDE = 1;
    public static final int FORWARD = 2;
    public static final String FORM_AUTH = "form";
    private boolean _includedRequest = false;
    private boolean _forwardedRequest = false;
    private HttpSession _httpSession = null;
    private boolean _sessionFromURL = false;
    private boolean _sessionFromCookie = false;
    private String _requestSessionId = null;
    private boolean _requestSessionId_checked = false;
    private Cookie _sessionCookie = null;
    private boolean _useLastSessionCookie;
    private NSServletWrapper _sw;

    public NSHttpServletRequest(WServletContext wServletContext, NSServletSession nSServletSession) {
        super(wServletContext, nSServletSession);
        nSServletSession.setHttpServletRequest(this);
        this._useLastSessionCookie = this._context.getSessionCookiePath().equals("/");
    }

    public String _getContextPath() {
        return this._context.getContextPath();
    }

    public String _getPathInfo() {
        return this._session.getPathInfo();
    }

    public String _getPathTranslated() {
        return this._context.getRealPath(this._getPathInfo());
    }

    public String _getQueryString() {
        return this._session.getQueryString();
    }

    public String _getRequestURI() {
        return this._session.getRequestURI();
    }

    public String _getServletPath() {
        return this._session.getServletPath();
    }

    void closeInputStream() {
        block2: {
            super.closeInputStream();
            if (this._httpSession == null) break block2;
            IWSHttpSessionManager iWSHttpSessionManager = this._context.getHttpSessionManager();
            try {
                iWSHttpSessionManager.update(this._httpSession);
            }
            catch (Exception exception) {
                this._httpSession.invalidate();
                this._httpSession = null;
            }
        }
    }

    private void createSessionCookie(String string) {
        Cookie cookie = new Cookie("JSESSIONID", string);
        cookie.setPath(this._context.getSessionCookiePath());
        String string2 = this._context.getSessionCookieDomain();
        if (string2 != null) {
            cookie.setDomain(string2);
        }
        if (this._context.getSessionCookieIsSecure()) {
            cookie.setSecure(this.isSecure());
        }
        this._sessionCookie = cookie;
        this._session.addCookie(cookie);
    }

    String getAggregatedQueryString() {
        String string = null;
        if (this._paramCache != null) {
            string = this._paramCache.getAggregateQueryString();
        }
        return string;
    }

    public String getAuthType() {
        if (this._context.useFormLogin()) {
            return FORM_AUTH;
        }
        return this._session.getAuthType();
    }

    public String getContextPath() {
        if (this._includedRequest) {
            return this._paramCache.getContextPath();
        }
        return this._context.getContextPath();
    }

    public Cookie[] getCookies() {
        return this._session.getCookies();
    }

    public long getDateHeader(String string) {
        long l = -1L;
        String string2 = this.getHeader(string);
        if (string2 != null) {
            int n = string2.indexOf(59);
            if (n != -1) {
                string2 = string2.substring(0, n);
            }
            try {
                l = Date.parse(string2);
            }
            catch (Exception exception) {}
            if (l == -1L) {
                throw new IllegalArgumentException();
            }
        }
        return l;
    }

    public String getHeader(String string) {
        return this._session.getHeader(string);
    }

    public Enumeration getHeaderNames() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = this._session.getAllHeaderNames();
        int n = 0;
        while (n < stringArray.length) {
            vector.addElement(stringArray[n]);
            ++n;
        }
        return vector.elements();
    }

    public Enumeration getHeaders(String string) {
        String string2 = this.getHeader(string);
        if (string2 != null) {
            return this.parseHeader(string2);
        }
        return new Vector().elements();
    }

    public int getIntHeader(String string) {
        int n = -1;
        String string2 = this.getHeader(string);
        if (string2 != null) {
            n = Integer.parseInt(string2);
        }
        return n;
    }

    public String getMethod() {
        return this._session.getMethodName();
    }

    public String getPathInfo() {
        if (this._includedRequest) {
            return this._paramCache.getPathInfo();
        }
        return this._session.getPathInfo();
    }

    public String getPathTranslated() {
        if (this._includedRequest) {
            return this._paramCache.getPathTranslated();
        }
        return this._context.getRealPath(this.getPathInfo());
    }

    public String getQueryString() {
        if (this._includedRequest) {
            return this._paramCache.getQueryString();
        }
        return this._session.getQueryString();
    }

    public String getRemoteUser() {
        return this._session.getRemoteUser();
    }

    public String getRequestParent() {
        String string = this._getServletPath();
        String string2 = "";
        int n = string.length() - 1;
        while (n >= 0 && string.charAt(n) == '/') {
            --n;
        }
        while (n >= 0 && string.charAt(n) != '/') {
            --n;
        }
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public String getRequestPath() {
        String string = this._context.getRealPath();
        if (string != null) {
            return (String.valueOf(string) + this._getServletPath()).replace('/', File.separatorChar);
        }
        return this._session.getRequestPath();
    }

    int getRequestType() {
        if (this._includedRequest) {
            return 1;
        }
        if (this._forwardedRequest) {
            return 2;
        }
        return 0;
    }

    public String getRequestURI() {
        if (this._includedRequest) {
            return this._paramCache.getRequestUri();
        }
        return this._session.getRequestURI();
    }

    public String getRequestedSessionId() {
        if (!this._requestSessionId_checked) {
            this.getSession(false);
            this._requestSessionId_checked = true;
        }
        return this._requestSessionId;
    }

    public String getServletPath() {
        if (this._includedRequest) {
            return this._paramCache.getServletPath();
        }
        return this._session.getServletPath();
    }

    public NSServletWrapper getServletWrapper() {
        return this._sw;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean bl) {
        try {
            if (this._httpSession != null) {
                this._httpSession.getSessionContext();
            }
        }
        catch (IllegalStateException illegalStateException) {
            this._httpSession = null;
        }
        if (this._httpSession != null) {
            return this._httpSession;
        }
        IWSHttpSessionManager iWSHttpSessionManager = this._context.getHttpSessionManager();
        if (iWSHttpSessionManager == null) {
            return null;
        }
        if (this._context.isSessionTrackingViaCookie() && (this._httpSession = this.getSessionViaCookie("JSESSIONID", iWSHttpSessionManager)) != null) {
            return this._httpSession;
        }
        if (this._context.isSessionTrackingViaURL() && (this._httpSession = this.getSessionViaURL(iWSHttpSessionManager)) != null) {
            return this._httpSession;
        }
        if (!bl) {
            return null;
        }
        String string = URLEncoder.encode(String.valueOf(this._session.getServerName()) + "-" + iWSHttpSessionManager.generateSID());
        this._httpSession = iWSHttpSessionManager.createSession(string, this._context);
        if (this._httpSession != null && this._context instanceof WebApplication) {
            WebApplication webApplication = (WebApplication)this._context;
            this._httpSession.setMaxInactiveInterval(webApplication.getSessionTimeout());
        }
        if (this._context.isSessionTrackingViaCookie() && this._httpSession != null) {
            this.createSessionCookie(string);
        }
        if (LogUtil.enableTrace) {
            LogUtil.TRACE((int)5, (String)("getSession(): creating new session ID=" + string));
        }
        return this._httpSession;
    }

    HttpSession getSessionViaCookie(String string, IWSHttpSessionManager iWSHttpSessionManager) {
        HttpSession httpSession;
        block4: {
            httpSession = null;
            boolean bl = this._useLastSessionCookie ^ true;
            Cookie cookie = this._session.getCookie(string, bl);
            if (cookie == null) break block4;
            if (LogUtil.enableTrace) {
                LogUtil.TRACE((int)5, (String)("getSession(): SessionID is obtained from the cookie, ID=" + cookie.getValue()));
            }
            this._requestSessionId = cookie.getValue();
            httpSession = iWSHttpSessionManager.getSession(this._requestSessionId, this._context);
            try {
                if (httpSession != null) {
                    httpSession.getSessionContext();
                    this._sessionFromCookie = true;
                }
            }
            catch (IllegalStateException illegalStateException) {
                httpSession = null;
            }
        }
        return httpSession;
    }

    private HttpSession getSessionViaURL(IWSHttpSessionManager iWSHttpSessionManager) {
        HttpSession httpSession;
        block4: {
            httpSession = null;
            String string = this._session.getHttpSessionIdFromURL();
            if (string == null) break block4;
            this._requestSessionId = URLEncoder.encode(string);
            if (LogUtil.enableTrace) {
                LogUtil.TRACE((int)5, (String)("getSession(): SessionID is obtained from URL, ID=" + this._requestSessionId));
            }
            httpSession = iWSHttpSessionManager.getSession(this._requestSessionId, this._context);
            try {
                if (httpSession == null) break block4;
                httpSession.getSessionContext();
                this._sessionFromURL = true;
                if (this._context.isSessionTrackingViaCookie()) {
                    this.createSessionCookie(this._requestSessionId);
                }
            }
            catch (IllegalStateException illegalStateException) {
                httpSession = null;
            }
        }
        return httpSession;
    }

    Exception getStoredException() {
        if (this._paramCache != null) {
            return this._paramCache.getException();
        }
        return null;
    }

    public Principal getUserPrincipal() {
        String string = this.getRemoteUser();
        if (string != null) {
            return new NSPrincipal(string);
        }
        return null;
    }

    void initParamCache() {
        if (this._paramCache == null) {
            this._paramCache = new RequestParameterCache(this._getRequestURI(), this._getContextPath(), this._getPathInfo(), this._getPathTranslated(), this._getQueryString(), this._getServletPath());
        }
    }

    public boolean isRequestedSessionIdFromCookie() {
        if (this._context.isSessionTrackingViaCookie()) {
            return this._sessionFromCookie;
        }
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        if (this._context.isSessionTrackingViaURL()) {
            return this._sessionFromURL;
        }
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        HttpSession httpSession = this.getSession(false);
        return httpSession != null;
    }

    public boolean isUserInRole(String string) {
        String string2;
        if (string == null) {
            return false;
        }
        String string3 = this._sw.getServletConfig().lookupSecurityRoleRef(string);
        if (string3 != null) {
            string = string3;
        }
        if ((string2 = this.getRemoteUser()) != null) {
            int n = this._context.getRoleMapping();
            if (n == 1) {
                return string2.equals(string);
            }
            return this._session.isUserInRole(string2, n, string, this._context.getAuthDB());
        }
        return false;
    }

    private void parseCommas(Vector vector, String string) {
        if ((string = string.trim()).equals("")) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2 == null || string2.length() == 0) continue;
            vector.add(string2);
        }
    }

    private Enumeration parseHeader(String string) {
        String string2 = "\"";
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Vector<String> vector = new Vector<String>();
        int n4 = string.length();
        while (n < n4 && n2 != -1) {
            n2 = string.indexOf("\"", n);
            if (n2 == -1) continue;
            if (++n3 % 2 == 0) {
                String string3 = string.substring(n, n2).trim();
                if (string3.length() > 0) {
                    vector.add(string3);
                }
            } else if (n < n2) {
                this.parseCommas(vector, string.substring(n, n2));
            }
            n = ++n2;
        }
        if (n < n4) {
            if (n != 0) {
                this.parseCommas(vector, string.substring(n, n4));
            } else {
                this.parseCommas(vector, string);
            }
        }
        return vector.elements();
    }

    void removeIncludeAttributes() {
        this.removeAttribute("javax.servlet.include.request_uri");
        this.removeAttribute("javax.servlet.include.context_path");
        this.removeAttribute("javax.servlet.include.path_info");
        this.removeAttribute("javax.servlet.include.query_string");
        this.removeAttribute("javax.servlet.include.servlet_path");
    }

    void resetRequestDispatcherAttrs() {
        if (this._includedRequest) {
            this.setIncludeAttributes();
        } else {
            this.removeIncludeAttributes();
        }
    }

    void setAggregatedQueryString(String string) {
        if (this._paramCache != null) {
            this._paramCache.setAggregateQueryString(string);
        }
    }

    private void setIncludeAttr(String string, String string2) {
        if (string2 != null) {
            this.setAttribute(string, string2);
        } else {
            this.setAttribute(string, "");
        }
    }

    void setIncludeAttributes() {
        this.setIncludeAttr("javax.servlet.include.request_uri", this._getRequestURI());
        this.setIncludeAttr("javax.servlet.include.context_path", this._getContextPath());
        this.setIncludeAttr("javax.servlet.include.path_info", this._getPathInfo());
        this.setIncludeAttr("javax.servlet.include.query_string", this._getQueryString());
        this.setIncludeAttr("javax.servlet.include.servlet_path", this._getServletPath());
    }

    void setRequestDispatcherAttrs() {
        if (this._includedRequest) {
            this.setIncludeAttributes();
        } else {
            this.removeIncludeAttributes();
        }
        this._paramCache.aggregateQuery(this._getQueryString());
    }

    void setRequestType(int n) {
        this._includedRequest = false;
        this._forwardedRequest = false;
        if (n == 1) {
            this._includedRequest = true;
        }
        if (n == 2) {
            this._forwardedRequest = true;
        }
        this.initParamCache();
    }

    public void setServletWrapper(NSServletWrapper nSServletWrapper) {
        this._sw = nSServletWrapper;
    }

    void setStoredException(Exception exception) {
        this.initParamCache();
        if (this._paramCache != null) {
            this._paramCache.setException(exception);
        }
    }
}

