/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.servlet;

import com.iplanet.server.http.servlet.IContextProperties;
import com.iplanet.server.http.servlet.IServletProperties;
import com.iplanet.server.http.servlet.NSServletLoader;
import com.iplanet.server.http.util.LogUtil;
import com.iplanet.server.http.util.ResUtil;
import com.iplanet.server.http.util.SlashUtil;
import com.iplanet.server.http.util.misc.EnvUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.Servlet;

public class NSServletAdmin {
    public static final String rules_properties = "rules.properties";
    public static final String servlets_properties = "servlets.properties";
    public static final String contexts_properties = "contexts.properties";
    public static final String startup_property = "servlets.startup";
    public static final String sessionmgr_property = "servlets.sessionmgr";
    public static final String sessionmgr_initargs = "servlets.sessionmgr.initArgs";
    public static final String config_docRoot = "servlets.config.docRoot";
    public static final String pre_property = "servlet.";
    public static final String postclassname_property = ".code";
    public static final String postclasspath_property = ".classpath";
    public static final String postcontext_property = ".context";
    public static final String postinitargs_property = ".initArgs";
    public static final String poststartup_property = ".startup";
    public static final String config_sessionexp = "servlets.config.sessionExpireOnClose";
    public static final String config_reloadInterval = "servlets.config.reloadInterval";
    public static final String config_bufferSize = "servlets.config.bufferSize";
    public static final String config_realpath = "servlets.config.realPathFromRequest";
    public static final String config_cookieVersion = "servlets.config.respondCookieVersion";
    public static final String config_singleClassLoader = "servlets.config.singleClassLoader";
    public static final String config_useResponseCTforHeaders = "servlets.config.use-responseCT-for-headers";
    public static final String context_pre_property = "context.";
    public static final String context_sessionmgr_property = ".sessionmgr";
    public static final String context_initargs_property = ".initArgs";
    public static final String context_docRoot = ".docRoot";
    public static final String context_sessionmgr_args_property = ".sessionmgr.initArgs";
    public static final String context_global = "global";
    public static final String context_cookieVersion = ".respondCookieVersion";
    public static final String context_realpath = ".realPathFromRequest";
    public static final String context_sessionexp = ".sessionExpireOnClose";
    public static final String context_transparency = ".includeTransparency";
    public static final String context_tempDir = ".tempDir";
    public static final String context_streamSize = ".bufferSize";
    public static final String context_bufferSize = ".javaBufferSize";
    public static final String context_reloadInterval = ".reloadInterval";
    public static final String context_flushTimer = ".outputStreamFlushTimer";
    public static final String context_uri = ".uri";
    public static final String context_host = ".host";
    public static final String context_ip = ".ip";
    public static final String context_authdb = ".authdb";
    public static final String context_classpath = ".classpath";
    public static final String context_serverName = ".serverName";
    public static final String context_singleClassLoader = ".singleClassLoader";
    public static final String context_useResponseCTforHeaders = ".use-responseCT-for-headers";
    public static final String context_parameterEncoding = ".parameterEncoding";
    public static final String context_sessionCookie = ".sessionCookie";
    public static final String context_isModified = ".isModifiedCheckAggressive";
    public static final String context_formEncodingHint = ".formEncodingHint";
    public static final String context_cookieEncoding = ".enableCookieEncoding";
    public static final String _defaultSessionCookieName = "JSESSIONID";
    public static final String msg_propsHeader = "# @(#)servlets.properties (autogenerated) %1\n#\n# Servlets Properties\n#\n# servlet.<servlet name>.code=class name (foo or foo.class)\n# servlet.<servlet name>.context=name of the context\n# servlet.<servlet name>.classpath=the url or path to the directory where classes are located (no backslashes)\n#                          or the list of directories (but not urls) or jar files, just like CLASSPATH\n# servlet.<servlet name>.initArgs=list of {name, value} pairs which can be accessed\n#                          by the servlet using the servlet API calls\n# servlet.<servlet_name>.startup=true\n#\n# For example:\n# servlet.wasp.code=WASPServlet\n# servlet.wasp.classpath=this is optional\n# servlet.wasp.initArgs=initial=0\n# servlet.wasp.context=global\n# servlet.wasp.startup=true\n#\n# General properties:\n#\n# Deprecated (use contexts.properties instead):\n# servlets.config.docRoot=E:/Netscape/SuiteSpot/docs (forward slashes only)\n# servlets.config.realPathFromRequest=false\n# servlets.config.respondCookieVersion=0\n# servlets.config.sessionExpireOnClose=false\n# servlets.sessionmgr=com.netscape.server.http.session.SimpleSessionManager\n# servlets.sessionmgr.initArgs=\n# servlets.startup=hello,byebye (use servlet startup property instead)\n# servlets.config.reloadInterval=5\n# servlets.config.bufferSize=0\n# servlets.config.singleClassLoader=false\n################################# Servlets #############################\n";
    public static final String msg_contextHeader = "# @(#)contexts.properties (autogenerated) %1\n#\n# Contexts Properties:\n#\n# context.<context_name>.sessionmgr=session manager (some session managers\n#              (like MMapSessionManager) can only be instatiated once within the server\n# context.<context_name>.sessionmgr.initArgs=list of (name, value) pairs which will\n#              represent parameters specific to the session manager\n# context.<context_name>.initArgs=list of (name, value) pairs which will be added to\n#              this context's attributes\n# context.<context_name>.realPathFromRequest=(true|false) tells the server wheather to\n#              calculate getRealPath based on docRoot of the context or try to go through\n#              normal NSAPI steps\n# context.<context_name>.respondCookieVersion=(cookie version) tells the server wheather to\n#              respond with specific cookie version\n# context.<context_name>.sessionExpireOnClose(true|false) tells the server to mark session\n#              cookies as directed to expire when the user quits the browser\n# context.<context_name>.includeTransparency=(true|false) tells the server wheather to try\n#              to honor setting headers from the included servlet\n# context.<context_name>.tempDir=path (forward slashes only) - sets up Servlet API 2.2\n#              property for the temporary directory\n# context.<context_name>.reloadInterval=seconds - time interval within which the server\n#              checks for jsp and servlet files being modified (global context only)\n# context.<context_name>.javaBufferSize=bytes (deprecated)\n# context.<context_name>.bufferSize=bytes - initial http output stream buffer size\n# context.<context_name>.docRoot=path (forward slashes only) - this context document root\n#              when not specified - web server's document root will be used (default)\n# context.<context_name>.outputStreamFlushTimer=(seconds|0) - forces the stream to flush\n#              the data if certain time elapsed since the last flush; 0 - ignore it\n# context.<context_name>.uri=contex_uri_base - additional URI prefix which servces as\n#              a context base\n# context.<context_name>.host=hostname\n# context.<context_name>.ip=ip\n# context.<context_name>.authdb=name - authentication database\n# context.<context_name>.classpath=name - global classpath for this context\n# context.<context_name>.signleClassLoader=(true|false) - tells the servlet engine wheather\n#              to use a single class loader for all servlets in the context\n# context.<context_name>.serverName=name - server instance name\n# context.<context_name>.parameterEncoding=(utf8,none,auto) - advises the web server on\n#              how to decode parameters from forms\n# context.<context_name>.sessionCookie=cookie name- define a name for the session cookie\n# context.<context_name>.isModifiedCheckAggressive=(true|false) - determines whether to be\n#              aggressively checking dependencies for the servlet loader to reload modified servlets\n#\n# <context_name>=\"global\" is reserved for the global context. Every new context will inherit\n#              initial settings of the global context\n#\n# Context properties:\n# context.global.sessionmgr=com.netscape.server.http.session.SimpleSessionManager\n# context.global.sessionmgr.initArgs=\n# context.global.initArgs=initial=0\n# context.global.realPathFromRequest=false\n# context.global.respondCookieVersion=0\n# context.global.sessionExpireOnClose=false\n# context.global.includeTransparency=true\n# context.global.tempDir=/tmp\n# context.global.reloadInterval=5\n# context.global.javaBufferSize=0\n# context.global.bufferSize=4096\n# context.global.docRoot=/foo/bar\n# context.global.outputStreamFlushTimer=0\n# context.global.uri=/\n# context.global.host=\n# context.global.ip=\n# context.global.authdb=default\n# context.global.classpath=\n# context.global.singleClassLoader=false\n# context.global.parameterEncoding=utf8\n# context.global.sessionCookie=IWS50Session\n# context.global.isModifiedCheckAggressive=false\n# context.global.formEncodingHint=j_encoding\n#\n################################# Contexts #############################\n";
    public static final String msg_rulesHeader = "# Servlet rules properties (autogenerated) %1\n#\n# This file specifies the translation rules for invoking servlets.\n# The syntax is:\n#  <virtual-path>=<servlet-name>\n#  or\n#  @regular_expression=<servlet-name> (use double back-slashes)\n#\n# where <virtual-path> is the virtual path used to invoke the servlet,  \n# and <servlet-name> is the name of the servlet. Surrounding white space\n# is ignored. The ordering of the rules is not important, as the longest\n# match will always be used first. Use of regular expression can lead to\n# a heavy peformance penalty\n#\n# Example:\n# /simple=SimpleServlet\n# @.*\\.foo=wasp\n################################# rules ################################\n";
    private ResUtil _res;
    private File _fileServletsProperty;
    private File _fileRulesProperty;
    private File _fileContextsProperty;
    private Hashtable _contexts;
    private Hashtable _servlets;
    private Hashtable _aliases;
    private Hashtable _aliasesByName;
    private String _prefix = null;
    private ContextEntry _ce = new ContextEntry();
    public static String defaultEncoding = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();

    public NSServletAdmin(String string) {
        this._res = new ResUtil((Object)this);
        this._prefix = string;
        this._fileServletsProperty = this._prefix == null ? new File(servlets_properties) : new File(this._prefix, servlets_properties);
        this._fileRulesProperty = this._prefix == null ? new File(rules_properties) : new File(this._prefix, rules_properties);
        this._fileContextsProperty = this._prefix == null ? new File(contexts_properties) : new File(this._prefix, contexts_properties);
        this._contexts = new Hashtable();
        this._servlets = new Hashtable();
        this._aliases = new Hashtable();
        this._aliasesByName = new Hashtable();
        this._ce.setBaseURI("/");
        this._ce.setName(context_global);
        this._contexts.put(context_global, this._ce);
    }

    public boolean addAlias(AliasEntry aliasEntry) {
        if (aliasEntry.isValid() && this.servletExists(aliasEntry.getServletName())) {
            AliasSet aliasSet = this.getAliasSet(aliasEntry.getAlias());
            if (aliasSet == null) {
                aliasSet = new AliasSet();
                this._aliases.put(aliasEntry.getAlias(), aliasSet);
            }
            aliasSet.add(aliasEntry, aliasEntry.getHost(), aliasEntry.getIPAddress());
            this._aliasesByName.put(aliasEntry.getServletName(), aliasEntry);
            return true;
        }
        return false;
    }

    public boolean addContext(ContextEntry contextEntry) {
        this._contexts.put(contextEntry.getName(), contextEntry);
        return true;
    }

    public boolean addServlet(ServletEntry servletEntry) {
        if (servletEntry.isValid()) {
            this._servlets.put(servletEntry.getName(), servletEntry);
            return true;
        }
        return false;
    }

    public boolean aliasExists(String string) {
        return this.getAlias(string) != null;
    }

    public boolean contextExists(String string) {
        return this._contexts.get(string) != null;
    }

    public AliasEntry getAlias(String string) {
        return this.getAlias(string, null, null);
    }

    public AliasEntry getAlias(String string, String string2, String string3) {
        AliasSet aliasSet = this.getAliasSet(string);
        AliasEntry aliasEntry = null;
        if (aliasSet != null) {
            aliasEntry = aliasSet.get(string2, string3);
        }
        return aliasEntry;
    }

    public AliasEntry getAliasByName(String string) {
        return (AliasEntry)this._aliasesByName.get(string);
    }

    public AliasSet getAliasSet(String string) {
        return (AliasSet)this._aliases.get(string);
    }

    public Enumeration getAllAliases() {
        Vector<AliasEntry> vector = new Vector<AliasEntry>();
        Enumeration enumeration = this._aliases.elements();
        while (enumeration.hasMoreElements()) {
            AliasSet aliasSet = (AliasSet)enumeration.nextElement();
            Enumeration enumeration2 = aliasSet.getAllAliases();
            while (enumeration2.hasMoreElements()) {
                AliasEntry aliasEntry = (AliasEntry)enumeration2.nextElement();
                vector.addElement(aliasEntry);
            }
        }
        return vector.elements();
    }

    public Enumeration getAllContexts() {
        return this._contexts.elements();
    }

    public Enumeration getAllServlets() {
        return this._servlets.elements();
    }

    public ContextEntry getContext(String string) {
        return (ContextEntry)this._contexts.get(string);
    }

    public ContextEntry getGlobalContext() {
        return this._ce;
    }

    public ServletEntry getServlet(String string) {
        return (ServletEntry)this._servlets.get(string);
    }

    public ContextEntry getServletContext(String string) {
        ServletEntry servletEntry = this.getServlet(string);
        return servletEntry != null ? (ContextEntry)this._contexts.get(servletEntry.getContext()) : null;
    }

    public String getServletName(String string) {
        return this.getServletName(string, null, null);
    }

    public String getServletName(String string, String string2, String string3) {
        AliasSet aliasSet = (AliasSet)this._aliases.get(string);
        AliasEntry aliasEntry = null;
        if (aliasSet != null) {
            aliasEntry = aliasSet.get(string2, string3);
        }
        return aliasEntry != null ? aliasEntry.getServletName() : null;
    }

    public AliasEntry newAliasEntry() {
        return new AliasEntry();
    }

    public ServletEntry newServletEntry() {
        return new ServletEntry();
    }

    public void read() throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Properties properties = new Properties();
        Properties properties2 = new Properties();
        properties.load(new FileInputStream(this._fileServletsProperty));
        try {
            properties2.load(new FileInputStream(this._fileContextsProperty));
        }
        catch (Exception exception) {}
        this._ce.legacy_fill(properties);
        Enumeration<?> enumeration = properties2.propertyNames();
        while (enumeration.hasMoreElements()) {
            int n;
            object4 = (String)enumeration.nextElement();
            if (!((String)object4).startsWith(context_pre_property) || (n = ((String)object4).indexOf(46, context_pre_property.length())) == -1) continue;
            object3 = ((String)object4).substring(context_pre_property.length(), n);
            object2 = this.getServletContext((String)object3);
            if (object2 == null) {
                object2 = (ContextEntry)this._ce.clone();
                ((ContextEntry)object2).setName((String)object3);
                this.addContext((ContextEntry)object2);
            }
            ((ContextEntry)object2).fill((String)object3, properties2);
        }
        object4 = properties.propertyNames();
        while (object4.hasMoreElements()) {
            int n;
            String string = (String)object4.nextElement();
            if (!string.startsWith(pre_property) || (n = string.indexOf(postclassname_property, pre_property.length())) == -1) continue;
            object2 = string.substring(pre_property.length(), n);
            object = new ServletEntry();
            ((ServletEntry)object).fill((String)object2, properties);
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this._fileRulesProperty));
            while ((object3 = bufferedReader.readLine()) != null) {
                if (((String)object3).length() == 0 || ((String)object3).charAt(0) == '#') continue;
                object2 = new StringTokenizer((String)object3, "=");
                object = null;
                String string = null;
                if (((StringTokenizer)object2).hasMoreTokens()) {
                    object = ((StringTokenizer)object2).nextToken();
                }
                if (((StringTokenizer)object2).hasMoreTokens()) {
                    string = ((StringTokenizer)object2).nextToken();
                }
                if (string == null || object == null) continue;
                AliasEntry aliasEntry = new AliasEntry();
                aliasEntry.setServletName(string);
                aliasEntry.setAlias((String)object);
                if (this.addAlias(aliasEntry)) continue;
                LogUtil.logWarning((String)this._res.getProp("msg_badAlias", object));
            }
        }
        catch (Exception exception) {}
        String string = properties.getProperty(startup_property);
        if (string != null) {
            object3 = new StringTokenizer(string, ",");
            object2 = null;
            while (((StringTokenizer)object3).hasMoreTokens()) {
                object2 = ((StringTokenizer)object3).nextToken();
                object = this.getServlet((String)object2);
                if (object != null) {
                    ((ServletEntry)object).setLoadOnStartup(true);
                    continue;
                }
                LogUtil.logWarning((String)this._res.getProp("msg_unknownServlet", object2));
            }
        }
    }

    public Properties readSEProperties() {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(new File("se.properties")));
        }
        catch (Exception exception) {}
        return properties;
    }

    public void removeAlias(String string) {
        this.removeAlias(string, null, null);
    }

    public void removeAlias(String string, String string2, String string3) {
        AliasEntry aliasEntry = this.getAlias(string, string2, string3);
        AliasSet aliasSet = this.getAliasSet(string);
        aliasSet.remove(aliasEntry);
        this._aliasesByName.remove(aliasEntry.getServletName());
    }

    public void removeContext(String string) {
        this._contexts.remove(string);
        Enumeration enumeration = this._servlets.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            ServletEntry servletEntry = (ServletEntry)this._servlets.get(string2);
            if (!servletEntry.getName().equals(string)) continue;
            this.removeServlet(servletEntry.getName());
        }
    }

    public void removeServlet(String string) {
        this._servlets.remove(string);
        Enumeration enumeration = this._aliases.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            AliasSet aliasSet = (AliasSet)this._aliases.get(string2);
            Enumeration enumeration2 = aliasSet.getAllAliases();
            while (enumeration2.hasMoreElements()) {
                AliasEntry aliasEntry = (AliasEntry)enumeration2.nextElement();
                if (!aliasEntry.getServletName().equals(string)) continue;
                this.removeAlias(aliasEntry.getAlias());
            }
        }
    }

    public boolean save() {
        Object object;
        Object object2;
        Object object3;
        Enumeration enumeration;
        PrintWriter printWriter;
        File file;
        File file2;
        if (this._contexts.size() > 0) {
            try {
                file2 = new File(this._fileContextsProperty.getPath());
                file = this._prefix == null ? new File("contexts.properties.bak") : new File(this._prefix, "contexts.properties.bak");
                file2.renameTo(file);
                printWriter = new PrintWriter(new FileWriter(this._fileContextsProperty));
                printWriter.println(this._res.getProp("msg_contextHeader", (Object)new Date().toString()));
                printWriter.println();
                enumeration = this._contexts.elements();
                while (enumeration.hasMoreElements()) {
                    object3 = (ContextEntry)enumeration.nextElement();
                    ((ContextEntry)object3).save(printWriter);
                }
                printWriter.close();
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (this._servlets.size() > 0) {
            try {
                file2 = new File(this._fileServletsProperty.getPath());
                file = this._prefix == null ? new File("servlets.properties.bak") : new File(this._prefix, "servlets.properties.bak");
                file2.renameTo(file);
                printWriter = new PrintWriter(new FileWriter(this._fileServletsProperty));
                int n = 0;
                printWriter.println(this._res.getProp("msg_propsHeader", (Object)new Date().toString()));
                printWriter.println();
                object3 = this._servlets.elements();
                while (object3.hasMoreElements()) {
                    object2 = (ServletEntry)object3.nextElement();
                    if (!((ServletEntry)object2).getLoadOnStartup()) continue;
                    if (n++ == 0) {
                        printWriter.print("servlets.startup=");
                    } else {
                        printWriter.print(',');
                    }
                    printWriter.print(((ServletEntry)object2).getName());
                }
                if (n != 0) {
                    printWriter.println();
                }
                object2 = this._servlets.elements();
                while (object2.hasMoreElements()) {
                    object = (ServletEntry)object2.nextElement();
                    ((ServletEntry)object).save(printWriter);
                }
                printWriter.close();
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (this._aliases.size() > 0) {
            try {
                file2 = new File(this._fileRulesProperty.getPath());
                file = this._prefix == null ? new File("rules.properties.bak") : new File(this._prefix, "rules.properties.bak");
                file2.renameTo(file);
                printWriter = new PrintWriter(new FileWriter(this._fileRulesProperty));
                printWriter.println(this._res.getProp("msg_rulesHeader", (Object)new Date().toString()));
                printWriter.println();
                enumeration = this._aliases.elements();
                while (enumeration.hasMoreElements()) {
                    object3 = (AliasSet)enumeration.nextElement();
                    object2 = ((AliasSet)object3).getAllAliases();
                    while (object2.hasMoreElements()) {
                        object = (AliasEntry)object2.nextElement();
                        printWriter.println(String.valueOf(((AliasEntry)object).getAlias()) + '=' + ((AliasEntry)object).getServletName());
                    }
                }
                printWriter.close();
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public boolean servletExists(String string) {
        return this._servlets.get(string) != null;
    }

    public class ServletEntry
    implements IServletProperties {
        private String _name = null;
        private String _classname = null;
        private String _classpath = null;
        private Properties _props = null;
        private String _context = "global";
        private boolean _startup = false;

        public boolean canLoad() {
            Serializable serializable;
            if (!this.isValid()) {
                return false;
            }
            String string = null;
            if (this._classpath != null) {
                serializable = new File(this._classpath);
                if (((File)serializable).isDirectory()) {
                    string = this._classpath;
                } else {
                    string = ((File)serializable).getParent();
                    if (string == null) {
                        string = "/";
                    }
                }
            }
            try {
                serializable = new NSServletLoader(string, false).loadClass(this._classname, true);
                Servlet servlet = (Servlet)((Class)serializable).newInstance();
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }

        void fill(String string, Properties properties) {
            Properties properties2 = null;
            String string2 = properties.getProperty(NSServletAdmin.pre_property + string + NSServletAdmin.postclassname_property);
            String string3 = properties.getProperty(NSServletAdmin.pre_property + string + ".classpath");
            String string4 = properties.getProperty(NSServletAdmin.pre_property + string + NSServletAdmin.postcontext_property);
            String string5 = properties.getProperty(NSServletAdmin.pre_property + string + ".initArgs");
            String string6 = properties.getProperty(NSServletAdmin.pre_property + string + NSServletAdmin.poststartup_property);
            if (string5 != null) {
                properties2 = ResUtil.parsePropertyList((String)string5);
            }
            this.setName(string);
            this.setClassName(string2);
            this.setClassPath(string3);
            this.setInitArgs(properties2);
            if (string6 != null) {
                this.setLoadOnStartup(Boolean.valueOf(string6));
            }
            if (string4 == null) {
                string4 = NSServletAdmin.context_global;
            }
            this.setContext(string4);
            if (!NSServletAdmin.this.addServlet(this)) {
                LogUtil.logWarning((String)NSServletAdmin.this._res.getProp("msg_badServlet", (Object)string));
            }
        }

        public String getClassName() {
            return this._classname;
        }

        public String getClassPath() {
            return this._classpath;
        }

        public String getContext() {
            return this._context;
        }

        public Properties getInitArgs() {
            return this._props;
        }

        public boolean getLoadOnStartup() {
            return this._startup;
        }

        public String getName() {
            return this._name;
        }

        public boolean isValid() {
            return this._name != null && this._classname != null && NSServletAdmin.this.contextExists(this._context);
        }

        void save(PrintWriter printWriter) {
            String string = NSServletAdmin.pre_property + this.getName();
            Properties properties = this.getInitArgs();
            printWriter.println(String.valueOf(string) + NSServletAdmin.postclassname_property + '=' + this.getClassName());
            if (this.getClassPath() != null) {
                printWriter.println(String.valueOf(string) + ".classpath" + '=' + this.getClassPath());
            }
            printWriter.println(String.valueOf(string) + NSServletAdmin.postcontext_property + '=' + this._context);
            if (properties != null && ((Hashtable)properties).size() > 0) {
                printWriter.print(String.valueOf(string) + ".initArgs" + '=');
                SlashUtil.printProps((PrintWriter)printWriter, (Properties)properties);
            }
            if (this.getLoadOnStartup()) {
                printWriter.println(String.valueOf(string) + NSServletAdmin.poststartup_property + '=' + this.getLoadOnStartup());
            }
        }

        public void setClassName(String string) {
            this._classname = SlashUtil.normalizeValue((String)string);
        }

        public void setClassPath(String string) {
            this._classpath = SlashUtil.normalizeValue((String)string);
        }

        public void setContext(String string) {
            this._context = SlashUtil.normalizeValue((String)string);
        }

        public void setInitArgs(Properties properties) {
            this._props = properties != null && ((Hashtable)properties).size() > 0 ? properties : null;
        }

        public void setLoadOnStartup(boolean bl) {
            this._startup = bl;
        }

        public void setName(String string) {
            this._name = SlashUtil.normalizeValue((String)string);
        }
    }

    public class ContextEntry
    implements IContextProperties,
    Cloneable {
        private String _name = null;
        private String _sessionMgrName = null;
        private Properties _sessionMgrArgs = null;
        private Properties _initArgs = null;
        private String _sessionCookie = "JSESSIONID";
        private int _respondCookieVersion = 0;
        private boolean _realPathFromRequest = false;
        private boolean _sessionExpireOnClose = false;
        private boolean _transparency = true;
        private boolean _inputStreamLengthCheck = true;
        private boolean _contentTypeIgnoredFromSSI = true;
        private int _nativeBufferSize = -1;
        private int _javaBufferSize = 8192;
        private int _reloadInterval = 5;
        private int _outputStreamFlushTimer = 0;
        private String _docRoot = null;
        private String _tempDir = null;
        private String _uri = null;
        private String _host = null;
        private String _ip = null;
        private String _authDB = "default";
        private String _classpath = null;
        private String _serverName = null;
        private boolean _singleCL = false;
        private boolean _isModified = false;
        private String _formEncodingHint = "j_encoding";
        private boolean _cookieEncoding = true;
        private boolean _useResponseCTforHeaders = false;
        private String _parameterEncoding = "auto";

        public ContextEntry() {
            if (File.pathSeparatorChar == '/') {
                this._tempDir = "/tmp";
            } else {
                this._tempDir = EnvUtil.getenv((String)"TEMP");
                if (this._tempDir == null) {
                    this._tempDir = "C:/TEMP";
                }
            }
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        void fill(String string, Properties properties) {
            String string2;
            Properties properties2 = null;
            String string3 = properties.getProperty(NSServletAdmin.context_pre_property + string + ".initArgs");
            this.setName(string);
            if (string3 != null) {
                properties2 = ResUtil.parsePropertyList((String)string3);
                this.setInitArgs(properties2);
            }
            if ((string2 = properties.getProperty(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_sessionmgr_property)) != null) {
                this.setSessionManagerClassName(string2);
            }
            if ((string2 = properties.getProperty(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_docRoot)) != null) {
                this.setDocRoot(string2);
            }
            if ((string2 = properties.getProperty(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_sessionmgr_args_property)) != null) {
                this.setSessionManagerArgs(ResUtil.parsePropertyList((String)string2));
            }
            if ((string2 = properties.getProperty(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_cookieVersion)) != null) {
                this.setRespondCookieVersion(Integer.parseInt(string2));
            } else {
                this.setRespondCookieVersion(0);
            }
            string2 = properties.getProperty(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_sessionexp);
            if (string2 != null) {
                this.setSessionExpireOnClose(Boolean.valueOf(string2));
            }
            if ((string2 = properties.getProperty(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_realpath)) != null) {
                this.setRealPathFromRequest(Boolean.valueOf(string2));
            }
            if ((string2 = properties.getProperty(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_transparency)) != null) {
                this.setIncludeTransparency(Boolean.valueOf(string2));
            }
            if ((string2 = properties.getProperty(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_tempDir)) != null) {
                this.setTempDir(string2);
            }
            if ((string2 = properties.getProperty(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_streamSize)) != null) {
                this.setNativeBufferSize(Integer.parseInt(string2));
            }
            if ((string2 = properties.getProperty(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_bufferSize)) != null) {
                this.setBufferSize(Integer.parseInt(string2));
            }
            if ((string2 = properties.getProperty(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_reloadInterval)) != null) {
                this.setReloadInterval(Integer.parseInt(string2));
            }
            if ((string2 = properties.getProperty(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_flushTimer)) != null) {
                this.setOutputStreamFlushTimer(Integer.parseInt(string2));
            }
            if ((string2 = properties.getProperty(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_uri)) != null) {
                this.setBaseURI(string2);
            }
            if ((string2 = properties.getProperty(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_host)) != null) {
                this.setHost(string2);
            }
            if ((string2 = properties.getProperty(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_ip)) != null) {
                this.setIPAddress(string2);
            }
            if ((string2 = properties.getProperty(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_authdb)) != null) {
                this.setAuthDB(string2);
            }
            if ((string2 = properties.getProperty(NSServletAdmin.context_pre_property + string + ".classpath")) != null) {
                this.setClassPath(string2);
            }
            if ((string2 = properties.getProperty(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_singleClassLoader)) != null) {
                this.setSingleClassLoader(Boolean.valueOf(string2));
            }
            if ((string2 = properties.getProperty(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_serverName)) != null) {
                this.setServerName(string2);
            }
            if ((string2 = properties.getProperty(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_parameterEncoding)) != null) {
                this.setParameterEncoding(string2);
            }
            if ((string2 = properties.getProperty(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_sessionCookie)) != null) {
                this.setSessionCookie(string2);
            }
            if ((string2 = properties.getProperty(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_isModified)) != null) {
                this.setIsModifiedCheckAggressive(Boolean.valueOf(string2));
            }
            if ((string2 = properties.getProperty(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_formEncodingHint)) != null) {
                this.setFormEncodingHint(string2);
            }
            if ((string2 = properties.getProperty(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_cookieEncoding)) != null) {
                this.setCookieEncoding(Boolean.valueOf(string2));
            }
            if ((string2 = properties.getProperty(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_useResponseCTforHeaders)) != null) {
                if (string2.equals("true") || string2.equals("on") || string2.equals("yes")) {
                    this.setuseResponseCTforHeaders(true);
                } else {
                    this.setuseResponseCTforHeaders(false);
                }
            }
        }

        public String getAuthDB() {
            return this._authDB;
        }

        public String getBaseURI() {
            return this._uri;
        }

        public int getBufferSize() {
            return this._javaBufferSize;
        }

        public String getClassPath() {
            return this._classpath;
        }

        public String getDocRoot() {
            return this._docRoot;
        }

        public String getFormEncodingHint() {
            return this._formEncodingHint;
        }

        public String getHost() {
            return this._host;
        }

        public String getIPAddress() {
            return this._ip;
        }

        public boolean getIncludeTransparency() {
            return this._transparency;
        }

        public Properties getInitArgs() {
            return this._initArgs;
        }

        public String getName() {
            return this._name;
        }

        public int getNativeBufferSize() {
            return this._nativeBufferSize;
        }

        public int getOutputStreamFlushTimer() {
            return this._outputStreamFlushTimer;
        }

        public String getParameterEncoding() {
            return this._parameterEncoding;
        }

        public String getParameterEncodingString() {
            return this._parameterEncoding;
        }

        public boolean getRealPathFromRequest() {
            return this._realPathFromRequest;
        }

        public int getReloadInterval() {
            return this._reloadInterval;
        }

        public int getRespondCookieVersion() {
            return this._respondCookieVersion;
        }

        public String getServerName() {
            return this._serverName;
        }

        public String getSessionCookie() {
            return this._sessionCookie;
        }

        public boolean getSessionExpireOnClose() {
            return this._sessionExpireOnClose;
        }

        public Properties getSessionManagerArgs() {
            return this._sessionMgrArgs;
        }

        public String getSessionManagerClassName() {
            return this._sessionMgrName;
        }

        public String getTempDir() {
            return this._tempDir;
        }

        public boolean getuseResponseCTforHeaders() {
            return this._useResponseCTforHeaders;
        }

        public boolean isCookieEncoding() {
            return this._cookieEncoding;
        }

        public boolean isModifiedCheckAggressive() {
            return this._isModified;
        }

        public boolean isSingleClassLoader() {
            return this._singleCL;
        }

        void legacy_fill(Properties properties) {
            String string = properties.getProperty(NSServletAdmin.config_docRoot);
            if (string != null) {
                this.setDocRoot(string);
            }
            if ((string = properties.getProperty(NSServletAdmin.sessionmgr_property)) != null) {
                this.setSessionManagerClassName(string);
            }
            if ((string = properties.getProperty(NSServletAdmin.sessionmgr_initargs)) != null) {
                this.setSessionManagerArgs(ResUtil.parsePropertyList((String)string));
            } else {
                this.setSessionManagerArgs(null);
            }
            string = properties.getProperty(NSServletAdmin.config_cookieVersion);
            if (string != null) {
                this.setRespondCookieVersion(Integer.parseInt(string));
            } else {
                this.setRespondCookieVersion(0);
            }
            string = properties.getProperty(NSServletAdmin.config_sessionexp);
            if (string != null) {
                this.setSessionExpireOnClose(Boolean.valueOf(string));
            }
            if ((string = properties.getProperty(NSServletAdmin.config_realpath)) != null) {
                this.setRealPathFromRequest(Boolean.valueOf(string));
            }
            if ((string = properties.getProperty(NSServletAdmin.config_reloadInterval)) != null) {
                this.setReloadInterval(Integer.parseInt(string));
            }
            if ((string = properties.getProperty(NSServletAdmin.config_bufferSize)) != null) {
                this.setBufferSize(Integer.parseInt(string));
            }
            if ((string = properties.getProperty(NSServletAdmin.config_singleClassLoader)) != null) {
                this.setSingleClassLoader(Boolean.valueOf(string));
            }
            if ((string = properties.getProperty(NSServletAdmin.config_useResponseCTforHeaders)) != null) {
                if (string.equals("true") || string.equals("on") || string.equals("yes")) {
                    this.setuseResponseCTforHeaders(true);
                } else {
                    this.setuseResponseCTforHeaders(false);
                }
            }
        }

        void save(PrintWriter printWriter) {
            Properties properties;
            String string = this.getName();
            String string2 = this.getDocRoot();
            if (string2 != null) {
                printWriter.println(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_docRoot + '=' + string2);
            }
            if ((string2 = this.getSessionManagerClassName()) != null) {
                printWriter.println(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_sessionmgr_property + '=' + string2);
                properties = this.getSessionManagerArgs();
                if (properties != null && ((Hashtable)properties).size() > 0) {
                    printWriter.print(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_sessionmgr_args_property + '=');
                    SlashUtil.printProps((PrintWriter)printWriter, (Properties)properties);
                }
            }
            if ((properties = this.getInitArgs()) != null && ((Hashtable)properties).size() > 0) {
                printWriter.print(NSServletAdmin.context_pre_property + string + ".initArgs" + '=');
                SlashUtil.printProps((PrintWriter)printWriter, (Properties)properties);
            }
            if (this.getRespondCookieVersion() != 0) {
                printWriter.println(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_cookieVersion + '=' + this.getRespondCookieVersion());
            }
            if (this.getSessionExpireOnClose()) {
                printWriter.println(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_sessionexp + '=' + this.getSessionExpireOnClose());
            }
            if (this.getRealPathFromRequest()) {
                printWriter.println(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_realpath + '=' + this.getRealPathFromRequest());
            }
            if (!this.getIncludeTransparency()) {
                printWriter.println(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_transparency + '=' + this.getIncludeTransparency());
            }
            if (this.getTempDir() != null) {
                printWriter.println(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_tempDir + '=' + this.getTempDir());
            }
            if (this.getBufferSize() != 0) {
                printWriter.println(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_bufferSize + '=' + this.getBufferSize());
            }
            if (this.getBufferSize() != -1) {
                printWriter.println(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_streamSize + '=' + this.getBufferSize());
            }
            if (this.getReloadInterval() != 5) {
                printWriter.println(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_reloadInterval + '=' + this.getReloadInterval());
            }
            if (this.getOutputStreamFlushTimer() != 0) {
                printWriter.println(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_flushTimer + '=' + this.getOutputStreamFlushTimer());
            }
            if (this.getBaseURI() != null) {
                printWriter.println(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_uri + '=' + this.getBaseURI());
            }
            if (this.getHost() != null) {
                printWriter.println(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_host + '=' + this.getHost());
            }
            if (this.getIPAddress() != null) {
                printWriter.println(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_ip + '=' + this.getIPAddress());
            }
            if (this.getAuthDB() != null) {
                printWriter.println(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_authdb + '=' + this.getAuthDB());
            }
            if (this.getClassPath() != null) {
                printWriter.println(NSServletAdmin.context_pre_property + string + ".classpath" + '=' + this.getClassPath());
            }
            if (this.isSingleClassLoader()) {
                printWriter.println(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_singleClassLoader + '=' + this.isSingleClassLoader());
            }
            printWriter.println(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_isModified + '=' + this.isModifiedCheckAggressive());
            if (this.getServerName() != null) {
                printWriter.println(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_serverName + '=' + this.getServerName());
            }
            if (this.getParameterEncodingString() != null) {
                printWriter.println(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_parameterEncoding + '=' + this.getParameterEncodingString());
            }
            if (this.getSessionCookie() != null) {
                printWriter.println(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_sessionCookie + '=' + this.getSessionCookie());
            }
            if (this.getFormEncodingHint() != null) {
                printWriter.println(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_formEncodingHint + '=' + this.getFormEncodingHint());
            }
            if (!this.isCookieEncoding()) {
                printWriter.println(NSServletAdmin.context_pre_property + string + NSServletAdmin.context_cookieEncoding + '=' + this.isCookieEncoding());
            }
            printWriter.println(NSServletAdmin.context_pre_property + string + ".name=" + string);
        }

        public void setAuthDB(String string) {
            this._authDB = SlashUtil.normalizeValue((String)string);
            if (this._authDB == null) {
                this._authDB = "default";
            }
        }

        public void setBaseURI(String string) {
            this._uri = SlashUtil.normalizeUriValue((String)string);
        }

        public void setBufferSize(int n) {
            this._javaBufferSize = n;
            if (n < 0) {
                this._javaBufferSize = 0;
            }
            if (n > 65536) {
                this._javaBufferSize = 65536;
            }
        }

        public void setClassPath(String string) {
            this._classpath = SlashUtil.normalizeValue((String)string);
        }

        public void setCookieEncoding(boolean bl) {
            this._cookieEncoding = bl;
        }

        public void setDocRoot(String string) {
            this._docRoot = SlashUtil.normalizeUriValue((String)string);
        }

        public void setFormEncodingHint(String string) {
            this._formEncodingHint = string;
        }

        public void setHost(String string) {
            this._host = SlashUtil.normalizeValue((String)string);
        }

        public void setIPAddress(String string) {
            this._ip = SlashUtil.normalizeValue((String)string);
        }

        public void setIncludeTransparency(boolean bl) {
            this._transparency = bl;
        }

        public void setInitArgs(Properties properties) {
            this._initArgs = properties;
        }

        public void setIsModifiedCheckAggressive(boolean bl) {
            this._isModified = bl;
        }

        public void setName(String string) {
            this._name = SlashUtil.normalizeValue((String)string);
        }

        public void setNativeBufferSize(int n) {
            if (n < 1024) {
                n = 1024;
            }
            if (n > 65536) {
                n = 65536;
            }
            this._nativeBufferSize = n;
        }

        public void setOutputStreamFlushTimer(int n) {
            this._outputStreamFlushTimer = n;
        }

        public void setParameterEncoding(String string) {
            this._parameterEncoding = string;
        }

        public void setRealPathFromRequest(boolean bl) {
            this._realPathFromRequest = bl;
        }

        public void setReloadInterval(int n) {
            this._reloadInterval = n;
            if (this._reloadInterval < 5) {
                this._reloadInterval = 5;
            }
            if (this._reloadInterval > 600) {
                this._reloadInterval = 600;
            }
        }

        public void setRespondCookieVersion(int n) {
            this._respondCookieVersion = n;
        }

        public void setServerName(String string) {
            this._serverName = SlashUtil.normalizeValue((String)string);
        }

        public void setSessionCookie(String string) {
            this._sessionCookie = SlashUtil.normalizeValue((String)string);
            if (this._sessionCookie == null) {
                this._sessionCookie = NSServletAdmin._defaultSessionCookieName;
            }
        }

        public void setSessionExpireOnClose(boolean bl) {
            this._sessionExpireOnClose = bl;
        }

        public void setSessionManagerArgs(Properties properties) {
            this._sessionMgrArgs = properties;
        }

        public void setSessionManagerClassName(String string) {
            this._sessionMgrName = SlashUtil.normalizeValue((String)string);
        }

        public void setSingleClassLoader(boolean bl) {
            this._singleCL = bl;
        }

        public void setTempDir(String string) {
            this._tempDir = SlashUtil.normalizeValue((String)string);
            if (string == null || !new File(string).isDirectory()) {
                if (File.pathSeparatorChar == '/') {
                    this._tempDir = "/tmp";
                } else {
                    this._tempDir = EnvUtil.getenv((String)"TEMP");
                    if (this._tempDir == null) {
                        this._tempDir = "C:/WINNT/TEMP";
                    }
                }
            }
        }

        public void setuseResponseCTforHeaders(boolean bl) {
            this._useResponseCTforHeaders = bl;
        }
    }

    public class AliasEntry {
        private String _name = null;
        private String _alias = null;
        private String _ip = null;
        private String _host = null;

        public String getAlias() {
            return this._alias;
        }

        public String getHost() {
            return this._host;
        }

        public String getIPAddress() {
            return this._ip;
        }

        public String getServletName() {
            return this._name;
        }

        public boolean isValid() {
            return this._alias != null && this._name != null;
        }

        public void setAlias(String string) {
            this._alias = SlashUtil.normalizeUriValue((String)string);
        }

        public void setHost(String string) {
            this._host = SlashUtil.normalizeValue((String)string);
        }

        public void setIPAddress(String string) {
            this._ip = SlashUtil.normalizeValue((String)string);
        }

        public void setServletName(String string) {
            this._name = SlashUtil.normalizeValue((String)string);
        }
    }

    public class AliasSet {
        private Hashtable host_ht = null;
        private Hashtable ip_ht = null;
        private AliasEntry root = null;

        public void add(AliasEntry aliasEntry, String string, String string2) {
            if (string != null) {
                if (this.host_ht == null) {
                    this.host_ht = new Hashtable();
                }
                this.host_ht.put(string, aliasEntry);
                int n = string.indexOf(46);
                if (n != -1) {
                    this.host_ht.put(string.substring(0, n), aliasEntry);
                }
            } else if (string2 != null) {
                if (this.ip_ht == null) {
                    this.ip_ht = new Hashtable();
                }
                this.ip_ht.put(string2, aliasEntry);
            } else {
                this.root = aliasEntry;
            }
        }

        public AliasEntry get(String string, String string2) {
            AliasEntry aliasEntry = null;
            if (string != null && this.host_ht != null) {
                aliasEntry = (AliasEntry)this.host_ht.get(string);
            } else if (string2 != null && this.ip_ht != null) {
                aliasEntry = (AliasEntry)this.ip_ht.get(string2);
            }
            if (aliasEntry == null) {
                aliasEntry = this.root;
            }
            return aliasEntry;
        }

        public Enumeration getAllAliases() {
            AliasEntry aliasEntry;
            Enumeration enumeration;
            Vector<AliasEntry> vector = new Vector<AliasEntry>();
            if (this.root != null) {
                vector.addElement(this.root);
            }
            if (this.host_ht != null) {
                enumeration = this.host_ht.elements();
                while (enumeration.hasMoreElements()) {
                    aliasEntry = (AliasEntry)enumeration.nextElement();
                    vector.addElement(aliasEntry);
                }
            }
            if (this.ip_ht != null) {
                enumeration = this.ip_ht.elements();
                while (enumeration.hasMoreElements()) {
                    aliasEntry = (AliasEntry)enumeration.nextElement();
                    vector.addElement(aliasEntry);
                }
            }
            return vector.elements();
        }

        public void remove(AliasEntry aliasEntry) {
            String string = aliasEntry.getHost();
            String string2 = aliasEntry.getIPAddress();
            if (this.host_ht != null && string != null) {
                this.host_ht.remove(string);
                int n = string.indexOf(46);
                if (n != -1) {
                    this.host_ht.remove(string.substring(0, n));
                }
            }
            if (this.ip_ht != null && string2 != null) {
                this.ip_ht.remove(string2);
            }
            if (aliasEntry == this.root) {
                this.root = null;
            }
        }
    }
}

