/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.ace;

import com.netscape.management.client.ace.ACIAttribute;
import com.netscape.management.client.ace.IACITab;
import com.netscape.management.client.components.ButtonFactory;
import com.netscape.management.client.components.DirBrowserDialog;
import com.netscape.management.client.components.Table;
import com.netscape.management.client.components.UIConstants;
import com.netscape.management.client.console.ConsoleHelp;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import netscape.ldap.LDAPAttributeSchema;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSchema;

class TargetTab
implements IACITab,
UIConstants {
    private static ResourceSet i18n = new ResourceSet("com.netscape.management.client.ace.ace");
    public static String BIND_PREFIX = "ldap:///";
    private static String KEYWORD_TARGETENTRY = "target";
    private static String KEYWORD_TARGETFILTER = "targetfilter";
    private static String KEYWORD_TARGETATTRS = "targetattr";
    private static String KEYWORD_OR = "or";
    private static String KEYWORD_AND = "and";
    private static String THIS_COMMAND = "THIS";
    private static String ALL_COMMAND = "ALL";
    private static String NONE_COMMAND = "NONE";
    private static LDAPSchema schema = null;
    private static int TAB_POSITION = 2;
    private JFrame parentFrame;
    private JButton thisEntryButton = null;
    private JButton browseButton = null;
    private JButton constructButton = null;
    private JButton allButton = null;
    private JButton noneButton = null;
    private JTextField entryField = new JTextField();
    private JTextField filterField = new JTextField();
    private String selectedACIAttrs = null;
    private AttributeTableModel attrTableModel;
    private Table attrTable;
    private JScrollPane sp;
    private ActionListener buttonListener = new ButtonActionListener();
    private LDAPConnection aciLdc;
    private String aciDN;
    private JPanel p = new JPanel();
    private boolean isInitialized = false;
    private String targetEntryEquality = "=";
    private String targetFilterEquality = "=";
    private String targetAttrEquality = "=";

    TargetTab() {
    }

    private static String i18n(String string) {
        return i18n.getString("target", string);
    }

    public void initialize(JFrame jFrame, LDAPConnection lDAPConnection, String string, LDAPConnection lDAPConnection2, String string2) {
        this.parentFrame = jFrame;
        this.aciLdc = lDAPConnection;
        this.aciDN = string;
    }

    public JComponent getComponent() {
        this.p.setPreferredSize(new Dimension(480, 260));
        return this.p;
    }

    public int getPreferredPosition() {
        return TAB_POSITION;
    }

    private JPanel createEntryPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JLabel jLabel = new JLabel(TargetTab.i18n("entryLabel"));
        jLabel.setLabelFor(this.entryField);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this.entryField, gridBagConstraints);
        jPanel.add(this.entryField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.thisEntryButton = ButtonFactory.createButton(TargetTab.i18n("thisEntry"), this.buttonListener, THIS_COMMAND);
        this.thisEntryButton.setToolTipText(TargetTab.i18n("thisEntry_tt"));
        gridBagLayout.setConstraints(this.thisEntryButton, gridBagConstraints);
        jPanel.add(this.thisEntryButton);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.browseButton = ButtonFactory.createPredefinedButton("BROWSE", this.buttonListener);
        this.browseButton.setToolTipText(TargetTab.i18n("browse_tt"));
        gridBagLayout.setConstraints(this.browseButton, gridBagConstraints);
        jPanel.add(this.browseButton);
        return jPanel;
    }

    private JPanel createFilterPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JLabel jLabel = new JLabel(TargetTab.i18n("filterLabel"));
        jLabel.setLabelFor(this.filterField);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this.filterField, gridBagConstraints);
        jPanel.add(this.filterField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.constructButton = ButtonFactory.createButton(TargetTab.i18n("construct"));
        this.constructButton.setEnabled(false);
        this.constructButton.setVisible(false);
        gridBagLayout.setConstraints(this.constructButton, gridBagConstraints);
        jPanel.add(this.constructButton);
        return jPanel;
    }

    private JPanel createAttributePanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JLabel jLabel = new JLabel(TargetTab.i18n("attrLabel"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.attrTableModel = new AttributeTableModel();
        this.attrTable = new Table((TableModel)this.attrTableModel, true);
        jLabel.setLabelFor(this.attrTable);
        TableColumn tableColumn = this.attrTable.getColumnModel().getColumn(0);
        tableColumn.setMinWidth(30);
        tableColumn.setMaxWidth(30);
        tableColumn.setResizable(false);
        this.sp = new JScrollPane(this.attrTable);
        this.sp.setPreferredSize(new Dimension(250, 150));
        gridBagLayout.setConstraints(this.sp, gridBagConstraints);
        jPanel.add(this.sp);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        JPanel jPanel2 = this.createButtonPanel();
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n = (int)(0.6 * TargetTab.this.sp.getSize().getWidth());
                TableColumn tableColumn = TargetTab.this.attrTable.getColumnModel().getColumn(1);
                tableColumn.setPreferredWidth(n);
            }
        });
        return jPanel;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.allButton = ButtonFactory.createButton(TargetTab.i18n("all"), this.buttonListener, ALL_COMMAND);
        this.allButton.setToolTipText(TargetTab.i18n("all_tt"));
        gridBagLayout.setConstraints(this.allButton, gridBagConstraints);
        jPanel.add(this.allButton);
        this.noneButton = ButtonFactory.createButton(TargetTab.i18n("none"), this.buttonListener, NONE_COMMAND);
        this.noneButton.setToolTipText(TargetTab.i18n("none_tt"));
        gridBagLayout.setConstraints(this.noneButton, gridBagConstraints);
        jPanel.add(this.noneButton);
        return jPanel;
    }

    public ACIAttribute[] aciChanged(ACIAttribute[] aCIAttributeArray, String string) throws Exception {
        Vector<Object> vector = new Vector<Object>();
        this.entryField.setText("");
        this.filterField.setText("");
        int n = 0;
        while (n < aCIAttributeArray.length) {
            Object object;
            Object object2;
            ACIAttribute aCIAttribute = aCIAttributeArray[n];
            if (aCIAttribute.getName().equalsIgnoreCase(KEYWORD_TARGETENTRY)) {
                String string2;
                object2 = aCIAttribute.getValue();
                this.targetEntryEquality = aCIAttribute.getOperator();
                if (((String)object2).startsWith(BIND_PREFIX)) {
                    object2 = ((String)object2).substring(BIND_PREFIX.length());
                }
                this.entryField.setText((String)object2);
                vector.addElement(aCIAttribute);
                if (n > 0 && ((string2 = ((ACIAttribute)(object = aCIAttributeArray[n - 1])).getOperator()).equalsIgnoreCase(KEYWORD_OR) || string2.equalsIgnoreCase(KEYWORD_AND))) {
                    vector.addElement(object);
                }
            } else if (aCIAttribute.getName().equalsIgnoreCase(KEYWORD_TARGETFILTER)) {
                this.targetFilterEquality = aCIAttribute.getOperator();
                this.filterField.setText(aCIAttribute.getValue());
                vector.addElement(aCIAttribute);
                if (n > 0 && (((String)(object = ((ACIAttribute)(object2 = aCIAttributeArray[n - 1])).getOperator())).equalsIgnoreCase(KEYWORD_OR) || ((String)object).equalsIgnoreCase(KEYWORD_AND))) {
                    vector.addElement(object2);
                }
            } else if (aCIAttribute.getName().equalsIgnoreCase(KEYWORD_TARGETATTRS)) {
                this.targetAttrEquality = aCIAttribute.getOperator();
                this.selectedACIAttrs = " " + aCIAttribute.getValue() + " ";
                vector.addElement(aCIAttribute);
                if (n > 0 && (((String)(object = ((ACIAttribute)(object2 = aCIAttributeArray[n - 1])).getOperator())).equalsIgnoreCase(KEYWORD_OR) || ((String)object).equalsIgnoreCase(KEYWORD_AND))) {
                    vector.addElement(object2);
                }
            }
            ++n;
        }
        if (this.selectedACIAttrs == null) {
            this.selectedACIAttrs = "*";
        }
        this.updateAttributeTable();
        if (this.attrTableModel != null && !this.attrTable.isEnabled()) {
            this.setAttrEditingEnabled(true);
        }
        return ACIAttribute.toArray(vector);
    }

    public String getTitle() {
        return TargetTab.i18n("title");
    }

    public void tabSelected() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        this.p.setBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9));
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.p.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        JPanel jPanel = this.createEntryPanel();
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.p.add(jPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        JPanel jPanel2 = this.createFilterPanel();
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        this.p.add(jPanel2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JPanel jPanel3 = this.createAttributePanel();
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        this.p.add(jPanel3);
        ButtonFactory.resizeButtons(this.browseButton, this.constructButton, this.allButton, this.noneButton);
        SchemaThread schemaThread = new SchemaThread(this.aciLdc);
        schemaThread.start();
    }

    public void helpInvoked() {
        ConsoleHelp.showContextHelp("ace-targets");
    }

    public void okInvoked() {
    }

    public void cancelInvoked() {
    }

    public StringBuffer createACI(StringBuffer stringBuffer) {
        String string;
        String string2 = this.filterField.getText();
        if (string2.length() > 0) {
            stringBuffer.insert(0, "(" + KEYWORD_TARGETFILTER + " " + this.targetFilterEquality + " " + string2 + ") \n");
        }
        if ((string = this.entryField.getText()).length() > 0) {
            stringBuffer.insert(0, "(" + KEYWORD_TARGETENTRY + " " + this.targetEntryEquality + " \"" + BIND_PREFIX + string + "\") \n");
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        if (this.attrTableModel == null || !this.attrTable.isEnabled()) {
            stringBuffer2.append(this.selectedACIAttrs.trim());
        } else {
            int n = this.attrTableModel.getRowCount();
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                Boolean bl = (Boolean)this.attrTableModel.getValueAt(n3, 0);
                if (bl.booleanValue()) {
                    if (n2 > 0) {
                        stringBuffer2.append(" || ");
                    }
                    stringBuffer2.append(this.attrTableModel.getValueAt(n3, 1));
                    ++n2;
                }
                ++n3;
            }
            this.targetAttrEquality = "=";
            if (n2 == n) {
                stringBuffer2 = new StringBuffer("*");
            } else if (n2 > n / 2) {
                stringBuffer2 = new StringBuffer();
                n2 = 0;
                int n4 = 0;
                while (n4 < n) {
                    Boolean bl = (Boolean)this.attrTableModel.getValueAt(n4, 0);
                    if (!bl.booleanValue()) {
                        if (n2 > 0) {
                            stringBuffer2.append(" || ");
                        }
                        stringBuffer2.append(this.attrTableModel.getValueAt(n4, 1));
                        ++n2;
                    }
                    ++n4;
                }
                this.targetAttrEquality = "!=";
            }
        }
        stringBuffer.insert(0, "(" + KEYWORD_TARGETATTRS + " " + this.targetAttrEquality + " \"" + stringBuffer2 + "\") \n");
        return stringBuffer;
    }

    private StringBuffer prepareAttrListForParsing(String string) {
        StringBuffer stringBuffer = new StringBuffer(" " + string + " ");
        int n = stringBuffer.length() - 1;
        int n2 = 0;
        while (n2 <= n) {
            if (stringBuffer.charAt(n2) == '|' && n2 < n && stringBuffer.charAt(n2 + 1) == '|') {
                stringBuffer.setCharAt(n2, ' ');
                stringBuffer.setCharAt(n2 + 1, ' ');
            }
            ++n2;
        }
        return stringBuffer;
    }

    private boolean isAllAttrsWildcard(StringBuffer stringBuffer) {
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringBuffer.length()) {
            if (stringBuffer.charAt(n3) == '*') {
                n = n3;
                ++n2;
            } else if (stringBuffer.charAt(n3) != ' ') {
                return false;
            }
            ++n3;
        }
        if (n2 == 1) {
            stringBuffer.setCharAt(n, ' ');
            return true;
        }
        return false;
    }

    private boolean hasAttr(StringBuffer stringBuffer, String string) {
        int n = stringBuffer.toString().indexOf(" " + string.toLowerCase() + " ");
        if (n >= 0) {
            int n2 = 0;
            while (n2 < string.length()) {
                int n3 = n + 1 + n2;
                stringBuffer.setCharAt(n3, ' ');
                ++n2;
            }
            return true;
        }
        return false;
    }

    private boolean isEmptyAttrList(StringBuffer stringBuffer) {
        int n = 0;
        while (n < stringBuffer.length()) {
            if (stringBuffer.charAt(n) != ' ') {
                Debug.println("ACI TargetTab: can not process the whole attr list: " + stringBuffer);
                return false;
            }
            ++n;
        }
        return true;
    }

    private synchronized void updateAttributeTable() throws Exception {
        AttributeTableModel attributeTableModel = this.attrTableModel;
        if (attributeTableModel == null) {
            return;
        }
        StringBuffer stringBuffer = this.prepareAttrListForParsing(this.selectedACIAttrs.toLowerCase());
        int n = attributeTableModel.getRowCount();
        boolean bl = this.targetAttrEquality.equals("=");
        boolean bl2 = this.isAllAttrsWildcard(stringBuffer);
        int n2 = 0;
        while (n2 < n) {
            Boolean bl3;
            boolean bl4 = bl;
            String string = (String)attributeTableModel.getValueAt(n2, 1);
            if (!bl2 && !this.hasAttr(stringBuffer, string)) {
                boolean bl5 = bl4 = !bl;
            }
            if ((bl3 = (Boolean)attributeTableModel.getValueAt(n2, 0)) != bl4) {
                attributeTableModel.setValueAt(new Boolean(bl4), n2, 0);
            }
            ++n2;
        }
        if (!this.isEmptyAttrList(stringBuffer)) {
            throw new Exception(TargetTab.i18n("attrListErr"));
        }
        attributeTableModel.fireTableDataChanged();
    }

    private void setAttrEditingEnabled(boolean bl) {
        this.noneButton.setEnabled(bl);
        this.allButton.setEnabled(bl);
        this.attrTable.setEnabled(bl);
        this.attrTable.setBackground(bl ? UIManager.getColor("window") : UIManager.getColor("control"));
    }

    private void populateAttributeTable() {
        AttributeTableModel attributeTableModel = this.attrTableModel;
        int n = 0;
        Enumeration enumeration = schema.getAttributes();
        while (enumeration.hasMoreElements()) {
            LDAPAttributeSchema lDAPAttributeSchema = (LDAPAttributeSchema)enumeration.nextElement();
            attributeTableModel.addRow(new Object[]{new Boolean(false), lDAPAttributeSchema.getName(), lDAPAttributeSchema.getOID()});
            if (n++ != 100) continue;
            n = 0;
            attributeTableModel.newRowsAdded(new TableModelEvent(attributeTableModel, 0, attributeTableModel.getRowCount() - 1, -1, 1));
        }
        attributeTableModel.newRowsAdded(new TableModelEvent(attributeTableModel, 0, attributeTableModel.getRowCount() - 1, -1, 1));
    }

    private void checkAll() {
        this.setAllState(true);
    }

    private void checkNone() {
        this.setAllState(false);
    }

    private void setAllState(boolean bl) {
        int n = this.attrTableModel.getRowCount();
        int n2 = 0;
        while (n2 < n) {
            this.attrTableModel.setValueAt(new Boolean(bl), n2, 0);
            ++n2;
        }
        this.attrTableModel.fireTableDataChanged();
    }

    public ACIAttribute[] getSupportedAttributes() {
        return new ACIAttribute[]{new ACIAttribute(KEYWORD_TARGETENTRY, "=|!=", "\"" + BIND_PREFIX + " \""), new ACIAttribute(KEYWORD_TARGETFILTER, "=|!=", "\" \""), new ACIAttribute(KEYWORD_TARGETATTRS, "=|!=", "\" \"")};
    }

    class SchemaThread
    extends Thread {
        LDAPConnection ldc;
        static /* synthetic */ Class class$javax$swing$JDialog;

        public SchemaThread(LDAPConnection lDAPConnection) {
            this.ldc = lDAPConnection;
            this.setPriority(1);
        }

        public void run() {
            TargetTab.this.attrTable.setCursor(Cursor.getPredefinedCursor(3));
            TargetTab.this.setAttrEditingEnabled(false);
            try {
                if (schema == null) {
                    schema = new LDAPSchema();
                    schema.fetchSchema(this.ldc);
                }
                if (TargetTab.this.attrTableModel.getRowCount() == 0) {
                    TargetTab.this.populateAttributeTable();
                }
                try {
                    TargetTab.this.updateAttributeTable();
                }
                catch (Exception exception) {
                    TargetTab.this.attrTable.setCursor(Cursor.getDefaultCursor());
                    Container container = SwingUtilities.getAncestorOfClass(class$javax$swing$JDialog == null ? (class$javax$swing$JDialog = SchemaThread.class$("javax.swing.JDialog")) : class$javax$swing$JDialog, TargetTab.this.attrTable);
                    String string = TargetTab.i18n("attrListErr");
                    String string2 = i18n.getString("ed", "visualFailedTitle");
                    SwingUtilities.invokeLater(new Runnable(this, container, string, string2){
                        private final /* synthetic */ Container val$parent;
                        private final /* synthetic */ String val$msg;
                        private final /* synthetic */ String val$title;
                        private final /* synthetic */ SchemaThread this$1;
                        {
                            this.this$1 = schemaThread;
                            this.val$parent = container;
                            this.val$msg = string;
                            this.val$title = string2;
                        }

                        public void run() {
                            JOptionPane.showMessageDialog(this.val$parent, this.val$msg, this.val$title, 0);
                        }
                    });
                    return;
                }
            }
            catch (LDAPException lDAPException) {
                schema = null;
                System.err.println("ACI TargetTab: unable to read schema\nException: " + (Object)((Object)lDAPException));
            }
            TargetTab.this.setAttrEditingEnabled(true);
            TargetTab.this.attrTable.setCursor(Cursor.getDefaultCursor());
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    class AttributeTableModel
    extends DefaultTableModel {
        static /* synthetic */ Class class$java$lang$Boolean;
        static /* synthetic */ Class class$java$lang$String;

        public AttributeTableModel() {
            this.addColumn("");
            this.addColumn(TargetTab.i18n("columnName"));
            this.addColumn(TargetTab.i18n("columnDesc"));
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = AttributeTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            return class$java$lang$String == null ? (class$java$lang$String = AttributeTableModel.class$("java.lang.String")) : class$java$lang$String;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public void addRow(Vector vector) {
            if (vector == null) {
                vector = new Vector(this.getColumnCount());
            } else {
                vector.setSize(this.getColumnCount());
            }
            this.dataVector.addElement(vector);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    class ButtonActionListener
    implements ActionListener {
        ButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("BROWSE")) {
                DirBrowserDialog dirBrowserDialog = new DirBrowserDialog(TargetTab.this.parentFrame, TargetTab.this.aciLdc);
                dirBrowserDialog.show();
                TargetTab.this.entryField.setText(dirBrowserDialog.getSelectedDN());
            } else if (string.equals(THIS_COMMAND)) {
                TargetTab.this.entryField.setText(TargetTab.this.aciDN);
            } else if (string.equals(ALL_COMMAND)) {
                TargetTab.this.checkAll();
            } else if (string.equals(NONE_COMMAND)) {
                TargetTab.this.checkNone();
            }
        }
    }
}

