/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.acleditor;

import com.netscape.management.client.acleditor.ACLEditorWindow;
import com.netscape.management.client.acleditor.CallbackAction;
import com.netscape.management.client.acleditor.DataModelAdapter;
import com.netscape.management.client.acleditor.DataModelFactory;
import com.netscape.management.client.acleditor.SelectionListener;
import com.netscape.management.client.acleditor.Table;
import com.netscape.management.client.acleditor.TableDataModel;
import com.netscape.management.client.acleditor.WindowFactory;
import com.netscape.management.client.console.ConsoleInfo;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class ACLRuleTableWindow
extends ACLEditorWindow
implements SelectionListener {
    protected static Dimension TableSize = new Dimension(600, 200);
    protected Thread thread;
    protected ConsoleInfo info;
    protected DataModelFactory dataFactory;
    protected WindowFactory windowFactory;
    protected Table table;
    protected Table inheritedTable;
    protected JPanel inheritedPanel;

    public ACLRuleTableWindow(ConsoleInfo consoleInfo, DataModelFactory dataModelFactory, WindowFactory windowFactory, String string) {
        super(windowFactory, "main", string);
        this.info = consoleInfo;
        this.dataFactory = dataModelFactory;
        this.windowFactory = windowFactory;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(10, 15, 10, 15);
        this._add(this.createInstruction("table"), gridBagConstraints);
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 15, 0, 15);
        this._add(this.createHorizontalLine(), gridBagConstraints);
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        JPanel jPanel = new JPanel(new FlowLayout(0, 10, 10));
        jPanel.add(this.createButton("add", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ACLRuleTableWindow.this.table.addRow();
            }
        }));
        jPanel.add(this.createButton("delete", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ACLRuleTableWindow.this.table.deleteRow();
            }
        }));
        jPanel.add(this.createCheckBox("show", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ACLRuleTableWindow.this.showInheritedRulesSelect(actionEvent);
            }
        }));
        this._add(jPanel, gridBagConstraints);
        DataModelAdapter dataModelAdapter = this.dataFactory.getInheritedTableDataModel(this.info);
        if (dataModelAdapter != null) {
            this.resetConstraints(gridBagConstraints);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.ipady = 0;
            this.inheritedPanel = new JPanel(new GridLayout(1, 1, 0, 0));
            this._add(this.inheritedPanel, gridBagConstraints);
            this.inheritedTable = new Table(dataModelAdapter);
            this.inheritedTable.getJTable().setRowSelectionAllowed(false);
        } else {
            this.inheritedTable = null;
        }
        DataModelAdapter dataModelAdapter2 = this.dataFactory.getTableDataModel(this.info, this.windowFactory);
        this.table = new Table(dataModelAdapter2);
        this.table.addSelectionListener(this);
        this.table.setMouseOverFocusEnabled();
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.8;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 15, 0, 15);
        this._add(this.table, gridBagConstraints);
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        jPanel = new JPanel(new FlowLayout(0, 10, 10));
        jPanel.add(this.createButton("check", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ACLRuleTableWindow.this.checkSyntax(actionEvent);
            }
        }));
        if (((TableDataModel)dataModelAdapter2).isTestACLAvailable()) {
            jPanel.add(this.createButton("test", new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ACLRuleTableWindow.this.testACL(actionEvent);
                }
            }));
        }
        jPanel.add(this.createButton("establish", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ACLRuleTableWindow.this.establishAttributes(actionEvent);
            }
        }));
        this._add(jPanel, gridBagConstraints);
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 15, 0, 15);
        this._add(this.createHorizontalLine(), gridBagConstraints);
        jPanel = this.createStandardFooter();
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this._add(jPanel, gridBagConstraints);
        this.table.getJTable().setSelectionMode(0);
        this.table.getJTable().getColumn("Rule").setMaxWidth(40);
        this.table.getJTable().getColumn("AllowDeny").setMaxWidth(80);
        this.table.getJTable().setPreferredScrollableViewportSize(TableSize);
        this.selectionNotify(-1, -1, 0, null);
        this.pack();
        if (this.inheritedTable != null) {
            this.setInheritedTableVisibility(false);
        } else {
            this.getComponent("show").setEnabled(false);
        }
    }

    protected void setInheritedTableVisibility(boolean bl) {
        GridBagLayout gridBagLayout = (GridBagLayout)this.getContentPane().getLayout();
        GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints(this.inheritedPanel);
        if (bl) {
            this.inheritedPanel.add(this.inheritedTable);
            gridBagConstraints.insets = new Insets(0, 10, 15, 10);
        } else {
            this.inheritedPanel.remove(this.inheritedTable);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        }
        gridBagLayout.setConstraints(this.inheritedPanel, gridBagConstraints);
        this.pack();
    }

    public void selectionNotify(int n, int n2, int n3, CallbackAction callbackAction) {
        boolean bl = n != -1 && n2 != -1;
        this.getComponent("delete").setEnabled(bl);
        if (callbackAction != null) {
            callbackAction.go(null);
        }
    }

    protected void showInheritedRulesSelect(ActionEvent actionEvent) {
        this.setInheritedTableVisibility(((JCheckBox)this.getComponent("show")).isSelected());
    }

    protected void cancel(ActionEvent actionEvent) {
        TableDataModel tableDataModel = (TableDataModel)this.table.getDataModelAdapter();
        tableDataModel.dispose();
        super.cancel(actionEvent);
    }

    protected void save(ActionEvent actionEvent) {
        TableDataModel tableDataModel = (TableDataModel)this.table.getDataModelAdapter();
        try {
            tableDataModel.saveData();
        }
        catch (Exception exception) {
            this.showErrorDialog(exception);
            return;
        }
        tableDataModel.dispose();
        super.save(actionEvent);
    }

    protected void checkSyntax(ActionEvent actionEvent) {
        ((TableDataModel)this.table.getDataModelAdapter()).showSyntaxWindow(new CallbackAction(){

            public void callback(Object object) {
                ACLRuleTableWindow.this.repaint(0L);
            }
        });
    }

    protected void establishAttributes(ActionEvent actionEvent) {
        ((TableDataModel)this.table.getDataModelAdapter()).showAttributesWindow(new CallbackAction(){

            public void callback(Object object) {
                ACLRuleTableWindow.this.repaint(0L);
            }
        });
    }

    protected void testACL(ActionEvent actionEvent) {
        ((TableDataModel)this.table.getDataModelAdapter()).showTestACLWindow(new CallbackAction(){

            public void callback(Object object) {
                ACLRuleTableWindow.this.repaint(0L);
            }
        });
    }
}

