/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.acleditor;

import com.netscape.management.client.acl.AttributeList;
import com.netscape.management.client.acl.Rule;
import com.netscape.management.client.acleditor.DataModelAdapter;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiCheckCellEditor;
import com.netscape.management.nmclf.SuiCheckCellRenderer;
import java.util.Enumeration;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class RightsDataModel
extends DataModelAdapter {
    protected static final String NoRightsSelectedError = "NoneSelected";
    protected static final int checkBoxWidth = 20;
    protected static final int numColumns = 2;
    protected AttributeList datacopy;
    protected Rule rule;
    protected String[] rights;
    protected static String[] defaultRights = new String[]{"read", "write", "add", "delete", "search", "compare", "selfwrite"};

    protected String allString() {
        return "all";
    }

    public RightsDataModel(ResourceSet resourceSet, String string, Rule rule) {
        this(resourceSet, string, rule, defaultRights);
    }

    public RightsDataModel(ResourceSet resourceSet, String string, Rule rule, String[] stringArray) {
        super(resourceSet, string);
        this.setHeaderVisible(false);
        this.rule = rule;
        this.rights = stringArray;
        this.datacopy = new AttributeList(this.rule.getRightsList());
        if (this.datacopy.containsAttribute(this.allString())) {
            this.datacopy.removeAttribute(this.allString());
            this.setAllSelected(true);
        }
    }

    public TableCellRenderer getColumnCellRenderer(int n) {
        switch (n) {
            case 0: {
                SuiCheckCellRenderer suiCheckCellRenderer = new SuiCheckCellRenderer();
                suiCheckCellRenderer.getCheckBox().setToolTipText(this.getColumnToolTip(n));
                return suiCheckCellRenderer;
            }
        }
        return super.getColumnCellRenderer(n);
    }

    public TableCellEditor getColumnCellEditor(int n) {
        switch (n) {
            case 0: {
                SuiCheckCellEditor suiCheckCellEditor = new SuiCheckCellEditor();
                suiCheckCellEditor.getCheckBox().setToolTipText(this.getColumnToolTip(n));
                return suiCheckCellEditor;
            }
        }
        return null;
    }

    public int getColumnWidth(int n) {
        switch (n) {
            case 0: {
                return 20;
            }
        }
        return -1;
    }

    public int getRowCount() {
        return this.rights.length;
    }

    public int getColumnCount() {
        return 2;
    }

    public Object getValueAt(int n, int n2) {
        int n3 = n2;
        switch (n3) {
            case 0: {
                return new Boolean(this.datacopy.containsAttribute(this.rights[n]));
            }
            case 1: {
                return this.resources.getString(this.name, this.rights[n] + "Right");
            }
        }
        System.out.println("RightsDataModel:getValueAt():invalid column");
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        int n3 = n2;
        switch (n3) {
            case 0: {
                Boolean bl = (Boolean)object;
                if (bl.booleanValue()) {
                    this.datacopy.setAttribute(this.rights[n]);
                } else {
                    this.datacopy.removeAttribute(this.rights[n]);
                }
                return;
            }
            case 1: {
                return;
            }
        }
        System.out.println("RightsDataModel:getValueAt():invalid column");
    }

    protected void addRow(int n) {
    }

    protected void deleteRow(int n) {
    }

    protected void moveRow(int n, boolean bl) {
    }

    protected String complete() {
        int n = this.datacopy.size();
        if (n == 0) {
            return NoRightsSelectedError;
        }
        if (n == this.rights.length) {
            this.datacopy.removeAll();
            this.datacopy.setAttribute(this.allString());
        }
        AttributeList attributeList = this.rule.getRightsList();
        Enumeration enumeration = attributeList.keys();
        while (enumeration.hasMoreElements()) {
            this.rule.unSetRight((String)enumeration.nextElement());
        }
        enumeration = this.datacopy.keys();
        while (enumeration.hasMoreElements()) {
            this.rule.setRight((String)enumeration.nextElement());
        }
        return null;
    }

    protected void toggleSelectAll() {
        this.setAllSelected(!this.getAllSelectedValue());
    }

    protected void setAllSelected(boolean bl) {
        if (!bl) {
            this.datacopy.removeAll();
            return;
        }
        int n = 0;
        while (n < this.rights.length) {
            this.datacopy.setAttribute(this.rights[n]);
            ++n;
        }
    }

    protected boolean getAllSelectedValue() {
        return this.datacopy.size() == this.rights.length;
    }
}

