/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.components;

import com.netscape.management.client.components.DirNode;
import com.netscape.management.client.components.IDirContentListener;
import com.netscape.management.client.components.IDirModel;
import com.netscape.management.client.components.IDirNode;
import com.netscape.management.client.components.RootDirNode;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSchema;

public class DirModel
implements IDirModel,
IDirContentListener,
Serializable {
    private boolean _callContentChanged = true;
    static ResourceSet _resource = new ResourceSet("com.netscape.management.client.components.components");
    private static final String _section = "dirBrowser";
    private LDAPConnection _ldc;
    private LDAPSchema _schema = null;
    private static LDAPControl _manageDSAITControl = new LDAPControl("2.16.840.1.113730.3.4.2", true, null);
    private IDirNode _root = null;
    private boolean _followReferrals = true;
    private boolean _allowLeafNodes = false;
    private Hashtable _cContainers = null;
    private String _childFilter;
    protected EventListenerList _listenerList = new EventListenerList();
    private boolean _showPrivateSuffixes = true;
    private static Hashtable _icons = new Hashtable();
    private static String _defaultImageName = DirModel.initDefaultIconName();
    private static String _defaultFolderImageName = DirModel.initDefaultFolderIconName();
    static /* synthetic */ Class class$javax$swing$event$TreeModelListener;

    public DirModel() {
        this.setChildFilter(this.initializeChildFilter());
    }

    public DirModel(LDAPConnection lDAPConnection) {
        this();
        this.setLDAPConnection(lDAPConnection);
    }

    public DirModel(Object object, LDAPConnection lDAPConnection) {
        this(lDAPConnection);
        this.initialize(object);
    }

    private String initializeChildFilter() {
        Hashtable hashtable = this.getContainers();
        String string = "(|(&(numsubordinates=*)(numsubordinates>=1))";
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string = string + "(objectclass=" + (String)enumeration.nextElement() + ")";
        }
        string = string + ")";
        Debug.println("DirModel.initializeChildFilter: " + string);
        return string;
    }

    public boolean getAllowsLeafNodes() {
        return this._allowLeafNodes;
    }

    public void setAllowsLeafNodes(boolean bl) {
        if (bl) {
            this.setChildFilter("|(objectclass=*)(objectclass=ldapsubentry)");
        } else {
            this.setChildFilter(this.initializeChildFilter());
        }
        this._allowLeafNodes = bl;
        if (this._callContentChanged) {
            this.contentChanged();
        }
    }

    public String getChildFilter() {
        return this._childFilter;
    }

    public void setChildFilter(String string) {
        this._childFilter = string;
    }

    public void initialize(Object object) {
        if (object == null) {
            object = new RootDirNode((IDirModel)this, this.getShowsPrivateSuffixes());
            Debug.println(9, "DirModel.initialize: new root");
        } else {
            ((DirNode)object).setModel(this);
            Debug.println(9, "DirModel.initialize: old root=" + object);
        }
        this.setRoot(object);
    }

    public Object getChild(Object object, int n) {
        IDirNode iDirNode = (IDirNode)object;
        return iDirNode.getChildAt(n);
    }

    public int getChildCount(Object object) {
        IDirNode iDirNode = (IDirNode)object;
        return iDirNode.getChildCount();
    }

    public int getIndexOfChild(Object object, Object object2) {
        return ((IDirNode)object).getIndex((IDirNode)object2);
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this._listenerList.add(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = DirModel.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this._listenerList.remove(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = DirModel.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, treeModelListener);
    }

    public void fireTreeNodeChanged(DirNode dirNode) {
        Object[] objectArray = this._listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$TreeModelListener == null ? DirModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) {
                if (treeModelEvent == null) {
                    treeModelEvent = new TreeModelEvent((Object)this, dirNode.getPath());
                }
                TreeModelListener treeModelListener = (TreeModelListener)objectArray[n + 1];
                treeModelListener.treeNodesChanged(treeModelEvent);
            }
            n -= 2;
        }
    }

    public void fireTreeStructureChanged(IDirNode iDirNode) {
        Object[] objectArray = this._listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$TreeModelListener == null ? DirModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) {
                if (treeModelEvent == null) {
                    treeModelEvent = new TreeModelEvent((Object)this, ((DirNode)iDirNode).getPath());
                }
                TreeModelListener treeModelListener = (TreeModelListener)objectArray[n + 1];
                treeModelListener.treeStructureChanged(treeModelEvent);
            }
            n -= 2;
        }
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public boolean isLeaf(Object object) {
        IDirNode iDirNode = (IDirNode)object;
        return iDirNode.isLeaf();
    }

    public void contentChanged() {
        this.newTree();
    }

    void repaintObject(IDirNode iDirNode) {
        Debug.println("DirModel.repaintObject: " + iDirNode);
        this.fireTreeStructureChanged((DirNode)iDirNode);
    }

    private void newTree() {
        RootDirNode rootDirNode = new RootDirNode((IDirModel)this, "", this.getShowsPrivateSuffixes());
        Debug.println(9, "DirModel.newTree: new root");
        this.setRoot(rootDirNode);
        this.refreshTree();
    }

    private void refreshNode(IDirNode iDirNode) {
        iDirNode.load();
        this.repaintObject(iDirNode);
    }

    private void refreshTree() {
        this.refreshNode((IDirNode)this.getRoot());
    }

    public LDAPConnection getLDAPConnection() {
        return this._ldc;
    }

    public void setLDAPConnection(LDAPConnection lDAPConnection) {
        if (this._ldc != null) {
            try {
                this._ldc.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._ldc = lDAPConnection == null ? null : (LDAPConnection)lDAPConnection.clone();
    }

    protected void finalize() {
        if (this._ldc != null) {
            try {
                this._ldc.disconnect();
                this._ldc = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Object getRoot() {
        return this._root;
    }

    public void setRoot(Object object) {
        this._root = (IDirNode)object;
    }

    public boolean getReferralsEnabled() {
        return this._followReferrals;
    }

    public void setReferralsEnabled(boolean bl) {
        this._followReferrals = bl;
    }

    public LDAPSchema getSchema() {
        if (this._schema == null) {
            this._schema = new LDAPSchema();
            try {
                this._schema.fetchSchema(this.getLDAPConnection());
            }
            catch (LDAPException lDAPException) {
                Debug.println("DirModel.getSchema: " + (Object)((Object)lDAPException));
                this._schema = null;
            }
        }
        return this._schema;
    }

    public void setSchema(LDAPSchema lDAPSchema) {
        this._schema = lDAPSchema;
    }

    public boolean getShowsPrivateSuffixes() {
        return this._showPrivateSuffixes;
    }

    public void setShowsPrivateSuffixes(boolean bl) {
        this._showPrivateSuffixes = bl;
        if (this._callContentChanged) {
            this.contentChanged();
        }
    }

    private static Hashtable initContainerNames() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = _resource.getString(_section, "containers");
        Debug.println("DirModel.initContainerNames");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().toLowerCase();
                Debug.println("  added container type " + string2);
                hashtable.put(string2, string2);
            }
        }
        return hashtable;
    }

    public void addContainerName(String string) {
        this._cContainers.put(string, string);
    }

    public Hashtable getContainers() {
        if (this._cContainers == null) {
            this._cContainers = DirModel.initContainerNames();
        }
        return this._cContainers;
    }

    public ImageIcon checkIcon(Hashtable hashtable, boolean bl) {
        Object object;
        String string = "";
        String string2 = "";
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = ((String)enumeration.nextElement()).toLowerCase();
            string = (String)_icons.get(object);
            if (string == null) {
                string = _resource.getString(_section, (String)object + "-icon");
                string2 = _resource.getString(_section, (String)object + "-icon-description");
                if (string == null) {
                    string = "";
                }
                _icons.put(object, string);
            }
            if (!string.equals("")) break;
        }
        if (string.equals("")) {
            if (bl) {
                string = _defaultImageName;
                string2 = _resource.getString(_section, "default-icon-description");
            } else {
                string = _defaultFolderImageName;
                string2 = _resource.getString(_section, "default-folder-icon-description");
            }
        }
        object = new RemoteImage("com/netscape/management/client/images/" + string);
        ((ImageIcon)object).setDescription(string2);
        return object;
    }

    public void setObjectClassIcon(String string, String string2) {
        _icons.put(string, string2);
        if (this._callContentChanged) {
            this.contentChanged();
        }
    }

    private static String initDefaultIconName() {
        String string = _resource.getString(_section, "default-icon");
        if (string == null) {
            string = "genobject.gif";
        }
        return string;
    }

    private static String initDefaultFolderIconName() {
        String string = _resource.getString(_section, "default-folder-icon");
        if (string == null) {
            string = "folder.gif";
        }
        return string;
    }

    void setCallContentChanged(boolean bl) {
        this._callContentChanged = bl;
    }

    boolean getCallContentChanged() {
        return this._callContentChanged;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

