/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.components;

import com.netscape.management.client.components.GenericDialog;
import com.netscape.management.client.components.UIConstants;
import com.netscape.management.client.util.JButtonFactory;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class StatusDialog
extends GenericDialog
implements UIConstants {
    public static final int CLOSE = 1;
    public static final int STOP = 2;
    public static final int CLOSE_STOP = 3;
    public static final int CONFIRM_NONE = 0;
    public static final int CONFIRM_CLOSE = 1;
    public static final int CONFIRM_STOP = 2;
    private Frame parentFrame;
    private String lblClose = StatusDialog.i18n("close");
    private String lblStop = StatusDialog.i18n("stop");
    private String lblDetails = StatusDialog.i18n("details");
    private int confirmationFlags = 0;
    private JButton closeButton;
    private JButton stopButton;
    private JButton detailButton;
    private JLabel iconLabel = new JLabel();
    private JLabel descriptionLabel = new JLabel();
    private JLabel progressLabel = new JLabel();
    private JProgressBar progressBar = new JProgressBar();
    private Container contentPane;
    private JComponent detailComponent = null;
    private boolean isDetailVisible = true;
    private boolean isInitialized = false;
    private int showDelay = 0;
    private int hideDelay = 0;
    private Timer showTimer = null;
    private Timer hideTimer = null;
    private long showStartTime = 0L;
    private static ResourceSet resource = new ResourceSet("com.netscape.management.client.components.components");

    private static String i18n(String string) {
        return resource.getString("statusDialog", string);
    }

    public StatusDialog(JFrame jFrame, String string, String string2) {
        super(jFrame, string, 0);
        this.setModal(false);
        this.parentFrame = jFrame;
        this.descriptionLabel.setText(string2);
    }

    public void show() {
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.initialize();
        }
        super.show();
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.showStartTime = System.currentTimeMillis();
            if (this.hideTimer != null) {
                this.hideTimer.stop();
                this.hideTimer = null;
            }
            if (this.showDelay > 0 && this.showTimer == null && this.getProgressValue() < 100) {
                this.showTimer = new Timer(this.showDelay, new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        StatusDialog.this.setVisible(true);
                    }
                });
                this.showTimer.setRepeats(false);
                this.showTimer.start();
                return;
            }
        } else if (!bl) {
            if (this.showTimer != null) {
                this.showTimer.stop();
                this.showTimer = null;
            }
            int n = (int)(System.currentTimeMillis() - this.showStartTime);
            if (this.hideDelay > 0 && this.hideTimer == null && n < this.hideDelay) {
                this.hideTimer = new Timer(this.hideDelay - n, new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        StatusDialog.this.setVisible(false);
                    }
                });
                this.hideTimer.setRepeats(false);
                this.hideTimer.start();
                return;
            }
        }
        super.setVisible(bl);
    }

    private void initialize() {
        this.contentPane = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.contentPane.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.iconLabel, gridBagConstraints);
        this.contentPane.add(this.iconLabel);
        this.descriptionLabel.setHorizontalAlignment(0);
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.descriptionLabel, gridBagConstraints);
        this.contentPane.add(this.descriptionLabel);
        this.progressLabel.setHorizontalAlignment(0);
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.progressLabel, gridBagConstraints);
        this.contentPane.add(this.progressLabel);
        Dimension dimension = this.progressBar.getPreferredSize();
        dimension.width = Math.max(300, dimension.width);
        this.progressBar.setPreferredSize(dimension);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        gridBagLayout.setConstraints(this.progressBar, gridBagConstraints);
        this.contentPane.add(this.progressBar);
        this.detailComponent = this.createDetailComponent();
        if (this.detailComponent != null) {
            gridBagConstraints.insets = new Insets(6, 0, 0, 0);
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagLayout.setConstraints(this.detailComponent, gridBagConstraints);
            this.contentPane.add(this.detailComponent);
        }
        this.closeButton = JButtonFactory.create(this.lblClose, new CloseButtonActionListener(), "CLOSE");
        this.closeButton.setToolTipText(StatusDialog.i18n("close_tt"));
        this.stopButton = JButtonFactory.create(this.lblStop, new StopButtonActionListener(), "STOP");
        this.stopButton.setToolTipText(StatusDialog.i18n("stop_tt"));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 15;
        gridBagLayout.setConstraints(this.closeButton, gridBagConstraints);
        this.contentPane.add(this.closeButton);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        gridBagLayout.setConstraints(this.stopButton, gridBagConstraints);
        this.contentPane.add(this.stopButton);
        if (this.detailComponent != null) {
            this.detailButton = JButtonFactory.create(this.lblDetails + " <<", new DetailButtonActionListener(), "DETAIL");
            gridBagConstraints.insets = new Insets(6, 12, 0, 0);
            gridBagConstraints.gridy = 2;
            gridBagLayout.setConstraints(this.detailButton, gridBagConstraints);
            this.contentPane.add(this.detailButton);
        }
    }

    public void setDetailVisible(boolean bl) {
        if (this.detailComponent != null) {
            this.detailComponent.setVisible(bl);
            if (bl) {
                this.detailButton.setToolTipText(StatusDialog.i18n("details_hide_tt"));
            } else {
                this.detailButton.setToolTipText(StatusDialog.i18n("details_show_tt"));
            }
            this.validate();
        }
    }

    public boolean isDetailVisible() {
        if (this.detailComponent != null) {
            return this.detailComponent.isVisible();
        }
        return false;
    }

    public void setProgressBarVisible(boolean bl) {
        this.progressBar.setVisible(bl);
    }

    public boolean isProgressBarVisible() {
        return this.progressBar.isVisible();
    }

    public void setIcon(Icon icon) {
        this.iconLabel.setIcon(icon);
    }

    public void setProgressValue(int n) {
        this.progressBar.setValue(n);
    }

    public int getProgressValue() {
        return this.progressBar.getValue();
    }

    public void setProgressText(String string) {
        this.progressLabel.setText(string);
    }

    public String getProgressText() {
        return this.progressLabel.getText();
    }

    protected JComponent createDetailComponent() {
        return null;
    }

    public void setConfirmation(int n) {
        this.confirmationFlags = n;
    }

    public int getConfirmation() {
        return this.confirmationFlags;
    }

    public void setShowDelay(int n) {
        this.showDelay = n;
    }

    public int getShowDelay() {
        return this.showDelay;
    }

    public void setHideDelay(int n) {
        this.hideDelay = n;
    }

    public int getHideDelay() {
        return this.hideDelay;
    }

    class CloseButtonActionListener
    implements ActionListener {
        CloseButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if ((StatusDialog.this.confirmationFlags & 1) == 1) {
                int n = JOptionPane.showConfirmDialog(StatusDialog.this, StatusDialog.i18n("close_confirm"), StatusDialog.i18n("warning"), 0);
                if (n == 0) {
                    StatusDialog.this.setVisible(false);
                }
            } else {
                StatusDialog.this.setVisible(false);
            }
        }
    }

    class StopButtonActionListener
    implements ActionListener {
        StopButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if ((StatusDialog.this.confirmationFlags & 2) == 2) {
                int n = JOptionPane.showConfirmDialog(StatusDialog.this, StatusDialog.i18n("stop_confirm"), StatusDialog.i18n("warning"), 0);
                if (n == 0) {
                    StatusDialog.this.stopButton.setEnabled(false);
                    StatusDialog.this.closeButton.setEnabled(true);
                }
            } else {
                StatusDialog.this.stopButton.setEnabled(false);
                StatusDialog.this.closeButton.setEnabled(true);
            }
        }
    }

    class DetailButtonActionListener
    implements ActionListener {
        private boolean isDetailVisible = false;

        DetailButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StatusDialog.this.setDetailVisible(!StatusDialog.this.isDetailVisible());
        }
    }
}

