/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.topology;

import com.netscape.management.client.util.AbstractModalDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ProductSelectionDialog
extends AbstractModalDialog {
    public static final int DEFAULT_CONFIGURATION = 0;
    public static final int FOR_MIGRATION = 1;
    public static final int FOR_CLONING = 2;
    public static final int FOR_CREATION = 3;
    private static ResourceSet _resource = new ResourceSet("com.netscape.management.client.topology.topology");
    private JList _productList;
    private String[] _productInfo;
    private JLabel _prompt;
    private int _task;
    private Help _helpSession;
    private String _defaultTitle;
    private String _defaultPrompt;
    private String _defaultActionLabel;

    public ProductSelectionDialog(Frame frame) {
        this(frame, 0);
    }

    public ProductSelectionDialog(Frame frame, int n) {
        super(frame, "");
        this._task = n;
        this._helpSession = new Help(_resource);
        this._defaultTitle = _resource.getString("ProductSelectionDialog", "DefaultTitle");
        this._defaultPrompt = _resource.getString("ProductSelectionDialog", "DefaultPrompt");
        this._defaultActionLabel = _resource.getString("ProductSelectionDialog", "DefaultActionLabel");
        this._prompt = new JLabel();
        this.configure(this._task);
        this._productInfo = null;
        this._productList = new JList();
        this._productList.addMouseMotionListener(new DialogMouseMotionListener());
        this._productList.addListSelectionListener(new DialogListSelectionListener());
        this._productList.setSelectionMode(2);
        this._prompt.setLabelFor(this._productList);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().setView(this._productList);
        jScrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagUtil.constrain(jPanel, this._prompt, 0, 0, 0, 1, 1.0, 0.0, 17, 2, 0, 0, 0, 0);
        GridBagUtil.constrain(jPanel, jScrollPane, 0, 1, 0, 0, 1.0, 1.0, 17, 1, 0, 0, 0, 0);
        this.setPanel(jPanel);
        ((Component)this).setSize(475, 300);
        this.setMinimumSize(475, 300);
    }

    public void configure(int n) {
        this._task = n;
        if (n == 1) {
            this.setTitle(_resource.getString("ProductSelectionDialog", "MigrateTitle"));
            this._prompt.setText(_resource.getString("ProductSelectionDialog", "MigratePrompt"));
            this.setOKButtonText(_resource.getString("ProductSelectionDialog", "MigrateButtonLabel"));
        } else if (n == 2) {
            this.setTitle(_resource.getString("ProductSelectionDialog", "CloneTitle"));
            this._prompt.setText(_resource.getString("ProductSelectionDialog", "ClonePrompt"));
            this.setOKButtonText(_resource.getString("ProductSelectionDialog", "CloneButtonLabel"));
        } else if (n == 3) {
            this.setTitle(_resource.getString("ProductSelectionDialog", "CreateTitle"));
            this._prompt.setText(_resource.getString("ProductSelectionDialog", "CreatePrompt"));
            this.setOKButtonText(_resource.getString("ProductSelectionDialog", "CreateButtonLabel"));
        } else {
            this.setTitle(this._defaultTitle);
            this._prompt.setText(this._defaultPrompt);
            this.setOKButtonText(this._defaultActionLabel);
        }
        this.setOKButtonEnabled(false);
    }

    public void show() {
        ModalDialogUtil.setDialogLocation(this, null);
        this._productList.clearSelection();
        super.show();
    }

    public int getTask() {
        return this._task;
    }

    public int[] getSelectedIndices() {
        return this._productList.getSelectedIndices();
    }

    public Object[] getSelectedValues() {
        return this._productList.getSelectedValues();
    }

    public void setProductList(String[] stringArray) {
        this._productList.setListData(stringArray);
        this._productInfo = null;
    }

    public void setProductList(String[] stringArray, String[] stringArray2) {
        this._productList.setListData(stringArray);
        this.setProductInfo(stringArray2);
    }

    public void setProductInfo(String[] stringArray) {
        this._productInfo = stringArray;
    }

    public void helpInvoked() {
        if (this._task == 1) {
            this._helpSession.contextHelp("topology", "psd-migrate");
        } else if (this._task == 2) {
            this._helpSession.contextHelp("topology", "psd-clone");
        } else if (this._task == 3) {
            this._helpSession.contextHelp("topology", "psd-create");
        } else {
            Debug.println("ERROR ProductSelectionDialog.help: no help available for dialog task: " + this._task);
        }
    }

    class DialogListSelectionListener
    implements ListSelectionListener {
        DialogListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int[] nArray = ProductSelectionDialog.this._productList.getSelectedIndices();
            if (nArray.length == 0) {
                ProductSelectionDialog.this.setOKButtonEnabled(false);
            } else {
                ProductSelectionDialog.this.setOKButtonEnabled(true);
            }
        }
    }

    class DialogMouseMotionListener
    implements MouseMotionListener {
        DialogMouseMotionListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (ProductSelectionDialog.this._productInfo == null) {
                return;
            }
            int n = ProductSelectionDialog.this._productList.locationToIndex(mouseEvent.getPoint());
            if (n >= 0 && n < ProductSelectionDialog.this._productInfo.length) {
                ProductSelectionDialog.this._productList.setToolTipText(ProductSelectionDialog.this._productInfo[n]);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (ProductSelectionDialog.this._productInfo == null) {
                return;
            }
            int n = ProductSelectionDialog.this._productList.locationToIndex(mouseEvent.getPoint());
            if (n >= 0 && n < ProductSelectionDialog.this._productInfo.length) {
                ProductSelectionDialog.this._productList.setToolTipText(ProductSelectionDialog.this._productInfo[n]);
            }
        }
    }
}

