/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.topology;

import com.netscape.management.client.FrameworkInitializer;
import com.netscape.management.client.UIPermissions;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.topology.ITopologyPlugin;
import com.netscape.management.client.topology.TopologyModel;
import com.netscape.management.client.topology.TopologyResourcePage;
import com.netscape.management.client.topology.ug.UGPage;
import com.netscape.management.client.util.ClassLoaderUtil;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UITools;
import java.util.Enumeration;
import java.util.Hashtable;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class TopologyInitializer
extends FrameworkInitializer {
    public static String PERMID_UGTAB = "UGTabVisibility";
    public static String PERMID_UGEDIT = "UGEditing";
    public static String PERMID_TOPOEDIT = "TopologyEditing";
    public static String PERMID_SECURITY = "SecurityVisibility";
    public static String PERMID_CUSTOMVIEW = "CustomViewEditing";
    private static boolean canEditTopology = true;
    public static ResourceSet _resource = new ResourceSet("com.netscape.management.client.topology.topology");
    private ConsoleInfo consoleInfo;
    private static Hashtable topologyPlugin;
    private UIPermissions uip = null;

    private static String getPermString(String string) {
        return _resource.getString("Permissions", string);
    }

    public TopologyInitializer(ConsoleInfo consoleInfo) {
        this.consoleInfo = consoleInfo;
        this.setFrameTitle("Sun Java(TM) System Server Console");
        if (UITools.getOS().equals("Win32")) {
            this.setMinimizedImage(new RemoteImage("com/netscape/management/client/images/Console16x_JLF.gif").getImage());
        } else {
            this.setMinimizedImage(new RemoteImage("com/netscape/management/client/images/Console48x_CDE.gif").getImage());
        }
        this.setBannerImage(new RemoteImage("com/netscape/management/client/images/ConsoleBanner.gif").getImage());
        this.setBannerText(_resource.getString("topology", "version"));
        this.uip = new UIPermissions(LDAPUtil.getAdminGlobalParameterEntry());
        this.uip.addPermission(PERMID_UGTAB, TopologyInitializer.getPermString("UGTabName"), TopologyInitializer.getPermString("UGTabDesc"));
        this.uip.addPermission(PERMID_UGEDIT, TopologyInitializer.getPermString("UGEditName"), TopologyInitializer.getPermString("UGEditDesc"));
        this.uip.addPermission(PERMID_TOPOEDIT, TopologyInitializer.getPermString("TPEditName"), TopologyInitializer.getPermString("TPEditDesc"));
        this.uip.addPermission(PERMID_SECURITY, TopologyInitializer.getPermString("SecurityName"), TopologyInitializer.getPermString("SecurityDesc"));
        this.uip.addPermission(PERMID_CUSTOMVIEW, TopologyInitializer.getPermString("CustomViewName"), TopologyInitializer.getPermString("CustomViewDesc"));
        this.setUIPermissions(this.uip);
        canEditTopology = this.uip.hasPermission(PERMID_TOPOEDIT);
        this.setupTopologyPage();
        this.setupUserPage();
    }

    public static boolean canEditTopology() {
        return canEditTopology;
    }

    private void setupUserPage() {
        if (this.uip.hasPermission(PERMID_UGTAB)) {
            this.addPage(new UGPage(this.consoleInfo, this.uip.hasPermission(PERMID_UGEDIT)));
        }
    }

    private void setupTopologyPage() {
        TopologyInitializer.getTopologyPluginFromDS(this.consoleInfo);
        TopologyModel topologyModel = new TopologyModel(this.consoleInfo, canEditTopology);
        TopologyResourcePage topologyResourcePage = new TopologyResourcePage(this.consoleInfo, topologyModel, this.uip.hasPermission(PERMID_CUSTOMVIEW));
        topologyResourcePage.setPageTitle(_resource.getString("topology", "title"));
        this.addPage(topologyResourcePage);
    }

    public static Hashtable getTopologyPluginFromDS(ConsoleInfo consoleInfo) {
        String string = "cn=topologyplugin," + LDAPUtil.getAdminGlobalParameterEntry();
        topologyPlugin = new Hashtable();
        try {
            LDAPConnection lDAPConnection = consoleInfo.getLDAPConnection();
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string, 1, "objectclass=nstopologyplugin", null, false);
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("nsclassname");
                if (lDAPAttribute == null) continue;
                Enumeration enumeration = lDAPAttribute.getStringValues();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    Class clazz = ClassLoaderUtil.getClass((ConsoleInfo)consoleInfo, (String)string2);
                    if (clazz == null) continue;
                    try {
                        ITopologyPlugin iTopologyPlugin = (ITopologyPlugin)clazz.newInstance();
                        iTopologyPlugin.initialize(consoleInfo);
                        topologyPlugin.put(clazz.getName(), iTopologyPlugin);
                    }
                    catch (Exception exception) {
                        Debug.println("Cannot create: " + string2);
                    }
                }
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println("Cannot open: " + string);
        }
        return topologyPlugin;
    }

    public static Hashtable getNetworkTopologyPlugin() {
        return topologyPlugin;
    }

    public static void setNetworkTopologyPlugin(Hashtable hashtable) {
        topologyPlugin = hashtable;
    }
}

