/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class Debug {
    public static final String TYPE_GC = "memgc";
    public static final String TYPE_LDAP = "ldap";
    public static final String TYPE_HTTP = "http";
    public static final String TYPE_RSPTIME = "rsptime";
    public static final String KW_CREATE = "Create   ";
    public static final String KW_FINALIZE = "FINALIZE ";
    public static boolean _fTrace = false;
    public static int _iTraceLevel = 5;
    private static Vector _traceTypes;
    private static boolean _fTraceGC;
    private static boolean _fTraceLdap;
    private static boolean _fTraceHttp;
    private static boolean _fTraceTime;
    public static final int SHOW_INDEX = 1;
    public static final int SHOW_DEBUGLEVEL = 2;
    public static final int SHOW_TIMESTAMP = 4;
    private static int _showFlags;
    public static SimpleDateFormat _timeFormat;
    public static Vector _onFilter;
    public static Vector _offFilter;
    private static long _appStartTimeStamp;
    private static long _lastTimeStamp;
    private static int _iEntryIndex;
    private static int _showCaller;
    private static boolean _fPrintCallStack;

    public Debug() {
        _fTrace = false;
        _iTraceLevel = -1;
    }

    public static boolean gcTraceEnabled() {
        return _fTraceGC;
    }

    public static boolean ldapTraceEnabled() {
        return _fTraceLdap;
    }

    public static boolean httpTraceEnabled() {
        return _fTraceHttp;
    }

    public static boolean timeTraceEnabled() {
        return _fTraceTime;
    }

    public static int getShowFlags() {
        return _showFlags;
    }

    public static void setTrace(boolean bl) {
        _fTrace = bl;
        if (!_fTrace) {
            _iTraceLevel = -1;
        }
    }

    public static boolean getTrace() {
        return _fTrace;
    }

    public static boolean isEnabled() {
        return _fTrace;
    }

    public static void setTraceLevel(int n) {
        _iTraceLevel = n;
        if (_iTraceLevel >= 0) {
            _fTrace = true;
        }
    }

    public static int getTraceLevel() {
        return _iTraceLevel;
    }

    public static boolean setTraceMode(String string) {
        if (string == null) {
            _fTrace = true;
            _iTraceLevel = 5;
            return true;
        }
        String string2 = null;
        String string3 = string;
        int n = string.indexOf(58);
        if (n >= 0) {
            string2 = string.substring(n + 1);
            string3 = string.substring(0, n);
            if (string3.length() == 0) {
                _fTrace = true;
                _iTraceLevel = 5;
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        _traceTypes = new Vector();
        int n2 = 0;
        while (stringTokenizer.hasMoreElements()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.length() == 1 && string4.charAt(0) >= '0' && string4.charAt(0) <= '9') {
                _fTrace = true;
                _iTraceLevel = Integer.parseInt(string4);
            } else if (string4.equals(TYPE_GC)) {
                _fTraceGC = true;
                _traceTypes.addElement(string4);
            } else if (string4.equals(TYPE_LDAP)) {
                _fTraceLdap = true;
                _traceTypes.addElement(string4);
            } else if (string4.equals(TYPE_HTTP)) {
                _fTraceHttp = true;
                _traceTypes.addElement(string4);
            } else if (string4.equals(TYPE_RSPTIME)) {
                _fTraceTime = true;
                _showFlags |= 4;
                _traceTypes.addElement(string4);
                if (_appStartTimeStamp > 0L) {
                    System.out.println(_timeFormat.format(new Date(_appStartTimeStamp)) + " JVM Loaded");
                    _lastTimeStamp = _appStartTimeStamp;
                }
            } else {
                System.err.println("Bad trace type: " + string4);
                return false;
            }
            ++n2;
        }
        if (_traceTypes.size() == 0) {
            _traceTypes = null;
        }
        if (string2 == null) {
            return true;
        }
        stringTokenizer = new StringTokenizer(string2, ",");
        int n3 = 0;
        while (stringTokenizer.hasMoreElements()) {
            String string5;
            StringTokenizer stringTokenizer2;
            String string6 = stringTokenizer.nextToken();
            if (string6.equals("idx")) {
                _showFlags |= 1;
            } else if (string6.equals("lvl")) {
                _showFlags |= 2;
            } else if (string6.equals("ts")) {
                _showFlags |= 4;
            } else if (string6.equals("cls")) {
                _showCaller = 1;
            } else if (string6.equals("clf")) {
                _showCaller = 2;
            } else if (string6.equals("cs")) {
                _fPrintCallStack = true;
            } else if (string6.equals("all")) {
                _showFlags |= 0xFF;
                _showCaller = 1;
            } else if (string6.startsWith("on") && string6.length() > 3) {
                stringTokenizer2 = new StringTokenizer(string6.substring(3), String.valueOf(string6.charAt(2)));
                if (_onFilter == null) {
                    _onFilter = new Vector();
                }
                while (stringTokenizer2.hasMoreElements()) {
                    string5 = stringTokenizer2.nextToken();
                    _onFilter.addElement(string5);
                }
            } else if (string6.startsWith("off") && string6.length() > 4) {
                stringTokenizer2 = new StringTokenizer(string6.substring(4), String.valueOf(string6.charAt(3)));
                if (_offFilter == null) {
                    _offFilter = new Vector();
                }
                while (stringTokenizer2.hasMoreElements()) {
                    string5 = stringTokenizer2.nextToken();
                    _offFilter.addElement(string5);
                }
            } else {
                System.err.println("Bad trace flag: " + string6);
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static String getUsage() {
        String string = "\n-D option format: -D [<type1,type2,...>][:<flag1,flag2,...]";
        string = string + "\nPredefined Debug Types:";
        string = string + "\nn\t\tDebug level  0<=n<=9, 0 = min info, 9 = max info";
        string = string + "\nldap\t\tLDAP Calls";
        string = string + "\nhttp\t\tHTTP Calls";
        string = string + "\nmemgc\t\tGarbage Collection";
        string = string + "\nrsptime\t\tResponse Time";
        string = string + "\nDebug Flags:";
        string = string + "\nidx\t\tEnumerate debug entries";
        string = string + "\nlvl\t\tShow debug level for debug entries";
        string = string + "\nts\t\tTime stamp debug entries, format Hour:Minute:Second.Milliseconds";
        string = string + "\ncls\t\tShow caller short mode: (file:line)";
        string = string + "\nclf\t\tShowCaller full mode: package.metod(file:line)";
        string = string + "\nall\t\tShortcut for enabling idx,lvl,ts,cls";
        string = string + "\ncs\t\tPrint call stack for each debug entry";
        string = string + "\non<list>\tShow only entries that contain strings in the filter <list>";
        string = string + "\noff<list>\tDo not show entries that contain strings in the filter <list>";
        string = string + "\n\t\ton/off filter <list> list has the format";
        string = string + "\n\t\t  X<string1>[X<string2>X<string3>...] ";
        string = string + "\n\t\twhere X is the list entry separator character.";
        string = string + "\nExamples:";
        string = string + "\n\t\t-D 9:all";
        string = string + "\n\t\t-D ldap,http:idx";
        string = string + "\n\t\t-D \":cls,on@HttpChannel,off@send>\"";
        return string;
    }

    public static void setApplicationStartTime(long l) {
        _appStartTimeStamp = l;
    }

    public static long getApplicationStartTime() {
        return _appStartTimeStamp;
    }

    public static Vector getTraceTypes() {
        return _traceTypes;
    }

    public static boolean isTraceTypeEnabled(String string) {
        if (_traceTypes == null) {
            return false;
        }
        int n = 0;
        while (n < _traceTypes.size()) {
            if (((String)_traceTypes.elementAt(n)).startsWith(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static boolean isInFilterList(Vector vector, String string) {
        if (vector == null) {
            return false;
        }
        int n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.elementAt(n);
            if (string.indexOf(string2) >= 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static String getEntryPrefix(int n) {
        if ((_showFlags & 7) == 0) {
            return "";
        }
        ++_iEntryIndex;
        String string = "";
        if ((_showFlags & 5) == 5) {
            string = _iEntryIndex + " ";
        } else if ((_showFlags & 1) != 0) {
            string = string + _iEntryIndex;
        }
        if ((_showFlags & 4) != 0) {
            long l = System.currentTimeMillis();
            string = string + _timeFormat.format(new Date(l));
            if (_lastTimeStamp != 0L) {
                string = string + " (" + (double)(l - _lastTimeStamp) / 1000.0 + ")";
            }
            _lastTimeStamp = l;
        }
        if ((_showFlags & 2) != 0 && n >= 0) {
            string = string + " L" + n;
        }
        return string + " ";
    }

    public static void println(String string, String string2) {
        if (_traceTypes != null && Debug.isTraceTypeEnabled(string)) {
            if (_showCaller > 0) {
                string2 = Debug.getCaller(_showCaller == 1) + " " + string2;
            }
            if (_showFlags != 0) {
                System.err.println(Debug.getEntryPrefix(-1) + string2);
            } else {
                System.err.println(string2);
            }
            if (_fPrintCallStack) {
                Thread.currentThread();
                Thread.dumpStack();
            }
        }
    }

    public static void print(String string, String string2) {
        if (_traceTypes != null && Debug.isTraceTypeEnabled(string)) {
            if (_showCaller > 0) {
                string2 = Debug.getCaller(_showCaller == 1) + " " + string2;
            }
            if (_showFlags != 0) {
                System.err.print(Debug.getEntryPrefix(-1) + string2);
            } else {
                System.err.print(string2);
            }
            if (_fPrintCallStack) {
                Thread.currentThread();
                Thread.dumpStack();
            }
        }
    }

    public static void println(String string) {
        Debug.println(5, string);
    }

    public static void print(String string) {
        Debug.print(5, string);
    }

    public static void println(int n, String string) {
        if (_fTrace && _iTraceLevel >= n) {
            if (_showCaller > 0) {
                string = Debug.getCaller(_showCaller == 1) + " " + string;
            }
            if (_offFilter != null && Debug.isInFilterList(_offFilter, string)) {
                return;
            }
            if (_onFilter != null && !Debug.isInFilterList(_onFilter, string)) {
                return;
            }
            if (_showFlags != 0) {
                System.err.println(Debug.getEntryPrefix(n) + string);
            } else {
                System.err.println(string);
            }
            if (_fPrintCallStack) {
                Thread.currentThread();
                Thread.dumpStack();
            }
        }
    }

    public static void print(int n, String string) {
        if (_fTrace && _iTraceLevel >= n) {
            if (_showCaller > 0) {
                string = Debug.getCaller(_showCaller == 1) + " " + string;
            }
            if (_offFilter != null && Debug.isInFilterList(_offFilter, string)) {
                return;
            }
            if (_onFilter != null && !Debug.isInFilterList(_onFilter, string)) {
                return;
            }
            if (_showFlags != 0) {
                System.err.print(Debug.getEntryPrefix(n) + string);
            } else {
                System.err.print(string);
            }
            if (_fPrintCallStack) {
                Thread.currentThread();
                Thread.dumpStack();
            }
        }
    }

    public static void println(int n) {
        Debug.println(5, "" + n);
    }

    public static void print(int n) {
        Debug.print(5, "" + n);
    }

    public static void println(int n, int n2) {
        Debug.println(n, "" + n2);
    }

    public static void print(int n, int n2) {
        Debug.print(n, "" + n2);
    }

    public static String getShortClassName(String string) {
        int n = string.lastIndexOf(46);
        return n >= 0 ? string.substring(n + 1) : string;
    }

    public static void printHashtable(String string, Hashtable hashtable) {
        if (string != null && string.length() != 0) {
            Debug.println(" ======== " + string + " ========");
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Debug.println(string2 + "=" + hashtable.get(string2));
        }
    }

    private static String getCaller(boolean bl) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        new Exception().printStackTrace(new PrintStream(byteArrayOutputStream));
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        try {
            String string;
            int n = 0;
            boolean bl2 = false;
            while ((string = dataInputStream.readLine()) != null) {
                if (++n == 1 || string.indexOf("client.util.Debug") >= 0 || string.indexOf("client/util/Debug") >= 0) continue;
                if (bl) {
                    return string.substring(string.lastIndexOf(40));
                }
                return string.trim().substring(3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    static {
        _timeFormat = new SimpleDateFormat("HH:mm:ss.SSS");
        _iEntryIndex = 0;
        _showCaller = 0;
        _fPrintCallStack = false;
    }
}

