/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.util;

import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.KingpinLDAPConnection;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UtilConsoleGlobals;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class LDAPUtil {
    public static final int LDAP_VERSION = 3;
    static String _isieDN = "ou=Netscape SuiteSpot, o=NetscapeRoot";

    public static void setGlobalPreferenceLocation(String string) {
        LDAPUtil.setInstalledSoftwareDN(string);
    }

    public static void setInstalledSoftwareDN(String string) {
        _isieDN = string;
    }

    public static String getInstalledSoftwareDN() {
        return _isieDN;
    }

    public static String getAdminGlobalParameterEntry() {
        return "ou=4.0, ou=admin, ou=Global Preferences," + _isieDN;
    }

    public static String getCommonGlobalParameterEntry() {
        return "cn=common, ou=Global Preferences," + _isieDN;
    }

    public static String getConfigurationRoot() {
        return "o=netscapeRoot";
    }

    public static String getGlobalParameterEntry(String string) {
        return "ou=4.0," + string + ", ou=Global Preferences," + _isieDN;
    }

    public static String getGlobalParameterEntry(String string, String string2) {
        return string2 + "," + string + ", ou=Global Preferences," + _isieDN;
    }

    public static String getUserPreferenceOU() {
        return "UserPreferences";
    }

    public static String flatting(Enumeration enumeration) {
        String string = "";
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (bl) {
                string = string2;
                bl = false;
                continue;
            }
            string = string + " " + string2;
        }
        return string;
    }

    public static String flatting(LDAPAttribute lDAPAttribute) {
        String string = "";
        if (lDAPAttribute != null) {
            string = LDAPUtil.flatting(lDAPAttribute.getStringValues());
        }
        return string;
    }

    public static String getUniqueAttribute(LDAPConnection lDAPConnection, String string) {
        String string2 = "uid";
        try {
            LDAPEntry lDAPEntry = lDAPConnection.read(string);
            if (lDAPEntry != null) {
                LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("nsuniqueattribute");
                string2 = LDAPUtil.flatting(lDAPAttribute);
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println(0, "cannot read global parameter because error:" + (Object)((Object)lDAPException));
        }
        if (string2 == null || string2 == "") {
            string2 = "uid";
        }
        return string2;
    }

    public static String getUIDFromDN(LDAPConnection lDAPConnection, String string) {
        String string2 = null;
        try {
            LDAPEntry lDAPEntry = lDAPConnection.read(string, new String[]{"uid"});
            if (lDAPEntry != null) {
                LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("uid");
                string2 = LDAPUtil.flatting(lDAPAttribute);
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println(0, "LDAPUtil.getUIDFromDN: cannot read " + string + " - " + (Object)((Object)lDAPException));
        }
        return string2;
    }

    public static String getDNFromUID(String string, int n, String string2, String string3) {
        return LDAPUtil.getDNFromUID(string, n, false, string2, string3);
    }

    /*
     * Unable to fully structure code
     */
    public static String getDNFromUID(String var0, int var1_1, boolean var2_2, String var3_3, String var4_4) {
        block14: {
            var5_5 = null;
            var6_6 = null;
            try {
                block13: {
                    var6_6 = var2_2 != false ? new KingpinLDAPConnection(UtilConsoleGlobals.getLDAPSSLSocketFactory(), "", "") : new KingpinLDAPConnection("", "");
                    var6_6.connect(var0, var1_1);
                    var7_7 = "(" + LDAPUtil.getUniqueAttribute(var6_6, LDAPUtil.getCommonGlobalParameterEntry()) + "=" + var4_4 + ")";
                    var8_9 = var6_6.search(var3_3, 2, var7_7, null, false);
                    if (var8_9 == null) break block13;
                    while (var8_9.hasMoreElements()) {
                        var9_10 = var8_9.next();
                        var5_5 = var9_10.getDN();
                    }
                }
                var11_11 = null;
                ** if (var6_6 == null) goto lbl-1000
            }
            catch (Throwable var10_17) {
                var11_13 = null;
                if (var6_6 != null) {
                    try {
                        var6_6.disconnect();
                    }
                    catch (Exception var12_16) {
                        // empty catch block
                    }
                }
                throw var10_17;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var6_6.disconnect();
                }
                catch (Exception var12_14) {}
            }
lbl-1000:
            // 2 sources

            {
                break block14;
                catch (LDAPException var7_8) {
                    Debug.println(0, "LDAPUtil.getDNFromUID: cannot read " + var4_4 + " - " + (Object)var7_8);
                    var11_12 = null;
                    if (var6_6 != null) {
                        try {
                            var6_6.disconnect();
                        }
                        catch (Exception var12_15) {}
                    }
                }
            }
        }
        if (var5_5 == null) {
            Debug.println("cannot find uid <" + var4_4 + "> under " + var0 + ":" + var1_1 + ":" + var3_3);
        }
        return var5_5;
    }

    public static String getLDAPAttributeLocale() {
        ResourceSet resourceSet = new ResourceSet("com.netscape.management.client.console.console");
        String string = resourceSet.getString("DirectoryServer", "attribute-extension");
        if (string == null || string == "") {
            string = "lang-us";
        }
        return string;
    }

    public static void printEntry(LDAPEntry lDAPEntry) {
        if (lDAPEntry == null) {
            return;
        }
        Debug.println("==== DN: " + lDAPEntry.getDN() + " =====");
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        Enumeration enumeration = lDAPAttributeSet.getAttributes();
        while (enumeration.hasMoreElements()) {
            LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
            String string = lDAPAttribute.getName();
            Enumeration enumeration2 = lDAPAttribute.getStringValues();
            Debug.println(string + "=" + LDAPUtil.flatting(enumeration2));
        }
    }

    public static Hashtable ldapEntryToHashtable(LDAPEntry lDAPEntry, String string) {
        if (lDAPEntry == null) {
            return new Hashtable();
        }
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        Enumeration enumeration = lDAPAttributeSet.getAttributes();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while (enumeration.hasMoreElements()) {
            LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
            String string2 = lDAPAttribute.getName();
            Enumeration enumeration2 = lDAPAttribute.getStringValues();
            String string3 = LDAPUtil.flatting(enumeration2);
            if (string == null) {
                hashtable.put(new String(string2), string3);
                continue;
            }
            hashtable.put(string + string2, string3);
        }
        return hashtable;
    }

    public static Date getDateTime(String string) {
        String string2 = "yyyyMMddHHmmss";
        boolean bl = false;
        if (string.length() > string2.length() && string.length() == string2.length() + 1 && string.endsWith("Z")) {
            string = string.substring(0, string.length() - 1);
            bl = true;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            Date date = simpleDateFormat.parse(string, new ParsePosition(0));
            if (bl) {
                long l = TimeZone.getDefault().getRawOffset();
                Date date2 = new Date(date.getTime() + l);
                if (TimeZone.getDefault().inDaylightTime(date2)) {
                    date2 = new Date(date2.getTime() + 3600000L);
                }
                return date2;
            }
            return date;
        }
        catch (Exception exception) {
            Debug.println(0, string + " does not match expected format " + string2);
            Debug.println(0, exception.getMessage());
            return null;
        }
    }

    public static String formatDateTime(String string) {
        try {
            Date date = LDAPUtil.getDateTime(string);
            if (date == null) {
                return string;
            }
            DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1);
            return dateFormat.format(date);
        }
        catch (Exception exception) {
            Debug.println(0, exception.getMessage());
            return string;
        }
    }

    public static String[] getAttributeLanguages(LDAPEntry lDAPEntry) {
        return LDAPUtil.getAttributeLanguages(lDAPEntry.getAttributeSet());
    }

    public static String[] getAttributeLanguages(LDAPAttributeSet lDAPAttributeSet) {
        LDAPAttribute lDAPAttribute;
        Enumeration enumeration = lDAPAttributeSet.getAttributes();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
            String string = lDAPAttribute.getLangSubtype();
            if (string == null || vector.indexOf(string) >= 0) continue;
            vector.addElement(string);
        }
        lDAPAttribute = new String[vector.size()];
        int n = 0;
        while (n < ((LDAPAttribute)lDAPAttribute).length) {
            lDAPAttribute[n] = (String)vector.elementAt(n);
            ++n;
        }
        return lDAPAttribute;
    }

    public static String createEntry(LDAPConnection lDAPConnection, String string, String string2) {
        return LDAPUtil.createEntry(lDAPConnection, string, string2, false);
    }

    public static String createEntry(LDAPConnection lDAPConnection, String string, String string2, boolean bl) {
        String string3;
        block7: {
            string3 = "ou=" + string + "," + string2;
            LDAPSearchResults lDAPSearchResults = null;
            try {
                lDAPSearchResults = lDAPConnection.search(string3, 2, "(objectclass=*)", null, false);
                while (lDAPSearchResults.hasMoreElements()) {
                    LDAPEntry lDAPEntry = lDAPSearchResults.next();
                }
            }
            catch (LDAPException lDAPException) {
                Debug.println(0, "Cannot find: " + string3);
                Debug.println(0, "Creating: " + string3);
                if (lDAPSearchResults != null) break block7;
                try {
                    String string4;
                    LDAPAttribute lDAPAttribute = new LDAPAttribute("objectclass", "top");
                    LDAPAttribute lDAPAttribute2 = new LDAPAttribute("objectclass", "organizationalUnit");
                    LDAPAttribute lDAPAttribute3 = null;
                    if (bl) {
                        string4 = "(targetattr=*)(version 3.0; acl \"UserDNControl\"; allow (all) userdnattr=\"creatorsname\";)";
                        lDAPAttribute3 = new LDAPAttribute("aci", string4);
                    }
                    string4 = new LDAPAttributeSet();
                    string4.add(lDAPAttribute);
                    string4.add(lDAPAttribute2);
                    if (bl) {
                        string4.add(lDAPAttribute3);
                    }
                    lDAPConnection.add(new LDAPEntry(string3, (LDAPAttributeSet)string4));
                }
                catch (LDAPException lDAPException2) {
                    Debug.println(0, "Cannot create: " + string3);
                }
            }
        }
        return string3;
    }

    public static boolean isVersion4(LDAPConnection lDAPConnection) {
        try {
            LDAPEntry lDAPEntry = lDAPConnection.read("");
            String string = LDAPUtil.flatting(lDAPEntry.getAttribute("netscapemdsuffix"));
            if (string != null && !string.equals("")) {
                return true;
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println(0, "ERROR LDAPUtil.isVersion4: failed to determine server version: " + (Object)((Object)lDAPException));
        }
        return false;
    }

    public static boolean isDirectoryServerSupportingIPv6(LDAPConnection lDAPConnection) {
        try {
            String string = LDAPUtil.getDirectoryServerVersion(lDAPConnection);
            return string.compareTo("5.2") >= 0;
        }
        catch (LDAPException lDAPException) {
            Debug.println(0, "ERROR LDAPUtil.isDirectoryServerSupportingIPv6: failed to determine directory server version: " + (Object)((Object)lDAPException));
            return false;
        }
    }

    public static String getDirectoryServerVersion(LDAPConnection lDAPConnection) throws LDAPException {
        String string;
        block4: {
            string = null;
            LDAPEntry lDAPEntry = null;
            LDAPAttribute lDAPAttribute = null;
            try {
                lDAPEntry = lDAPConnection.read("cn=config");
                lDAPAttribute = lDAPEntry.getAttribute("nsslapd-versionstring");
                String[] stringArray = lDAPAttribute.getStringValueArray();
                if (stringArray.length > 0) {
                    String string2 = stringArray[0];
                    int n = string2.indexOf("/");
                    string = string2.substring(n + 1);
                }
            }
            catch (LDAPException lDAPException) {
                Debug.println(0, "LDAPException raised and thrown again when trying to get the directory server number version from cn=config entry " + (Object)((Object)lDAPException));
                throw lDAPException;
            }
            catch (Exception exception) {
                Debug.println(0, "Exception raised in VersionInfo.getDrectoryServerVersion()");
                if (lDAPAttribute != null) break block4;
                Debug.println(0, "check nsslapd-versionstring attribute exists in cn=config and has got a value such as 'iPlanet-Directory/5.2'");
            }
        }
        return string;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void validateLDAPParams(String var0, int var1_1, boolean var2_2, String var3_3, String var4_4, String var5_5) throws IllegalArgumentException {
        block19: {
            block18: {
                var6_6 = 0;
                var7_7 = null;
                try {
                    try {
                        var6_6 = 1;
                        var7_7 = var2_2 != false ? new KingpinLDAPConnection(UtilConsoleGlobals.getLDAPSSLSocketFactory(), var3_3, var4_4) : new KingpinLDAPConnection(var3_3, var4_4);
                        var6_6 = 2;
                        var7_7.connect(var0, var1_1);
                        if (var3_3 == null || var4_4 == null) {
                            var6_6 = 0;
                            var12_8 = null;
                            if (var7_7 == null) return;
                            break block18;
                        }
                        var6_6 = 3;
                        var7_7.authenticate(var3_3, var4_4);
                        var6_6 = 4;
                        if (var5_5 != null) {
                            var7_7.search(var5_5, 0, "objectclass=*", null, false);
                        }
                        var6_6 = 0;
                        break block19;
                    }
                    catch (LDAPException var8_14) {
                        var9_15 = new ResourceSet("com.netscape.management.client.util.default");
                        var10_16 = "";
                        if (var6_6 == 1) {
                            var10_16 = var9_15.getString("error", "LdapSSLSocket");
                        } else if (var6_6 == 2) {
                            var10_16 = var9_15.getString("error", var2_2 != false ? "LdapConnectSecure" : "LdapConnect");
                        } else if (var6_6 == 3) {
                            var10_16 = var9_15.getString("error", "LdapAuthenticate");
                        } else if (var6_6 == 4) {
                            var10_16 = var9_15.getString("error", "LdapBaseDN");
                        }
                        Debug.println("validateLDAPParams " + (Object)var8_14);
                        throw new IllegalArgumentException(var10_16);
                    }
                }
                catch (Throwable var11_17) {
                    var12_10 = null;
                    if (var7_7 == null) throw var11_17;
                    try {
                        var7_7.disconnect();
                        throw var11_17;
                    }
                    catch (Exception var13_13) {
                        // empty catch block
                    }
                    throw var11_17;
                }
            }
            ** try [egrp 2[TRYBLOCK] [2 : 261->269)] { 
lbl51:
            // 1 sources

            var7_7.disconnect();
            return;
lbl53:
            // 1 sources

            catch (Exception var13_11) {
                // empty catch block
            }
            return;
        }
        var12_9 = null;
        if (var7_7 == null) return;
        try {}
        catch (Exception var13_12) {}
        var7_7.disconnect();
        return;
    }
}

