/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;

public class XmlNode {
    private XmlNode root;
    boolean isModified;
    XmlNode parentNode;
    private ArrayList childList;
    private String xmlFile;
    private int lineNo;
    String name;
    String value;
    boolean attrFlag = false;

    public XmlNode() {
        this(null, null, null, null, 0);
    }

    public XmlNode(XmlNode xmlNode, String string, String string2, String string3, int n) {
        this.root = xmlNode;
        this.name = string;
        this.value = string2;
        this.xmlFile = string3;
        this.lineNo = n;
    }

    public XmlNode addChild(XmlNode xmlNode) {
        if (this.childList == null) {
            this.childList = new ArrayList();
        }
        this.childList.add(xmlNode);
        xmlNode.parentNode = this;
        return xmlNode;
    }

    public XmlNode addChild(String string, String string2, String string3, int n) {
        XmlNode xmlNode = new XmlNode(this, string, string2, string3, n);
        if (this.childList == null) {
            this.childList = new ArrayList();
        }
        this.childList.add(xmlNode);
        xmlNode.parentNode = this;
        return xmlNode;
    }

    public XmlNode addChild(String string, String string2, String string3, int n, boolean bl) {
        XmlNode xmlNode = this.addChild(string, string2, string3, n);
        xmlNode.setAttr(bl);
        return xmlNode;
    }

    public void append(XmlNode xmlNode) {
        if (xmlNode == null || xmlNode.childList == null) {
            return;
        }
        int n = 0;
        while (n < xmlNode.childList.size()) {
            XmlNode xmlNode2 = (XmlNode)xmlNode.childList.get(n);
            if (this.childList == null) {
                this.childList = new ArrayList();
            }
            this.childList.add(xmlNode2);
            ++n;
        }
    }

    public Object clone() {
        XmlNode xmlNode = new XmlNode(this.root, this.name, this.value, this.xmlFile, this.lineNo);
        if (this.root == this) {
            xmlNode.root = xmlNode;
            xmlNode.parentNode = this.parentNode;
        } else {
            xmlNode.root = this.root;
            xmlNode.parentNode = this.parentNode;
        }
        xmlNode.isModified = false;
        if (this.childList != null) {
            xmlNode.childList = new ArrayList();
            int n = 0;
            while (n < this.childList.size()) {
                xmlNode.childList.add(this.childList.get(n));
                ++n;
            }
        }
        return xmlNode;
    }

    public void destroy() {
        if (this.childList != null) {
            int n = 0;
            while (n < this.childList.size()) {
                ((XmlNode)this.childList.get(n)).destroy();
                ++n;
            }
            this.childList.trimToSize();
            this.childList = null;
        }
        this.parentNode = null;
        this.root = null;
        this.xmlFile = null;
        this.value = null;
        this.name = null;
    }

    public XmlNode findChildNode(String string) {
        int n = this.childList == null ? 0 : this.childList.size();
        int n2 = 0;
        while (n2 < n) {
            XmlNode xmlNode = (XmlNode)this.childList.get(n2);
            if (xmlNode.name.equals(string)) {
                return xmlNode;
            }
            ++n2;
        }
        return null;
    }

    private XmlNode findChildNode(String string, String string2) {
        int n = this.childList == null ? 0 : this.childList.size();
        int n2 = 0;
        while (n2 < n) {
            XmlNode xmlNode = (XmlNode)this.childList.get(n2);
            if (xmlNode.name.equals(string) && xmlNode.value != null && xmlNode.value.equals(string2)) {
                return xmlNode;
            }
            ++n2;
        }
        return null;
    }

    public XmlNode findConfig(String string) {
        int n = 0;
        int n2 = string.length();
        XmlNode xmlNode = this;
        while (n < n2 && string.charAt(n) == '/') {
            ++n;
        }
        while (n < n2) {
            int n3 = n;
            while (n3 < n2 && string.charAt(n3) != '/') {
                ++n3;
            }
            if (n3 > n && (xmlNode = xmlNode.findChildNode(string.substring(n, n3))) == null) {
                return null;
            }
            n = n3;
            while (n < n2 && string.charAt(n) == '/') {
                ++n;
            }
        }
        return xmlNode;
    }

    public boolean getBoolean() {
        String string = this.getValue();
        if (string == null) {
            return false;
        }
        return string.equals("false") ^ true;
    }

    public boolean getBoolean(String string, boolean bl) {
        XmlNode xmlNode = this.findConfig(string);
        if (xmlNode == null) {
            return bl;
        }
        return xmlNode.getBoolean();
    }

    public XmlNode getFirstChild() {
        if (this.childList != null && this.childList.size() > 0) {
            return (XmlNode)this.childList.get(0);
        }
        return null;
    }

    public int getInt() {
        String string = this.getValue();
        if (string == null || string.equals("")) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getInt(String string, int n) {
        XmlNode xmlNode = this.findConfig(string);
        if (xmlNode == null) {
            return n;
        }
        return xmlNode.getInt();
    }

    public int getInterval(String string, int n) {
        return this.getInt(string, n);
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public String getName() {
        return this.name;
    }

    public XmlNode getParentNode() {
        return this.parentNode;
    }

    public String getString() {
        return this.getValue();
    }

    public String getString(String string, String string2) {
        XmlNode xmlNode = this.findConfig(string);
        if (xmlNode == null) {
            return string2;
        }
        return xmlNode.getString();
    }

    public String getValue() {
        return this.value;
    }

    public String getXmlFile() {
        return this.xmlFile;
    }

    public boolean isAttr() {
        return this.attrFlag;
    }

    public Iterator iterate() {
        return new XmlIterator();
    }

    public Iterator iterate(String string) {
        return new XmlIterator(string);
    }

    public XmlNode removeChild(XmlNode xmlNode) {
        int n;
        if (this.childList == null || xmlNode == null || (n = this.childList.indexOf(xmlNode)) == -1) {
            return null;
        }
        return (XmlNode)this.childList.remove(n);
    }

    public void save(PrintWriter printWriter) throws IOException {
        this.save(printWriter, 0);
    }

    private void save(PrintWriter printWriter, int n) throws IOException {
        this.writeSpaces(printWriter, n);
        printWriter.print("<" + this.getName());
        int n2 = this.childList == null ? 0 : this.childList.size();
        boolean bl = false;
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < n2) {
            XmlNode xmlNode = (XmlNode)this.childList.get(n3);
            if (xmlNode.childList != null && xmlNode.childList.size() != 0) {
                bl = true;
                break;
            }
            printWriter.print(" " + xmlNode.getName() + "=\"" + xmlNode.getValue() + "\"");
            ++n3;
        }
        if (!bl) {
            printWriter.println("/>");
            return;
        }
        printWriter.println(">");
        int n4 = 0;
        while (n4 < n2) {
            XmlNode xmlNode = (XmlNode)this.childList.get(n4);
            if (bl2 || xmlNode.childList != null && xmlNode.childList.size() > 0) {
                bl2 = true;
                xmlNode.save(printWriter, n + 2);
            }
            ++n4;
        }
        this.writeSpaces(printWriter, n);
        printWriter.println("</" + this.getName() + ">");
    }

    public void save_webapp(PrintWriter printWriter, int n) throws Exception {
        this.writeSpaces(printWriter, n);
        printWriter.print("<" + this.getName());
        int n2 = this.childList == null ? 0 : this.childList.size();
        boolean bl = false;
        boolean bl2 = false;
        if (this.childList != null && n2 == 0) {
            bl = true;
        }
        int n3 = 0;
        while (n3 < n2) {
            XmlNode xmlNode = (XmlNode)this.childList.get(n3);
            if (xmlNode.childList == null || xmlNode.childList.size() == 0) {
                if (xmlNode.isAttr()) {
                    if (xmlNode.getValue() != null) {
                        printWriter.print(" " + xmlNode.getName() + "=\"" + xmlNode.getValue() + "\"");
                    } else {
                        printWriter.print(" " + xmlNode.getName());
                    }
                } else {
                    if (!bl2) {
                        bl2 = true;
                        printWriter.println(">");
                    }
                    this.writeSpaces(printWriter, n + 2);
                    if (xmlNode.getValue() != null) {
                        printWriter.println("<" + xmlNode.getName() + ">" + xmlNode.getValue() + "</" + xmlNode.getName() + ">");
                    } else {
                        printWriter.println("<" + xmlNode.getName() + "/>");
                    }
                }
            } else {
                bl = true;
                break;
            }
            ++n3;
        }
        if (!bl && !bl2) {
            printWriter.println("/>");
            return;
        }
        if (!bl2) {
            printWriter.println(">");
        }
        boolean bl3 = false;
        int n4 = 0;
        while (n4 < n2) {
            XmlNode xmlNode = (XmlNode)this.childList.get(n4);
            if (bl3 || xmlNode.childList != null && xmlNode.childList.size() > 0) {
                bl3 = true;
                xmlNode.save_webapp(printWriter, n + 2);
            }
            ++n4;
        }
        this.writeSpaces(printWriter, n);
        printWriter.println("</" + this.getName() + ">");
    }

    public void setAttr(boolean bl) {
        this.attrFlag = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String toString() {
        return "[XmlNode " + this.name + " " + this.value + "]";
    }

    private void writeSpaces(PrintWriter printWriter, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            printWriter.print(' ');
            ++n2;
        }
    }

    class XmlIterator
    implements Iterator {
        int i;
        String key;

        public XmlIterator() {
        }

        public XmlIterator(String string) {
            this.key = string;
            this.findNext();
        }

        /*
         * Unable to fully structure code
         */
        private void findNext() {
            if (this.key != null && XmlNode.access$0(XmlNode.this) != null) ** GOTO lbl7
            return;
lbl-1000:
            // 1 sources

            {
                var1_1 = (XmlNode)XmlNode.access$0(XmlNode.this).get(this.i);
                if (var1_1.name.equals(this.key)) {
                    return;
                }
                ++this.i;
lbl7:
                // 2 sources

                ** while (this.i < XmlNode.access$0((XmlNode)XmlNode.this).size())
            }
lbl8:
            // 1 sources

        }

        public boolean hasNext() {
            return XmlNode.this.childList != null && this.i < XmlNode.this.childList.size();
        }

        public Object next() {
            if (XmlNode.this.childList == null || this.i >= XmlNode.this.childList.size()) {
                return null;
            }
            Object e = XmlNode.this.childList.get(this.i);
            ++this.i;
            this.findNext();
            return e;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

