/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv;

import com.netscape.admin.dirserv.DSSchemaHelper;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IEntryChangeListener;
import com.netscape.admin.dirserv.panel.MappingUtils;
import com.netscape.management.client.util.Debug;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSchema;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.ByteBuf;
import netscape.ldap.util.LDIF;
import netscape.ldap.util.LDIFAddContent;
import netscape.ldap.util.LDIFAttributeContent;
import netscape.ldap.util.LDIFContent;
import netscape.ldap.util.LDIFDeleteContent;
import netscape.ldap.util.LDIFModifyContent;
import netscape.ldap.util.LDIFRecord;
import netscape.ldap.util.MimeBase64Encoder;
import sun.io.MalformedInputException;

public class DSExportImport
implements Runnable {
    private LDAPConnection _ldc;
    private PrintWriter tmpPw = null;
    private IEntryChangeListener _listener = null;
    private String path;
    private String base;
    private boolean includeOperational;
    private boolean addOnly;
    private boolean continuous;
    private String rejectsFile;
    private String _lastDN;
    private boolean _status = false;
    private int _error = 0;
    private boolean _finished = false;
    private Exception _exception = null;
    private boolean _export = true;
    private int _rejects = 0;
    private int _entries = 0;
    private int _numEntry = 0;
    public static final int STATUS_OK = 0;
    public static final int STATUS_CANCEL = 1;
    public static final int STATUS_ERROR = 2;
    public static final int STATUS_UNWRITABLE = 3;
    public static final int LDIF_SYNTAX_ERROR = 4;
    public static final int MALFORMED_EXPRESSION_ERROR = 5;
    private static final String[] ROOT_ATTRS = new String[]{"objectclass", "passwordchange", "passwordchecksyntax", "passwordminlength", "passwordexp", "passwordmaxage", "passwordwarning", "passwordkeephistory", "passwordinhistory", "passwordlockout", "passwordmaxfailure", "passwordunlock", "passwordlockoutduration", "passwordresetduration", "modifytimestamp", "modifiersname"};
    private static final String[] BASE_ATTRS = new String[]{"*"};
    private static final int MAX_LINE = 300;
    private String insertValue = null;
    private long _sleepOnBusyTime = 0L;
    private long _lastBusyTime = 0L;
    private final long SLEEP_ON_BUSY_WINDOW = 10000L;
    private String _chainingSuffix;

    public DSExportImport(LDAPConnection lDAPConnection) {
        this._ldc = lDAPConnection;
    }

    public DSExportImport(LDAPConnection lDAPConnection, String string, String string2, boolean bl, String string3) {
        this(lDAPConnection);
        this.path = string;
        this.base = string2;
        this.includeOperational = bl;
        this.insertValue = string3;
        this._export = true;
    }

    public DSExportImport(LDAPConnection lDAPConnection, String string, String string2, boolean bl) {
        this(lDAPConnection, string, string2, bl, null);
    }

    public DSExportImport(LDAPConnection lDAPConnection, String string, boolean bl, boolean bl2, String string2) {
        this(lDAPConnection);
        this.path = string;
        this.addOnly = bl;
        this.continuous = bl2;
        this.rejectsFile = string2;
        this._export = false;
    }

    public void addEntryChangeListener(IEntryChangeListener iEntryChangeListener) {
        this._listener = iEntryChangeListener;
    }

    public int exportLDIF(String string, String string2, boolean bl, String string3) throws IOException, LDAPException {
        this.insertValue = string3;
        return this.exportLDIF(string, string2, bl);
    }

    public int exportLDIF(String string, String string2, boolean bl) throws IOException, LDAPException {
        String[] stringArray;
        Object object;
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        PrintWriter printWriter = new PrintWriter(fileOutputStream);
        if (bl) {
            String[] stringArray2 = null;
            object = null;
            try {
                object = new LDAPSchema();
                object.fetchSchema(this._ldc);
            }
            catch (LDAPException lDAPException) {
                object = null;
            }
            if (object != null) {
                stringArray2 = DSSchemaHelper.getEditableOperationalAttributes((LDAPSchema)object);
            }
            if (stringArray2 != null) {
                stringArray = new String[stringArray2.length + 1];
                int n = 0;
                while (n < stringArray2.length) {
                    stringArray[n] = stringArray2[n];
                    ++n;
                }
                stringArray[stringArray2.length] = "*";
            } else {
                stringArray = new String[]{"*"};
            }
        } else {
            stringArray = BASE_ATTRS;
        }
        int n = 0;
        if (string2 == null) {
            object = this._ldc.read("");
            LDAPAttribute lDAPAttribute = object.getAttribute("namingContexts");
            Enumeration enumeration = lDAPAttribute.getStringValues();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                if (string2.equalsIgnoreCase("cn=schema")) continue;
                try {
                    Debug.println((String)("DSExportImport.exporLDIF() searching under " + string2));
                    n = this.searchTree(printWriter, string2, 2, stringArray);
                    if (n == 0) continue;
                    break;
                }
                catch (LDAPException lDAPException) {
                    if (lDAPException.getLDAPResultCode() != 32) {
                        throw lDAPException;
                    }
                    Debug.println((String)("DSExportImport.exportLDIF: no entries under <" + string2 + ">"));
                }
            }
        } else {
            Debug.println((String)("DSExportImport.exporLDIF() searching under " + string2));
            n = this.searchTree(printWriter, string2, 2, stringArray);
        }
        printWriter.flush();
        printWriter.close();
        boolean bl2 = this._status = n == 1 || n == 0;
        if (n != 0) {
            try {
                object = new File(string);
                ((File)object).delete();
                Debug.println((String)("DSExportImport.exportLDIF: deleted <" + string + ">"));
            }
            catch (Exception exception) {
                Debug.println((String)("DSExportImport.exportLDIF: " + exception + " <" + string + ">"));
            }
        }
        return n;
    }

    private boolean doExport() throws IOException, LDAPException {
        this._error = this.exportLDIF(this.path, this.base, this.includeOperational, this.insertValue);
        this._finished = true;
        return this._error == 0 || this._error == 1;
    }

    public void run() {
        this._status = false;
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this._status = this._export ? this.doExport() : this.doImport();
        }
        catch (IOException iOException) {
            this._exception = iOException;
        }
        catch (LDAPException lDAPException) {
            this._exception = lDAPException;
        }
        if (this._listener != null) {
            Debug.println((String)"DSExportImport.run(): at the end");
            this._listener.entryChanged(null);
        }
        this._finished = true;
    }

    public boolean getStatus() {
        return this._status;
    }

    public int getError() {
        return this._error;
    }

    public Exception getException() {
        return this._exception;
    }

    public boolean isFinished() {
        return this._finished;
    }

    private void breakString(PrintWriter printWriter, String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 300;
        while (n > 0) {
            int n4 = Math.min(n3, n);
            String string2 = string.substring(n2, n2 + n4);
            if (n2 != 0) {
                printWriter.print(" " + string2);
            } else {
                printWriter.print(string2);
                n3 -= 2;
            }
            n2 += n4;
            n -= n4;
            printWriter.print('\n');
        }
        if (this.tmpPw != null) {
            this.tmpPw.print(string + '\n');
            this.tmpPw.flush();
        }
    }

    private int searchTree(PrintWriter printWriter, String string, int n, String[] stringArray) throws LDAPException, IOException {
        this._chainingSuffix = this.getChainingSuffixForEntry(string);
        MimeBase64Encoder mimeBase64Encoder = new MimeBase64Encoder();
        LDAPSearchConstraints lDAPSearchConstraints = this._ldc.getSearchConstraints();
        lDAPSearchConstraints.setMaxResults(0);
        LDAPSearchResults lDAPSearchResults = this._ldc.search(string, n, "(|(objectclass=*)(objectclass=ldapsubentry))", stringArray, false, lDAPSearchConstraints);
        int n2 = 0;
        while (lDAPSearchResults.hasMoreElements()) {
            LDAPEntry lDAPEntry;
            try {
                lDAPEntry = lDAPSearchResults.next();
            }
            catch (LDAPException lDAPException) {
                this._ldc.abandon(lDAPSearchResults);
                throw lDAPException;
            }
            String string2 = "";
            if (lDAPEntry.getDN() != null) {
                string2 = lDAPEntry.getDN();
            }
            this.breakString(printWriter, "dn: " + string2);
            if (this._listener != null && !this._listener.entryChanged(string2)) {
                this._ldc.abandon(lDAPSearchResults);
                this._entries += n2;
                return 1;
            }
            if (this.insertValue != null && string2.equalsIgnoreCase(string)) {
                this.breakString(printWriter, "copiedFrom: " + this.insertValue);
            }
            LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
            Enumeration enumeration = lDAPAttributeSet.getAttributes();
            while (enumeration.hasMoreElements()) {
                LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
                String string3 = lDAPAttribute.getName();
                Enumeration enumeration2 = lDAPAttribute.getByteValues();
                while (enumeration2.hasMoreElements()) {
                    byte[] byArray = (byte[])enumeration2.nextElement();
                    if (byArray == null || byArray.length < 1) {
                        printWriter.print(string3 + ": \n");
                        continue;
                    }
                    boolean bl = LDIF.isPrintable((byte[])byArray);
                    String string4 = null;
                    if (bl) {
                        try {
                            string4 = new String(byArray, "UTF8");
                        }
                        catch (Exception exception) {
                            bl = false;
                        }
                    }
                    if (bl) {
                        this.breakString(printWriter, string3 + ": " + string4);
                        continue;
                    }
                    ByteBuf byteBuf = new ByteBuf(byArray, 0, byArray.length);
                    ByteBuf byteBuf2 = new ByteBuf();
                    mimeBase64Encoder.translate(byteBuf, byteBuf2);
                    int n3 = byteBuf2.length();
                    if (n3 > 0) {
                        byte[] byArray2 = new byte[n3];
                        byteBuf2.getBytes(0, n3, byArray2, 0);
                        string4 = new String(byArray2, 0, n3);
                        this.breakString(printWriter, string3 + ":: " + string4);
                        continue;
                    }
                    printWriter.print(string3 + ": \n");
                }
            }
            printWriter.print('\n');
            ++n2;
        }
        printWriter.flush();
        this._entries += n2;
        Debug.println((String)("Wrote " + n2 + " entries for " + string));
        return 0;
    }

    private boolean doImport() throws IOException, LDAPException {
        this._error = this.importLDIF(this.path, this.addOnly, this.continuous, this.rejectsFile);
        return this._error == 0 || this._error == 1;
    }

    public int importLDIF(String string, boolean bl, boolean bl2, String string2) throws IOException, LDAPException {
        int n = 0;
        LDIF lDIF = new LDIF(string);
        PrintWriter printWriter = null;
        LDIFRecord lDIFRecord = null;
        boolean bl3 = false;
        this._lastBusyTime = System.currentTimeMillis();
        this._numEntry = 0;
        while (!bl3) {
            String[] stringArray;
            Object object;
            LDAPModification[] lDAPModificationArray;
            block51: {
                try {
                    ++this._numEntry;
                    lDIFRecord = lDIF.nextRecord();
                }
                catch (Exception exception) {
                    String[] stringArray2;
                    Debug.println((String)("DSExportImport.importLDIF getting next record: " + exception));
                    ++this._rejects;
                    lDAPModificationArray = "";
                    if (lDIFRecord != null && !this._lastDN.equals(lDIFRecord.getDN())) {
                        lDAPModificationArray = lDIFRecord.getDN();
                        this._lastDN = lDAPModificationArray;
                    }
                    if (exception instanceof MalformedInputException) {
                        stringArray2 = new String[]{String.valueOf(this._numEntry), exception.toString()};
                        object = DSUtil._resource.getString("dsexportimport", "malformedinputerror-label", stringArray2);
                        n = 5;
                    } else {
                        stringArray2 = new String[]{String.valueOf(this._numEntry), exception.getMessage()};
                        object = DSUtil._resource.getString("dsexportimport", "ioerror-label", stringArray2);
                        n = 2;
                    }
                    if (this._listener != null && !this._listener.entryChanged((String)lDAPModificationArray, (String)object)) {
                        Debug.println((String)("DSExportImport.importLDIF() ERROR entryChanged for entry " + (String)lDAPModificationArray));
                        n = 2;
                        bl3 = true;
                    }
                    if (string2 == null) break block51;
                    try {
                        if (printWriter == null) {
                            printWriter = new PrintWriter(new FileOutputStream(string2));
                        }
                    }
                    catch (Exception exception2) {
                        Debug.println((String)("DSExportImport.importLDIF creating PrintWriter" + exception2.toString()));
                        n = 3;
                        bl3 = true;
                    }
                    if (printWriter == null) break block51;
                    printWriter.println((String)object);
                    bl3 = true;
                }
            }
            if (lDIFRecord == null) {
                Debug.println((String)("DSExportImport.importLDIF: the LDIF record number " + this._numEntry + " is null"));
                if (this._listener != null) {
                    this._listener.entryChanged(null);
                }
                bl3 = true;
            }
            if (bl3) continue;
            this._lastDN = lDIFRecord.getDN();
            LDIFContent lDIFContent = lDIFRecord.getContent();
            lDAPModificationArray = null;
            object = null;
            boolean bl4 = false;
            boolean bl5 = false;
            String string3 = "";
            if (lDIFContent instanceof LDIFModifyContent) {
                if (bl) {
                    stringArray = new String[]{this._lastDN};
                    string3 = DSUtil._resource.getString("dsexportimport", "onlyadderror-label", stringArray);
                    bl5 = true;
                } else {
                    lDAPModificationArray = ((LDIFModifyContent)lDIFContent).getModifications();
                }
            } else if (lDIFContent instanceof LDIFAddContent) {
                object = ((LDIFAddContent)lDIFContent).getAttributes();
            } else if (lDIFContent instanceof LDIFAttributeContent) {
                object = ((LDIFAttributeContent)lDIFContent).getAttributes();
            } else if (lDIFContent instanceof LDIFDeleteContent) {
                if (bl) {
                    stringArray = new String[]{this._lastDN};
                    string3 = DSUtil._resource.getString("dsexportimport", "onlyadderror-label", stringArray);
                    bl5 = true;
                } else {
                    bl4 = true;
                }
            } else {
                stringArray = new String[]{this._lastDN};
                string3 = DSUtil._resource.getString("dsexportimport", "unknowrecordtype-label", stringArray);
                bl5 = true;
            }
            if (!bl5) {
                stringArray = null;
                LDAPEntry lDAPEntry = null;
                if (lDAPModificationArray == null) {
                    if (object != null) {
                        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet(object);
                        lDAPEntry = new LDAPEntry(this._lastDN, lDAPAttributeSet);
                    }
                } else {
                    stringArray = new LDAPModificationSet();
                    int n2 = 0;
                    while (n2 < lDAPModificationArray.length) {
                        stringArray.add(lDAPModificationArray[n2].getOp(), lDAPModificationArray[n2].getAttribute());
                        ++n2;
                    }
                }
                try {
                    while (this.importOneEntry(this._lastDN, (LDAPModificationSet)stringArray, lDAPEntry, lDAPModificationArray, bl4)) {
                        Debug.println((String)("DSExportImport.importLDIF(): going to sleep because " + this._lastDN + " is busy..."));
                        long l = System.currentTimeMillis();
                        this._sleepOnBusyTime = l - this._lastBusyTime < this._sleepOnBusyTime + 10000L ? (this._sleepOnBusyTime += 5000L) : 5000L;
                        this._lastBusyTime = l;
                        try {
                            Thread.sleep(this._sleepOnBusyTime);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (this._listener == null || this._listener.entryChanged(this._lastDN)) continue;
                        Debug.println((String)("DSExportImport.importLDIF() ERROR entryChanged for entry " + this._lastDN + " STATUS CANCEL"));
                        n = 1;
                    }
                    if (this._listener != null && !this._listener.entryChanged(this._lastDN)) {
                        Debug.println((String)("DSExportImport.importLDIF() ERROR entryChanged for entry " + this._lastDN + " STATUS CANCEL"));
                        n = 1;
                    }
                }
                catch (LDAPException lDAPException) {
                    String[] stringArray3;
                    Debug.println((String)("DSExportImport.importLDIF() (2) " + (Object)((Object)lDAPException)));
                    String string4 = lDAPException.errorCodeToString();
                    String string5 = lDAPException.getLDAPErrorMessage();
                    if (string5 != null && string5.length() > 0) {
                        string4 = string4 + ". " + string5;
                    }
                    if (lDAPModificationArray != null) {
                        stringArray3 = new String[]{this._lastDN, string4, lDAPModificationArray.toString()};
                        string3 = DSUtil._resource.getString("dsexportimport", "error-modify-label", stringArray3);
                    } else if (lDAPEntry != null) {
                        stringArray3 = new String[]{this._lastDN, string4, lDAPEntry.toString()};
                        string3 = DSUtil._resource.getString("dsexportimport", "error-add-label", stringArray3);
                    } else if (bl4) {
                        stringArray3 = new String[]{this._lastDN, string4};
                        string3 = DSUtil._resource.getString("dsexportimport", "error-delete-label", stringArray3);
                    }
                    bl5 = true;
                }
            }
            if (bl5) {
                ++this._rejects;
            } else {
                ++this._entries;
            }
            if (bl5) {
                if (this._listener != null && !this._listener.entryChanged(this._lastDN, string3)) {
                    n = 1;
                }
                if (string2 != null) {
                    try {
                        if (printWriter == null) {
                            printWriter = new PrintWriter(new FileOutputStream(string2));
                        }
                    }
                    catch (Exception exception) {
                        Debug.println((String)exception.toString());
                        n = 3;
                    }
                    if (printWriter != null) {
                        printWriter.println(string3);
                    }
                }
            }
            if (n != 1 && n != 3 && (bl2 || !bl5)) continue;
            bl3 = true;
        }
        if (printWriter != null) {
            printWriter.flush();
        }
        return n;
    }

    private boolean importOneEntry(String string, LDAPModificationSet lDAPModificationSet, LDAPEntry lDAPEntry, LDAPModification[] lDAPModificationArray, boolean bl) throws LDAPException {
        boolean bl2 = false;
        try {
            if (lDAPModificationArray != null) {
                this._ldc.modify(string, lDAPModificationSet);
            } else if (lDAPEntry != null) {
                this._ldc.add(lDAPEntry);
            } else if (bl) {
                this._ldc.delete(string);
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("DSExportImport.importOneEntry dn " + string + " Exception " + (Object)((Object)lDAPException)));
            if (lDAPException.getLDAPResultCode() == 51) {
                bl2 = true;
            }
            throw lDAPException;
        }
        return bl2;
    }

    public int getRejectCount() {
        return this._rejects;
    }

    public int getEntryCount() {
        return this._entries;
    }

    public int getCurrentEntry() {
        return this._numEntry;
    }

    public String getLastDN() {
        return this._lastDN;
    }

    private String getChainingSuffixForEntry(String string) {
        String[] stringArray = MappingUtils.getOrderedSuffixList(this._ldc, 0);
        String[] stringArray2 = MappingUtils.getOrderedSuffixList(this._ldc, 1);
        String[] stringArray3 = new String[1];
        int n = 0;
        while (n < stringArray2.length) {
            stringArray3[0] = stringArray2[n];
            if (MappingUtils.isEntryInSuffixes(string, stringArray3, stringArray)) {
                return stringArray2[n];
            }
            ++n;
        }
        return null;
    }

    public String getChainingName() {
        if (this._chainingSuffix == null) {
            return null;
        }
        return MappingUtils.getBackendForSuffix(this._ldc, this._chainingSuffix);
    }

    public String getChainingSuffix() {
        if (this._chainingSuffix == null) {
            return null;
        }
        return this._chainingSuffix;
    }
}

