/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv;

import com.netscape.admin.dirserv.DSSchemaHelper;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.GlobalConstants;
import com.netscape.admin.dirserv.IAuthenticationChangeListener;
import com.netscape.admin.dirserv.PasswordDialog;
import com.netscape.admin.dirserv.SimpleReferral;
import com.netscape.admin.dirserv.TT;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.preferences.PreferenceManager;
import com.netscape.management.client.preferences.Preferences;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UtilConsoleGlobals;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Window;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.text.Collator;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import java.util.zip.CRC32;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileSystemView;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPObjectClassSchema;
import netscape.ldap.LDAPSSLSocketFactoryExt;
import netscape.ldap.LDAPSchema;
import netscape.ldap.LDAPSchemaElement;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSocketFactory;
import netscape.ldap.LDAPUrl;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

public class DSUtil {
    private static Vector _ttStrings = null;
    private static int _ttIndex = 0;
    protected static final String _bckValidSyntax = "abcdefghijklmnopqrstuvwxyz0123456789-_";
    public static final String HELP_DIRECTORY = "slapd";
    public static final int AUTH_SUCCESS = 0;
    public static final int AUTH_CANCEL = 1;
    public static final int AUTH_FAILURE = 2;
    private static Preferences _confirmationPreferences;
    private static Hashtable _addressCache;
    private static String _authName;
    private static final String _sImageDir = "com/netscape/admin/dirserv/images";
    private static final String _sGeneralImageDir = "com/netscape/management/client/icons";
    private static Hashtable _cPackageImages;
    private static Hashtable _cSharedImages;
    private static Hashtable _cRequiresRestart;
    private static Icon _infoIcon;
    private static Icon _warningIcon;
    private static Icon _errorIcon;
    public static final String AUTH_CHANGE_LISTENERS = "AuthChangeListeners";
    private static final String INSTANCE_ATTR = "nsslapd-instancedir";
    private static final String SECURITY_ATTR = "nsslapd-security";
    private static final ResourceSet _helpResource;
    public static ResourceSet _resource;
    public static ResourceSet _langResource;
    private static int _local;
    public static final String PLUGIN_CONFIG_BASE_DN = "cn=plugins,cn=config";
    public static final String LDBM_CONFIG_BASE_DN = "cn=ldbm database,cn=plugins,cn=config";
    public static final String CHAINING_CONFIG_BASE_DN = "cn=chaining database,cn=plugins,cn=config";
    public static final String DEFAULT_DB_INSTANCE_FILTER = "objectclass=nsBackendInstance";
    public static final String MAPPING_TREE_BASE_DN = "cn=mapping tree,cn=config";
    public static final String DEFAULT_LDBM_INDEX_PREFIX = "cn=default indexes, cn=config";
    public static final String LDBM_PLUGIN_ID = "ldbm-backend";
    public static final String LDBM_PLUGIN_NAME = "ldbm database";
    public static final String CHAINING_PLUGIN_NAME = "chaining database";
    public static final String DEFAULT_LDBM_INSTANCE_FILTER = "(&(objectclass=nsBackendInstance)(nsslapd-pluginid=ldbm-backend))";
    private static LDAPConnection _configLdc;
    public static final int LDBM_TYPE = 0;
    public static final int CHAINING_TYPE = 1;
    public static int TRANSPARENT;
    static /* synthetic */ Class class$com$netscape$admin$dirserv$DSUtil;

    private DSUtil() {
    }

    public static void initialize(LDAPConnection lDAPConnection, String string) {
        if (_cRequiresRestart == null) {
            _cRequiresRestart = DSUtil.getRequiresRestartTable(lDAPConnection);
        }
        _authName = string;
    }

    public static void setConfigConnection(LDAPConnection lDAPConnection) {
        _configLdc = lDAPConnection;
    }

    public static DeferAuthListeners reauthenticateDefer(LDAPConnection lDAPConnection, JFrame jFrame, Vector vector, String string, String string2) {
        String string3 = lDAPConnection.getAuthenticationDN();
        String string4 = lDAPConnection.getAuthenticationPassword();
        boolean bl = DSUtil.reauthenticate(lDAPConnection, jFrame, null, string, string2);
        if (bl) {
            return new DeferAuthListeners(vector, string3, lDAPConnection.getAuthenticationDN(), string4, lDAPConnection.getAuthenticationPassword());
        }
        return null;
    }

    public static boolean reauthenticate(LDAPConnection lDAPConnection, JFrame jFrame, Vector vector, String string, String string2) {
        boolean bl = true;
        String string3 = lDAPConnection.getAuthenticationDN();
        String string4 = lDAPConnection.getAuthenticationPassword();
        if (lDAPConnection != null) {
            bl = DSUtil.doReauthenticate(lDAPConnection, jFrame, null, string, string2);
        }
        if (bl && lDAPConnection != null) {
            DSUtil.notifyListeners(vector, string3, lDAPConnection.getAuthenticationDN(), string4, lDAPConnection.getAuthenticationPassword());
        }
        return bl;
    }

    private static boolean doReauthenticate(LDAPConnection lDAPConnection, JFrame jFrame, Vector vector, String string, String string2) {
        String string3 = null;
        String string4 = null;
        boolean bl = true;
        Debug.println((String)("DSUtil.reauthenticate: begin: ldc=" + DSUtil.format(lDAPConnection)));
        if (string2 == null) {
            bl = DSUtil.reauthenticate(lDAPConnection, jFrame, vector, string);
        } else {
            try {
                string3 = lDAPConnection.getAuthenticationDN();
                string4 = lDAPConnection.getAuthenticationPassword();
                lDAPConnection.authenticate(3, string, string2);
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("DSUtil.reauthenticate: " + string + " " + string2 + " " + (Object)((Object)lDAPException)));
                bl = lDAPException.getLDAPResultCode() == 49 || lDAPException.getLDAPResultCode() == 32 ? DSUtil.reauthenticate(lDAPConnection, jFrame, vector, string) : false;
            }
        }
        if (bl) {
            DSUtil.setDefaultReferralCredentials(lDAPConnection);
            Debug.println((int)9, (String)("DSUtil.reauthenticate: ldc=" + DSUtil.format(lDAPConnection)));
            DSUtil.notifyListeners(vector, string3, lDAPConnection.getAuthenticationDN(), string4, lDAPConnection.getAuthenticationPassword());
        }
        return bl;
    }

    private static boolean reauthenticate(LDAPConnection lDAPConnection, JFrame jFrame, Vector vector, String string) {
        boolean bl;
        int n = 2;
        boolean bl2 = bl = lDAPConnection.getSocketFactory() != null && lDAPConnection.getSocketFactory() instanceof LDAPSSLSocketFactoryExt;
        do {
            if ((n = DSUtil.getNewAuthentication(jFrame, lDAPConnection, lDAPConnection.getHost(), lDAPConnection.getPort(), string, vector, bl)) == 2) {
                Debug.println((String)("DSUtil.reauthenticate: DSUtil.getNewAuthentication failed ldc=" + DSUtil.format(lDAPConnection) + " isConnected=" + lDAPConnection.isConnected()));
                continue;
            }
            if (n == 1) {
                Debug.println((int)9, (String)("DSUtil.reauthenticate: DSUtil.getNewAuthentication canceled ldc=" + DSUtil.format(lDAPConnection) + " isConnected=" + lDAPConnection.isConnected()));
                continue;
            }
            Debug.println((String)("DSUtil.reauthenticate: DSUtil.getNewAuthentication okay ldc=" + DSUtil.format(lDAPConnection) + " isConnected=" + lDAPConnection.isConnected()));
        } while (n == 2);
        return n == 0;
    }

    public static void readServerRoot(ConsoleInfo consoleInfo, ConsoleInfo consoleInfo2, JFrame jFrame) {
        String[] stringArray;
        LDAPEntry lDAPEntry;
        LDAPConnection lDAPConnection;
        String string = null;
        String string2 = null;
        if (consoleInfo2 != null) {
            lDAPConnection = consoleInfo2.getLDAPConnection();
            string2 = lDAPConnection.getAuthenticationDN();
            lDAPEntry = null;
            Debug.println((int)9, (String)("DSUtil.readServerRoot ldc=" + DSUtil.format(lDAPConnection)));
            try {
                stringArray = new String[]{INSTANCE_ATTR, SECURITY_ATTR};
                lDAPEntry = lDAPConnection.read("cn=config", stringArray);
                Debug.println((int)9, (String)("DSUtil.readServerRoot entry=" + lDAPEntry));
                string = DSUtil.getAttrValue(lDAPEntry, INSTANCE_ATTR);
                String string3 = DSUtil.getAttrValue(lDAPEntry, SECURITY_ATTR);
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("DSUtil.readServerRoot(): exception " + (Object)((Object)lDAPException)));
                Debug.println((String)("DSUtil.readServerRoot: cannot read cn=config ldc " + (lDAPConnection.isConnected() ? "is" : "is not") + " connected, bind DN = " + lDAPConnection.getAuthenticationDN()));
            }
        }
        if (string == null && consoleInfo != null) {
            lDAPConnection = consoleInfo.getLDAPConnection();
            string2 = lDAPConnection.getAuthenticationDN();
            lDAPEntry = null;
            Debug.println((int)9, (String)("DSUtil.readServerRoot console ldc=" + DSUtil.format(lDAPConnection)));
            try {
                stringArray = new String[]{"serverroot"};
                lDAPEntry = lDAPConnection.read(consoleInfo.getCurrentDN(), stringArray);
                Debug.println((int)9, (String)("DSUtil.readServerRoot entry=" + lDAPEntry));
                string = DSUtil.getAttrValue(lDAPEntry, "serverroot");
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("DSUtil.readServerRoot(): exception " + (Object)((Object)lDAPException)));
                Debug.println((String)("DSUtil.readServerRoot: cannot read " + consoleInfo.getCurrentDN() + " ldc " + (lDAPConnection.isConnected() ? "is" : "is not") + " connected, bind DN = " + lDAPConnection.getAuthenticationDN()));
            }
        }
        if (string == null && jFrame != null) {
            DSUtil.showErrorDialog((Component)jFrame, "config-privilege", string2);
        } else if (string != null && consoleInfo2 != null) {
            consoleInfo2.put("serverroot", string);
        }
    }

    public static String getInstanceName(ConsoleInfo consoleInfo) {
        String string = (String)consoleInfo.get("ServerInstance");
        if (string == null || string.length() <= 0) {
            LDAPConnection lDAPConnection = consoleInfo.getLDAPConnection();
            String[] stringArray = new String[]{lDAPConnection.getHost(), Integer.toString(lDAPConnection.getPort())};
            string = _resource.getString("general", "serveratport-label", stringArray);
        } else {
            int n = string.lastIndexOf(HELP_DIRECTORY);
            if (n >= 0) {
                string = string.substring(n + 6);
            } else {
                LDAPConnection lDAPConnection = consoleInfo.getLDAPConnection();
                String[] stringArray = new String[]{lDAPConnection.getHost(), Integer.toString(lDAPConnection.getPort())};
                string = _resource.getString("general", "serveratport-label", stringArray);
            }
        }
        return string;
    }

    public static String format(LDAPConnection lDAPConnection) {
        return "{host=" + lDAPConnection.getHost() + "} {port=" + lDAPConnection.getPort() + "} {authdn=" + lDAPConnection.getAuthenticationDN() + "}";
    }

    private static int getNewAuthentication(JFrame jFrame, LDAPConnection lDAPConnection, String string, int n, String string2, Vector vector, boolean bl) {
        if (string2 == null || string2.equals("")) {
            string2 = _authName;
        }
        PasswordDialog passwordDialog = new PasswordDialog(jFrame, string2);
        Debug.println((int)9, (String)("DSUtil.getNewAuthentication(): before show ldc=" + lDAPConnection + " current Thread=" + Thread.currentThread()));
        ((Window)((Object)passwordDialog)).setLocationRelativeTo(jFrame);
        passwordDialog.show();
        Debug.println((int)9, (String)("DSUtil.getNewAuthentication(): before dialogCleanup() ldc=" + lDAPConnection));
        DSUtil.dialogCleanup();
        Debug.println((int)9, (String)("DSUtil.getNewAuthentication(): after dialogCleanup() ldc=" + lDAPConnection));
        if (lDAPConnection == null && (lDAPConnection = DSUtil.makeLDAPConnection(bl)) == null) {
            Debug.println((String)"DSUtil.getNewAuthentication(): makeLDAPConnection failed");
            return 2;
        }
        String string3 = lDAPConnection.getAuthenticationDN();
        String string4 = lDAPConnection.getAuthenticationPassword();
        Debug.println((int)9, (String)("DSUtil.getNewAuthentication(): 1: newname=" + passwordDialog.getUsername() + " oldname=" + string3));
        if (!passwordDialog.isCancel()) {
            _authName = passwordDialog.getUsername();
            String string5 = passwordDialog.getPassword();
            boolean bl2 = false;
            int n2 = 0;
            while (!bl2 && n2 < 2) {
                try {
                    ++n2;
                    lDAPConnection.authenticate(3, _authName, string5);
                    DSUtil.setDefaultReferralCredentials(lDAPConnection);
                    Debug.println((int)9, (String)("DSUtil.getNewAuthentication: new credentials are <" + _authName + "> <" + string5 + ">"));
                    DSUtil.notifyListeners(vector, string3, lDAPConnection.getAuthenticationDN(), string4, lDAPConnection.getAuthenticationPassword());
                    bl2 = true;
                    return 0;
                }
                catch (LDAPException lDAPException) {
                    if (lDAPException.getLDAPResultCode() == 19) {
                        DSUtil.showErrorDialog((Component)jFrame, "account-lockout", _authName);
                        bl2 = true;
                    } else if (lDAPException.getLDAPResultCode() == 32 && _configLdc != null) {
                        _authName = LDAPUtil.getDNFromUID((String)_configLdc.getHost(), (int)_configLdc.getPort(), (String)LDAPUtil.getConfigurationRoot(), (String)_authName);
                        if (_authName == null) {
                            DSUtil.showLDAPErrorDialog(jFrame, lDAPException, "109-title");
                            bl2 = true;
                        }
                    } else {
                        DSUtil.showLDAPErrorDialog(jFrame, lDAPException, "109-title");
                        bl2 = true;
                    }
                    try {
                        if (!lDAPConnection.isConnected()) continue;
                        lDAPConnection.authenticate(3, string3, string4);
                    }
                    catch (LDAPException lDAPException2) {
                        // empty catch block
                    }
                }
            }
        } else {
            Debug.println((int)9, (String)("DSUtil.getNewAuthentication: the user pressed the cancel button, authName=" + string2));
        }
        if (passwordDialog.isCancel()) {
            return 1;
        }
        return 2;
    }

    private static void notifyListeners(Vector vector, String string, String string2, String string3, String string4) {
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                IAuthenticationChangeListener iAuthenticationChangeListener = (IAuthenticationChangeListener)vector.elementAt(n);
                iAuthenticationChangeListener.authenticationChanged(string, string2, string3, string4);
                ++n;
            }
        }
    }

    public static void setDefaultReferralCredentials(LDAPConnection lDAPConnection) {
        if (lDAPConnection != null) {
            try {
                lDAPConnection.setOption(8, (Object)new Boolean(true));
                lDAPConnection.setOption(9, (Object)new SimpleReferral(lDAPConnection.getAuthenticationDN(), lDAPConnection.getAuthenticationPassword()));
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("DSUtil.setDefaultReferralCredentials: " + (Object)((Object)lDAPException)));
            }
        }
    }

    public static LDAPConnection makeLDAPConnection(boolean bl) {
        LDAPConnection lDAPConnection = null;
        if (bl) {
            LDAPSocketFactory lDAPSocketFactory;
            try {
                lDAPSocketFactory = UtilConsoleGlobals.getLDAPSSLSocketFactory();
            }
            catch (Throwable throwable) {
                lDAPSocketFactory = null;
                Debug.println((int)0, (String)("DSUtil.makeLDAPConnection: " + throwable));
            }
            if (lDAPSocketFactory == null) {
                Debug.println((int)0, (String)"DSUtil.makeLDAPConnection: failed to get an SSL socket factory");
            } else {
                lDAPConnection = new LDAPConnection(lDAPSocketFactory);
            }
        } else {
            lDAPConnection = new LDAPConnection();
        }
        return lDAPConnection;
    }

    public static LDAPConnection getLDAPConnection(String string, int n, String string2, String string3, boolean bl) throws LDAPException {
        try {
            LDAPConnection lDAPConnection = DSUtil.makeLDAPConnection(bl);
            if (lDAPConnection == null) {
                return null;
            }
            Debug.println((String)"DSUtil: made valid conn object");
            lDAPConnection.connect(string, n);
            Debug.println((String)"DSUtil: connection established");
            if (string2 != null && !string2.equals("")) {
                lDAPConnection.authenticate(3, string2, string3);
                Debug.println((String)"DSUtil: auth done");
            }
            Debug.println((String)"DSUtil: passed connect and auth");
            DSUtil.setDefaultReferralCredentials(lDAPConnection);
            Debug.println((String)"DSUtil: passed default referal");
            return lDAPConnection;
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("DSUtil.getLDAPConnection(" + string + ',' + n + ',' + string2 + ',' + string3 + "): " + (Object)((Object)lDAPException)));
            throw lDAPException;
        }
    }

    public static LDAPConnection getLDAPConnection(String string, int n, String string2, String string3) throws LDAPException {
        return DSUtil.getLDAPConnection(string, n, string2, string3, false);
    }

    public static boolean reconnect(LDAPConnection lDAPConnection) {
        boolean bl;
        boolean bl2 = bl = lDAPConnection != null && lDAPConnection.isConnected();
        if (lDAPConnection != null && !bl) {
            String string = lDAPConnection.getHost();
            int n = lDAPConnection.getPort();
            String string2 = lDAPConnection.getAuthenticationDN();
            String string3 = lDAPConnection.getAuthenticationPassword();
            if (string != null) {
                try {
                    lDAPConnection.connect(3, string, n, string2, string3);
                    bl = true;
                }
                catch (LDAPException lDAPException) {
                    Debug.println((String)("DSUtil.reconnect: (" + string + "," + n + "," + string2 + "," + string3 + "), " + (Object)((Object)lDAPException)));
                }
            }
        }
        return bl;
    }

    static JFrame getDefaultFrame() {
        return UtilConsoleGlobals.getActivatedFrame();
    }

    public static void showLDAPErrorDialog(Component component, LDAPException lDAPException, String string) {
        String string2;
        String string3 = lDAPException.getLDAPErrorMessage();
        String string4 = lDAPException.getMatchedDN();
        if (string3 != null && string3.length() > 0) {
            if (string4 != null && string4.length() > 0) {
                String[] stringArray = new String[]{lDAPException.errorCodeToString(), string3, string4};
                string2 = _resource.getString("general", "ldap-error-dn-msg", stringArray);
            } else {
                String[] stringArray = new String[]{lDAPException.errorCodeToString(), string3};
                string2 = _resource.getString("general", "ldap-error-msg", stringArray);
            }
        } else {
            string2 = lDAPException.errorCodeToString();
        }
        DSUtil.showErrorDialog(component, string2, (Exception)((Object)lDAPException), string);
    }

    public static void showUnknownErrorDialog(Component component, Exception exception, String string) {
        DSUtil.showErrorDialog(component, exception.toString(), exception, string);
    }

    private static void showErrorDialog(Component component, String string, Exception exception, String string2, ResourceSet resourceSet) {
        String string3;
        Component component2 = component = component != null ? component : DSUtil.getDefaultFrame();
        if (string == null || string.length() < 1) {
            string = exception.toString();
        }
        if (resourceSet == null) {
            resourceSet = _resource;
        }
        if ((string3 = resourceSet.getString("general", string2)) == null) {
            string3 = string2;
        }
        JOptionPane.showMessageDialog(component, string, string3, 0, DSUtil.getErrorIcon());
        DSUtil.dialogCleanup();
    }

    private static void showErrorDialog(Component component, String string, Exception exception, String string2) {
        DSUtil.showErrorDialog(component, string, exception, string2, null);
    }

    public static void showErrorDialog(Component component, String string, String string2, String[] stringArray, String string3, ResourceSet resourceSet) {
        String string4;
        String string5;
        Component component2 = component = component != null ? component : DSUtil.getDefaultFrame();
        if (resourceSet == null) {
            resourceSet = _resource;
        }
        if ((string5 = resourceSet.getString(string3, string2, stringArray)) == null || string5.length() < 1) {
            string5 = "Undefined resource: " + string3 + '-' + string2;
        }
        if ((string4 = resourceSet.getString(string3, string)) == null || string4.length() < 1) {
            string4 = "Undefined resource: " + string3 + '-' + string;
        }
        JOptionPane.showMessageDialog(component, string5, string4, 0, DSUtil.getErrorIcon());
        DSUtil.dialogCleanup();
    }

    public static void showErrorDialog(Component component, String string, String string2, String[] stringArray, String string3) {
        DSUtil.showErrorDialog(component, string, string2, stringArray, string3, null);
    }

    public static void showErrorDialog(Component component, String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{string3};
        DSUtil.showErrorDialog(component, string, string2, stringArray, string4, null);
    }

    public static void showErrorDialog(Component component, String string, String[] stringArray, String string2, ResourceSet resourceSet) {
        DSUtil.showErrorDialog(component, string + "-title", string + "-msg", stringArray, string2, resourceSet);
    }

    public static void showErrorDialog(Component component, String string, String[] stringArray, String string2) {
        DSUtil.showErrorDialog(component, string, stringArray, string2, null);
    }

    public static void showErrorDialog(Component component, String string, String[] stringArray, ResourceSet resourceSet) {
        DSUtil.showErrorDialog(component, string, stringArray, "general", resourceSet);
    }

    public static void showErrorDialog(Component component, String string, String[] stringArray) {
        DSUtil.showErrorDialog(component, string, stringArray, (ResourceSet)null);
    }

    public static void showErrorDialog(Component component, String string, String string2, ResourceSet resourceSet) {
        String[] stringArray = new String[]{string2};
        DSUtil.showErrorDialog(component, string, stringArray, "general", resourceSet);
    }

    public static void showErrorDialog(Component component, String string, String string2) {
        DSUtil.showErrorDialog(component, string, string2, (ResourceSet)null);
    }

    public static void showErrorDialog(Component component, String string, String string2, String string3, ResourceSet resourceSet) {
        String[] stringArray = new String[]{string2};
        DSUtil.showErrorDialog(component, string, stringArray, string3, resourceSet);
    }

    public static void showErrorDialog(Component component, String string, String string2, String string3) {
        DSUtil.showErrorDialog(component, string, string2, string3, (ResourceSet)null);
    }

    public static int showConfirmationDialog(Component component, String string, String[] stringArray, String string2) {
        return DSUtil.showConfirmationDialog(component, string, stringArray, string2, null);
    }

    public static int showConfirmationDialog(Component component, String string, String string2, String string3) {
        String[] stringArray = new String[]{string2};
        return DSUtil.showConfirmationDialog(component, string, stringArray, string3, null);
    }

    public static int showConfirmationDialog(Component component, String string, String[] stringArray, String string2, ResourceSet resourceSet) {
        String string3;
        component = component != null ? component : DSUtil.getDefaultFrame();
        ResourceSet resourceSet2 = resourceSet != null ? resourceSet : _resource;
        String string4 = resourceSet2.getString(string2, string + "-msg", stringArray);
        if (string4 == null || string4.length() < 1) {
            string4 = "Undefined resource: " + string2 + '-' + string;
        }
        if ((string3 = resourceSet2.getString(string2, string + "-title")) == null || string3.length() < 1) {
            string3 = "Undefined resource: " + string2 + '-' + string + "-title";
        }
        int n = JOptionPane.showConfirmDialog(component, string4, string3, 0, 0, DSUtil.getWarningIcon());
        DSUtil.dialogCleanup();
        return n;
    }

    public static int showConfirmationDialog(Component component, String string, String string2, String string3, ResourceSet resourceSet) {
        String[] stringArray = new String[]{string2};
        return DSUtil.showConfirmationDialog(component, string, stringArray, string3, resourceSet);
    }

    public static void showInformationDialog(Component component, String string, String[] stringArray, String string2) {
        DSUtil.showInformationDialog(component, string, stringArray, string2, _resource);
    }

    public static void showInformationDialog(Component component, String string, String[] stringArray, String string2, ResourceSet resourceSet) {
        String string3;
        String string4;
        Component component2 = component = component != null ? component : DSUtil.getDefaultFrame();
        if (resourceSet == null) {
            resourceSet = _resource;
        }
        if ((string4 = resourceSet.getString(string2, string + "-msg", stringArray)) == null || string4.length() < 1) {
            string4 = "Undefined resource: " + string2 + '-' + string;
        }
        if ((string3 = resourceSet.getString(string2, string + "-title")) == null || string3.length() < 1) {
            string3 = "Undefined resource: " + string2 + '-' + string + "-title";
        }
        JOptionPane.showMessageDialog(component, string4, string3, 1, DSUtil.getInformationIcon());
        DSUtil.dialogCleanup();
    }

    public static void showInformationDialog(Component component, String string, String string2, String string3) {
        String[] stringArray = new String[]{string2};
        DSUtil.showInformationDialog(component, string, stringArray, string3);
    }

    public static void showInformationDialog(Component component, String string, String[] stringArray) {
        DSUtil.showInformationDialog(component, string, stringArray, "general");
    }

    public static void showInformationDialog(Component component, String string, String string2) {
        String[] stringArray = new String[]{string2};
        DSUtil.showInformationDialog(component, string, stringArray, "general");
    }

    public static void showPermissionDialog(Component component, String string) {
        component = component != null ? component : DSUtil.getDefaultFrame();
        JOptionPane.showMessageDialog(component, _resource.getString("authenticate", "101-msg", string), _resource.getString("authenticate", "101-title"), 0, DSUtil.getErrorIcon());
        DSUtil.dialogCleanup();
    }

    public static void showPermissionDialog(Component component, LDAPConnection lDAPConnection) {
        DSUtil.showPermissionDialog(component, lDAPConnection.getAuthenticationDN());
    }

    private static Icon getInformationIcon() {
        if (_infoIcon == null) {
            _infoIcon = DSUtil.getPackageImage("messagel.gif");
        }
        return _infoIcon;
    }

    private static Icon getWarningIcon() {
        if (_warningIcon == null) {
            _warningIcon = DSUtil.getPackageImage("alertl.gif");
        }
        return _warningIcon;
    }

    private static Icon getErrorIcon() {
        if (_errorIcon == null) {
            _errorIcon = DSUtil.getPackageImage("error.gif");
        }
        return _errorIcon;
    }

    public static void dialogCleanup() {
        try {
            Thread.sleep(200L);
            Thread.yield();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static LDAPSchema getSchema(ConsoleInfo consoleInfo) {
        Object v;
        LDAPSchema lDAPSchema = null;
        ConsoleInfo consoleInfo2 = consoleInfo;
        synchronized (consoleInfo2) {
            v = consoleInfo.get("Schema");
        }
        if (v != null) {
            lDAPSchema = (LDAPSchema)v;
        } else {
            LDAPConnection lDAPConnection = consoleInfo.getLDAPConnection();
            if (DSUtil.reconnect(lDAPConnection)) {
                try {
                    lDAPSchema = new LDAPSchema();
                    lDAPSchema.fetchSchema(lDAPConnection);
                }
                catch (LDAPException lDAPException) {
                    lDAPSchema = null;
                }
            }
            if (lDAPSchema != null) {
                ConsoleInfo consoleInfo3 = consoleInfo;
                synchronized (consoleInfo3) {
                    consoleInfo.put("Schema", lDAPSchema);
                }
            }
        }
        return lDAPSchema;
    }

    public static void setSchema(ConsoleInfo consoleInfo, LDAPSchema lDAPSchema) {
        ConsoleInfo consoleInfo2 = consoleInfo;
        synchronized (consoleInfo2) {
            if (lDAPSchema != null) {
                Debug.println((int)8, (String)"DSUtil.setSchema: schema was set");
                consoleInfo.put("Schema", lDAPSchema);
            } else {
                Debug.println((int)8, (String)"DSUtil.setSchema: schema was removed");
                consoleInfo.remove("Schema");
            }
        }
    }

    static String getImageDir() {
        return _sImageDir;
    }

    static String getSharedImageDir() {
        return _sGeneralImageDir;
    }

    private String getPackagePath() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        string = string.substring(0, n);
        string = string.replace('.', '/');
        return string;
    }

    public static RemoteImage getPackageImage(String string) {
        RemoteImage remoteImage = (RemoteImage)_cPackageImages.get(string);
        if (remoteImage != null) {
            return remoteImage;
        }
        remoteImage = DSUtil.getSystemImage(DSUtil.getImageDir() + "/" + string, string);
        if (remoteImage != null) {
            _cPackageImages.put(string, remoteImage);
        }
        return remoteImage;
    }

    static RemoteImage getSharedImage(String string) {
        RemoteImage remoteImage = (RemoteImage)_cSharedImages.get(string);
        if (remoteImage != null) {
            return remoteImage;
        }
        remoteImage = DSUtil.getSystemImage(DSUtil.getSharedImageDir() + "/" + string, string);
        if (remoteImage != null) {
            _cSharedImages.put(string, remoteImage);
        }
        return remoteImage;
    }

    public static RemoteImage getInactivatedPackageImage(String string) {
        String string2 = string + "INACTIVATED";
        RemoteImage remoteImage = (RemoteImage)_cPackageImages.get(string2);
        if (remoteImage != null) {
            return remoteImage;
        }
        RemoteImage remoteImage2 = DSUtil.getSystemImage(DSUtil.getImageDir() + "/" + string, string);
        if (remoteImage2 != null && (remoteImage = DSUtil.inactivatedIcon((ImageIcon)remoteImage2)) != null) {
            _cPackageImages.put(string2, remoteImage);
            return remoteImage;
        }
        return null;
    }

    public static RemoteImage getInactivatedRolePackageImage(String string) {
        String string2 = string + "INACTIVATED-ROLE";
        RemoteImage remoteImage = (RemoteImage)_cPackageImages.get(string2);
        if (remoteImage != null) {
            return remoteImage;
        }
        RemoteImage remoteImage2 = DSUtil.getSystemImage(DSUtil.getImageDir() + "/" + string, string);
        if (remoteImage2 != null && (remoteImage = DSUtil.inactivatedRoleIcon((ImageIcon)remoteImage2)) != null) {
            _cPackageImages.put(string2, remoteImage);
            return remoteImage;
        }
        return null;
    }

    static RemoteImage getSystemImage(String string, String string2) {
        RemoteImage remoteImage = new RemoteImage(string);
        remoteImage.setDescription(_resource.getString("icon-description", string2));
        return remoteImage;
    }

    public static void dumpConsoleInfo(ConsoleInfo consoleInfo) {
        Enumeration enumeration = consoleInfo.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Debug.println((String)("  " + string + ": " + consoleInfo.get(string)));
        }
    }

    private static void addAttributesToTable(LDAPSchema lDAPSchema, LDAPObjectClassSchema lDAPObjectClassSchema, Hashtable hashtable) {
        if (lDAPObjectClassSchema != null && lDAPSchema != null && hashtable != null) {
            DSSchemaHelper.allAttributes(lDAPObjectClassSchema, lDAPSchema, hashtable);
        }
    }

    private static void addAttributesToTable(LDAPSchema lDAPSchema, String string, Hashtable hashtable) {
        if (string == null) {
            return;
        }
        LDAPObjectClassSchema lDAPObjectClassSchema = lDAPSchema.getObjectClass(string);
        DSUtil.addAttributesToTable(lDAPSchema, lDAPObjectClassSchema, hashtable);
    }

    public static Hashtable getAllAttributeList(LDAPSchema lDAPSchema, LDAPEntry lDAPEntry) {
        Hashtable hashtable = new Hashtable();
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("objectclass");
        if (lDAPAttribute == null) {
            return hashtable;
        }
        Enumeration enumeration = lDAPAttribute.getStringValues();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            DSUtil.addAttributesToTable(lDAPSchema, string, hashtable);
        }
        return hashtable;
    }

    public static Hashtable getAllAttributeList(LDAPSchema lDAPSchema, Vector vector) {
        Hashtable hashtable = new Hashtable();
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                DSUtil.addAttributesToTable(lDAPSchema, string, hashtable);
            }
        }
        return hashtable;
    }

    public static String getAttrValue(LDAPEntry lDAPEntry, String string) {
        Enumeration enumeration;
        LDAPAttribute lDAPAttribute;
        if (lDAPEntry != null && (lDAPAttribute = lDAPEntry.getAttribute(string)) != null && (enumeration = lDAPAttribute.getStringValues()).hasMoreElements()) {
            return (String)enumeration.nextElement();
        }
        return "";
    }

    public static String[] getAttrValues(LDAPEntry lDAPEntry, String string) {
        LDAPAttribute lDAPAttribute;
        if (lDAPEntry != null && (lDAPAttribute = lDAPEntry.getAttribute(string)) != null) {
            return lDAPAttribute.getStringValueArray();
        }
        return null;
    }

    public static String[] getAttrStringValueArray(LDAPConnection lDAPConnection, String string, String string2) {
        return DSUtil.getAttrStringValueArray(lDAPConnection, string, "objectclass=*", 0, string2);
    }

    public static String[] getAttrStringValueArray(LDAPConnection lDAPConnection, String string, String string2, String string3) {
        return DSUtil.getAttrStringValueArray(lDAPConnection, string, string2, 2, string3);
    }

    public static String[] getAttrStringValueArray(LDAPConnection lDAPConnection, String string, String string2, int n, String string3) {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = new String[]{string3};
        try {
            String[] stringArray2;
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string, n, string2, stringArray, false);
            while (lDAPSearchResults.hasMoreElements()) {
                stringArray2 = (String[])lDAPSearchResults.nextElement();
                if (string3.compareToIgnoreCase("dn") == 0) {
                    vector.addElement(stringArray2.getDN());
                    continue;
                }
                LDAPAttribute lDAPAttribute = stringArray2.getAttribute(string3);
                if (lDAPAttribute == null) continue;
                Enumeration enumeration = lDAPAttribute.getStringValues();
                while (enumeration.hasMoreElements()) {
                    vector.addElement((String)enumeration.nextElement());
                }
            }
            if (vector.size() == 0) {
                return null;
            }
            stringArray2 = new String[vector.size()];
            vector.toArray(stringArray2);
            return stringArray2;
        }
        catch (LDAPException lDAPException) {
            return null;
        }
    }

    public static boolean requiresRestart(String string, String string2) {
        String string3 = (string + ":" + string2).toLowerCase();
        if (_cRequiresRestart == null) {
            Debug.println((String)"DSUtil.requiresRestart: null hashtable");
            return false;
        }
        return _cRequiresRestart.get(string3) != null;
    }

    public static void addRequiresRestart(String string, String string2) {
        String string3 = (string + ":" + string2).toLowerCase();
        if (_cRequiresRestart == null) {
            Debug.println((String)"DSUtil.addRequiresRestart: null hashtable");
            return;
        }
        _cRequiresRestart.put(string3, string3);
    }

    private static Hashtable getRequiresRestartTable(LDAPConnection lDAPConnection) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (DSUtil.reconnect(lDAPConnection)) {
            try {
                String[] stringArray = new String[]{"nsslapd-requiresrestart"};
                LDAPEntry lDAPEntry = lDAPConnection.read("cn=config", stringArray);
                LDAPAttribute lDAPAttribute = null;
                if (lDAPEntry != null) {
                    lDAPAttribute = lDAPEntry.getAttribute(stringArray[0]);
                }
                if (lDAPAttribute != null) {
                    Enumeration enumeration = lDAPAttribute.getStringValues();
                    while (enumeration.hasMoreElements()) {
                        String string = ((String)enumeration.nextElement()).toLowerCase();
                        hashtable.put(string, string);
                    }
                }
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("DSUtil.getRequiresRestartTable: " + (Object)((Object)lDAPException)));
            }
        }
        return hashtable;
    }

    public static int getCRC32(String string) {
        return DSUtil.getCRC32(string.getBytes());
    }

    public static int getCRC32(byte[] byArray) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        return (int)cRC32.getValue();
    }

    public static int getCRC32(LDAPAttribute lDAPAttribute) {
        Enumeration enumeration = lDAPAttribute.getByteValues();
        byte[] byArray = null;
        int n = 0;
        while (enumeration.hasMoreElements()) {
            byArray = (byte[])enumeration.nextElement();
            if (lDAPAttribute.size() == 1) {
                return DSUtil.getCRC32(byArray);
            }
            n += byArray.length;
        }
        byte[] byArray2 = new byte[n];
        enumeration = lDAPAttribute.getByteValues();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            byArray = (byte[])enumeration.nextElement();
            System.arraycopy(byArray, 0, byArray2, n2, byArray.length);
            n2 += byArray.length;
        }
        return DSUtil.getCRC32(byArray2);
    }

    public static void trimAndBubbleSort(String[] stringArray, boolean bl) {
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringArray[n].trim();
            ++n;
        }
        DSUtil.bubbleSort(stringArray, bl);
    }

    public static void bubbleSort(String[] stringArray, boolean bl) {
        if (bl) {
            DSUtil.bubbleSortAscii(stringArray);
        } else {
            DSUtil.bubbleSortCollated(stringArray);
        }
    }

    public static void bubbleSort(String[] stringArray) {
        DSUtil.bubbleSortCollated(stringArray);
    }

    private static void bubbleSortCollated(String[] stringArray) {
        Collator collator = Collator.getInstance();
        int n = 0;
        while (n < stringArray.length - 1) {
            int n2 = n + 1;
            while (n2 < stringArray.length) {
                if (collator.compare(stringArray[n], stringArray[n2]) > 0) {
                    String string = stringArray[n];
                    stringArray[n] = stringArray[n2];
                    stringArray[n2] = string;
                }
                ++n2;
            }
            ++n;
        }
    }

    private static void bubbleSortAscii(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length - 1) {
            int n2 = n + 1;
            while (n2 < stringArray.length) {
                if (stringArray[n].compareTo(stringArray[n2]) > 0) {
                    String string = stringArray[n];
                    stringArray[n] = stringArray[n2];
                    stringArray[n2] = string;
                }
                ++n2;
            }
            ++n;
        }
    }

    public static void insertAlphabetically(List list, String string) {
        int n = 0;
        while (n < list.size() && !((String)list.get(n)).equals("") && string.compareTo((String)list.get(n)) > 0) {
            ++n;
        }
        list.add(n, string);
    }

    public static String getRootDN() {
        return _authName;
    }

    public static void help(String string, String string2) {
        URL uRL = null;
        if (string2 != null) {
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (uRL != null) {
            Help.showContextHelp((String)HELP_DIRECTORY, (String)string, (URL)uRL);
        } else {
            Help.showContextHelp((String)HELP_DIRECTORY, (String)string);
        }
    }

    public static Date getDateTime(String string) {
        String string2 = "yyyyMMddHHmmss";
        if (string.length() == string2.length() + 1 && string.endsWith("Z")) {
            string2 = string2 + "zzz";
            string = string.substring(0, string.length() - 1) + "GMT.";
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            Date date = simpleDateFormat.parse(string, new ParsePosition(0));
            return date;
        }
        catch (Exception exception) {
            Debug.println((String)("DSUtil.getDateTime: " + string + " does not match expected format " + string2));
            Debug.println((String)exception.getMessage());
            return null;
        }
    }

    public static String formatDateTime(String string) {
        try {
            Date date = DSUtil.getDateTime(string);
            if (date == null) {
                return string;
            }
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
            return dateFormat.format(date);
        }
        catch (Exception exception) {
            Debug.println((String)exception.getMessage());
            return string;
        }
    }

    public static String canonicalHost(String string) throws UnknownHostException {
        if (string == null || string.equals("")) {
            return "";
        }
        String string2 = null;
        Debug.println((int)9, (String)("canonicalHost: enter with " + string));
        string2 = (String)_addressCache.get(string);
        if (string2 == null) {
            InetAddress inetAddress;
            InetAddress inetAddress2 = InetAddress.getByName(string);
            if (inetAddress2 != null && (inetAddress = InetAddress.getByName(inetAddress2.getHostAddress())) != null) {
                string2 = inetAddress.getHostName();
            }
            if (string2 != null) {
                _addressCache.put(string, string2);
                Debug.println((int)9, (String)("canonicalHost: returning " + string2 + ", hostAddress = " + inetAddress2.getHostAddress()));
            }
        }
        return string2;
    }

    public static boolean requiresConfirmation(String string) {
        boolean bl = true;
        if (_confirmationPreferences == null) {
            PreferenceManager preferenceManager = PreferenceManager.getPreferenceManager((String)"Console", (String)"4.0");
            _confirmationPreferences = preferenceManager.getPreferences(GlobalConstants.PREFERENCES_CONFIRM);
        }
        if (_confirmationPreferences != null) {
            return _confirmationPreferences.getBoolean(string, bl);
        }
        return bl;
    }

    public static int getSSLPort(ConsoleInfo consoleInfo) {
        int n;
        LDAPEntry lDAPEntry;
        LDAPConnection lDAPConnection = consoleInfo.getLDAPConnection();
        String string = "cn=config";
        String[] stringArray = new String[]{"nsslapd-secureport"};
        if (lDAPConnection == null) {
            return -1;
        }
        try {
            lDAPEntry = lDAPConnection.read(string, stringArray);
        }
        catch (LDAPException lDAPException) {
            return -1;
        }
        if (lDAPEntry == null) {
            return -1;
        }
        String string2 = DSUtil.getAttrValue(lDAPEntry, stringArray[0]);
        if (string2.equals("")) {
            return -1;
        }
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        return n;
    }

    public static int checkServerStatus(ConsoleInfo consoleInfo) {
        LDAPConnection lDAPConnection = consoleInfo.getLDAPConnection();
        boolean bl = false;
        Debug.println((int)7, (String)"DSUtil.checkServerStatus: begin");
        LDAPConnection lDAPConnection2 = lDAPConnection;
        synchronized (lDAPConnection2) {
            bl = lDAPConnection != null && lDAPConnection.isConnected();
            Debug.println((int)9, (String)("DSUtil.checkServerStatus: ldc=" + DSUtil.format(lDAPConnection) + " state=" + bl));
            if (!bl) {
                String string = consoleInfo.getHost();
                int n = consoleInfo.getPort();
                String string2 = consoleInfo.getAuthenticationDN();
                String string3 = consoleInfo.getAuthenticationPassword();
                try {
                    lDAPConnection.connect(3, string, n, string2, string3);
                    DSUtil.setDefaultReferralCredentials(lDAPConnection);
                }
                catch (LDAPException lDAPException) {
                    // empty catch block
                }
                bl = lDAPConnection != null && lDAPConnection.isConnected();
            }
        }
        Debug.println((int)7, (String)("DSUtil.checkServerStatus: end state = " + bl));
        return bl ? 1 : 2;
    }

    public static boolean isValidDN(String string) {
        if (string.equals("")) {
            return true;
        }
        if (!DN.isDN((String)string)) {
            return false;
        }
        int n = string.indexOf(61);
        return n > 0 && n < string.length() - 1;
    }

    public static boolean equalDNs(String string, String string2) {
        return LDAPDN.equals((String)string, (String)string2);
    }

    public static boolean isSubtreeOf(DN dN, DN dN2) {
        boolean bl = false;
        Vector vector = dN.getRDNs();
        Vector vector2 = dN2.getRDNs();
        Debug.println((int)9, (String)("DSUtil.isSubtreeOf: dn1: " + dN + " dn2: " + dN2 + " size1=" + vector.size() + " size2=" + vector2.size()));
        if (vector.size() >= vector2.size()) {
            bl = true;
            int n = vector.size() - 1;
            int n2 = vector2.size() - 1;
            while (bl && n >= 0 && n2 >= 0) {
                RDN rDN = (RDN)vector.elementAt(n);
                RDN rDN2 = (RDN)vector2.elementAt(n2);
                bl = rDN.equals(rDN2);
                Debug.println((int)9, (String)("DSUtil.isSubtreeOf: " + rDN + " " + (bl ? "equals" : "does not equal") + " " + rDN2));
                --n;
                --n2;
            }
        }
        return bl;
    }

    public static boolean deleteTree(String string, LDAPConnection lDAPConnection) {
        return DSUtil.deleteTree(string, lDAPConnection, true);
    }

    public static boolean deleteTree(String string, LDAPConnection lDAPConnection, boolean bl) {
        return DSUtil.deleteTree(string, lDAPConnection, bl, null);
    }

    public static boolean deleteTree(String string, LDAPConnection lDAPConnection, boolean bl, GenericProgressDialog genericProgressDialog) {
        Debug.println((int)8, (String)("DSUtil.deleteTree:  " + string));
        boolean bl2 = true;
        if (lDAPConnection == null || string == null) {
            return false;
        }
        LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)lDAPConnection.getSearchConstraints().clone();
        if (!bl) {
            lDAPSearchConstraints.setServerControls(new LDAPControl("2.16.840.1.113730.3.4.2", true, null));
        }
        LDAPSearchResults lDAPSearchResults = null;
        String[] stringArray = new String[]{"dn"};
        lDAPSearchConstraints.setMaxResults(0);
        try {
            lDAPSearchResults = lDAPConnection.search(string, 1, "(|(objectClass=*)(objectclass=ldapsubentry))", stringArray, false, lDAPSearchConstraints);
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("DSUtil.deleteTree: could not search entry " + string + ": " + (Object)((Object)lDAPException)));
            if (lDAPSearchResults != null) {
                try {
                    lDAPConnection.abandon(lDAPSearchResults);
                }
                catch (LDAPException lDAPException2) {
                    // empty catch block
                }
            }
            return false;
        }
        Stack<Object> stack = new Stack<Object>();
        while (lDAPSearchResults != null && lDAPSearchResults.hasMoreElements()) {
            stack.push(lDAPSearchResults.nextElement());
        }
        if (lDAPSearchResults != null) {
            try {
                lDAPConnection.abandon(lDAPSearchResults);
            }
            catch (LDAPException lDAPException) {}
        }
        while (bl2 && stack != null && !stack.empty()) {
            String string2 = ((LDAPEntry)stack.pop()).getDN();
            bl2 = DSUtil.deleteTree(string2, lDAPConnection, bl, genericProgressDialog);
        }
        if (!bl2) {
            Debug.println((String)("DSUtil.deleteTree: could not delete children of " + string));
            return bl2;
        }
        Debug.println((String)("Deleting entry " + string));
        if (genericProgressDialog != null) {
            genericProgressDialog.setTextInLabel(_resource.getString("general", "delete-entry-title", DSUtil.abreviateString(string, 30)));
        }
        try {
            lDAPConnection.delete(string);
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("DSUtil.deleteTree: could not delete entry " + string + ": " + (Object)((Object)lDAPException)));
            return false;
        }
        bl2 = true;
        return bl2;
    }

    public static String getTTString() {
        String string = "";
        if (_ttIndex < _ttStrings.size()) {
            string = (String)_ttStrings.elementAt(_ttIndex);
            if (++_ttIndex >= _ttStrings.size()) {
                _ttIndex = 0;
            }
        }
        return string;
    }

    public static boolean DNUsesLDAPv2Quoting(String string) {
        char c = '\\';
        int n = 34;
        boolean bl = false;
        if (string == null) {
            return bl;
        }
        int n2 = string.indexOf(n);
        if (n2 >= 0) {
            int n3 = 0;
            --n2;
            while (n2 >= 0 && string.charAt(n2) == c) {
                ++n3;
                --n2;
            }
            bl = n3 % 2 == 0;
        }
        return bl;
    }

    public static void checkForLDAPv2Quoting(String string, JFrame jFrame, String string2) {
        if (DSUtil.DNUsesLDAPv2Quoting(string)) {
            String[] stringArray = new String[]{string2, string};
            DSUtil.showInformationDialog((Component)jFrame, "ldapv2quoting", stringArray);
        }
    }

    public static String URLEncode(String string) {
        if (string == null || string.length() == 0) {
            Debug.println((String)("Error: DSUtil.URLEncode: invalid string: " + string));
            return string;
        }
        String string2 = URLEncoder.encode(string);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string2.length()) {
            char c = string2.charAt(n);
            if (c == '+') {
                stringBuffer.append("%20");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static boolean isLocalDirectoryManager(LDAPConnection lDAPConnection) {
        Debug.println((int)9, (String)"DSUtil.isLocalDirectoryManager: begin");
        boolean bl = false;
        try {
            Debug.println((int)9, (String)("DSUtil.isLocalDirectoryManager: ldc=" + DSUtil.format(lDAPConnection)));
            String[] stringArray = new String[]{"nsslapd-rootdn"};
            LDAPEntry lDAPEntry = lDAPConnection.read("cn=config", stringArray);
            String string = DSUtil.getAttrValue(lDAPEntry, "nsslapd-rootdn");
            if (string == null || string.length() == 0) {
                throw new LDAPException("No value for rootdn attribute", 32);
            }
            bl = DSUtil.equalDNs(lDAPConnection.getAuthenticationDN(), string) || lDAPConnection.getAuthenticationDN().equalsIgnoreCase(string);
        }
        catch (Exception exception) {
            Debug.println((String)("DSUtil.isLocalDirectoryManager(): could not read cn=config from " + DSUtil.format(lDAPConnection) + " bound as " + lDAPConnection.getAuthenticationDN() + ":" + exception));
        }
        Debug.println((int)9, (String)("DSUtil.isLocalDirectoryManager: end status = " + bl));
        return bl;
    }

    public static String getSIE(LDAPConnection lDAPConnection, String string, int n) {
        Debug.println((int)9, (String)"DSUtil.getSIE: begin");
        String string2 = null;
        try {
            Debug.println((int)9, (String)("DSUtil.getSIE: ldc=" + DSUtil.format(lDAPConnection)));
            String string3 = LDAPUtil.getConfigurationRoot();
            int n2 = 2;
            String string4 = "(&(serverHostName=" + string + ")" + "(nsServerPort=" + n + "))";
            String[] stringArray = new String[]{"serverHostName", "nsServerPort"};
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string3, n2, string4, stringArray, false);
            if (lDAPSearchResults != null && lDAPSearchResults.hasMoreElements()) {
                string2 = ((LDAPEntry)lDAPSearchResults.nextElement()).getDN();
                Debug.println((int)9, (String)("DSUtil.getSIE: SIE DN=" + string2));
                if (lDAPSearchResults.hasMoreElements()) {
                    Debug.println((String)("DSUtil.getSIE: more than 1 SIE returned " + string3 + " scope=" + n2 + " using filter=" + string4 + " other SIE=" + lDAPSearchResults.nextElement()));
                }
            } else {
                Debug.println((String)("DSUtil.getSIE: the search for " + string3 + " scope=" + n2 + " using filter=" + string4 + " was empty"));
            }
        }
        catch (Exception exception) {
            Debug.println((String)("DSUtil.getSIE(): could not read the SIE DN from " + DSUtil.format(lDAPConnection) + " bound as " + lDAPConnection.getAuthenticationDN() + ":" + exception));
        }
        Debug.println((int)9, (String)("DSUtil.getSIE: end SIE DN = " + string2));
        return string2;
    }

    public static LDAPEntry readEntry(LDAPConnection lDAPConnection, String string, String[] stringArray, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        LDAPEntry lDAPEntry = null;
        LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string, 0, "(|(objectclass=*)(objectclass=ldapsubentry))", stringArray, false, lDAPSearchConstraints);
        if (lDAPSearchResults != null && lDAPSearchResults.hasMoreElements()) {
            lDAPEntry = lDAPSearchResults.next();
        }
        return lDAPEntry;
    }

    public static boolean same(LDAPConnection lDAPConnection, LDAPConnection lDAPConnection2) {
        String string = lDAPConnection.getHost();
        String string2 = lDAPConnection2.getHost();
        try {
            string = DSUtil.canonicalHost(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string2 = DSUtil.canonicalHost(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string.equalsIgnoreCase(string2) && lDAPConnection.getPort() == lDAPConnection2.getPort();
    }

    public static String getLdapURL(LDAPConnection lDAPConnection, String string) {
        boolean bl = lDAPConnection.getSocketFactory() != null;
        return "ldap" + (bl ? "s" : "") + "://" + lDAPConnection.getHost() + ":" + lDAPConnection.getPort() + "/" + string;
    }

    public static int indexOfIgnoreCase(Vector vector, String string) {
        int n = -1;
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2 && n == -1) {
            if (string.equalsIgnoreCase((String)vector.elementAt(n3))) {
                n = n3;
            }
            ++n3;
        }
        return n;
    }

    public static Vector getLDBMInstanceList(LDAPConnection lDAPConnection, boolean bl, String string) throws LDAPException {
        Object object;
        Vector<Object> vector = null;
        if (string == null) {
            string = DEFAULT_DB_INSTANCE_FILTER;
        }
        LDAPSearchResults lDAPSearchResults = null;
        try {
            lDAPSearchResults = lDAPConnection.search(LDBM_CONFIG_BASE_DN, 2, string, null, false);
            while (lDAPSearchResults.hasMoreElements()) {
                object = (LDAPEntry)lDAPSearchResults.nextElement();
                if (vector == null) {
                    vector = new Vector<Object>();
                }
                vector.addElement(object);
                Debug.println((int)8, (String)("DSUtil.getLDBMInstanceList: found backend instance " + object.getDN()));
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("DSUtil.getLDBMInstanceList: could not search under entry cn=plugins,cn=config in server " + DSUtil.format(lDAPConnection) + ": " + (Object)((Object)lDAPException)));
            try {
                if (lDAPSearchResults != null) {
                    lDAPConnection.abandon(lDAPSearchResults);
                }
            }
            catch (LDAPException lDAPException2) {
                // empty catch block
            }
            throw lDAPException;
        }
        if (bl && vector != null) {
            object = vector.elements();
            Vector vector2 = new Vector();
            while (object.hasMoreElements()) {
                LDAPEntry lDAPEntry = (LDAPEntry)object.nextElement();
                String string2 = DSUtil.getAttrValue(lDAPEntry, "cn");
                lDAPSearchResults = null;
                try {
                    String string3 = "nsslapd-backend=" + string2;
                    lDAPSearchResults = lDAPConnection.search(MAPPING_TREE_BASE_DN, 1, string3, null, false);
                    if (lDAPSearchResults == null || !lDAPSearchResults.hasMoreElements()) {
                        Debug.println((String)("DSUtil.getLDBMInstanceList: instance entry " + lDAPEntry.getDN() + " has no corresponding " + "mapping tree entry"));
                    }
                    while (lDAPSearchResults != null && lDAPSearchResults.hasMoreElements()) {
                        Vector<LDAPEntry> vector3 = new Vector<LDAPEntry>(2);
                        vector3.addElement(lDAPEntry);
                        LDAPEntry lDAPEntry2 = (LDAPEntry)lDAPSearchResults.nextElement();
                        vector3.addElement(lDAPEntry2);
                        vector2.addElement(vector3);
                        Debug.println((int)8, (String)("DSUtil.getLDBMInstanceList: found mapping tree entry " + lDAPEntry2.getDN() + " corresponding to " + "instance entry " + lDAPEntry.getDN()));
                    }
                }
                catch (LDAPException lDAPException) {
                    Debug.println((String)("DSUtil.getLDBMInstanceList: could not search under entry cn=mapping tree,cn=config in server " + DSUtil.format(lDAPConnection) + ": " + (Object)((Object)lDAPException)));
                    try {
                        if (lDAPSearchResults != null) {
                            lDAPConnection.abandon(lDAPSearchResults);
                        }
                    }
                    catch (LDAPException lDAPException3) {
                        // empty catch block
                    }
                    throw lDAPException;
                }
            }
            vector = vector2;
        }
        return vector;
    }

    public static boolean isStandardSchema(LDAPSchemaElement lDAPSchemaElement) {
        String[] stringArray;
        boolean bl = true;
        if (lDAPSchemaElement != null && (stringArray = lDAPSchemaElement.getQualifier("X-ORIGIN")) != null) {
            Debug.println((int)8, (String)("DSUtil.isStandardSchema: schema " + lDAPSchemaElement.getName() + " qual = " + stringArray));
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equalsIgnoreCase("user defined")) {
                    bl = false;
                    break;
                }
                ++n;
            }
        }
        if (bl) {
            Debug.println((int)8, (String)("DSUtil.isStandardSchema: schema " + lDAPSchemaElement.getName() + " isStandardSchema=true"));
        }
        return bl;
    }

    public static boolean isValidBckName(String string) {
        boolean bl = true;
        if (string != null && string.length() > 0) {
            StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string, 0);
            char c = stringCharacterIterator.first();
            while (c != '\uffff' && bl) {
                if (_bckValidSyntax.indexOf(Character.toLowerCase(c)) == -1) {
                    bl = false;
                }
                c = stringCharacterIterator.next();
            }
        }
        return bl;
    }

    public static boolean isValidLDAPUrl(String string) {
        boolean bl = false;
        try {
            LDAPUrl lDAPUrl = new LDAPUrl(string);
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static RemoteImage maskedIcon(ImageIcon imageIcon, ImageIcon imageIcon2) {
        Object object;
        Object object2;
        int n = imageIcon.getIconHeight();
        int n2 = imageIcon.getIconWidth();
        if (imageIcon2.getImageLoadStatus() != 8) {
            Debug.println((String)"DSUtil.maskedIcon(): Error while loading maskImage");
            return null;
        }
        Image image = imageIcon2.getImage();
        Image image2 = image.getScaledInstance(n2, n, 4);
        RemoteImage remoteImage = new RemoteImage(image2);
        if (remoteImage.getImageLoadStatus() != 8) {
            Debug.println((String)"DSUtil.maskedIcon(): Error while loading scaledMaskImage");
            return null;
        }
        int[] nArray = new int[n2 * n];
        try {
            object2 = new PixelGrabber(imageIcon.getImage(), 0, 0, n2, n, nArray, 0, n2);
            ((PixelGrabber)object2).grabPixels();
            if ((((PixelGrabber)object2).status() & 0x80) != 0) {
                Debug.println((String)"DSUtil.maskedIcon(): Error while fetching icon");
                return null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        object2 = new int[n2 * n];
        try {
            object = new PixelGrabber(remoteImage.getImage(), 0, 0, n2, n, (int[])object2, 0, n2);
            ((PixelGrabber)object).grabPixels();
            if ((((PixelGrabber)object).status() & 0x80) != 0) {
                Debug.println((String)"DSUtil.maskedIcon(): Error while fetching mask");
                RemoteImage remoteImage2 = null;
                return remoteImage2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            RemoteImage remoteImage3 = null;
            return remoteImage3;
        }
        object = new int[n2 * n];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                object[n4 + n3 * n2] = object2[n4 + n3 * n2] != TRANSPARENT ? object2[n4 + n3 * n2] : (Object)nArray[n4 + n3 * n2];
                ++n4;
            }
            ++n3;
        }
        Canvas canvas = new Canvas();
        Image image3 = canvas.getToolkit().createImage(new MemoryImageSource(n2, n, ColorModel.getRGBdefault(), (int[])object, 0, n2));
        RemoteImage remoteImage4 = new RemoteImage(image3);
        remoteImage4.setDescription(imageIcon.getDescription());
        return remoteImage4;
    }

    public static RemoteImage inactivatedIcon(ImageIcon imageIcon) {
        RemoteImage remoteImage = DSUtil.getPackageImage("inactivated.gif");
        return DSUtil.maskedIcon(imageIcon, (ImageIcon)remoteImage);
    }

    public static RemoteImage inactivatedRoleIcon(ImageIcon imageIcon) {
        RemoteImage remoteImage = DSUtil.getPackageImage("roleinactivated.gif");
        return DSUtil.maskedIcon(imageIcon, (ImageIcon)remoteImage);
    }

    public static String abreviateString(String string, int n) {
        if (string == null) {
            return null;
        }
        if (string.length() > n) {
            String string2 = string.substring(0, n) + _resource.getString("general", "abreviate-ending");
            return string2;
        }
        String string3 = new String(string);
        return string3;
    }

    public static String inverseAbreviateString(String string, int n) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 > n) {
            String string2 = _resource.getString("general", "abreviate-ending") + string.substring(n2 - n, n2);
            return string2;
        }
        String string3 = new String(string);
        return string3;
    }

    public static Component searchChildComponent(Component component, Class clazz) {
        Component component2 = null;
        if (clazz.isInstance(component)) {
            component2 = component;
        } else if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (component2 == null && n < componentArray.length) {
                component2 = DSUtil.searchChildComponent(componentArray[n], clazz);
                ++n;
            }
        }
        return component2;
    }

    public static int DbType(LDAPConnection lDAPConnection, String string) {
        int n = -1;
        DN dN = new DN(string);
        if (dN != null) {
            try {
                LDAPEntry lDAPEntry;
                DN dN2 = dN.getParent();
                if (dN2 != null && (lDAPEntry = lDAPConnection.read(dN2.toString())) != null) {
                    LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("nsslapd-pluginid");
                    Enumeration enumeration = lDAPAttribute.getStringValues();
                    String string2 = (String)enumeration.nextElement();
                    if (string2.compareTo(LDBM_PLUGIN_ID) == 0) {
                        n = 0;
                    } else if (string2.compareTo(CHAINING_PLUGIN_NAME) == 0) {
                        n = 1;
                    }
                }
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("DSUtil.DbType: error" + string + "\n\t LDAPException : " + lDAPException.toString()));
            }
        }
        return n;
    }

    public static boolean isNT(ConsoleInfo consoleInfo) {
        return consoleInfo.getAdminOS().startsWith("Windows");
    }

    public static boolean isLocal(String string) {
        if (_local == -1) {
            try {
                _local = 0;
                InetAddress inetAddress = InetAddress.getByName(string);
                InetAddress inetAddress2 = InetAddress.getLocalHost();
                byte[] byArray = inetAddress.getAddress();
                byte[] byArray2 = inetAddress2.getAddress();
                if (inetAddress.equals(inetAddress2) || string.equals("localhost")) {
                    _local = 1;
                }
            }
            catch (UnknownHostException unknownHostException) {
                Debug.println((String)("Unkown host for: " + string + " uhe: " + unknownHostException.toString()));
            }
        }
        return _local == 1;
    }

    public static boolean fileExists(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return true;
        }
        FileSystemView fileSystemView = null;
        fileSystemView = FileSystemView.getFileSystemView();
        File file2 = null;
        file2 = fileSystemView.getParentDirectory(file);
        if (file2 == null) {
            return false;
        }
        File[] fileArray = fileSystemView.getFiles(file2, false);
        if (fileArray == null) {
            return false;
        }
        int n = 0;
        n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].equals(file)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static String getRdnValue(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            char c = stringBuffer.charAt(n);
            boolean bl = false;
            int n2 = 0;
            while (n2 < DN.ESCAPED_CHAR.length && !bl) {
                bl = c == DN.ESCAPED_CHAR[n2];
                ++n2;
            }
            if (bl) {
                stringBuffer.insert(n, '\\');
                ++n;
            } else if (n == 0) {
                if (c == ' ') {
                    stringBuffer.deleteCharAt(n);
                    stringBuffer.insert(n, "\\20");
                    n += 2;
                } else if (c == '#') {
                    stringBuffer.insert(n, '\\');
                    ++n;
                }
            } else if (n == stringBuffer.length() - 1 && c == ' ') {
                stringBuffer.deleteCharAt(n);
                stringBuffer.insert(n, "\\20");
                n += 2;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String getLDAPErrorMessage(LDAPException lDAPException) {
        String string = lDAPException.errorCodeToString();
        String string2 = lDAPException.getLDAPErrorMessage();
        if (string2 != null && string2.length() > 0) {
            string = string + ". " + string2;
        }
        if (string == null || string.length() == 0) {
            int n = lDAPException.getLDAPResultCode();
            String string3 = null;
            switch (n) {
                case 80: {
                    string3 = "LDAP Other";
                    break;
                }
                case 81: {
                    string3 = "LDAP Server Down";
                    break;
                }
                case 82: {
                    string3 = "LDAP Local Error";
                    break;
                }
                case 83: {
                    string3 = "LDAP Encoding Error";
                    break;
                }
                case 84: {
                    string3 = "LDAP Decoding Error";
                    break;
                }
                case 85: {
                    string3 = "Timeout";
                    break;
                }
                case 86: {
                    string3 = "Auth Unknown";
                    break;
                }
                case 87: {
                    string3 = "Filter Error";
                    break;
                }
                case 88: {
                    string3 = "User Cancelled";
                    break;
                }
                case 89: {
                    string3 = "Parameter Error";
                    break;
                }
                case 90: {
                    string3 = "No Memory";
                    break;
                }
                case 91: {
                    string3 = "LDAP Connect Error";
                    break;
                }
            }
            if (string3 == null) {
                String[] stringArray = new String[]{String.valueOf(lDAPException.getLDAPResultCode())};
                string = _resource.getString("general", "unknown-error", stringArray);
            } else {
                String[] stringArray = new String[]{String.valueOf(lDAPException.getLDAPResultCode()), string3};
                string = _resource.getString("general", "unknown-error-withcode", stringArray);
            }
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _ttStrings = new Vector();
        try {
            String string = "ds.tt";
            InputStream inputStream = (class$com$netscape$admin$dirserv$DSUtil == null ? (class$com$netscape$admin$dirserv$DSUtil = DSUtil.class$("com.netscape.admin.dirserv.DSUtil")) : class$com$netscape$admin$dirserv$DSUtil).getResourceAsStream(string);
            if (inputStream == null) {
                Debug.println((String)("DSUtil static: could not open " + string));
            } else {
                _ttStrings = TT.read(inputStream);
            }
        }
        catch (Exception exception) {
            Debug.println((String)("DSUtil static: " + exception));
            exception.printStackTrace();
        }
        _confirmationPreferences = null;
        _addressCache = new Hashtable();
        _authName = "cn=Directory Manager";
        _cPackageImages = new Hashtable();
        _cSharedImages = new Hashtable();
        _cRequiresRestart = null;
        _infoIcon = null;
        _warningIcon = null;
        _errorIcon = null;
        _helpResource = new ResourceSet("com.netscape.admin.dirserv.dirserv-help");
        _resource = new ResourceSet("com.netscape.admin.dirserv.dirserv");
        _langResource = new ResourceSet("com.netscape.management.client.ug.PickerEditorResource");
        _local = -1;
        _configLdc = null;
        TRANSPARENT = 0xFEFDFD;
    }

    public static class DeferAuthListeners {
        private Vector _listeners;
        private String _oldDN;
        private String _newDN;
        private String _oldPwd;
        private String _newPwd;

        public DeferAuthListeners(Vector vector, String string, String string2, String string3, String string4) {
            this._listeners = vector;
            this._oldDN = string;
            this._newDN = string2;
            this._oldPwd = string3;
            this._newPwd = string4;
        }

        public void notifyListeners() {
            DSUtil.notifyListeners(this._listeners, this._oldDN, this._newDN, this._oldPwd, this._newPwd);
        }
    }
}

