/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.account;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.DatabaseConfig;
import com.netscape.admin.dirserv.config.Suffix;
import com.netscape.management.client.ug.ResourcePageObservable;
import com.netscape.management.client.util.Debug;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.ListIterator;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.util.DN;

public class AccountInactivation {
    String _dn;
    LDAPEntry _entry;
    int _initResult;
    private String _suffix;
    private DatabaseConfig _dbConfig;
    private Vector _throughRoles;
    private String _nsManagedDisabledRole;
    private String _nsDisabledRole;
    Vector _lockingInfrastructureDNs;
    public static final int SUCCESS = 0;
    public static final int ERROR = 1;
    public static final int CAN_NOT_ACTIVATE = 2;
    public static final int CAN_NOT_INACTIVATE = 3;
    public static final int INACTIVATED_THROUGH_UNKNOWN_MECHANICS = 4;
    public static final int ACTIVATED = 5;
    public static final int INACTIVATED = 6;
    public static final int ROOT_OR_CONFIG_ENTRY = 7;
    public static final int CAN_BE_ACTIVATED = 8;
    public static final int CAN_BE_INACTIVATED = 9;
    public static final int CANNOT_BE_ACTIVATED_INACTIVATED = 10;
    private final String DN = "dn";
    private final String CN = "cn";
    private final String USERPASSWORD = "userpassword";
    private final String NSROLE = "nsrole";
    private final String NSROLEDN = "nsroledn";
    private final String OBJECTCLASS = "objectclass";
    private final String ACCOUNT_LOCK = "nsAccountLock";
    private final String LOCKED = "true";
    private final String SUFFIX_ATTR = "nsslapd-suffix";
    private final String BACKEND_ATTR = "cn";
    String[] ATTRS = new String[]{"cn", "userpassword", "nsrole", "nsroledn", "objectclass", "nsAccountLock"};

    public AccountInactivation(LDAPEntry lDAPEntry, DatabaseConfig databaseConfig) {
        this._entry = lDAPEntry;
        if (lDAPEntry != null) {
            this._dn = lDAPEntry.getDN();
        }
        this._dbConfig = databaseConfig;
    }

    public AccountInactivation(ResourcePageObservable resourcePageObservable, DatabaseConfig databaseConfig) {
        this._entry = this.getEntry(resourcePageObservable);
        if (this._entry != null) {
            this._dn = this._entry.getDN();
        }
        this._dbConfig = databaseConfig;
    }

    public int getState(LDAPConnection lDAPConnection) throws LDAPException {
        if (!this.isLocked(lDAPConnection)) {
            return 5;
        }
        if (this._throughRoles == null) {
            this.updateThroughRoles(lDAPConnection);
        }
        if (this._throughRoles != null && this._throughRoles.size() > 0) {
            return 6;
        }
        return 4;
    }

    public int operationAllowed(LDAPConnection lDAPConnection) throws LDAPException {
        int n = 10;
        if (!this.isLocked(lDAPConnection)) {
            if (this._suffix == null) {
                this.updateSuffixAndRoleDNs(lDAPConnection);
            }
            if (this._suffix != null && this._suffix.length() > 0) {
                n = 9;
            }
        } else {
            if (this._throughRoles == null) {
                this.updateThroughRoles(lDAPConnection);
            }
            if (this._throughRoles != null && this._throughRoles.size() > 0) {
                n = 8;
            }
        }
        return n;
    }

    public Vector getLockingRolesForRole(LDAPConnection lDAPConnection) throws LDAPException {
        if (this._throughRoles == null) {
            this.updateThroughRolesForRole(lDAPConnection);
        }
        if (this._suffix == null) {
            this.updateSuffixAndRoleDNs(lDAPConnection);
        }
        if (this._throughRoles == null || this._suffix == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        DN dN = new DN(this._nsDisabledRole);
        int n = 0;
        while (n < this._throughRoles.size()) {
            String string = (String)this._throughRoles.elementAt(n);
            DN dN2 = new DN(string);
            if (!dN.equals(dN2)) {
                vector.addElement(string);
            }
            ++n;
        }
        return vector;
    }

    public Vector getLockingRolesForEntry(LDAPConnection lDAPConnection) throws LDAPException {
        if (this._throughRoles == null) {
            this.updateThroughRolesForEntry(lDAPConnection);
        }
        if (this._suffix == null) {
            this.updateSuffixAndRoleDNs(lDAPConnection);
        }
        if (this._throughRoles == null || this._suffix == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        DN dN = new DN(this._nsManagedDisabledRole);
        int n = 0;
        while (n < this._throughRoles.size()) {
            String string = (String)this._throughRoles.elementAt(n);
            DN dN2 = new DN(string);
            if (!dN.equals(dN2)) {
                vector.addElement(string);
            }
            ++n;
        }
        return vector;
    }

    public Vector getLockingRoles(LDAPConnection lDAPConnection) throws LDAPException {
        if (this.isRole()) {
            return this.getLockingRolesForRole(lDAPConnection);
        }
        if (this.hasUserPassword()) {
            return this.getLockingRolesForEntry(lDAPConnection);
        }
        return null;
    }

    public boolean canBeActivated(LDAPConnection lDAPConnection) throws LDAPException {
        if (this.isRole()) {
            return this.canRoleBeActivated(lDAPConnection);
        }
        if (this.hasUserPassword()) {
            return this.canEntryBeActivated(lDAPConnection);
        }
        return false;
    }

    public boolean canEntryBeActivated(LDAPConnection lDAPConnection) throws LDAPException {
        DN dN;
        DN dN2;
        if (!this.isLocked(lDAPConnection)) {
            return true;
        }
        if (this._throughRoles == null) {
            this.updateThroughRolesForEntry(lDAPConnection);
        }
        return this._throughRoles != null && this._throughRoles.size() == 1 && (dN2 = new DN((String)this._throughRoles.elementAt(0))).equals(dN = new DN(this._nsManagedDisabledRole));
    }

    public boolean canRoleBeActivated(LDAPConnection lDAPConnection) throws LDAPException {
        DN dN;
        DN dN2;
        if (!this.isLocked(lDAPConnection)) {
            return true;
        }
        if (this._throughRoles == null) {
            this.updateThroughRolesForRole(lDAPConnection);
        }
        return this._throughRoles != null && this._throughRoles.size() == 1 && (dN2 = new DN((String)this._throughRoles.elementAt(0))).equals(dN = new DN(this._nsDisabledRole));
    }

    public boolean canBeInactivated() {
        return this.isRole() || this.hasUserPassword();
    }

    public boolean isLocked(LDAPConnection lDAPConnection) throws LDAPException {
        LDAPAttribute lDAPAttribute;
        if (this.isRole()) {
            DN dN;
            DN dN2;
            if (this._throughRoles == null) {
                this.updateThroughRolesForRole(lDAPConnection);
            }
            if (this._throughRoles != null && this._throughRoles.size() > 0) {
                Debug.println((int)0, (String)("AccountInactivation.isLocked(): entry " + this._dn + " belongs to locking roles " + this._throughRoles.toString()));
                return true;
            }
            if (this._nsDisabledRole != null && (dN2 = new DN(this._entry.getDN())).equals(dN = new DN(this._nsDisabledRole))) {
                return true;
            }
        } else if (this.hasUserPassword() && this._entry != null && (lDAPAttribute = this._entry.getAttribute("nsAccountLock")) != null) {
            Enumeration enumeration = lDAPAttribute.getStringValues();
            String string = (String)enumeration.nextElement();
            return string != null && string.equalsIgnoreCase("true");
        }
        return false;
    }

    public boolean isLockingInfrastructureCreated(LDAPConnection lDAPConnection) throws LDAPException {
        if (this._suffix == null) {
            this.updateSuffixAndRoleDNs(lDAPConnection);
        }
        if (this._suffix == null) {
            return false;
        }
        String[] stringArray = new String[]{"cn=nsManagedDisabledRole," + this._suffix, "cn=nsDisabledRole," + this._suffix, "cn=nsAccountInactivationTmp," + this._suffix, "cn=cn=nsDisabledRole\\," + DSUtil.getRdnValue(this._suffix) + ",cn=nsAccountInactivationTmp," + this._suffix, "cn=nsAccountInactivation_cos," + this._suffix};
        LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)lDAPConnection.getSearchConstraints().clone();
        int n = 0;
        while (n < stringArray.length) {
            try {
                LDAPEntry lDAPEntry = DSUtil.readEntry(lDAPConnection, stringArray[n], null, lDAPSearchConstraints);
                if (lDAPEntry == null) {
                    return false;
                }
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() != 32) {
                    Debug.println((String)("AccountInactivation.isLockingInfrastructureCreated() " + (Object)((Object)lDAPException)));
                    throw lDAPException;
                }
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean createLockingInfrastructure(LDAPConnection lDAPConnection) throws LDAPException {
        if (this._suffix == null) {
            this.updateSuffixAndRoleDNs(lDAPConnection);
        }
        if (this._suffix == null) {
            return false;
        }
        String[] stringArray = new String[]{"cn=nsManagedDisabledRole," + this._suffix, "cn=nsDisabledRole," + this._suffix, "cn=nsAccountInactivationTmp," + this._suffix, "cn=cn=nsDisabledRole\\," + DSUtil.getRdnValue(this._suffix) + ",cn=nsAccountInactivationTmp," + this._suffix, "cn=nsAccountInactivation_cos," + this._suffix};
        String[] stringArray2 = new String[]{"top", "ldapsubentry", "nsroledefinition", "nssimpleroledefinition", "nsmanagedroledefinition"};
        LDAPAttribute[] lDAPAttributeArray = new LDAPAttribute[]{new LDAPAttribute("objectclass", stringArray2), new LDAPAttribute("cn", "nsManagedDisabledRole")};
        String[] stringArray3 = new String[]{"ldapsubentry", "nsroledefinition", "nscomplexroledefinition", "nsnestedroledefinition"};
        LDAPAttribute[] lDAPAttributeArray2 = new LDAPAttribute[]{new LDAPAttribute("objectclass", stringArray3), new LDAPAttribute("nsroledn", "cn=nsmanageddisabledrole," + this._suffix), new LDAPAttribute("cn", "nsDisabledRole")};
        String[] stringArray4 = new String[]{"top", "nscontainer"};
        LDAPAttribute[] lDAPAttributeArray3 = new LDAPAttribute[]{new LDAPAttribute("objectclass", stringArray4)};
        String[] stringArray5 = new String[]{"top", "ldapsubentry", "extensibleobject", "costemplate"};
        LDAPAttribute[] lDAPAttributeArray4 = new LDAPAttribute[]{new LDAPAttribute("objectclass", stringArray5), new LDAPAttribute("nsaccountlock", "true"), new LDAPAttribute("cospriority", "1")};
        String[] stringArray6 = new String[]{"top", "ldapsubentry", "cossuperdefinition", "cosclassicdefinition"};
        LDAPAttribute[] lDAPAttributeArray5 = new LDAPAttribute[]{new LDAPAttribute("objectclass", stringArray6), new LDAPAttribute("costemplatedn", "cn=nsAccountInactivationTmp," + this._suffix), new LDAPAttribute("cosspecifier", "nsrole"), new LDAPAttribute("cosattribute", "nsaccountlock operational")};
        LDAPAttributeSet[] lDAPAttributeSetArray = new LDAPAttributeSet[]{new LDAPAttributeSet(lDAPAttributeArray), new LDAPAttributeSet(lDAPAttributeArray2), new LDAPAttributeSet(lDAPAttributeArray3), new LDAPAttributeSet(lDAPAttributeArray4), new LDAPAttributeSet(lDAPAttributeArray5)};
        boolean bl = false;
        this._lockingInfrastructureDNs = new Vector();
        int n = 0;
        while (n < stringArray.length) {
            block8: {
                try {
                    LDAPEntry lDAPEntry = new LDAPEntry(stringArray[n], lDAPAttributeSetArray[n]);
                    lDAPConnection.add(lDAPEntry);
                    bl = true;
                    this._lockingInfrastructureDNs.addElement(lDAPEntry.getDN());
                }
                catch (LDAPException lDAPException) {
                    if (lDAPException.getLDAPResultCode() == 68) break block8;
                    Debug.println((String)("AccountInactivation.createLockingInfrastructure(): Error adding " + stringArray[n] + "\n with attribute:\n" + lDAPAttributeSetArray[n].toString() + "\n\n" + (Object)((Object)lDAPException)));
                    throw lDAPException;
                }
            }
            ++n;
        }
        if (bl) {
            try {
                Thread.sleep(1500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public Vector getLockingInfrastructureDNs() {
        return this._lockingInfrastructureDNs;
    }

    public boolean modifyEntryToActivateEntry(LDAPConnection lDAPConnection) throws LDAPException {
        if (this._suffix == null) {
            this.updateSuffixAndRoleDNs(lDAPConnection);
        }
        if (this._suffix == null) {
            return false;
        }
        LDAPAttribute lDAPAttribute = new LDAPAttribute("nsroledn", this._nsManagedDisabledRole);
        LDAPModification lDAPModification = new LDAPModification(1, lDAPAttribute);
        try {
            lDAPConnection.modify(this._dn, lDAPModification);
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() != 16) {
                Debug.println((String)("AccountInactivation.modifyEntryToActivateEntry(): " + (Object)((Object)lDAPException)));
                throw lDAPException;
            }
            Debug.println((int)0, (String)("AccountInactivation.modifyEntryToActivateEntry(): " + (Object)((Object)lDAPException)));
        }
        return true;
    }

    public boolean modifyRolesToActivateRole(LDAPConnection lDAPConnection) throws LDAPException {
        if (this._suffix == null) {
            this.updateSuffixAndRoleDNs(lDAPConnection);
        }
        if (this._suffix == null) {
            return false;
        }
        LDAPAttribute lDAPAttribute = new LDAPAttribute("nsroledn", this._dn);
        LDAPModification lDAPModification = new LDAPModification(1, lDAPAttribute);
        try {
            lDAPConnection.modify(this._nsDisabledRole, lDAPModification);
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() != 16) {
                Debug.println((String)("AccountInactivation.modifyRolesToActivateRole(): " + (Object)((Object)lDAPException)));
                throw lDAPException;
            }
            Debug.println((int)0, (String)("AccountInactivation.modifyRolesToActivateRole(): " + (Object)((Object)lDAPException)));
        }
        return true;
    }

    public boolean modifyEntryToInactivateEntry(LDAPConnection lDAPConnection) throws LDAPException {
        if (this._suffix == null) {
            this.updateSuffixAndRoleDNs(lDAPConnection);
        }
        if (this._suffix == null) {
            return false;
        }
        LDAPAttribute lDAPAttribute = new LDAPAttribute("nsroledn", this._nsManagedDisabledRole);
        LDAPModification lDAPModification = new LDAPModification(0, lDAPAttribute);
        try {
            lDAPConnection.modify(this._dn, lDAPModification);
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() != 20) {
                Debug.println((String)("AccountInactivation.modifyEntryToInactivateEntry(): " + (Object)((Object)lDAPException)));
                throw lDAPException;
            }
            Debug.println((int)0, (String)("AccountInactivation.modifyEntryToInactivateEntry(): " + (Object)((Object)lDAPException)));
        }
        return true;
    }

    public boolean modifyRolesToInactivateRole(LDAPConnection lDAPConnection) throws LDAPException {
        if (this._suffix == null) {
            this.updateSuffixAndRoleDNs(lDAPConnection);
        }
        if (this._suffix == null) {
            return false;
        }
        LDAPAttribute lDAPAttribute = new LDAPAttribute("nsroledn", this._dn);
        LDAPModification lDAPModification = new LDAPModification(0, lDAPAttribute);
        try {
            lDAPConnection.modify(this._nsDisabledRole, lDAPModification);
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() != 20) {
                Debug.println((String)("AccountInactivation.modifyRolesToInactivateRole(): " + (Object)((Object)lDAPException)));
                throw lDAPException;
            }
            Debug.println((int)0, (String)("AccountInactivation.modifyRolesToInactivateRole(): " + (Object)((Object)lDAPException)));
        }
        return true;
    }

    public int inactivate(LDAPConnection lDAPConnection) {
        try {
            int n = this.getState(lDAPConnection);
            if (n == 6) {
                Debug.println((String)("AccountInactivation.inactivate(): entry " + this._dn + " was already inactivated "));
                return 0;
            }
            if (n == 4) {
                Debug.println((String)("AccountInactivation.inactivate(): entry " + this._dn + " was already inactivated through unknown mechanics"));
                return 4;
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("AccountInactivation: inactivate() getting state of entry " + this._dn + " " + (Object)((Object)lDAPException)));
            return 1;
        }
        if (!this.canBeInactivated()) {
            Debug.println((String)("AccountInactivation.inactivate(): entry " + this._dn + " can not be inactivated: it is not a role and has no userpassword "));
            return 3;
        }
        try {
            if (!this.isLockingInfrastructureCreated(lDAPConnection)) {
                this.createLockingInfrastructure(lDAPConnection);
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("AccountInactivation: inactivate() creating locking roles for entry " + this._dn + " " + (Object)((Object)lDAPException)));
            return 1;
        }
        try {
            if (this.isRole() ? !this.modifyRolesToInactivateRole(lDAPConnection) && this._suffix == null : this.hasUserPassword() && !this.modifyEntryToInactivateEntry(lDAPConnection) && this._suffix == null) {
                return 7;
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("AccountInactivation: inactivate() modifying locking roles for entry " + this._dn + " " + (Object)((Object)lDAPException)));
            return 1;
        }
        return 0;
    }

    public int activate(LDAPConnection lDAPConnection) {
        try {
            int n = this.getState(lDAPConnection);
            if (n == 5) {
                Debug.println((String)("AccountInactivation.activate(): entry " + this._dn + " was already activated "));
                return 0;
            }
            if (n == 4) {
                Debug.println((String)("AccountInactivation.activate(): entry " + this._dn + " is inactivated through unknown mechanics"));
                return 4;
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("AccountInactivation: activate() getting state for entry " + this._dn + " " + (Object)((Object)lDAPException)));
            return 1;
        }
        try {
            if (!this.canBeActivated(lDAPConnection)) {
                Debug.println((String)("AccountInactivation.activate(): entry " + this._dn + " can't be activated because is locked trough roles " + this.getLockingRoles(lDAPConnection)));
                return 2;
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("AccountInactivation: activate() looking if we can activate entry " + this._dn + " " + (Object)((Object)lDAPException)));
            return 1;
        }
        try {
            if (this.isRole() ? !this.modifyRolesToActivateRole(lDAPConnection) && this._suffix == null : this.hasUserPassword() && !this.modifyEntryToActivateEntry(lDAPConnection) && this._suffix == null) {
                return 7;
            }
            return 0;
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("AccountInactivation: activate() modifying locking roles for entry " + this._dn + " " + (Object)((Object)lDAPException)));
            return 1;
        }
    }

    private LDAPEntry getEntry(ResourcePageObservable resourcePageObservable) {
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        Enumeration enumeration = resourcePageObservable.getAttributesList();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector = resourcePageObservable.get(string);
            String[] stringArray = new String[vector.size()];
            vector.toArray(stringArray);
            lDAPAttributeSet.add(new LDAPAttribute(string, stringArray));
        }
        LDAPEntry lDAPEntry = new LDAPEntry(resourcePageObservable.getDN(), lDAPAttributeSet);
        return lDAPEntry;
    }

    private boolean isRole() {
        LDAPAttribute lDAPAttribute = this._entry.getAttribute("objectclass");
        if (lDAPAttribute != null) {
            Enumeration enumeration = lDAPAttribute.getStringValues();
            boolean bl = false;
            boolean bl2 = false;
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string == null) continue;
                if (string.equalsIgnoreCase("nsroledefinition")) {
                    bl = true;
                } else if (string.equalsIgnoreCase("ldapsubentry")) {
                    bl2 = true;
                }
                if (!bl || !bl2) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasUserPassword() {
        return true;
    }

    private void updateSuffixAndRoleDNs(LDAPConnection lDAPConnection) {
        boolean bl = false;
        String string = null;
        DN dN = null;
        DN dN2 = new DN(this._dn);
        ListIterator listIterator = ((AbstractList)this._dbConfig.getSuffixes()).listIterator();
        while (listIterator.hasNext() && !bl) {
            DN dN3;
            Suffix suffix = (Suffix)listIterator.next();
            if (suffix.getParentSuffix() != null || !dN2.isDescendantOf(dN3 = new DN(suffix.getName())) && !dN2.equals(dN3)) continue;
            bl = true;
            dN = dN3;
        }
        if (!bl) {
            Debug.println((String)("AccountInactivation(): could not get the suffix of the entry " + this._dn));
        } else if (!dN.equals(dN2)) {
            string = dN.toString();
        }
        this._suffix = string;
        this._nsDisabledRole = "cn=nsdisabledrole," + this._suffix;
        this._nsManagedDisabledRole = "cn=nsmanageddisabledrole," + this._suffix;
    }

    private void updateThroughRoles(LDAPConnection lDAPConnection) throws LDAPException {
        if (this.isRole()) {
            this.updateThroughRolesForRole(lDAPConnection);
        } else if (this.hasUserPassword()) {
            this.updateThroughRolesForEntry(lDAPConnection);
        }
    }

    private void updateThroughRolesForEntry(LDAPConnection lDAPConnection) throws LDAPException {
        block11: {
            this._throughRoles = null;
            if (this._suffix == null) {
                this.updateSuffixAndRoleDNs(lDAPConnection);
            }
            try {
                LDAPEntry lDAPEntry;
                Object object;
                if (this._nsDisabledRole != null && lDAPConnection != null) {
                    object = (LDAPSearchConstraints)lDAPConnection.getSearchConstraints().clone();
                    lDAPEntry = DSUtil.readEntry(lDAPConnection, this._nsDisabledRole, this.ATTRS, (LDAPSearchConstraints)object);
                    if (lDAPEntry == null) {
                        Debug.println((String)("AccountInactivation.updateThroughRolesForEntry(): could not read the nsDisabledRoleEntry " + this._nsDisabledRole));
                        return;
                    }
                } else {
                    return;
                }
                object = this.getAttributeValues(this._entry, "nsrole");
                Vector vector = this.getAttributeValues(lDAPEntry, "nsroledn");
                if (object == null || vector == null) {
                    Debug.println((String)("AccountInactivation.updateThroughRolesForEntry(): the entry " + this._dn + " has no nsrole or the role has no nsroledn"));
                    return;
                }
                int n = 0;
                while (n < ((Vector)object).size()) {
                    DN dN = new DN((String)((Vector)object).elementAt(n));
                    int n2 = 0;
                    while (n2 < vector.size()) {
                        DN dN2 = new DN((String)vector.elementAt(n2));
                        if (dN.equals(dN2)) {
                            if (this._throughRoles == null) {
                                this._throughRoles = new Vector();
                            }
                            this._throughRoles.addElement(vector.elementAt(n2));
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 32) break block11;
                Debug.println((String)("AccountInactivation.updateThroughRolesForEntry(): " + (Object)((Object)lDAPException)));
                throw lDAPException;
            }
        }
    }

    private void updateThroughRolesForRole(LDAPConnection lDAPConnection) throws LDAPException {
        block6: {
            this._throughRoles = null;
            if (this._suffix == null) {
                this.updateSuffixAndRoleDNs(lDAPConnection);
            }
            try {
                LDAPEntry lDAPEntry;
                if (this._nsDisabledRole != null && lDAPConnection != null) {
                    LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)lDAPConnection.getSearchConstraints().clone();
                    lDAPEntry = DSUtil.readEntry(lDAPConnection, this._nsDisabledRole, this.ATTRS, lDAPSearchConstraints);
                    if (lDAPEntry == null) {
                        Debug.println((String)("AccountInactivation.updateThroughRolesForRole(): could not read the nsDisabledRoleEntry " + this._nsDisabledRole));
                        return;
                    }
                } else {
                    return;
                }
                this.lookForRolesLockingRole(this._dn, lDAPEntry, lDAPConnection);
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 32) break block6;
                Debug.println((String)("AccountInactivation.updateThroughRolesForRole(): " + (Object)((Object)lDAPException)));
                throw lDAPException;
            }
        }
    }

    private void lookForRolesLockingRole(String string, LDAPEntry lDAPEntry, LDAPConnection lDAPConnection) throws LDAPException {
        if (lDAPEntry == null) {
            return;
        }
        Vector vector = this.getAttributeValues(lDAPEntry, "nsroledn");
        if (vector == null) {
            return;
        }
        DN dN = new DN(string);
        DN dN2 = new DN(lDAPEntry.getDN());
        if (!dN.isDescendantOf(dN2.getParent())) {
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            block11: {
                DN dN3 = new DN((String)vector.elementAt(n));
                if (dN3.equals(dN)) {
                    if (this._throughRoles == null) {
                        this._throughRoles = new Vector();
                    }
                    this._throughRoles.addElement(lDAPEntry.getDN());
                } else {
                    try {
                        if (vector.elementAt(n) != null && lDAPConnection != null) {
                            LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)lDAPConnection.getSearchConstraints().clone();
                            LDAPEntry lDAPEntry2 = DSUtil.readEntry(lDAPConnection, (String)vector.elementAt(n), this.ATTRS, lDAPSearchConstraints);
                            if (lDAPEntry2 != null) {
                                this.lookForRolesLockingRole(string, lDAPEntry2, lDAPConnection);
                            }
                        }
                    }
                    catch (LDAPException lDAPException) {
                        if (lDAPException.getLDAPResultCode() == 32) break block11;
                        Debug.println((String)("AccountInactivation.lookForRolesLockingRole(): " + (Object)((Object)lDAPException)));
                        throw lDAPException;
                    }
                }
            }
            ++n;
        }
    }

    private Vector getAttributeValues(LDAPEntry lDAPEntry, String string) {
        Vector vector = new Vector();
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string);
        if (lDAPAttribute != null) {
            Enumeration enumeration = lDAPAttribute.getStringValues();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        if (vector.isEmpty()) {
            return null;
        }
        return vector;
    }
}

