/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.browser;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSSearchPanel;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.browser.Activator;
import com.netscape.admin.dirserv.browser.CutDeleter;
import com.netscape.admin.dirserv.browser.EntryEditor;
import com.netscape.admin.dirserv.browser.IContentPageInfo;
import com.netscape.admin.dirserv.browser.Inactivator;
import com.netscape.admin.dirserv.config.Suffix;
import com.netscape.admin.dirserv.effectiverights.EffectiveRightsInputDialog;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.ppoledit.PasswordPolicyEditorDialog;
import com.netscape.admin.dirserv.ppoledit.PasswordPolicyEditorDialogForRoles;
import com.netscape.admin.dirserv.roledit.RoleEditorDialog;
import com.netscape.management.client.MenuItemSeparator;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.ace.ACIManager;
import com.netscape.management.client.console.Console;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.ug.AdvancePanel;
import com.netscape.management.client.ug.BasicPanel;
import com.netscape.management.client.ug.IResourcePickerPlugin;
import com.netscape.management.client.ug.ResourcePickerDlg;
import com.netscape.management.client.ug.SearchResultPanel;
import com.netscape.management.client.util.ArrowIcon;
import com.netscape.management.client.util.JButtonFactory;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.util.DN;

public class DSSearchDialog
extends ResourcePickerDlg {
    private JButton _bHelp;
    private JButton _bClose;
    private JButton _bAction;
    private JButton _bDelete;
    private JButton _bEdit;
    private JLabel _lDn;
    private JPopupMenu _actionMenu;
    private MenuItemText _mOpen;
    private MenuItemText _mAdvanced;
    private MenuItemText _mEffectiveRights;
    private MenuItemText _mAci;
    private MenuItemText _mRoles;
    private MenuItemText _mPasswordPolicy;
    private MenuItemText _mActivate;
    private MenuItemText _mInactivate;
    private MenuItemText _mDelete;
    private MenuItemSeparator _mSeparator;
    private SearchResultPanel _searchResultPanel;
    private ArrayList _modifiedEntries = new ArrayList();
    private ActionListener _listener;
    private IContentPageInfo _contentPageInfo;
    private ConsoleInfo _info;
    private DSFramework _framework;
    private static ResourceSet _resource = DSUtil._resource;

    public DSSearchDialog(ConsoleInfo consoleInfo, IContentPageInfo iContentPageInfo, DSFramework dSFramework) {
        super(consoleInfo, (JFrame)((Object)dSFramework));
        this._info = consoleInfo;
        this._contentPageInfo = iContentPageInfo;
        this._framework = dSFramework;
        this._searchResultPanel = this.getSearchResultPanel(this.getContentPane().getComponents());
        this._listener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object == DSSearchDialog.this._bHelp) {
                    DSSearchDialog.this.helpInvoked();
                } else if (object == DSSearchDialog.this._bClose) {
                    DSSearchDialog.super.closeInvoked();
                } else if (object == DSSearchDialog.this._bDelete) {
                    DSSearchDialog.this.actionDelete();
                } else if (object == DSSearchDialog.this._bEdit) {
                    DSSearchDialog.this.actionEdit();
                } else if (object == DSSearchDialog.this._bAction) {
                    DSSearchDialog.this._mOpen.setVisible(false);
                    DSSearchDialog.this._mAdvanced.setVisible(false);
                    DSSearchDialog.this._mSeparator.setVisible(false);
                    DSSearchDialog.this._mDelete.setVisible(false);
                    DSSearchDialog.this._actionMenu.show(DSSearchDialog.this._bAction, UIFactory.getComponentSpace() - (int)DSSearchDialog.this._actionMenu.getPreferredSize().getWidth(), UIFactory.getComponentSpace());
                } else if (object == DSSearchDialog.this._mOpen) {
                    DSSearchDialog.this.actionEdit();
                } else if (object == DSSearchDialog.this._mAdvanced) {
                    DSSearchDialog.this.actionAdvancedEdit();
                } else if (object == DSSearchDialog.this._mEffectiveRights) {
                    DSSearchDialog.this.actionEffectiveRights();
                } else if (object == DSSearchDialog.this._mAci) {
                    DSSearchDialog.this.actionAci();
                } else if (object == DSSearchDialog.this._mRoles) {
                    DSSearchDialog.this.actionRoles();
                } else if (object == DSSearchDialog.this._mPasswordPolicy) {
                    DSSearchDialog.this.actionPasswordPolicy();
                } else if (object == DSSearchDialog.this._mActivate) {
                    DSSearchDialog.this.actionActivate();
                } else if (object == DSSearchDialog.this._mInactivate) {
                    DSSearchDialog.this.actionInactivate();
                } else if (object == DSSearchDialog.this._mDelete) {
                    DSSearchDialog.this.actionDelete();
                }
            }
        };
        this.createActionButtons();
        this.createActionMenu();
        this._searchResultPanel.addTableMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && DSSearchDialog.this._searchResultPanel.getSelectedEntries() != null && DSSearchDialog.this._searchResultPanel.getSelectedEntries().size() == 1) {
                    DSSearchDialog.this.actionEdit();
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (!DSSearchDialog.this._actionMenu.isVisible() && SwingUtilities.isRightMouseButton(mouseEvent)) {
                    DSSearchDialog.this._mOpen.setVisible(true);
                    DSSearchDialog.this._mAdvanced.setVisible(true);
                    DSSearchDialog.this._mSeparator.setVisible(true);
                    DSSearchDialog.this._mDelete.setVisible(true);
                    this.popupContextMenu(mouseEvent);
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (!DSSearchDialog.this._actionMenu.isVisible() && SwingUtilities.isRightMouseButton(mouseEvent)) {
                    DSSearchDialog.this._mOpen.setVisible(true);
                    DSSearchDialog.this._mAdvanced.setVisible(true);
                    DSSearchDialog.this._mSeparator.setVisible(true);
                    DSSearchDialog.this._mDelete.setVisible(true);
                    this.popupContextMenu(mouseEvent);
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            private void popupContextMenu(MouseEvent mouseEvent) {
                Component component = mouseEvent.getComponent();
                if (component instanceof JTable) {
                    int n = ((JTable)component).rowAtPoint(mouseEvent.getPoint());
                    boolean bl = n != -1;
                    ListSelectionModel listSelectionModel = ((JTable)component).getSelectionModel();
                    if (bl) {
                        if (!listSelectionModel.isSelectedIndex(n)) {
                            listSelectionModel.setSelectionInterval(n, n);
                        }
                        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                        Point point = component.getLocationOnScreen();
                        int n2 = (int)dimension.getWidth();
                        int n3 = DSSearchDialog.this._actionMenu.getWidth();
                        int n4 = mouseEvent.getX();
                        int n5 = (int)point.getX();
                        int n6 = (int)dimension.getHeight();
                        int n7 = DSSearchDialog.this._actionMenu.getHeight();
                        int n8 = mouseEvent.getY();
                        int n9 = (int)point.getY();
                        if (n5 + n4 + n3 > n2) {
                            n4 -= n3;
                        }
                        if (n9 + n8 + n7 > n6) {
                            n8 -= n7;
                        }
                        DSSearchDialog.this._actionMenu.show(component, n4, n8);
                    }
                }
            }
        });
        this._searchResultPanel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                boolean bl = DSSearchDialog.this._searchResultPanel.getSelectedEntries() == null || DSSearchDialog.this._searchResultPanel.getSelectedEntries().size() == 0;
                boolean bl2 = DSSearchDialog.this._searchResultPanel.getSelectedEntries().size() == 1;
                DSSearchDialog.this._bEdit.setEnabled(bl2);
                DSSearchDialog.this._bDelete.setEnabled(!bl);
                DSSearchDialog.this._bAction.setEnabled(bl2);
                if (!bl) {
                    DSSearchDialog.this.updateMenuEnabling();
                    if (DSSearchDialog.this._searchResultPanel.getSelectedEntries().size() > 1) {
                        DSSearchDialog.this._lDn.setText("  ");
                    } else {
                        LDAPEntry lDAPEntry = (LDAPEntry)DSSearchDialog.this._searchResultPanel.getSelectedEntries().elementAt(0);
                        DSSearchDialog.this._lDn.setText(lDAPEntry.getDN());
                    }
                } else {
                    DSSearchDialog.this._lDn.setText("  ");
                }
            }
        });
        this.createHelpCloseButtons();
    }

    public ArrayList getModifiedEntries() {
        return this._modifiedEntries;
    }

    protected void helpInvoked() {
        IResourcePickerPlugin iResourcePickerPlugin = this.getSearchInterface(this.getContentPane().getComponents());
        String string = this._framework.getServerObject().getServerInfo().getAdminURL();
        if (iResourcePickerPlugin instanceof DSSearchPanel) {
            ((DSSearchPanel)iResourcePickerPlugin).help();
        } else if (iResourcePickerPlugin instanceof AdvancePanel) {
            DSUtil.help("search_advanced", string);
        } else if (iResourcePickerPlugin instanceof BasicPanel) {
            DSUtil.help("search_basic", string);
        } else {
            super.helpInvoked();
        }
    }

    private SearchResultPanel getSearchResultPanel(Component[] componentArray) {
        SearchResultPanel searchResultPanel = null;
        int n = 0;
        while (n < componentArray.length && searchResultPanel == null) {
            if (componentArray[n] instanceof SearchResultPanel) {
                searchResultPanel = (SearchResultPanel)componentArray[n];
            } else if (componentArray[n] instanceof Container) {
                searchResultPanel = this.getSearchResultPanel(((Container)componentArray[n]).getComponents());
            }
            ++n;
        }
        return searchResultPanel;
    }

    private IResourcePickerPlugin getSearchInterface(Component[] componentArray) {
        IResourcePickerPlugin iResourcePickerPlugin = null;
        int n = 0;
        while (n < componentArray.length && iResourcePickerPlugin == null) {
            if (componentArray[n] instanceof IResourcePickerPlugin) {
                if (componentArray[n].isVisible()) {
                    iResourcePickerPlugin = (IResourcePickerPlugin)componentArray[n];
                }
            } else if (componentArray[n] instanceof Container) {
                iResourcePickerPlugin = this.getSearchInterface(((Container)componentArray[n]).getComponents());
            }
            ++n;
        }
        return iResourcePickerPlugin;
    }

    private void createActionMenu() {
        this._actionMenu = new JPopupMenu();
        this._mOpen = new MenuItemText("open", _resource.getString("menu", "properties"), _resource.getString("menu", "properties-description"), this._listener);
        this._actionMenu.add((JMenuItem)this._mOpen);
        this._mAdvanced = new MenuItemText("advanced open", _resource.getString("menu", "advanced-properties"), _resource.getString("menu", "advanced-properties-description"), this._listener);
        this._actionMenu.add((JMenuItem)this._mAdvanced);
        this._mEffectiveRights = new MenuItemText("effective rights", _resource.getString("menu", "effectiverights"), _resource.getString("menu", "effectiverights-description"), this._listener);
        this._actionMenu.add((JMenuItem)this._mEffectiveRights);
        this._actionMenu.add((Component)new MenuItemSeparator());
        this._mAci = new MenuItemText("acl", _resource.getString("menu", "editacls"), _resource.getString("menu", "editacls-description"), this._listener);
        this._actionMenu.add((JMenuItem)this._mAci);
        this._mRoles = new MenuItemText("roles", _resource.getString("menu", "editroles"), _resource.getString("menu", "editroles-description"), this._listener);
        this._actionMenu.add((JMenuItem)this._mRoles);
        this._mPasswordPolicy = new MenuItemText("password policies", _resource.getString("menu", "editpasswordpolicies"), _resource.getString("menu", "editpasswordpolicies-description"), this._listener);
        this._actionMenu.add((JMenuItem)this._mPasswordPolicy);
        this._actionMenu.add((Component)new MenuItemSeparator());
        this._mActivate = new MenuItemText("activate", _resource.getString("menu", "activate"), _resource.getString("menu", "activate-description"), this._listener);
        this._actionMenu.add((JMenuItem)this._mActivate);
        this._mInactivate = new MenuItemText("inactivate", _resource.getString("menu", "inactivate"), _resource.getString("menu", "inactivate-description"), this._listener);
        this._actionMenu.add((JMenuItem)this._mInactivate);
        this._mSeparator = new MenuItemSeparator();
        this._actionMenu.add((Component)this._mSeparator);
        this._mDelete = new MenuItemText("delete", _resource.getString("menu", "EditDelete"), _resource.getString("menu", "EditDelete-description"), this._listener);
        this._actionMenu.add((JMenuItem)this._mDelete);
    }

    private void createActionButtons() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        this._bEdit = UIFactory.makeJButton(this._listener, "dssearchdialog", "bedit", DSUtil._resource);
        this._bDelete = UIFactory.makeJButton(this._listener, "dssearchdialog", "bdelete", DSUtil._resource);
        this._bAction = UIFactory.makeJButton(this._listener, "dssearchdialog", "baction", DSUtil._resource);
        ArrowIcon arrowIcon = new ArrowIcon(7);
        this._bAction.setIcon((Icon)arrowIcon);
        this._bEdit.setEnabled(false);
        this._bDelete.setEnabled(false);
        this._bAction.setEnabled(false);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        jPanel.add((Component)this._bEdit, gridBagConstraints);
        gridBagConstraints.insets.top = UIFactory.getComponentSpace();
        jPanel.add((Component)this._bDelete, gridBagConstraints);
        jPanel.add((Component)this._bAction, gridBagConstraints);
        jPanel.add(Box.createHorizontalStrut((int)this._bAction.getPreferredSize().getWidth() + arrowIcon.getIconWidth()), gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        this._searchResultPanel.add("East", jPanel);
        this._lDn = new JLabel();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)this._lDn, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add(Box.createHorizontalGlue(), gridBagConstraints);
        this._searchResultPanel.add("South", jPanel2);
    }

    private void createHelpCloseButtons() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._bHelp = JButtonFactory.createHelpButton((ActionListener)this._listener);
        this._bClose = JButtonFactory.createCloseButton((ActionListener)this._listener);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this._bClose, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = UIFactory.getDifferentSpace();
        jPanel.add((Component)this._bHelp, gridBagConstraints);
        Container container = (Container)this.getButtonComponent();
        container.removeAll();
        container.add(jPanel);
    }

    private void updateMenuEnabling() {
        boolean bl = this._searchResultPanel.getSelectedEntries().size() > 1;
        this._mOpen.setEnabled(!bl);
        this._mAdvanced.setEnabled(!bl);
        this._mEffectiveRights.setEnabled(!bl);
        this._mAci.setEnabled(!bl);
        this._mRoles.setEnabled(!bl);
        this._mPasswordPolicy.setEnabled(!bl);
        this._mActivate.setEnabled(!bl);
        this._mInactivate.setEnabled(!bl);
        if (!bl) {
            LDAPEntry lDAPEntry = (LDAPEntry)this._searchResultPanel.getSelectedEntries().elementAt(0);
            this._mOpen.setEnabled(this._contentPageInfo.hasCustomEditor(lDAPEntry));
            boolean bl2 = this._contentPageInfo.isSelectedNodeRemote();
            if (!bl2) {
                Integer n = this._contentPageInfo.getActivationState(lDAPEntry.getDN());
                this._mInactivate.setEnabled(n == 9);
                this._mActivate.setEnabled(n == 8);
            } else {
                this._mInactivate.setEnabled(false);
                this._mActivate.setEnabled(false);
            }
        }
    }

    private void actionEdit() {
        this.setBusyCursor(true);
        LDAPEntry lDAPEntry = (LDAPEntry)this._searchResultPanel.getSelectedEntries().elementAt(0);
        LDAPConnection lDAPConnection = this._info.getLDAPConnection();
        EntryEditor entryEditor = this._contentPageInfo.getEntryEditor();
        boolean bl = entryEditor.editObject(lDAPEntry.getDN(), lDAPConnection, false);
        if (bl) {
            String string = entryEditor.getEditedObjectDn();
            this.updateTable(string, lDAPConnection);
            this._modifiedEntries.add(string);
        }
        this.setBusyCursor(false);
    }

    private void actionAdvancedEdit() {
        this.setBusyCursor(true);
        LDAPEntry lDAPEntry = (LDAPEntry)this._searchResultPanel.getSelectedEntries().elementAt(0);
        LDAPConnection lDAPConnection = this._info.getLDAPConnection();
        EntryEditor entryEditor = this._contentPageInfo.getEntryEditor();
        boolean bl = entryEditor.editObject(lDAPEntry.getDN(), lDAPConnection, true);
        if (bl) {
            String string = entryEditor.getEditedObjectDn();
            this.updateTable(string, lDAPConnection);
            this._modifiedEntries.add(string);
        }
        this.setBusyCursor(false);
    }

    private void actionEffectiveRights() {
        this.setBusyCursor(true);
        LDAPEntry lDAPEntry = (LDAPEntry)this._searchResultPanel.getSelectedEntries().elementAt(0);
        LDAPConnection lDAPConnection = this._info.getLDAPConnection();
        EffectiveRightsInputDialog effectiveRightsInputDialog = new EffectiveRightsInputDialog(this._framework, lDAPConnection, lDAPEntry.getDN());
        effectiveRightsInputDialog.pack();
        effectiveRightsInputDialog.show();
        this.setBusyCursor(false);
    }

    private void actionAci() {
        DN dN;
        this.setBusyCursor(true);
        LDAPEntry lDAPEntry = (LDAPEntry)this._searchResultPanel.getSelectedEntries().elementAt(0);
        LDAPConnection lDAPConnection = this._info.getLDAPConnection();
        LDAPConnection lDAPConnection2 = Console.getConsoleInfo().getUserLDAPConnection();
        String string = "";
        if (lDAPConnection2.getHost().equals(lDAPConnection.getHost()) && lDAPConnection2.getPort() == lDAPConnection.getPort()) {
            string = Console.getConsoleInfo().getUserBaseDN();
        } else {
            dN = new DN(lDAPEntry.getDN());
            boolean bl = false;
            Enumeration enumeration = this._framework.getServerObject().getDatabaseConfig().getSuffixes().elements();
            while (enumeration.hasMoreElements() && !bl) {
                DN dN2;
                Suffix suffix = (Suffix)enumeration.nextElement();
                if (suffix.getParentSuffix() != null || !dN.equals(dN2 = new DN(suffix.getName())) && !dN.isDescendantOf(dN2)) continue;
                bl = true;
                string = suffix.getName();
            }
        }
        dN = new ACIManager((JFrame)((Object)this._framework), lDAPEntry.getDN(), lDAPConnection, lDAPEntry.getDN(), lDAPConnection, string);
        dN.show();
        this._modifiedEntries.add(lDAPEntry.getDN());
        this.setBusyCursor(false);
    }

    private void actionRoles() {
        this.setBusyCursor(true);
        LDAPEntry lDAPEntry = (LDAPEntry)this._searchResultPanel.getSelectedEntries().elementAt(0);
        String string = lDAPEntry.getDN();
        LDAPConnection lDAPConnection = this._info.getLDAPConnection();
        ConsoleInfo consoleInfo = new ConsoleInfo(lDAPConnection.getHost(), lDAPConnection.getPort(), lDAPConnection.getAuthenticationDN() == null ? "" : lDAPConnection.getAuthenticationDN(), lDAPConnection.getAuthenticationDN() == null ? "" : lDAPConnection.getAuthenticationPassword(), string);
        consoleInfo.setCurrentDN(string);
        consoleInfo.setUserGroupDN(string);
        consoleInfo.setLDAPConnection(lDAPConnection);
        RoleEditorDialog roleEditorDialog = new RoleEditorDialog((JFrame)((Object)this._framework), consoleInfo);
        roleEditorDialog.show();
        this._modifiedEntries.add(string);
        this.setBusyCursor(false);
    }

    private void actionPasswordPolicy() {
        PasswordPolicyEditorDialog passwordPolicyEditorDialog;
        this.setBusyCursor(true);
        LDAPEntry lDAPEntry = (LDAPEntry)this._searchResultPanel.getSelectedEntries().elementAt(0);
        String string = lDAPEntry.getDN();
        LDAPConnection lDAPConnection = this._info.getLDAPConnection();
        ConsoleInfo consoleInfo = new ConsoleInfo(lDAPConnection.getHost(), lDAPConnection.getPort(), lDAPConnection.getAuthenticationDN() == null ? "" : lDAPConnection.getAuthenticationDN(), lDAPConnection.getAuthenticationDN() == null ? "" : lDAPConnection.getAuthenticationPassword(), string);
        consoleInfo.setCurrentDN(string);
        consoleInfo.setUserGroupDN(string);
        consoleInfo.setLDAPConnection(lDAPConnection);
        boolean bl = false;
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("objectclass");
        if (lDAPAttribute != null) {
            String[] stringArray = lDAPAttribute.getStringValueArray();
            int n = 0;
            while (n < stringArray.length) {
                String string2 = stringArray[n];
                if (string2.toLowerCase().equals("nsroledefinition")) {
                    passwordPolicyEditorDialog = new PasswordPolicyEditorDialogForRoles(this._framework, consoleInfo);
                    bl = true;
                }
                ++n;
            }
        }
        if (!bl) {
            passwordPolicyEditorDialog = new PasswordPolicyEditorDialog(this._framework, consoleInfo);
        }
        this._modifiedEntries.add(string);
        this.setBusyCursor(false);
    }

    private void actionActivate() {
        this.setBusyCursor(true);
        LDAPEntry lDAPEntry = (LDAPEntry)this._searchResultPanel.getSelectedEntries().elementAt(0);
        String string = lDAPEntry.getDN();
        LDAPConnection lDAPConnection = this._info.getLDAPConnection();
        Activator activator = new Activator(this._framework, string, lDAPConnection);
        activator.execute();
        this._contentPageInfo.notifyActivationModified(string);
        this._modifiedEntries.add(string);
        this.updateMenuEnabling();
        this.setBusyCursor(false);
    }

    private void actionInactivate() {
        this.setBusyCursor(true);
        LDAPEntry lDAPEntry = (LDAPEntry)this._searchResultPanel.getSelectedEntries().elementAt(0);
        String string = lDAPEntry.getDN();
        LDAPConnection lDAPConnection = this._info.getLDAPConnection();
        Inactivator inactivator = new Inactivator(this._framework, string, lDAPConnection);
        inactivator.execute();
        this._contentPageInfo.notifyActivationModified(string);
        this._modifiedEntries.add(string);
        this.updateMenuEnabling();
        this.setBusyCursor(false);
    }

    private void actionDelete() {
        this.setBusyCursor(true);
        Vector vector = this._searchResultPanel.getSelectedEntries();
        String[] stringArray = new String[vector.size()];
        LDAPConnection[] lDAPConnectionArray = new LDAPConnection[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = ((LDAPEntry)vector.get(n)).getDN();
            lDAPConnectionArray[n] = this._info.getLDAPConnection();
            ++n;
        }
        CutDeleter cutDeleter = new CutDeleter(lDAPConnectionArray, stringArray, (JFrame)((Object)this._framework), null, false);
        cutDeleter.execute();
        Vector vector2 = new Vector();
        ListIterator listIterator = ((AbstractList)cutDeleter.getDeletedSubtrees()).listIterator();
        while (listIterator.hasNext()) {
            String string = (String)listIterator.next();
            boolean bl = false;
            int n2 = 0;
            while (n2 < stringArray.length && !bl) {
                bl = string.equals(stringArray[n2]);
                if (bl) {
                    vector2.add(vector.get(n2));
                    this._modifiedEntries.add(string);
                }
                ++n2;
            }
        }
        if (vector2.size() > 0) {
            this._searchResultPanel.deleteRows(vector2);
        }
        this.setBusyCursor(false);
    }

    private void updateTable(String string, LDAPConnection lDAPConnection) {
        try {
            LDAPEntry lDAPEntry = lDAPConnection.read(string);
            this._searchResultPanel.updatedSelectedItem(lDAPEntry);
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
    }
}

