/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.browser;

import com.netscape.admin.dirserv.DSEntryDialog;
import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSResourceEditor;
import com.netscape.admin.dirserv.DSSchemaHelper;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.browser.DialogDisplayerAndDisposer;
import com.netscape.admin.dirserv.browser.LDAPConnectionPool;
import com.netscape.admin.dirserv.config.DatabaseConfig;
import com.netscape.admin.dirserv.config.Suffix;
import com.netscape.admin.dirserv.propedit.ChooseObjectClassDialog;
import com.netscape.admin.dirserv.propedit.DSEntryPanel;
import com.netscape.admin.dirserv.propedit.DSPropertyModel;
import com.netscape.admin.dirserv.propedit.EntryPageDescription;
import com.netscape.admin.dirserv.referraledit.ResEditorReferralURLPage;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.ug.ResourceEditor;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSchema;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

public class EntryEditor {
    LDAPConnection _ldc;
    LDAPSchema _schema;
    JFrame _frame;
    DatabaseConfig _databaseConfig;
    static ResourceSet _resource = DSUtil._resource;
    String[] _allAttrs;
    String _editedObjectDn;
    LDAPEntry _createdObject;
    private LDAPConnectionPool _connectionPool;
    static final String DEFAULT_NEW = _resource.getString("EntryObject", "defaultnew");

    public EntryEditor(LDAPSchema lDAPSchema, JFrame jFrame, DatabaseConfig databaseConfig) {
        this._schema = lDAPSchema;
        this._frame = jFrame;
        this._databaseConfig = databaseConfig;
    }

    public EntryEditor(LDAPSchema lDAPSchema, JFrame jFrame) {
        this(lDAPSchema, jFrame, null);
    }

    public boolean createUser(String string, LDAPConnection lDAPConnection) {
        this._createdObject = null;
        this._ldc = lDAPConnection;
        Vector vector = (Vector)ResourceEditor.getNewObjectClasses().get("newUserObjectClasses");
        return this.newPredefinedObject(vector, string);
    }

    public boolean createGroup(String string, LDAPConnection lDAPConnection) {
        this._createdObject = null;
        this._ldc = lDAPConnection;
        Vector vector = (Vector)ResourceEditor.getNewObjectClasses().get("newGroupObjectClasses");
        return this.newPredefinedObject(vector, string);
    }

    public boolean createOrganizationalUnit(String string, LDAPConnection lDAPConnection) {
        this._createdObject = null;
        this._ldc = lDAPConnection;
        Vector vector = (Vector)ResourceEditor.getNewObjectClasses().get("newOUObjectClasses");
        return this.newPredefinedObject(vector, string);
    }

    public boolean createCos(String string, LDAPConnection lDAPConnection) {
        this._createdObject = null;
        this._ldc = lDAPConnection;
        Vector<String> vector = new Vector<String>();
        vector.addElement("top");
        vector.addElement("ldapsubentry");
        vector.addElement("cossuperdefinition");
        return this.newPredefinedObject(vector, string);
    }

    public boolean createRole(String string, LDAPConnection lDAPConnection) {
        this._createdObject = null;
        this._ldc = lDAPConnection;
        Vector<String> vector = new Vector<String>();
        vector.addElement("top");
        vector.addElement("ldapsubentry");
        vector.addElement("nsroledefinition");
        return this.newPredefinedObject(vector, string);
    }

    public boolean createPasswordPolicy(String string, LDAPConnection lDAPConnection) {
        this._createdObject = null;
        this._ldc = lDAPConnection;
        Vector<String> vector = new Vector<String>();
        vector.addElement("top");
        vector.addElement("ldapsubentry");
        vector.addElement("passwordpolicy");
        return this.newPredefinedObject(vector, string);
    }

    public boolean createReferral(String string, LDAPConnection lDAPConnection) {
        this._createdObject = null;
        this._ldc = lDAPConnection;
        Vector<String> vector = new Vector<String>();
        vector.addElement("top");
        vector.addElement("extensibleobject");
        vector.addElement("referral");
        return this.newPredefinedObject(vector, string);
    }

    public boolean createObject(String string, LDAPConnection lDAPConnection) {
        this._createdObject = null;
        this._ldc = lDAPConnection;
        boolean bl = false;
        ChooseObjectClassDialog chooseObjectClassDialog = new ChooseObjectClassDialog(this._frame, this._schema);
        chooseObjectClassDialog.show();
        ((Window)((Object)chooseObjectClassDialog)).dispose();
        if (!chooseObjectClassDialog.isCancel()) {
            LDAPEntry lDAPEntry;
            LDAPAttribute lDAPAttribute;
            String string2;
            String string3 = chooseObjectClassDialog.getSelectedValue();
            Vector vector = DSSchemaHelper.getObjectClassVector(string3, this._schema);
            if (DSSchemaHelper.isStandardObjectClass(vector, this._schema)) {
                bl = this.newPredefinedObject(vector, string);
                return bl;
            }
            Hashtable hashtable = new Hashtable();
            DSSchemaHelper.allRequiredAttributes(string3, this._schema, hashtable);
            Enumeration enumeration = hashtable.elements();
            LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
            String string4 = null;
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                lDAPAttribute = new LDAPAttribute(string2);
                if (string2.equalsIgnoreCase("objectclass")) {
                    vector = DSSchemaHelper.getObjectClassVector(string3, this._schema);
                    int n = vector.size() - 1;
                    while (n >= 0) {
                        lDAPAttribute.addValue((String)vector.elementAt(n));
                        --n;
                    }
                } else {
                    lDAPAttribute.addValue("");
                    if (string4 == null && !string2.equalsIgnoreCase("aci")) {
                        string4 = string2;
                    }
                }
                lDAPAttributeSet.add(lDAPAttribute);
            }
            if (string4 == null) {
                hashtable = new Hashtable();
                DSSchemaHelper.allOptionalAttributes(string3, this._schema, hashtable);
                enumeration = hashtable.elements();
                if (enumeration.hasMoreElements() && (string4 = (String)enumeration.nextElement()).equalsIgnoreCase("aci")) {
                    string4 = enumeration.hasMoreElements() ? (String)enumeration.nextElement() : null;
                }
            }
            if (string4 == null) {
                DSUtil.showErrorDialog((Component)this._frame, "noRDN", string3, "EntryObject");
                return false;
            }
            string2 = DEFAULT_NEW;
            lDAPAttribute = lDAPAttributeSet.getAttribute(string4);
            if (lDAPAttribute != null) {
                Enumeration enumeration2 = lDAPAttribute.getStringValues();
                if (enumeration2 != null && enumeration2.hasMoreElements()) {
                    string2 = (String)enumeration2.nextElement();
                    if (string2.length() < 1) {
                        string2 = DEFAULT_NEW;
                        lDAPAttributeSet.remove(string4);
                        lDAPAttributeSet.add(new LDAPAttribute(string4, string2));
                    }
                } else {
                    lDAPAttribute.addValue(string2);
                }
            } else {
                lDAPAttribute = new LDAPAttribute(string4, string2);
                lDAPAttributeSet.add(lDAPAttribute);
            }
            String string5 = string4 + "=" + string2;
            if (string != null && string.length() > 0) {
                lDAPEntry = new DN(string);
                lDAPEntry.addRDN(new RDN(string5));
                string5 = lDAPEntry.toRFCString();
            }
            if (this.addGeneric(lDAPEntry = new LDAPEntry(string5, lDAPAttributeSet), this._ldc)) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean createRootObject(String string, LDAPConnection lDAPConnection) {
        boolean bl = false;
        boolean bl2 = false;
        if (!DSUtil.isLocalDirectoryManager(lDAPConnection)) {
            DSUtil.showInformationDialog((Component)this._frame, "addRootEntry-needtobedirectorymanager", (String[])null, "dscontentmodel");
            bl = true;
        }
        if (!bl) {
            ChooseObjectClassDialog chooseObjectClassDialog = new ChooseObjectClassDialog(this._frame, this._schema);
            chooseObjectClassDialog.show();
            ((Window)((Object)chooseObjectClassDialog)).dispose();
            if (!chooseObjectClassDialog.isCancel()) {
                Object object;
                String string2;
                Object object2;
                Object object3;
                String[] stringArray;
                LDAPAttribute lDAPAttribute;
                String string3 = chooseObjectClassDialog.getSelectedValue();
                RDN rDN = new RDN(LDAPDN.explodeDN((String)string, (boolean)false)[0]);
                String[] stringArray2 = rDN.getTypes();
                String[] stringArray3 = rDN.getValues();
                LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
                int n = 0;
                while (n < stringArray2.length) {
                    lDAPAttribute = new LDAPAttribute(stringArray2[n]);
                    stringArray = DatabaseConfig.unQuote(stringArray3[n]);
                    object3 = LDAPDN.unEscapeRDN((String)("cn=" + (String)stringArray));
                    object2 = ((String)object3).substring(3);
                    lDAPAttribute.addValue((String)object2);
                    lDAPAttributeSet.add(lDAPAttribute);
                    ++n;
                }
                stringArray = new String[]{"(targetattr != \"userPassword\") (version 3.0; acl \"Anonymous access\"; allow (read, search, compare)userdn = \"ldap:///anyone\";)", "(targetattr != \"nsroledn || aci || nsLookThroughLimit || nsSizeLimit || nsTimeLimit || nsIdleTimeout || passwordPolicySubentry || passwordExpirationTime || passwordExpWarned || passwordRetryCount || retryCountResetTime || accountUnlockTime || passwordHistory || passwordAllowChangeTime\")(version 3.0; acl \"Allow self entry modification except for nsroledn, aci, resource limit attributes, passwordPolicySubentry and password policy state attributes\"; allow (write)userdn =\"ldap:///self\";)", "(targetattr = \"*\")(version 3.0; acl \"Configuration Administrator\"; allow (all) userdn = \"ldap:///" + this.getAdminDN(lDAPConnection) + "\";)", "(targetattr =\"*\")(version 3.0;acl \"Configuration Administrators Group\";allow (all) (groupdn = \"ldap:///cn=Configuration Administrators, ou=Groups, ou=TopologyManagement, o=NetscapeRoot\");)", "(targetattr = \"*\")(version 3.0; acl \"SIE Group\"; allow (all)groupdn = \"ldap:///" + string + "\";)"};
                lDAPAttribute = new LDAPAttribute("aci", stringArray);
                lDAPAttributeSet.add(lDAPAttribute);
                object3 = new Hashtable();
                DSSchemaHelper.allRequiredAttributes(string3, this._schema, (Hashtable)object3);
                object2 = ((Hashtable)object3).elements();
                while (object2.hasMoreElements()) {
                    string2 = (String)object2.nextElement();
                    boolean bl3 = false;
                    int n2 = 0;
                    while (n2 < stringArray2.length && !bl3) {
                        bl3 = string2.equalsIgnoreCase(stringArray2[n2]);
                        ++n2;
                    }
                    if (bl3) continue;
                    lDAPAttribute = new LDAPAttribute(string2);
                    if (string2.equalsIgnoreCase("objectclass")) {
                        object = DSSchemaHelper.getObjectClassVector(string3, this._schema);
                        int n3 = ((Vector)object).size() - 1;
                        while (n3 >= 0) {
                            lDAPAttribute.addValue((String)((Vector)object).elementAt(n3));
                            --n3;
                        }
                    } else {
                        lDAPAttribute.addValue("");
                    }
                    lDAPAttributeSet.add(lDAPAttribute);
                }
                string2 = new LDAPEntry(string, lDAPAttributeSet);
                LDAPAttributeSet lDAPAttributeSet2 = null;
                DSEntryDialog dSEntryDialog = this.doGenericDialog((LDAPEntry)string2, 0, lDAPConnection);
                if (dSEntryDialog != null) {
                    lDAPAttributeSet2 = dSEntryDialog.getAttributes();
                }
                if (lDAPAttributeSet2 == null) {
                    bl = true;
                }
                if (!bl) {
                    object = new LDAPEntry(dSEntryDialog.getDN(), lDAPAttributeSet2);
                    bl2 = this.addObject((LDAPEntry)object, lDAPConnection);
                }
                if (dSEntryDialog != null) {
                    ModalDialogUtil.disposeAndRaise((JDialog)((Object)dSEntryDialog), (Frame)this._frame);
                }
            }
        }
        return bl2;
    }

    public boolean editObject(String string, LDAPConnection lDAPConnection, boolean bl) {
        String[] stringArray;
        LDAPEntry lDAPEntry;
        boolean bl2 = false;
        this._editedObjectDn = null;
        this._ldc = lDAPConnection;
        if (this._allAttrs == null) {
            lDAPEntry = DSSchemaHelper.getOperationalAttributes(this._schema);
            String[] stringArray2 = null;
            if (lDAPEntry == null) {
                stringArray2 = new String[]{"*"};
            } else {
                stringArray2 = new String[((String[])lDAPEntry).length + 1];
                int n = 0;
                while (n < ((LDAPEntry)lDAPEntry).length) {
                    stringArray2[n] = lDAPEntry[n];
                    ++n;
                }
                stringArray2[((LDAPEntry)lDAPEntry).length] = "*";
            }
            this._allAttrs = stringArray2;
        }
        lDAPEntry = null;
        boolean bl3 = false;
        try {
            lDAPEntry = this._ldc.read(string, this._allAttrs);
        }
        catch (LDAPException lDAPException) {
            stringArray = new String[]{string, DSUtil.getLDAPErrorMessage(lDAPException)};
            DSUtil.showErrorDialog((Component)this._frame, "reading-object-error-title", "reading-object-error-msg", stringArray, "EntryEditor");
            bl3 = true;
        }
        if (lDAPEntry != null) {
            LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("objectclass");
            stringArray = lDAPAttribute.getStringValueArray();
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                arrayList.add(stringArray[n]);
                ++n;
            }
            if (!bl && DSSchemaHelper.isStandardObjectClass(arrayList, this._schema)) {
                String string2;
                ConsoleInfo consoleInfo = new ConsoleInfo();
                consoleInfo.setUserLDAPConnection(this._ldc);
                consoleInfo.setUserHost(this._ldc.getHost());
                consoleInfo.setUserPort(this._ldc.getPort());
                consoleInfo.setLDAPConnection(this._ldc);
                if (this._frame instanceof DSFramework) {
                    consoleInfo.setAdminURL(((DSFramework)((Object)this._frame)).getServerObject().getServerInfo().getAdminURL());
                }
                if ((string2 = this.getRootSuffixForEntry(string)) != null) {
                    consoleInfo.setUserBaseDN(string2);
                }
                DSResourceEditor dSResourceEditor = new DSResourceEditor(this._frame, consoleInfo, lDAPEntry);
                this.updateResourceEditorTitle(dSResourceEditor, stringArray);
                ResEditorReferralURLPage resEditorReferralURLPage = null;
                int n2 = 1;
                while (n2 - 1 < dSResourceEditor.getPageCount() && resEditorReferralURLPage == null) {
                    if (dSResourceEditor.getPage(n2) instanceof ResEditorReferralURLPage) {
                        resEditorReferralURLPage = (ResEditorReferralURLPage)dSResourceEditor.getPage(n2);
                        resEditorReferralURLPage.setConnectionPool(this._connectionPool);
                    }
                    ++n2;
                }
                dSResourceEditor.showModal();
                if (dSResourceEditor.getSaveStatus()) {
                    bl2 = true;
                    this._editedObjectDn = dSResourceEditor.getLDAPEntry().getDN();
                }
                ModalDialogUtil.disposeAndRaise((JDialog)((Object)dSResourceEditor), (Frame)this._frame);
            } else {
                DSEntryDialog dSEntryDialog = this.editGeneric(true, true, lDAPEntry, this._ldc);
                if (dSEntryDialog != null) {
                    bl2 = true;
                    this._editedObjectDn = dSEntryDialog.getDN();
                    ModalDialogUtil.disposeAndRaise((JDialog)((Object)dSEntryDialog), (Frame)this._frame);
                }
            }
        } else if (!bl3) {
            String[] stringArray3 = new String[]{string};
            DSUtil.showErrorDialog((Component)this._frame, "reading-object-no-rights-title", "reading-object-no-rights-msg", stringArray3, "EntryEditor");
        }
        return bl2;
    }

    public LDAPEntry getCreatedObject() {
        return this._createdObject;
    }

    public String getEditedObjectDn() {
        return this._editedObjectDn;
    }

    private String getAdminDN(LDAPConnection lDAPConnection) {
        String string = "uid=admin,ou=Administrators, ou=TopologyManagement, o=NetscapeRoot";
        LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)lDAPConnection.getSearchConstraints().clone();
        lDAPSearchConstraints.setMaxResults(0);
        String[] stringArray = new String[]{"uniquemember"};
        try {
            Enumeration enumeration;
            LDAPAttribute lDAPAttribute;
            LDAPEntry lDAPEntry = lDAPConnection.read("cn=Configuration Administrators, ou=Groups, ou=TopologyManagement, o=NetscapeRoot", stringArray, lDAPSearchConstraints);
            if (lDAPEntry != null && (lDAPAttribute = lDAPEntry.getAttribute("uniquemember")) != null && (enumeration = lDAPAttribute.getStringValues()) != null && enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
            }
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
        return string;
    }

    protected boolean newPredefinedObject(Vector vector, String string) {
        String string2;
        boolean bl = false;
        ConsoleInfo consoleInfo = new ConsoleInfo();
        consoleInfo.setLDAPConnection(this._ldc);
        if (this._ldc.getAuthenticationDN() == null) {
            consoleInfo.setAuthenticationDN("");
            consoleInfo.setAuthenticationPassword("");
        } else {
            consoleInfo.setAuthenticationDN(this._ldc.getAuthenticationDN());
            consoleInfo.setAuthenticationPassword(this._ldc.getAuthenticationPassword());
        }
        consoleInfo.setUserLDAPConnection(this._ldc);
        consoleInfo.setUserHost(this._ldc.getHost());
        consoleInfo.setUserPort(this._ldc.getPort());
        if (this._frame instanceof DSFramework) {
            consoleInfo.setAdminURL(((DSFramework)((Object)this._frame)).getServerObject().getServerInfo().getAdminURL());
        }
        if ((string2 = this.getRootSuffixForEntry(string)) != null) {
            consoleInfo.setUserBaseDN(string2);
        }
        consoleInfo.put("NewUserBaseDN", string);
        ResEditorReferralURLPage resEditorReferralURLPage = null;
        DSResourceEditor dSResourceEditor = null;
        try {
            dSResourceEditor = new DSResourceEditor(this._frame, consoleInfo, vector, string);
            int n = 1;
            while (n - 1 < dSResourceEditor.getPageCount() && resEditorReferralURLPage == null) {
                if (dSResourceEditor.getPage(n) instanceof ResEditorReferralURLPage) {
                    resEditorReferralURLPage = (ResEditorReferralURLPage)dSResourceEditor.getPage(n);
                    resEditorReferralURLPage.setConnectionPool(this._connectionPool);
                }
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("EntryEditor.newPredefinedObject: got" + arrayIndexOutOfBoundsException + " while instantiating a resource editor");
            JOptionPane.showMessageDialog(this._frame, _resource.getString("EntryObject", "role-extension-error"), _resource.getString("EntryObject", "role-extension-title"), 0);
            ModalDialogUtil.sleep();
        }
        if (dSResourceEditor != null) {
            ((JDialog)((Object)dSResourceEditor)).getAccessibleContext().setAccessibleDescription(_resource.getString("EntryEditor", "new-predefined-description"));
            dSResourceEditor.showModal();
            boolean bl2 = dSResourceEditor.getSaveStatus();
            if (bl2) {
                bl = true;
                this._createdObject = dSResourceEditor.getLDAPEntry();
            }
            ModalDialogUtil.disposeAndRaise((JDialog)((Object)dSResourceEditor), (Frame)this._frame);
        }
        return bl;
    }

    private boolean addGeneric(LDAPEntry lDAPEntry, LDAPConnection lDAPConnection) {
        LDAPAttributeSet lDAPAttributeSet = null;
        DSEntryDialog dSEntryDialog = this.doGenericDialog(lDAPEntry, 1, lDAPConnection);
        if (dSEntryDialog != null) {
            lDAPAttributeSet = dSEntryDialog.getAttributes();
        }
        if (lDAPAttributeSet == null) {
            return false;
        }
        LDAPEntry lDAPEntry2 = new LDAPEntry(dSEntryDialog.getDN(), lDAPAttributeSet);
        ModalDialogUtil.disposeAndRaise((JDialog)((Object)dSEntryDialog), (Frame)this._frame);
        return this.addObject(lDAPEntry2, lDAPConnection);
    }

    private boolean addObject(LDAPEntry lDAPEntry, LDAPConnection lDAPConnection) {
        if (lDAPConnection == null) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        while (!bl2) {
            try {
                lDAPConnection.add(lDAPEntry);
                this._createdObject = lDAPEntry;
                bl = true;
                bl2 = true;
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 50) {
                    DSUtil.showPermissionDialog((Component)this._frame, lDAPConnection);
                    bl = false;
                    bl2 = true;
                    continue;
                }
                if (lDAPException.getLDAPResultCode() == 32) {
                    DSUtil.showErrorDialog((Component)this._frame, "noParentForAdd", "", "EntryObject");
                    bl = false;
                    bl2 = true;
                    continue;
                }
                DSUtil.showLDAPErrorDialog(this._frame, lDAPException, "111-title");
                bl = false;
                bl2 = true;
            }
        }
        return bl;
    }

    private DSEntryDialog doGenericDialog(LDAPEntry lDAPEntry, int n, LDAPConnection lDAPConnection) {
        LDAPAttribute lDAPAttribute;
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        int n2 = 0;
        LDAPSchema lDAPSchema = this._schema;
        Enumeration enumeration = lDAPAttributeSet.getAttributes();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
            vector.addElement(lDAPAttribute.getName().toLowerCase());
        }
        lDAPAttribute = new String[vector.size()];
        String[] stringArray = new String[vector.size()];
        n2 = 0;
        while (n2 < ((LDAPAttribute)lDAPAttribute).length) {
            lDAPAttribute[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        DSUtil.trimAndBubbleSort((String[])lDAPAttribute, true);
        n2 = 0;
        while (n2 < ((LDAPAttribute)lDAPAttribute).length) {
            stringArray[n2] = lDAPAttribute[n2];
            ++n2;
        }
        EntryPageDescription entryPageDescription = new EntryPageDescription((String[])lDAPAttribute, stringArray);
        DSPropertyModel dSPropertyModel = new DSPropertyModel(this._schema, lDAPEntry, entryPageDescription);
        DSEntryPanel dSEntryPanel = new DSEntryPanel(dSPropertyModel, n, lDAPConnection);
        DSEntryDialog dSEntryDialog = new DSEntryDialog(this._frame, dSEntryPanel);
        ((Dialog)((Object)dSEntryDialog)).setTitle(_resource.getString("EntryObject", "property-dialog-title", lDAPEntry.getDN()));
        ((JDialog)((Object)dSEntryDialog)).getAccessibleContext().setAccessibleDescription(_resource.getString("EntryObject", "property-dialog-description", lDAPEntry.getDN()));
        ((Window)((Object)dSEntryDialog)).setLocationRelativeTo(this._frame);
        dSEntryDialog.pack();
        int n3 = ((Component)((Object)dSEntryDialog)).getHeight();
        int n4 = ((Component)((Object)dSEntryDialog)).getWidth();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n5 = (int)(3.0 * dimension.getHeight() / 4.0);
        int n6 = (int)(3.0 * dimension.getWidth() / 4.0);
        boolean bl = false;
        if (n5 < n3) {
            n3 = n5;
            bl = true;
        }
        if (n6 < n4) {
            n4 = n6;
            bl = true;
        }
        if (bl) {
            ((Component)((Object)dSEntryDialog)).setSize(n4, n3);
        }
        DialogDisplayerAndDisposer dialogDisplayerAndDisposer = new DialogDisplayerAndDisposer((JDialog)((Object)dSEntryDialog), this._frame);
        if (SwingUtilities.isEventDispatchThread()) {
            dialogDisplayerAndDisposer.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(dialogDisplayerAndDisposer);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (dSEntryDialog.isCancel()) {
            ModalDialogUtil.disposeAndRaise((JDialog)((Object)dSEntryDialog), (Frame)this._frame);
            dSEntryDialog = null;
        }
        return dSEntryDialog;
    }

    public void setSchema(LDAPSchema lDAPSchema) {
        this._schema = lDAPSchema;
    }

    public void setConnectionPool(LDAPConnectionPool lDAPConnectionPool) {
        this._connectionPool = lDAPConnectionPool;
    }

    public LDAPConnectionPool getConnectionPool() {
        return this._connectionPool;
    }

    private DSEntryDialog editGeneric(boolean bl, boolean bl2, LDAPEntry lDAPEntry, LDAPConnection lDAPConnection) {
        DSEntryDialog dSEntryDialog;
        block13: {
            int n = bl ? 1 : 0;
            dSEntryDialog = this.doGenericDialog(lDAPEntry, n, lDAPConnection);
            if (bl2 && dSEntryDialog != null) {
                DN dN;
                boolean bl3;
                LDAPModificationSet lDAPModificationSet = dSEntryDialog.getChanges();
                DN dN2 = new DN(lDAPEntry.getDN());
                boolean bl4 = bl3 = !dN2.equals(dN = new DN(dSEntryDialog.getDN()));
                if (bl3) {
                    try {
                        String string = dN.explodeDN(false)[0];
                        if (lDAPModificationSet != null && lDAPModificationSet.size() > 0) {
                            Object object;
                            String string2;
                            String string3;
                            String string4;
                            RDN rDN;
                            boolean bl5 = true;
                            if (lDAPModificationSet.size() == 1) {
                                rDN = new RDN(string);
                                string4 = new RDN(dN2.explodeDN(false)[0]);
                                if (!rDN.isMultivalued() && !string4.isMultivalued() && (string3 = rDN.getTypes()[0]).equalsIgnoreCase(string2 = string4.getTypes()[0])) {
                                    object = lDAPEntry.getAttribute(string2);
                                    LDAPAttribute lDAPAttribute = lDAPModificationSet.elementAt(0).getAttribute();
                                    if (string2.equalsIgnoreCase(lDAPAttribute.getName()) && object.getStringValueArray().length == 1 && lDAPAttribute.getStringValueArray().length == 1) {
                                        lDAPConnection.rename(lDAPEntry.getDN(), string, true);
                                        bl5 = false;
                                    }
                                }
                            }
                            if (bl5 && (rDN = lDAPEntry.getAttribute("nsuniqueid")) != null) {
                                string4 = (String)rDN.getStringValues().nextElement();
                                string3 = "nsuniqueid=" + string4;
                                lDAPConnection.rename(lDAPEntry.getDN(), string3, false);
                                string2 = dN2.getParent() != null ? string3 + ", " + dN2.getParent() : string3;
                                if (lDAPModificationSet != null && dSEntryDialog != null && !this.saveChanges(lDAPModificationSet, dSEntryDialog.getAttributes(), lDAPConnection, string2)) {
                                    object = dN2.explodeDN(false)[0];
                                    lDAPConnection.rename(string2, (String)object, false);
                                    ModalDialogUtil.disposeAndRaise((JDialog)((Object)dSEntryDialog), (Frame)this._frame);
                                    dSEntryDialog = null;
                                }
                                if (dSEntryDialog != null) {
                                    lDAPConnection.rename(string2, string, false);
                                }
                            }
                            break block13;
                        }
                        lDAPConnection.rename(lDAPEntry.getDN(), string, false);
                    }
                    catch (LDAPException lDAPException) {
                        String[] stringArray = new String[]{lDAPEntry.getDN(), DSUtil.getLDAPErrorMessage(lDAPException)};
                        DSUtil.showErrorDialog((Component)this._frame, "renaming-object-error-title", "renaming-object-error-msg", stringArray, "EntryEditor");
                    }
                } else if (lDAPModificationSet != null && !this.saveChanges(lDAPModificationSet, dSEntryDialog.getAttributes(), lDAPConnection, dSEntryDialog.getDN())) {
                    ModalDialogUtil.disposeAndRaise((JDialog)((Object)dSEntryDialog), (Frame)this._frame);
                    dSEntryDialog = null;
                }
            }
        }
        return dSEntryDialog;
    }

    boolean saveChanges(LDAPModificationSet lDAPModificationSet, LDAPAttributeSet lDAPAttributeSet, LDAPConnection lDAPConnection, String string) {
        boolean bl = true;
        if (lDAPModificationSet != null && lDAPModificationSet.size() > 0) {
            try {
                lDAPConnection.modify(string, lDAPModificationSet);
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 50) {
                    DSUtil.showPermissionDialog((Component)this._frame, lDAPConnection);
                    bl = false;
                }
                if (lDAPException.getLDAPResultCode() == 32) {
                    LDAPEntry lDAPEntry = new LDAPEntry(string, lDAPAttributeSet);
                    bl = this.addObject(lDAPEntry, lDAPConnection);
                }
                DSUtil.showLDAPErrorDialog(this._frame, lDAPException, "111-title");
                bl = false;
            }
        }
        return bl;
    }

    private String getRootSuffixForEntry(String string) {
        String string2 = null;
        DN dN = new DN(string);
        boolean bl = false;
        Enumeration enumeration = this._databaseConfig.getSuffixes().elements();
        while (enumeration.hasMoreElements() && !bl) {
            DN dN2;
            Suffix suffix = (Suffix)enumeration.nextElement();
            if (suffix.getParentSuffix() != null || !dN.equals(dN2 = new DN(suffix.getName())) && !dN.isDescendantOf(dN2)) continue;
            bl = true;
            string2 = suffix.getName();
        }
        return string2;
    }

    private void updateResourceEditorTitle(ResourceEditor resourceEditor, String[] stringArray) {
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length && !bl) {
            if (stringArray[n].equalsIgnoreCase("person")) {
                bl = true;
                resourceEditor.setTitle(_resource.getString("EntryEditor", "edit-user-title"));
            } else if (stringArray[n].equalsIgnoreCase("group")) {
                bl = true;
                resourceEditor.setTitle(_resource.getString("EntryEditor", "edit-group-title"));
            } else if (stringArray[n].equalsIgnoreCase("organizationalunit")) {
                bl = true;
                resourceEditor.setTitle(_resource.getString("EntryEditor", "edit-ou-title"));
            } else if (stringArray[n].equalsIgnoreCase("nsroledefinition")) {
                bl = true;
                resourceEditor.setTitle(_resource.getString("EntryEditor", "edit-role-title"));
            } else if (stringArray[n].equalsIgnoreCase("cossuperdefinition")) {
                bl = true;
                resourceEditor.setTitle(_resource.getString("EntryEditor", "edit-cos-title"));
            } else if (stringArray[n].equalsIgnoreCase("referral")) {
                bl = true;
                resourceEditor.setTitle(_resource.getString("EntryEditor", "edit-referral-title"));
            } else if (stringArray[n].equalsIgnoreCase("passwordpolicy")) {
                bl = true;
                resourceEditor.setTitle(_resource.getString("EntryEditor", "edit-ppol-title"));
            }
            ++n;
        }
    }
}

