/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.browser;

import com.netscape.management.client.util.RemoteImage;
import java.awt.Canvas;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.util.Enumeration;
import java.util.Hashtable;
import netscape.ldap.LDAPAttribute;

public class IconPool {
    public static final int MODIFIER_LEAF = 1;
    public static final int MODIFIER_REFERRAL = 2;
    public static final int MODIFIER_INACTIVATED = 4;
    public static final int MODIFIER_ERROR = 8;
    private Hashtable _iconTable = new Hashtable();
    private Hashtable _pathTable = new Hashtable();
    private RemoteImage _defaultLeafIcon;
    private RemoteImage _defaultContainerIcon;
    private RemoteImage _rootNodeIcon;
    private RemoteImage _errorIcon;
    private RemoteImage _errorMaskIcon;
    private RemoteImage _referralMaskIcon;
    private RemoteImage _inactivatedMaskIcon;
    private static final String IMAGE_PATH = "com/netscape/admin/dirserv/images";
    private static final String[] ICON_PATH = new String[]{"person", "alluser16n.gif", "organization", "folder.gif", "organizationalunit", "ou16.gif", "groupofuniquenames", "allgroup16n.gif", "nsmanagedroledefinition", "mrole.gif", "nsfilteredroledefinition", "frole.gif", "nsnestedroledefinition", "nrole.gif", "cossuperdefinition", "cos16.gif", "passwordpolicy", "ppol16.gif"};

    public IconPool() {
        int n = 0;
        while (n < ICON_PATH.length) {
            this._pathTable.put(ICON_PATH[n], ICON_PATH[n + 1]);
            n += 2;
        }
    }

    public RemoteImage getIcon(LDAPAttribute lDAPAttribute, int n) {
        Object object = this.makeKey(lDAPAttribute, n);
        RemoteImage remoteImage = (RemoteImage)this._iconTable.get(object);
        if (remoteImage == null) {
            remoteImage = this.makeIcon(lDAPAttribute, n);
            this._iconTable.put(object, remoteImage);
        }
        return remoteImage;
    }

    public RemoteImage getDefaultLeafIcon() {
        if (this._defaultLeafIcon == null) {
            this._defaultLeafIcon = new RemoteImage("com/netscape/admin/dirserv/images/genobject.gif");
        }
        return this._defaultLeafIcon;
    }

    public RemoteImage getDefaultContainerIcon() {
        if (this._defaultContainerIcon == null) {
            this._defaultContainerIcon = new RemoteImage("com/netscape/admin/dirserv/images/folder.gif");
        }
        return this._defaultContainerIcon;
    }

    public RemoteImage getIconForRootNode() {
        if (this._rootNodeIcon == null) {
            this._rootNodeIcon = new RemoteImage("com/netscape/admin/dirserv/images/directory.gif");
        }
        return this._rootNodeIcon;
    }

    public RemoteImage getErrorIcon() {
        if (this._errorIcon == null) {
            this._errorIcon = new RemoteImage("com/netscape/admin/dirserv/images/error16.gif");
        }
        return this._errorIcon;
    }

    public RemoteImage getErrorMaskIcon() {
        if (this._errorMaskIcon == null) {
            this._errorMaskIcon = new RemoteImage("com/netscape/admin/dirserv/images/failed.gif");
        }
        return this._errorMaskIcon;
    }

    public RemoteImage getReferralMaskIcon() {
        if (this._referralMaskIcon == null) {
            this._referralMaskIcon = new RemoteImage("com/netscape/admin/dirserv/images/referral.gif");
        }
        return this._referralMaskIcon;
    }

    public RemoteImage getInactivatedMaskIcon() {
        if (this._inactivatedMaskIcon == null) {
            this._inactivatedMaskIcon = new RemoteImage("com/netscape/admin/dirserv/images/inactivated.gif");
        }
        return this._inactivatedMaskIcon;
    }

    private RemoteImage makeIcon(LDAPAttribute lDAPAttribute, int n) {
        RemoteImage remoteImage;
        if (lDAPAttribute == null) {
            remoteImage = this.getDefaultContainerIcon();
        } else {
            String string = null;
            Enumeration enumeration = lDAPAttribute.getStringValues();
            while (enumeration.hasMoreElements() && string == null) {
                String string2 = ((String)enumeration.nextElement()).toLowerCase();
                string = (String)this._pathTable.get(string2);
            }
            remoteImage = string == null ? ((n & 1) != 0 ? this.getDefaultLeafIcon() : this.getDefaultContainerIcon()) : new RemoteImage("com/netscape/admin/dirserv/images/" + string);
        }
        if ((n & 2) != 0) {
            remoteImage = this.getReferralMaskIcon();
        }
        if ((n & 4) != 0) {
            remoteImage = IconPool.maskedIcon(remoteImage, this.getInactivatedMaskIcon());
        }
        if ((n & 8) != 0) {
            remoteImage = IconPool.maskedIcon(remoteImage, this.getErrorMaskIcon());
        }
        return remoteImage;
    }

    private Object makeKey(LDAPAttribute lDAPAttribute, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (lDAPAttribute != null) {
            Enumeration enumeration = lDAPAttribute.getStringValues();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(((String)enumeration.nextElement()).toLowerCase());
            }
        }
        stringBuffer.append(String.valueOf(n));
        return stringBuffer.toString();
    }

    public static RemoteImage maskedIcon(RemoteImage remoteImage, RemoteImage remoteImage2) {
        Object object;
        Object object2;
        int n = 0xFEFDFD;
        int n2 = remoteImage.getIconHeight();
        int n3 = remoteImage.getIconWidth();
        if (remoteImage2.getImageLoadStatus() != 8) {
            return null;
        }
        Image image = remoteImage2.getImage();
        Image image2 = image.getScaledInstance(n3, n2, 4);
        RemoteImage remoteImage3 = new RemoteImage(image2);
        if (remoteImage3.getImageLoadStatus() != 8) {
            return null;
        }
        int[] nArray = new int[n3 * n2];
        try {
            object2 = new PixelGrabber(remoteImage.getImage(), 0, 0, n3, n2, nArray, 0, n3);
            ((PixelGrabber)object2).grabPixels();
            if ((((PixelGrabber)object2).status() & 0x80) != 0) {
                return null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        object2 = new int[n3 * n2];
        try {
            object = new PixelGrabber(remoteImage3.getImage(), 0, 0, n3, n2, (int[])object2, 0, n3);
            ((PixelGrabber)object).grabPixels();
            if ((((PixelGrabber)object).status() & 0x80) != 0) {
                RemoteImage remoteImage4 = null;
                return remoteImage4;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            RemoteImage remoteImage5 = null;
            return remoteImage5;
        }
        object = new int[n3 * n2];
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n3) {
                object[n5 + n4 * n3] = object2[n5 + n4 * n3] != n ? object2[n5 + n4 * n3] : (Object)nArray[n5 + n4 * n3];
                ++n5;
            }
            ++n4;
        }
        Canvas canvas = new Canvas();
        Image image3 = canvas.getToolkit().createImage(new MemoryImageSource(n3, n2, ColorModel.getRGBdefault(), (int[])object, 0, n3));
        RemoteImage remoteImage6 = new RemoteImage(image3);
        return remoteImage6;
    }
}

