/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSExportImport;
import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.IEntryChangeListener;
import com.netscape.admin.dirserv.config.DSConfigPage;
import com.netscape.admin.dirserv.config.Suffix;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.UnsupportedEncodingException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPExtendedOperation;

class BulkInitialize
implements IEntryChangeListener,
Runnable,
ActionListener {
    private DSFramework _framework;
    private GenericProgressDialog _dlg;
    private Suffix _suffix;
    private String _fileName;
    private DSExportImport _ds;
    private boolean _bulkCancelled;
    private static ResourceSet _resource = DSConfigPage._resource;
    private final String START_BULK_INITIALIZE_OID = "2.16.840.1.113730.3.5.7";
    private final String FINISH_BULK_INITIALIZE_OID = "2.16.840.1.113730.3.5.8";

    public BulkInitialize(DSFramework dSFramework, Suffix suffix, String string) {
        this._framework = dSFramework;
        this._suffix = suffix;
        this._fileName = string;
        this.createProgressDialog();
        Thread thread = new Thread(this);
        thread.start();
        this._dlg.packAndShow();
    }

    public void run() {
        boolean bl;
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl2 = bl = !this.launchStartOperation();
        if (bl) {
            this._dlg.closeCallBack();
        } else {
            this._dlg.stepCompleted(0);
            boolean bl3 = bl = !this.doLDAPAdds();
            if (!bl && !this._bulkCancelled) {
                this._dlg.stepCompleted(1);
            }
            boolean bl4 = bl = bl || !this.launchEndOperation();
            if (!bl && !this._bulkCancelled) {
                this._dlg.stepCompleted(2);
            }
            if (!this._bulkCancelled) {
                this.checkRootEntry();
                this._dlg.waitForClose();
                String[] stringArray = new String[]{DSUtil.abreviateString(this._suffix.getName(), 40)};
                if (!bl) {
                    this._dlg.setTextInLabel(_resource.getString("bulkinitialize", "successful-label", stringArray));
                } else {
                    this._dlg.setTextInLabel(_resource.getString("bulkinitialize", "unsuccessful-label", stringArray));
                }
            } else {
                if (!bl) {
                    this.cleanUpSuffix();
                }
                this.checkRootEntry();
                this._dlg.setTextInLabel(_resource.getString("bulkinitialize", "cancelled-label"));
                this._dlg.waitForClose();
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Cancel-GenericProgressDialog") {
            this._dlg.disableCancelButton();
            this._dlg.setTextInLabel(_resource.getString("bulkinitialize", "cancelling-label"));
            this._bulkCancelled = true;
        } else if (string == "Close-GenericProgressDialog") {
            this._dlg.closeCallBack();
        }
    }

    public boolean entryChanged(String string, String string2) {
        boolean bl = false;
        if (!this._bulkCancelled && string != null) {
            if (this._ds.getCurrentEntry() % 30 == 0) {
                String[] stringArray = new String[]{String.valueOf(this._ds.getCurrentEntry()), DSUtil.abreviateString(string, 60)};
                this._dlg.setTextInLabel(_resource.getString("bulkinitialize", "addingentrynumber-label", stringArray));
            }
            if (string2 != null) {
                if (!string.trim().equals("")) {
                    this._dlg.appendTextToTextArea(DSUtil.abreviateString(string, 30) + ": " + string2 + "\n");
                } else {
                    this._dlg.appendTextToTextArea(string2 + "\n");
                }
            }
            bl = true;
        }
        return bl;
    }

    public boolean entryChanged(String string) {
        return this.entryChanged(string, null);
    }

    private void createProgressDialog() {
        this._dlg = new GenericProgressDialog((JFrame)((Object)this._framework), true, 7, _resource.getString("bulkinitialize", "title"), null, this);
        String[] stringArray = new String[]{DSUtil.abreviateString(this._suffix.getName(), 40), DSUtil.inverseAbreviateString(this._fileName, 40)};
        this._dlg.setTextInLabel(_resource.getString("bulkinitialize", "initializing-label", stringArray));
        this._dlg.setLabelRows(2);
        this._dlg.addStep(_resource.getString("bulkinitialize", "initializing-firststep-label"));
        this._dlg.addStep(_resource.getString("bulkinitialize", "initializing-secondstep-label"));
        this._dlg.addStep(_resource.getString("bulkinitialize", "initializing-thirdstep-label"));
        this._dlg.setTextInTextAreaLabel(_resource.getString("bulkinitialize", "status-label"));
        this._dlg.setTextAreaRows(5);
    }

    private boolean launchStartOperation() {
        LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        boolean bl = true;
        try {
            byte[] byArray = this._suffix.getName().getBytes("UTF8");
            LDAPExtendedOperation lDAPExtendedOperation = new LDAPExtendedOperation("2.16.840.1.113730.3.5.7", byArray);
            LDAPExtendedOperation lDAPExtendedOperation2 = lDAPConnection.extendedOperation(lDAPExtendedOperation);
            if (lDAPExtendedOperation2 == null || !lDAPExtendedOperation2.getID().equals("2.16.840.1.113730.3.5.7")) {
                bl = false;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DSUtil.showErrorDialog((Component)((Object)BulkInitialize.this._framework), "error-launching-nogoodresponse-title", "error-launching-nogoodresponse-msg", null, "bulkinitialize", _resource);
                    }
                });
            }
        }
        catch (LDAPException lDAPException) {
            bl = false;
            final String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DSUtil.showErrorDialog((Component)((Object)BulkInitialize.this._framework), "error-launching-title", "error-launching-msg", stringArray, "bulkinitialize", _resource);
                }
            });
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private boolean doLDAPAdds() {
        boolean bl = true;
        LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        this._ds = new DSExportImport(lDAPConnection, this._fileName, true, true, null);
        this._ds.addEntryChangeListener(this);
        this._ds.run();
        boolean bl2 = this._ds.getStatus();
        if (!bl2 && !this._bulkCancelled) {
            bl = false;
            if (this._ds.getError() == 4) {
                String[] stringArray = new String[2];
                stringArray[0] = DSUtil.abreviateString(this._ds.getLastDN(), 45);
                stringArray[1] = Integer.toString(4);
                String[] stringArray2 = stringArray;
                this._dlg.appendTextToTextArea(_resource.getString("bulkinitialize", "adding-ldifsyntaxerror-label", stringArray2) + "\n");
            } else if (this._ds.getError() == 5) {
                int n = this._ds.getEntryCount() + this._ds.getRejectCount() + 1;
                String string = this._ds.getLastDN();
                if (string == null) {
                    String[] stringArray = new String[2];
                    stringArray[0] = Integer.toString(n);
                    stringArray[1] = Integer.toString(5);
                    String[] stringArray3 = stringArray;
                    this._dlg.appendTextToTextArea(_resource.getString("bulkinitialize", "adding-malformed-expression-error-number-label", stringArray3) + "\n");
                } else {
                    String[] stringArray = new String[2];
                    stringArray[0] = DSUtil.abreviateString(string, 45);
                    stringArray[1] = Integer.toString(5);
                    String[] stringArray4 = stringArray;
                    this._dlg.appendTextToTextArea(_resource.getString("bulkinitialize", "adding-malformed-expression-error-dn-label", stringArray4) + "\n");
                }
            } else {
                String[] stringArray = new String[]{Integer.toString(this._ds.getError())};
                this._dlg.appendTextToTextArea(_resource.getString("bulkinitialize", "adding-unknowerror-label", stringArray));
            }
        }
        return bl;
    }

    private boolean launchEndOperation() {
        LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        boolean bl = true;
        try {
            byte[] byArray = this._suffix.getName().getBytes("UTF8");
            LDAPExtendedOperation lDAPExtendedOperation = new LDAPExtendedOperation("2.16.840.1.113730.3.5.8", byArray);
            LDAPExtendedOperation lDAPExtendedOperation2 = lDAPConnection.extendedOperation(lDAPExtendedOperation);
            if (lDAPExtendedOperation2 == null || !lDAPExtendedOperation2.getID().equals("2.16.840.1.113730.3.5.8")) {
                bl = false;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DSUtil.showErrorDialog((Component)((Object)BulkInitialize.this._framework), "error-closing-nogoodresponse-title", "error-closing-nogoodresponse-msg", null, "bulkinitialize", _resource);
                    }
                });
            }
        }
        catch (LDAPException lDAPException) {
            bl = false;
            final String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DSUtil.showErrorDialog((Component)((Object)BulkInitialize.this._framework), "error-closing-title", "error-closing-msg", stringArray, "bulkinitialize", _resource);
                }
            });
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private boolean cleanUpSuffix() {
        LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        boolean bl = false;
        try {
            byte[] byArray = this._suffix.getName().getBytes("UTF8");
            LDAPExtendedOperation lDAPExtendedOperation = new LDAPExtendedOperation("2.16.840.1.113730.3.5.7", byArray);
            LDAPExtendedOperation lDAPExtendedOperation2 = lDAPConnection.extendedOperation(lDAPExtendedOperation);
            if (lDAPExtendedOperation2 != null && lDAPExtendedOperation2.getID().equals("2.16.840.1.113730.3.5.7")) {
                lDAPExtendedOperation = new LDAPExtendedOperation("2.16.840.1.113730.3.5.8", byArray);
                lDAPExtendedOperation2 = lDAPConnection.extendedOperation(lDAPExtendedOperation);
                bl = true;
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DSUtil.showErrorDialog((Component)((Object)BulkInitialize.this._framework), "error-cleaningup-nogoodresponse-title", "error-cleaningup-nogoodresponse-msg", null, "bulkinitialize", _resource);
                    }
                });
            }
        }
        catch (LDAPException lDAPException) {
            final String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DSUtil.showErrorDialog((Component)((Object)BulkInitialize.this._framework), "error-cleaningup-title", "error-cleaningup-msg", stringArray, "bulkinitialize", _resource);
                }
            });
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return bl;
    }

    private void checkRootEntry() {
        LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        boolean bl = false;
        try {
            String[] stringArray = new String[]{"dn"};
            bl = lDAPConnection.read(this._suffix.getName(), stringArray) != null;
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
        if (bl && !this._suffix.hasRootEntry()) {
            this._framework.getServerObject().getDatabaseConfig().notifyRootEntryAdded(this._suffix);
        } else if (!bl && this._suffix.hasRootEntry()) {
            this._framework.getServerObject().getDatabaseConfig().notifyRootEntryDeleted(this._suffix);
        }
    }
}

