/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.ConfigBackupPanel;
import com.netscape.admin.dirserv.config.DSConfigPage;
import com.netscape.admin.dirserv.config.IConfigNode;
import com.netscape.management.client.IMenuItem;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;

public class ConfigBackupNode
extends DefaultMutableTreeNode
implements IConfigNode {
    private DSFramework _framework;
    private String _name;
    private Icon _icon;
    private ConfigBackupPanel _customPanel;
    private boolean _refreshPanelOnRequest;
    private final IMenuItem[] _objectMenuItems = new IMenuItem[0];
    private final IMenuItem[] _contextMenuItems = new IMenuItem[0];
    private static final String BACKUP_ICON_NAME = "backupc.gif";

    public ConfigBackupNode(DSFramework dSFramework) {
        this._framework = dSFramework;
        this._name = DSConfigPage._resource.getString("backupnode", "label");
        this._icon = DSUtil.getPackageImage(BACKUP_ICON_NAME);
    }

    public boolean isLeaf() {
        return true;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this._name;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public Component getCustomPanel() {
        if (this._customPanel == null) {
            this._customPanel = this.createCustomPanel();
        } else if (this._refreshPanelOnRequest) {
            this._customPanel.readAndUpdate();
        }
        this._refreshPanelOnRequest = false;
        return this._customPanel;
    }

    public boolean isRefreshNeededOnExpansion() {
        return false;
    }

    public void refreshNode() {
        this._refreshPanelOnRequest = true;
    }

    public void menuAction(String string) {
    }

    public IMenuItem[] getObjectMenuItems() {
        return this._objectMenuItems;
    }

    public IMenuItem[] getContextMenuItems() {
        return this._contextMenuItems;
    }

    private ConfigBackupPanel createCustomPanel() {
        return new ConfigBackupPanel(this._framework);
    }
}

