/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.ConfigBasePanel;
import com.netscape.admin.dirserv.config.ConfigPanelException;
import com.netscape.admin.dirserv.config.NewChainedSuffixDialog;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.MultilineLabel;
import com.netscape.management.client.util.UITools;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPUrl;
import netscape.ldap.util.DN;

public class ConfigChainingAuthenticationPanel
extends ConfigBasePanel
implements ActionListener {
    private String _suffixDn;
    private String _databaseDn;
    private boolean _isInitializing;
    private boolean _isInitializingComponents;
    private boolean _isCancelled;
    private JPanel _contentPanel;
    private JLabel _lUrl;
    private JLabel _lDn;
    private JLabel _lPassword;
    private JLabel _lConfirmPassword;
    private JTextArea _lCheckList;
    private JButton _bCopyAci;
    private String _aci;
    private JTextField _tfUrl;
    private JTextField _tfDn;
    private JPasswordField _pfPassword;
    private JPasswordField _pfConfirmPassword;
    private String _saveUrl;
    private String _saveDn;
    private String _savePassword;
    private boolean[] _isUrlValidDirty = new boolean[]{true, false};
    private boolean[] _isDnValidDirty = new boolean[]{true, false};
    private boolean[] _isPasswordValidDirty = new boolean[]{true, false};
    private final JLabel REFRESH_LABEL = new JLabel(ConfigBasePanel._resource.getString("chainingauthenticationpanel-reloading", "label"));
    private final MultilineLabel NO_RIGHTS_LABEL = new MultilineLabel(ConfigBasePanel._resource.getString("chainingauthenticationpanel-no-rights", "label"), 2, 50);

    public ConfigChainingAuthenticationPanel(String string, String string2) {
        this.setTitle(ConfigBasePanel._resource.getString("chainingauthenticationpanel", "title"));
        this._helpToken = "configuration-chainingsuffix-authentication-help";
        this._suffixDn = string;
        this._databaseDn = string2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._bCopyAci) {
            StringSelection stringSelection = new StringSelection(this.getAci());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
        }
    }

    public void init() {
        if (!this._isInitializing) {
            this._isInitializing = true;
            this.showComponent(this.REFRESH_LABEL, true);
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        ConfigChainingAuthenticationPanel.this.createContentPanel();
                        ConfigChainingAuthenticationPanel.this.readDataFromServer();
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                ConfigChainingAuthenticationPanel.access$300(1.access$200(this.this$1));
                                1.access$200(this.this$1).showComponent(ConfigChainingAuthenticationPanel.access$400(1.access$200(this.this$1)), false);
                            }
                        });
                    }
                    catch (NullPointerException nullPointerException) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                1.access$200(this.this$1).showComponent((JComponent)ConfigChainingAuthenticationPanel.access$500(1.access$200(this.this$1)), true);
                            }
                        });
                    }
                    catch (LDAPException lDAPException) {
                        String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                        String string = ConfigBasePanel._resource.getString("chainingauthenticationpanel-error-reading", "label", stringArray);
                        SwingUtilities.invokeLater(new Runnable(this, string){
                            private final /* synthetic */ String val$msg;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$msg = string;
                            }

                            public void run() {
                                1.access$200(this.this$1).showComponent((JComponent)new MultilineLabel(this.val$msg, 2, 50), true);
                            }
                        });
                    }
                    ConfigChainingAuthenticationPanel.this._isInitialized = true;
                    ConfigChainingAuthenticationPanel.this._isInitializing = false;
                }

                static /* synthetic */ ConfigChainingAuthenticationPanel access$200(1 var0) {
                    return var0.ConfigChainingAuthenticationPanel.this;
                }
            });
            thread.start();
        }
    }

    public void resetCallback() {
        try {
            this.readDataFromServer();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigChainingAuthenticationPanel.this.initComponentsFromServerValues();
                    ConfigChainingAuthenticationPanel.this.fireValidDirtyChange();
                    ConfigChainingAuthenticationPanel.this.showComponent(ConfigChainingAuthenticationPanel.this._contentPanel, false);
                }
            });
        }
        catch (NullPointerException nullPointerException) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigChainingAuthenticationPanel.this.showComponent((JComponent)ConfigChainingAuthenticationPanel.this.NO_RIGHTS_LABEL, true);
                }
            });
        }
        catch (LDAPException lDAPException) {
            String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            final String string = ConfigBasePanel._resource.getString("chainingauthenticationpanel-error-reading", "label", stringArray);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigChainingAuthenticationPanel.this.showComponent((JComponent)new MultilineLabel(string, 2, 50), true);
                }
            });
        }
    }

    public void okCallback() throws ConfigPanelException {
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        if (this._isUrlValidDirty[1]) {
            lDAPModificationSet.add(2, new LDAPAttribute("nsfarmserverurl", this._tfUrl.getText()));
        }
        if (this._isDnValidDirty[1]) {
            lDAPModificationSet.add(2, new LDAPAttribute("nsmultiplexorbinddn", this._tfDn.getText()));
        }
        if (this._isPasswordValidDirty[1]) {
            lDAPModificationSet.add(2, new LDAPAttribute("nsmultiplexorcredentials", String.valueOf(this._pfPassword.getPassword())));
        }
        if (lDAPModificationSet.size() > 0 && !this._isCancelled) {
            try {
                this.getServerInfo().getLDAPConnection().modify(this._databaseDn, lDAPModificationSet);
                this.resetCallback();
            }
            catch (LDAPException lDAPException) {
                String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                throw new ConfigPanelException(ConfigBasePanel._resource.getString("chainingauthenticationpanel", "updating-server-error-title"), ConfigBasePanel._resource.getString("chainingauthenticationpanel", "updating-server-error-msg", stringArray));
            }
        }
        this._isCancelled = false;
    }

    public void cancelCallback() {
        this._isCancelled = true;
    }

    public boolean needsConfirmation() {
        boolean bl = this._isUrlValidDirty[1] || this._isDnValidDirty[1] || this._isPasswordValidDirty[1];
        return bl;
    }

    public boolean askForConfirmation() {
        int n;
        boolean bl = DSUtil.isLocal(this._framework.getServerObject().getServerInfo().getHost());
        String string = null;
        int n2 = 0;
        boolean bl2 = false;
        try {
            String string2 = this._tfUrl.getText().trim();
            n = string2.indexOf(32);
            if (n > 0) {
                string2 = string2.substring(0, n);
            }
            LDAPUrl lDAPUrl = new LDAPUrl(string2);
            string = lDAPUrl.getHost();
            n2 = lDAPUrl.getPort();
            bl2 = lDAPUrl.isSecure();
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl3 = true;
        if (!bl2) {
            boolean bl4;
            n = DSUtil.showConfirmationDialog((Component)((Object)this._framework), "confirmation-testconnection", (String[])null, "chainingauthenticationpanel", ConfigBasePanel._resource);
            boolean bl5 = bl4 = n == 0;
            if (bl4) {
                String string3 = this._tfDn.getText();
                String string4 = String.valueOf(this._pfPassword.getPassword());
                bl3 = NewChainedSuffixDialog.testAuthentication((JFrame)((Object)this._framework), string3, string4, string, n2, bl);
            }
        }
        return bl3;
    }

    private void createContentPanel() {
        this._contentPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = UIFactory.makeJLabel("chainingauthenticationpanel", "ldescription", ConfigBasePanel._resource);
        jLabel.setLabelFor(this._contentPanel);
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ConfigChainingAuthenticationPanel.this._isInitializingComponents) {
                    try {
                        String string;
                        String string2 = ConfigChainingAuthenticationPanel.this._tfUrl.getText().trim();
                        int n = string2.indexOf(32);
                        if (n > 0) {
                            string = string2.substring(n);
                            string2 = string2.substring(0, n);
                            StringTokenizer stringTokenizer = new StringTokenizer(string);
                            while (stringTokenizer.hasMoreTokens()) {
                                new LDAPUrl("ldap://" + stringTokenizer.nextToken());
                            }
                        }
                        new LDAPUrl(string2);
                        string = ConfigChainingAuthenticationPanel.this._tfUrl.getText().trim();
                        if (!string.endsWith("/")) {
                            throw new Exception();
                        }
                        ((ConfigChainingAuthenticationPanel)ConfigChainingAuthenticationPanel.this)._isUrlValidDirty[0] = true;
                    }
                    catch (Exception exception) {
                        ((ConfigChainingAuthenticationPanel)ConfigChainingAuthenticationPanel.this)._isUrlValidDirty[0] = false;
                    }
                    ((ConfigChainingAuthenticationPanel)ConfigChainingAuthenticationPanel.this)._isUrlValidDirty[1] = !ConfigChainingAuthenticationPanel.this._tfUrl.getText().equals(ConfigChainingAuthenticationPanel.this._saveUrl);
                    ConfigChainingAuthenticationPanel.this.updateColoring(ConfigChainingAuthenticationPanel.this._lUrl, ConfigChainingAuthenticationPanel.this._isUrlValidDirty);
                    ((JTextComponent)ConfigChainingAuthenticationPanel.this._pfPassword).setText("");
                    ((JTextComponent)ConfigChainingAuthenticationPanel.this._pfConfirmPassword).setText("");
                    ConfigChainingAuthenticationPanel.this.fireValidDirtyChange();
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._tfUrl = UIFactory.makeJTextField(documentListener, "chainingauthenticationpanel", "lurl", null, 20, ConfigBasePanel._resource);
        this._lUrl = UIFactory.makeJLabel("chainingauthenticationpanel", "lurl", ConfigBasePanel._resource);
        this._lUrl.setLabelFor(this._tfUrl);
        DocumentListener documentListener2 = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ConfigChainingAuthenticationPanel.this._isInitializingComponents) {
                    ((ConfigChainingAuthenticationPanel)ConfigChainingAuthenticationPanel.this)._isDnValidDirty[0] = DN.isDN((String)ConfigChainingAuthenticationPanel.this._tfDn.getText());
                    ((ConfigChainingAuthenticationPanel)ConfigChainingAuthenticationPanel.this)._isDnValidDirty[1] = !ConfigChainingAuthenticationPanel.this._tfDn.getText().equals(ConfigChainingAuthenticationPanel.this._saveDn);
                    ConfigChainingAuthenticationPanel.this.updateColoring(ConfigChainingAuthenticationPanel.this._lDn, ConfigChainingAuthenticationPanel.this._isDnValidDirty);
                    if (ConfigChainingAuthenticationPanel.this._isDnValidDirty[0]) {
                        ConfigChainingAuthenticationPanel.this.updateAci();
                        String[] stringArray = new String[]{ConfigChainingAuthenticationPanel.this._suffixDn, ConfigChainingAuthenticationPanel.this.getAci()};
                        ConfigChainingAuthenticationPanel.this._lCheckList.setText(ConfigBasePanel._resource.getString("chainingauthenticationpanel", "lchecklist-label", stringArray));
                    }
                    ((JTextComponent)ConfigChainingAuthenticationPanel.this._pfPassword).setText("");
                    ((JTextComponent)ConfigChainingAuthenticationPanel.this._pfConfirmPassword).setText("");
                    ConfigChainingAuthenticationPanel.this.fireValidDirtyChange();
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._tfDn = UIFactory.makeJTextField(documentListener2, "chainingauthenticationpanel", "ldn", null, 20, ConfigBasePanel._resource);
        this._lDn = UIFactory.makeJLabel("chainingauthenticationpanel", "ldn", ConfigBasePanel._resource);
        this._lDn.setLabelFor(this._tfDn);
        DocumentListener documentListener3 = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ConfigChainingAuthenticationPanel.this._isInitializingComponents) {
                    char[] cArray = ConfigChainingAuthenticationPanel.this._pfPassword.getPassword();
                    char[] cArray2 = ConfigChainingAuthenticationPanel.this._pfConfirmPassword.getPassword();
                    ((ConfigChainingAuthenticationPanel)ConfigChainingAuthenticationPanel.this)._isPasswordValidDirty[1] = !ConfigChainingAuthenticationPanel.this._savePassword.equals(new String(cArray));
                    ((ConfigChainingAuthenticationPanel)ConfigChainingAuthenticationPanel.this)._isPasswordValidDirty[0] = cArray.length == cArray2.length;
                    int n = 0;
                    while (n < cArray.length && ConfigChainingAuthenticationPanel.this._isPasswordValidDirty[0]) {
                        ((ConfigChainingAuthenticationPanel)ConfigChainingAuthenticationPanel.this)._isPasswordValidDirty[0] = cArray[n] == cArray2[n];
                        ++n;
                    }
                    ConfigChainingAuthenticationPanel.this.updateColoring(ConfigChainingAuthenticationPanel.this._lPassword, ConfigChainingAuthenticationPanel.this._isPasswordValidDirty);
                    ConfigChainingAuthenticationPanel.this.updateColoring(ConfigChainingAuthenticationPanel.this._lConfirmPassword, ConfigChainingAuthenticationPanel.this._isPasswordValidDirty);
                    ConfigChainingAuthenticationPanel.this.fireValidDirtyChange();
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._pfPassword = UIFactory.makeJPasswordField(documentListener3, "chainingauthenticationpanel", "lpassword", null, 20, ConfigBasePanel._resource);
        this._lPassword = UIFactory.makeJLabel("chainingauthenticationpanel", "lpassword", ConfigBasePanel._resource);
        this._pfPassword.setToolTipText(this._lPassword.getToolTipText());
        this._lPassword.setLabelFor(this._pfPassword);
        this._pfConfirmPassword = UIFactory.makeJPasswordField(documentListener3, "chainingauthenticationpanel", "lconfirmpassword", null, 20, ConfigBasePanel._resource);
        this._lConfirmPassword = UIFactory.makeJLabel("chainingauthenticationpanel", "lconfirmpassword", ConfigBasePanel._resource);
        this._pfConfirmPassword.setToolTipText(this._lConfirmPassword.getToolTipText());
        this._lConfirmPassword.setLabelFor(this._pfConfirmPassword);
        this._lCheckList = new MultilineLabel(null, 4, 20);
        this._bCopyAci = UIFactory.makeJButton(this, "chainingauthenticationpanel", "bcopyaci", ConfigBasePanel._resource);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace());
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this._contentPanel.add((Component)jLabel, gridBagConstraints);
        this.addLine(this._contentPanel, this._lUrl, this._tfUrl);
        this.addLine(this._contentPanel, this._lDn, this._tfDn);
        this.addLine(this._contentPanel, this._lPassword, this._pfPassword);
        this.addLine(this._contentPanel, this._lConfirmPassword, this._pfConfirmPassword);
        JPanel jPanel = new JPanel(new GridBagLayout());
        ((MultilineLabel)this._lCheckList).setLabelFor((Component)jPanel);
        this._contentPanel.add((Component)jPanel, gridBagConstraints);
        CompoundBorder compoundBorder = new CompoundBorder(UITools.createLoweredBorder(), new EmptyBorder(UIFactory.getDifferentSpace(), UIFactory.getComponentSpace(), UIFactory.getDifferentSpace(), UIFactory.getComponentSpace()));
        jPanel.setBorder(compoundBorder);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, UIFactory.getComponentSpace());
        JScrollPane jScrollPane = new JScrollPane(this._lCheckList);
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jScrollPane.getViewport().setBackground(jPanel.getBackground());
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.right = 0;
        jPanel.add((Component)this._bCopyAci, gridBagConstraints);
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this._contentPanel.add(Box.createVerticalGlue(), gridBagConstraints);
    }

    private void readDataFromServer() throws LDAPException {
        LDAPConnection lDAPConnection = this.getServerInfo().getLDAPConnection();
        String[] stringArray = new String[]{"nsfarmserverurl", "nsmultiplexorbinddn", "nsmultiplexorcredentials"};
        LDAPEntry lDAPEntry = lDAPConnection.read(this._databaseDn, stringArray);
        this._saveUrl = this.getValue(lDAPEntry, "nsfarmserverurl");
        this._saveDn = this.getValue(lDAPEntry, "nsmultiplexorbinddn");
        this._savePassword = this.getValue(lDAPEntry, "nsmultiplexorcredentials");
    }

    private void initComponentsFromServerValues() {
        this._isInitializingComponents = true;
        this._tfUrl.setText(this._saveUrl);
        this._tfDn.setText(this._saveDn);
        ((JTextComponent)this._pfPassword).setText(this._savePassword);
        ((JTextComponent)this._pfConfirmPassword).setText(this._savePassword);
        this.updateAci();
        String[] stringArray = new String[]{this._suffixDn, this.getAci()};
        this._lCheckList.setText(ConfigBasePanel._resource.getString("chainingauthenticationpanel", "lchecklist-label", stringArray));
        this._isUrlValidDirty[0] = true;
        this._isUrlValidDirty[1] = false;
        this._isDnValidDirty[0] = true;
        this._isDnValidDirty[1] = false;
        this._isPasswordValidDirty[0] = true;
        this._isPasswordValidDirty[1] = false;
        BlankPanel.setChangeState(this._lUrl, 1);
        BlankPanel.setChangeState(this._lDn, 1);
        BlankPanel.setChangeState(this._lPassword, 1);
        BlankPanel.setChangeState(this._lConfirmPassword, 1);
        this._isInitializingComponents = false;
    }

    private void updateColoring(JLabel jLabel, boolean[] blArray) {
        if (!blArray[0]) {
            BlankPanel.setChangeState(jLabel, 3);
        } else if (blArray[1]) {
            BlankPanel.setChangeState(jLabel, 2);
        } else {
            BlankPanel.setChangeState(jLabel, 1);
        }
    }

    private void addLine(Container container, JLabel jLabel, JTextField jTextField) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = -1;
        container.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        gridBagConstraints.gridwidth = 0;
        container.add((Component)jTextField, gridBagConstraints);
    }

    private String getAci() {
        return this._aci;
    }

    private void updateAci() {
        String string = this._tfDn.getText().trim();
        if (string.equals("")) {
            this._aci = "(targetattr=*)(target = \"ldap:///" + this._suffixDn + "\")(version 3.0;" + "acl \"Allows use of anonymous for chaining\"; allow (proxy) (userdn=\"ldap:///anyone\");)";
        } else {
            String string2 = "";
            if (this._isDnValidDirty[0]) {
                string2 = LDAPDN.explodeDN((String)string, (boolean)true)[0];
            }
            this._aci = "(targetattr=*)(target = \"ldap:///" + this._suffixDn + "\")(version 3.0;" + "acl \"Allows use of " + string2 + " for chaining\"; allow (proxy) (userdn=\"ldap:///" + string + "\");)";
        }
    }

    private void fireValidDirtyChange() {
        boolean bl;
        boolean bl2 = this._isUrlValidDirty[0] && this._isDnValidDirty[0] && this._isPasswordValidDirty[0];
        boolean bl3 = bl = this._isUrlValidDirty[1] || this._isDnValidDirty[1] || this._isPasswordValidDirty[1];
        if (bl) {
            this.setDirtyFlag();
        } else {
            this.clearDirtyFlag();
        }
        if (bl2) {
            this.setValidFlag();
        } else {
            this.clearValidFlag();
        }
    }
}

