/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.config;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.config.ConfigBasePanel;
import com.netscape.admin.dirserv.config.ConfigPanelException;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.MultilineLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;

public class ConfigChainingLimitControlsPanel
extends ConfigBasePanel
implements ActionListener {
    private String _databaseDn;
    private boolean _isInitializing;
    private boolean _isInitializingComponents;
    private boolean _isCancelled;
    private boolean _hasWarningMessage;
    private String _lastReadAttribute;
    private JPanel _contentPanel;
    private JCheckBox _cbReturnReferral;
    private JCheckBox _cbCheckACI;
    private JLabel _lSizeLimit;
    private JLabel _lTimeLimit;
    private JLabel _lMaxHops;
    private JLabel _lMaxTCPConnections;
    private JLabel _lBindTimeout;
    private JLabel _lMaxBinds;
    private JLabel _lMaxBindRetries;
    private JLabel _lTimeoutBeforeAbandon;
    private JLabel _lMaxLDAPConnections;
    private JLabel _lMaxOperations;
    private JLabel _lConnectionLifetime;
    private JCheckBox _cbUnlimitedSizeLimit;
    private JCheckBox _cbUnlimitedTimeLimit;
    private JCheckBox _cbUnlimitedTimeout;
    private JCheckBox _cbUnlimitedTimeoutBeforeAbandon;
    private JCheckBox _cbUnlimitedConnectionLifetime;
    private JTextField _tfSizeLimit;
    private JTextField _tfTimeLimit;
    private JTextField _tfMaxHops;
    private JTextField _tfMaxTCPConnections;
    private JTextField _tfBindTimeout;
    private JTextField _tfMaxBinds;
    private JTextField _tfMaxBindRetries;
    private JTextField _tfTimeoutBeforeAbandon;
    private JTextField _tfMaxLDAPConnections;
    private JTextField _tfMaxOperations;
    private JTextField _tfConnectionLifetime;
    private boolean _saveReturnReferral;
    private boolean _saveCheckACI;
    private int _saveSizeLimit;
    private int _saveTimeLimit;
    private int _saveMaxHops;
    private int _saveMaxTCPConnections;
    private int _saveBindTimeout;
    private int _saveMaxBinds;
    private int _saveMaxBindRetries;
    private int _saveTimeoutBeforeAbandon;
    private int _saveMaxLDAPConnections;
    private int _saveMaxOperations;
    private int _saveConnectionLifetime;
    private boolean _isReturnReferralDirty;
    private boolean _isCheckACIDirty;
    private boolean[] _isSizeLimitValidDirty = new boolean[]{true, false};
    private boolean[] _isTimeLimitValidDirty = new boolean[]{true, false};
    private boolean[] _isMaxHopsValidDirty = new boolean[]{true, false};
    private boolean[] _isMaxTCPConnectionsValidDirty = new boolean[]{true, false};
    private boolean[] _isBindTimeoutValidDirty = new boolean[]{true, false};
    private boolean[] _isMaxBindsValidDirty = new boolean[]{true, false};
    private boolean[] _isMaxBindRetriesValidDirty = new boolean[]{true, false};
    private boolean[] _isTimeoutBeforeAbandonValidDirty = new boolean[]{true, false};
    private boolean[] _isMaxLDAPConnectionsValidDirty = new boolean[]{true, false};
    private boolean[] _isMaxOperationsValidDirty = new boolean[]{true, false};
    private boolean[] _isConnectionLifetimeValidDirty = new boolean[]{true, false};
    private final JLabel REFRESH_LABEL = new JLabel(ConfigBasePanel._resource.getString("serversettingspanel-reloading", "label"));
    private final MultilineLabel NO_RIGHTS_LABEL = new MultilineLabel(ConfigBasePanel._resource.getString("serversettingspanel-no-rights", "label"), 2, 50);

    public ConfigChainingLimitControlsPanel(String string) {
        this.setTitle(ConfigBasePanel._resource.getString("chaininglimitcontrolspanel", "title"));
        this._helpToken = "configuration-chainingsuffix-connection-help";
        this._databaseDn = string;
    }

    public void init() {
        if (!this._isInitializing) {
            this._isInitializing = true;
            this.showComponent(this.REFRESH_LABEL, true);
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        ConfigChainingLimitControlsPanel.this.createContentPanel();
                        ConfigChainingLimitControlsPanel.this.readDataFromServer();
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                ConfigChainingLimitControlsPanel.access$300(1.access$200(this.this$1));
                                1.access$200(this.this$1).showComponent(ConfigChainingLimitControlsPanel.access$400(1.access$200(this.this$1)), false);
                            }
                        });
                    }
                    catch (NullPointerException nullPointerException) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                1.access$200(this.this$1).showComponent((JComponent)ConfigChainingLimitControlsPanel.access$500(1.access$200(this.this$1)), true);
                            }
                        });
                    }
                    catch (NumberFormatException numberFormatException) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                String[] stringArray = new String[]{ConfigChainingLimitControlsPanel.access$600(1.access$200(this.this$1)), ConfigChainingLimitControlsPanel.access$700(1.access$200(this.this$1))};
                                1.access$200(this.this$1).showComponent((JComponent)new MultilineLabel(ConfigBasePanel._resource.getString("chaininglimitcontrolspanel-formatting-error", "label", stringArray), 2, 50), true);
                            }
                        });
                    }
                    catch (LDAPException lDAPException) {
                        String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                        String string = ConfigBasePanel._resource.getString("chaininglimitcontrolspanel-error-reading", "label", stringArray);
                        SwingUtilities.invokeLater(new Runnable(this, string){
                            private final /* synthetic */ String val$msg;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$msg = string;
                            }

                            public void run() {
                                1.access$200(this.this$1).showComponent((JComponent)new MultilineLabel(this.val$msg, 2, 50), true);
                            }
                        });
                    }
                    ConfigChainingLimitControlsPanel.this._isInitialized = true;
                    ConfigChainingLimitControlsPanel.this._isInitializing = false;
                }

                static /* synthetic */ ConfigChainingLimitControlsPanel access$200(1 var0) {
                    return var0.ConfigChainingLimitControlsPanel.this;
                }
            });
            thread.start();
        }
    }

    public void resetCallback() {
        try {
            this.readDataFromServer();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigChainingLimitControlsPanel.this.initComponentsWithValuesFromServer();
                    ConfigChainingLimitControlsPanel.this.fireValidDirtyChange();
                    ConfigChainingLimitControlsPanel.this.showComponent(ConfigChainingLimitControlsPanel.this._contentPanel, false);
                }
            });
        }
        catch (NullPointerException nullPointerException) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigChainingLimitControlsPanel.this.showComponent((JComponent)ConfigChainingLimitControlsPanel.this.NO_RIGHTS_LABEL, true);
                }
            });
        }
        catch (NumberFormatException numberFormatException) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String[] stringArray = new String[]{ConfigChainingLimitControlsPanel.this._lastReadAttribute};
                    ConfigChainingLimitControlsPanel.this.showComponent((JComponent)new MultilineLabel(ConfigBasePanel._resource.getString("chaininglimitcontrolspanel-formatting-error", "label", stringArray), 2, 50), true);
                }
            });
        }
        catch (LDAPException lDAPException) {
            String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
            final String string = ConfigBasePanel._resource.getString("chaininglimitcontrolspanel-error-reading", "label", stringArray);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigChainingLimitControlsPanel.this.showComponent((JComponent)new MultilineLabel(string, 2, 50), true);
                }
            });
        }
    }

    public void okCallback() throws ConfigPanelException {
        this._hasWarningMessage = false;
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        if (this._isReturnReferralDirty) {
            lDAPModificationSet.add(2, new LDAPAttribute("nsreferralonscopedsearch", this._cbReturnReferral.isSelected() ? "on" : "off"));
        }
        if (this._isCheckACIDirty) {
            this._hasWarningMessage = true;
            lDAPModificationSet.add(2, new LDAPAttribute("nschecklocalaci", this._cbCheckACI.isSelected() ? "on" : "off"));
        }
        if (this._isSizeLimitValidDirty[1]) {
            lDAPModificationSet.add(2, new LDAPAttribute("nsslapd-sizelimit", this._cbUnlimitedSizeLimit.isSelected() ? "-1" : this._tfSizeLimit.getText()));
        }
        if (this._isTimeLimitValidDirty[1]) {
            lDAPModificationSet.add(2, new LDAPAttribute("nsslapd-timelimit", this._cbUnlimitedTimeLimit.isSelected() ? "-1" : this._tfTimeLimit.getText()));
        }
        if (this._isMaxHopsValidDirty[1]) {
            lDAPModificationSet.add(2, new LDAPAttribute("nshoplimit", this._tfMaxHops.getText()));
        }
        if (this._isMaxTCPConnectionsValidDirty[1]) {
            lDAPModificationSet.add(2, new LDAPAttribute("nsbindconnectionslimit", this._tfMaxTCPConnections.getText()));
        }
        if (this._isBindTimeoutValidDirty[1]) {
            lDAPModificationSet.add(2, new LDAPAttribute("nsbindtimeout", this._cbUnlimitedTimeout.isSelected() ? "0" : this._tfBindTimeout.getText()));
        }
        if (this._isMaxBindsValidDirty[1]) {
            lDAPModificationSet.add(2, new LDAPAttribute("nsconcurrentbindlimit", this._tfMaxBinds.getText()));
        }
        if (this._isMaxBindRetriesValidDirty[1]) {
            lDAPModificationSet.add(2, new LDAPAttribute("nsbindretrylimit", this._tfMaxBindRetries.getText()));
        }
        if (this._isTimeoutBeforeAbandonValidDirty[1]) {
            this._hasWarningMessage = true;
            lDAPModificationSet.add(2, new LDAPAttribute("nsabandonedsearchcheckinterval", this._cbUnlimitedTimeoutBeforeAbandon.isSelected() ? "0" : this._tfTimeoutBeforeAbandon.getText()));
        }
        if (this._isMaxLDAPConnectionsValidDirty[1]) {
            lDAPModificationSet.add(2, new LDAPAttribute("nsoperationconnectionslimit", this._tfMaxLDAPConnections.getText()));
        }
        if (this._isMaxOperationsValidDirty[1]) {
            lDAPModificationSet.add(2, new LDAPAttribute("nsconcurrentoperationslimit", this._tfMaxOperations.getText()));
        }
        if (this._isConnectionLifetimeValidDirty[1]) {
            lDAPModificationSet.add(2, new LDAPAttribute("nsconnectionlife", this._cbUnlimitedConnectionLifetime.isSelected() ? "0" : this._tfConnectionLifetime.getText()));
        }
        if (lDAPModificationSet.size() > 0 && !this._isCancelled) {
            try {
                this.getServerInfo().getLDAPConnection().modify(this._databaseDn, lDAPModificationSet);
                this.resetCallback();
            }
            catch (LDAPException lDAPException) {
                String[] stringArray = new String[]{DSUtil.getLDAPErrorMessage(lDAPException)};
                throw new ConfigPanelException(ConfigBasePanel._resource.getString("chaininglimitcontrolspanel", "updating-server-error-title"), ConfigBasePanel._resource.getString("chaininglimitcontrolspanel", "updating-server-error-msg", stringArray));
            }
        }
        this._isCancelled = false;
    }

    public void cancelCallback() {
        this._isCancelled = true;
    }

    public boolean hasWarningMessage() {
        return this._hasWarningMessage;
    }

    public void displayWarningMessage() {
        Container container = this.getParent();
        while (!(container instanceof JFrame) && container != null) {
            container = container.getParent();
        }
        DSUtil.showInformationDialog((JFrame)container, "warning", null, "chaininglimitcontrolspanel", ConfigBasePanel._resource);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._cbReturnReferral) {
            boolean bl = this._isReturnReferralDirty = this._saveReturnReferral != this._cbReturnReferral.isSelected();
            if (this._isReturnReferralDirty) {
                BlankPanel.setChangeState(this._cbReturnReferral, 2);
            } else {
                BlankPanel.setChangeState(this._cbReturnReferral, 1);
            }
            this.fireValidDirtyChange();
        } else if (object == this._cbCheckACI) {
            boolean bl = this._isCheckACIDirty = this._saveCheckACI != this._cbCheckACI.isSelected();
            if (this._isCheckACIDirty) {
                BlankPanel.setChangeState(this._cbCheckACI, 2);
            } else {
                BlankPanel.setChangeState(this._cbCheckACI, 1);
            }
            this.fireValidDirtyChange();
        } else if (object == this._cbUnlimitedSizeLimit) {
            this.actionUnlimitedCheckBox(this._cbUnlimitedSizeLimit, this._lSizeLimit, this._tfSizeLimit, this._saveSizeLimit, this._isSizeLimitValidDirty, -1, 0, Integer.MAX_VALUE);
        } else if (object == this._cbUnlimitedTimeLimit) {
            this.actionUnlimitedCheckBox(this._cbUnlimitedTimeLimit, this._lTimeLimit, this._tfTimeLimit, this._saveTimeLimit, this._isTimeLimitValidDirty, -1, 0, Integer.MAX_VALUE);
        } else if (object == this._cbUnlimitedTimeout) {
            this.actionUnlimitedCheckBox(this._cbUnlimitedTimeout, this._lBindTimeout, this._tfBindTimeout, this._saveBindTimeout, this._isBindTimeoutValidDirty, 0, 1, Integer.MAX_VALUE);
        } else if (object == this._cbUnlimitedTimeoutBeforeAbandon) {
            this.actionUnlimitedCheckBox(this._cbUnlimitedTimeoutBeforeAbandon, this._lTimeoutBeforeAbandon, this._tfTimeoutBeforeAbandon, this._saveTimeoutBeforeAbandon, this._isTimeoutBeforeAbandonValidDirty, 0, 1, Integer.MAX_VALUE);
        } else if (object == this._cbUnlimitedConnectionLifetime) {
            this.actionUnlimitedCheckBox(this._cbUnlimitedConnectionLifetime, this._lConnectionLifetime, this._tfConnectionLifetime, this._saveConnectionLifetime, this._isConnectionLifetimeValidDirty, 0, 1, Integer.MAX_VALUE);
        }
    }

    private void createContentPanel() {
        this._contentPanel = new JPanel(new GridBagLayout());
        this._cbReturnReferral = UIFactory.makeJCheckBox(this, "chaininglimitcontrolspanel", "cbreturnreferral", false, ConfigBasePanel._resource);
        this._cbCheckACI = UIFactory.makeJCheckBox(this, "chaininglimitcontrolspanel", "cbcheckaci", false, ConfigBasePanel._resource);
        this._cbUnlimitedSizeLimit = UIFactory.makeJCheckBox(this, "chaininglimitcontrolspanel", "cbunlimitedsizelimit", false, ConfigBasePanel._resource);
        this._cbUnlimitedTimeLimit = UIFactory.makeJCheckBox(this, "chaininglimitcontrolspanel", "cbunlimitedtimelimit", false, ConfigBasePanel._resource);
        this._cbUnlimitedTimeout = UIFactory.makeJCheckBox(this, "chaininglimitcontrolspanel", "cbunlimitedtimeout", false, ConfigBasePanel._resource);
        this._cbUnlimitedTimeoutBeforeAbandon = UIFactory.makeJCheckBox(this, "chaininglimitcontrolspanel", "cbunlimitedtimeoutbeforeabandon", false, ConfigBasePanel._resource);
        this._cbUnlimitedConnectionLifetime = UIFactory.makeJCheckBox(this, "chaininglimitcontrolspanel", "cbunlimitedconnectionlifetime", false, ConfigBasePanel._resource);
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ConfigChainingLimitControlsPanel.this._isInitializingComponents) {
                    ConfigChainingLimitControlsPanel.this.checkField(ConfigChainingLimitControlsPanel.this._tfSizeLimit, ConfigChainingLimitControlsPanel.this._saveSizeLimit, ConfigChainingLimitControlsPanel.this._isSizeLimitValidDirty, ConfigChainingLimitControlsPanel.this._lSizeLimit, 0, Integer.MAX_VALUE);
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._lSizeLimit = UIFactory.makeJLabel("chaininglimitcontrolspanel", "lsizelimit", ConfigBasePanel._resource);
        this._tfSizeLimit = UIFactory.makeJTextField(documentListener, "chaininglimitcontrolspanel", "lsizelimit", null, 10, ConfigBasePanel._resource);
        this._lSizeLimit.setLabelFor(this._tfSizeLimit);
        DocumentListener documentListener2 = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ConfigChainingLimitControlsPanel.this._isInitializingComponents) {
                    ConfigChainingLimitControlsPanel.this.checkField(ConfigChainingLimitControlsPanel.this._tfTimeLimit, ConfigChainingLimitControlsPanel.this._saveTimeLimit, ConfigChainingLimitControlsPanel.this._isTimeLimitValidDirty, ConfigChainingLimitControlsPanel.this._lTimeLimit, 0, Integer.MAX_VALUE);
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._lTimeLimit = UIFactory.makeJLabel("chaininglimitcontrolspanel", "ltimelimit", ConfigBasePanel._resource);
        this._tfTimeLimit = UIFactory.makeJTextField(documentListener2, "chaininglimitcontrolspanel", "ltimelimit", null, 10, ConfigBasePanel._resource);
        this._lTimeLimit.setLabelFor(this._tfTimeLimit);
        DocumentListener documentListener3 = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ConfigChainingLimitControlsPanel.this._isInitializingComponents) {
                    ConfigChainingLimitControlsPanel.this.checkField(ConfigChainingLimitControlsPanel.this._tfMaxHops, ConfigChainingLimitControlsPanel.this._saveMaxHops, ConfigChainingLimitControlsPanel.this._isMaxHopsValidDirty, ConfigChainingLimitControlsPanel.this._lMaxHops, 0, 20);
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._lMaxHops = UIFactory.makeJLabel("chaininglimitcontrolspanel", "lmaxhops", ConfigBasePanel._resource);
        this._tfMaxHops = UIFactory.makeJTextField(documentListener3, "chaininglimitcontrolspanel", "lmaxhops", null, 3, ConfigBasePanel._resource);
        this._lMaxHops.setLabelFor(this._tfMaxHops);
        DocumentListener documentListener4 = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ConfigChainingLimitControlsPanel.this._isInitializingComponents) {
                    ConfigChainingLimitControlsPanel.this.checkField(ConfigChainingLimitControlsPanel.this._tfMaxTCPConnections, ConfigChainingLimitControlsPanel.this._saveMaxTCPConnections, ConfigChainingLimitControlsPanel.this._isMaxTCPConnectionsValidDirty, ConfigChainingLimitControlsPanel.this._lMaxTCPConnections, 1, 50);
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._lMaxTCPConnections = UIFactory.makeJLabel("chaininglimitcontrolspanel", "lmaxtcpconnections", ConfigBasePanel._resource);
        this._tfMaxTCPConnections = UIFactory.makeJTextField(documentListener4, "chaininglimitcontrolspanel", "lmaxtcpconnections", null, 3, ConfigBasePanel._resource);
        this._lMaxTCPConnections.setLabelFor(this._tfMaxTCPConnections);
        DocumentListener documentListener5 = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ConfigChainingLimitControlsPanel.this._isInitializingComponents) {
                    ConfigChainingLimitControlsPanel.this.checkField(ConfigChainingLimitControlsPanel.this._tfBindTimeout, ConfigChainingLimitControlsPanel.this._saveBindTimeout, ConfigChainingLimitControlsPanel.this._isBindTimeoutValidDirty, ConfigChainingLimitControlsPanel.this._lBindTimeout, 1, Integer.MAX_VALUE);
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._lBindTimeout = UIFactory.makeJLabel("chaininglimitcontrolspanel", "lbindtimeout", ConfigBasePanel._resource);
        this._tfBindTimeout = UIFactory.makeJTextField(documentListener5, "chaininglimitcontrolspanel", "lbindtimeout", null, 10, ConfigBasePanel._resource);
        this._lBindTimeout.setLabelFor(this._tfBindTimeout);
        DocumentListener documentListener6 = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ConfigChainingLimitControlsPanel.this._isInitializingComponents) {
                    ConfigChainingLimitControlsPanel.this.checkField(ConfigChainingLimitControlsPanel.this._tfMaxBinds, ConfigChainingLimitControlsPanel.this._saveMaxBinds, ConfigChainingLimitControlsPanel.this._isMaxBindsValidDirty, ConfigChainingLimitControlsPanel.this._lMaxBinds, 1, 25);
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._lMaxBinds = UIFactory.makeJLabel("chaininglimitcontrolspanel", "lmaxbinds", ConfigBasePanel._resource);
        this._tfMaxBinds = UIFactory.makeJTextField(documentListener6, "chaininglimitcontrolspanel", "lmaxbinds", null, 3, ConfigBasePanel._resource);
        this._lMaxBinds.setLabelFor(this._tfMaxBinds);
        DocumentListener documentListener7 = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ConfigChainingLimitControlsPanel.this._isInitializingComponents) {
                    ConfigChainingLimitControlsPanel.this.checkField(ConfigChainingLimitControlsPanel.this._tfMaxBindRetries, ConfigChainingLimitControlsPanel.this._saveMaxBindRetries, ConfigChainingLimitControlsPanel.this._isMaxBindRetriesValidDirty, ConfigChainingLimitControlsPanel.this._lMaxBindRetries, 1, 25);
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._lMaxBindRetries = UIFactory.makeJLabel("chaininglimitcontrolspanel", "lmaxbindretries", ConfigBasePanel._resource);
        this._tfMaxBindRetries = UIFactory.makeJTextField(documentListener7, "chaininglimitcontrolspanel", "lmaxbindretries", null, 3, ConfigBasePanel._resource);
        this._lMaxBindRetries.setLabelFor(this._tfMaxBindRetries);
        DocumentListener documentListener8 = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ConfigChainingLimitControlsPanel.this._isInitializingComponents) {
                    ConfigChainingLimitControlsPanel.this.checkField(ConfigChainingLimitControlsPanel.this._tfTimeoutBeforeAbandon, ConfigChainingLimitControlsPanel.this._saveTimeoutBeforeAbandon, ConfigChainingLimitControlsPanel.this._isTimeoutBeforeAbandonValidDirty, ConfigChainingLimitControlsPanel.this._lTimeoutBeforeAbandon, 1, Integer.MAX_VALUE);
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._lTimeoutBeforeAbandon = UIFactory.makeJLabel("chaininglimitcontrolspanel", "ltimeoutbeforeabandon", ConfigBasePanel._resource);
        this._tfTimeoutBeforeAbandon = UIFactory.makeJTextField(documentListener8, "chaininglimitcontrolspanel", "ltimeoutbeforeabandon", null, 10, ConfigBasePanel._resource);
        this._lTimeoutBeforeAbandon.setLabelFor(this._tfTimeoutBeforeAbandon);
        DocumentListener documentListener9 = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ConfigChainingLimitControlsPanel.this._isInitializingComponents) {
                    ConfigChainingLimitControlsPanel.this.checkField(ConfigChainingLimitControlsPanel.this._tfMaxLDAPConnections, ConfigChainingLimitControlsPanel.this._saveMaxLDAPConnections, ConfigChainingLimitControlsPanel.this._isMaxLDAPConnectionsValidDirty, ConfigChainingLimitControlsPanel.this._lMaxLDAPConnections, 1, 50);
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._lMaxLDAPConnections = UIFactory.makeJLabel("chaininglimitcontrolspanel", "lmaxldapconnections", ConfigBasePanel._resource);
        this._tfMaxLDAPConnections = UIFactory.makeJTextField(documentListener9, "chaininglimitcontrolspanel", "lmaxldapconnections", null, 3, ConfigBasePanel._resource);
        this._lMaxLDAPConnections.setLabelFor(this._tfMaxLDAPConnections);
        DocumentListener documentListener10 = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ConfigChainingLimitControlsPanel.this._isInitializingComponents) {
                    ConfigChainingLimitControlsPanel.this.checkField(ConfigChainingLimitControlsPanel.this._tfMaxOperations, ConfigChainingLimitControlsPanel.this._saveMaxOperations, ConfigChainingLimitControlsPanel.this._isMaxOperationsValidDirty, ConfigChainingLimitControlsPanel.this._lMaxOperations, 0, 50);
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._lMaxOperations = UIFactory.makeJLabel("chaininglimitcontrolspanel", "lmaxoperations", ConfigBasePanel._resource);
        this._tfMaxOperations = UIFactory.makeJTextField(documentListener10, "chaininglimitcontrolspanel", "lmaxoperations", null, 3, ConfigBasePanel._resource);
        this._lMaxOperations.setLabelFor(this._tfMaxOperations);
        DocumentListener documentListener11 = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ConfigChainingLimitControlsPanel.this._isInitializingComponents) {
                    ConfigChainingLimitControlsPanel.this.checkField(ConfigChainingLimitControlsPanel.this._tfConnectionLifetime, ConfigChainingLimitControlsPanel.this._saveConnectionLifetime, ConfigChainingLimitControlsPanel.this._isConnectionLifetimeValidDirty, ConfigChainingLimitControlsPanel.this._lConnectionLifetime, 1, Integer.MAX_VALUE);
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this._lConnectionLifetime = UIFactory.makeJLabel("chaininglimitcontrolspanel", "lconnectionlifetime", ConfigBasePanel._resource);
        this._tfConnectionLifetime = UIFactory.makeJTextField(documentListener11, "chaininglimitcontrolspanel", "lconnectionlifetime", null, 10, ConfigBasePanel._resource);
        this._lConnectionLifetime.setLabelFor(this._tfConnectionLifetime);
        GroupPanel groupPanel = new GroupPanel(ConfigBasePanel._resource.getString("chaininglimitcontrolspanel", "controlclientpanel-label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), UIFactory.getComponentSpace());
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        groupPanel.add((Component)this._cbReturnReferral, gridBagConstraints);
        JComponent[] jComponentArray = new JComponent[]{this._lSizeLimit, this._tfSizeLimit, UIFactory.makeJLabel("chaininglimitcontrolspanel", "lentries", ConfigBasePanel._resource), this._cbUnlimitedSizeLimit};
        this.addLine(groupPanel, jComponentArray);
        ((JLabel)jComponentArray[2]).setLabelFor(this._tfSizeLimit);
        JComponent[] jComponentArray2 = new JComponent[]{this._lTimeLimit, this._tfTimeLimit, UIFactory.makeJLabel("chaininglimitcontrolspanel", "lseconds", ConfigBasePanel._resource), this._cbUnlimitedTimeLimit};
        ((JLabel)jComponentArray[2]).setLabelFor(this._tfTimeLimit);
        this.addLine(groupPanel, jComponentArray2);
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.weighty = 1.0;
        groupPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        GroupPanel groupPanel2 = new GroupPanel(ConfigBasePanel._resource.getString("chaininglimitcontrolspanel", "cascadingchainingpanel-label"));
        gridBagConstraints.weighty = 0.0;
        groupPanel2.add((Component)this._cbCheckACI, gridBagConstraints);
        JComponent[] jComponentArray3 = new JComponent[]{this._lMaxHops, this._tfMaxHops};
        this.addLine(groupPanel2, jComponentArray3);
        gridBagConstraints.weighty = 1.0;
        groupPanel2.add(Box.createVerticalGlue(), gridBagConstraints);
        GroupPanel groupPanel3 = new GroupPanel(ConfigBasePanel._resource.getString("chaininglimitcontrolspanel", "connectionpanel-label"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        groupPanel3.add((Component)jPanel, gridBagConstraints);
        JComponent[] jComponentArray4 = new JComponent[]{this._lMaxLDAPConnections, this._tfMaxLDAPConnections};
        this.addLine(jPanel, jComponentArray4);
        JComponent[] jComponentArray5 = new JComponent[]{this._lMaxBinds, this._tfMaxBinds};
        this.addLine(jPanel, jComponentArray5);
        JComponent[] jComponentArray6 = new JComponent[]{this._lMaxOperations, this._tfMaxOperations};
        this.addLine(jPanel, jComponentArray6);
        jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        groupPanel3.add((Component)jPanel, gridBagConstraints);
        JComponent[] jComponentArray7 = new JComponent[]{this._lMaxTCPConnections, this._tfMaxTCPConnections};
        this.addLine(jPanel, jComponentArray7);
        JComponent[] jComponentArray8 = new JComponent[]{this._lMaxBindRetries, this._tfMaxBindRetries};
        this.addLine(jPanel, jComponentArray8);
        gridBagConstraints.weighty = 1.0;
        jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        jPanel = new JPanel(new GridBagLayout());
        groupPanel3.add((Component)jPanel, gridBagConstraints);
        JComponent[] jComponentArray9 = new JComponent[]{this._lBindTimeout, this._tfBindTimeout, this._cbUnlimitedTimeout};
        this.addLine(jPanel, jComponentArray9);
        JComponent[] jComponentArray10 = new JComponent[]{this._lTimeoutBeforeAbandon, this._tfTimeoutBeforeAbandon, this._cbUnlimitedTimeoutBeforeAbandon};
        this.addLine(jPanel, jComponentArray10);
        JComponent[] jComponentArray11 = new JComponent[]{this._lConnectionLifetime, this._tfConnectionLifetime, this._cbUnlimitedConnectionLifetime};
        this.addLine(jPanel, jComponentArray11);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets = new Insets(UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0, UIFactory.getComponentSpace());
        gridBagConstraints.weightx = 0.0;
        this._contentPanel.add((Component)groupPanel, gridBagConstraints);
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this._contentPanel.add((Component)groupPanel2, gridBagConstraints);
        gridBagConstraints.insets.left = UIFactory.getComponentSpace();
        this._contentPanel.add((Component)groupPanel3, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        this._contentPanel.add(Box.createVerticalGlue(), gridBagConstraints);
    }

    private void readDataFromServer() throws LDAPException, NumberFormatException {
        LDAPConnection lDAPConnection = this.getServerInfo().getLDAPConnection();
        String[] stringArray = new String[]{"nsreferralonscopedsearch", "nschecklocalaci", "nsslapd-sizelimit", "nsslapd-timelimit", "nshoplimit", "nsbindconnectionslimit", "nsbindtimeout", "nsconcurrentbindlimit", "nsbindretrylimit", "nsabandonedsearchcheckinterval", "nsoperationconnectionslimit", "nsconcurrentoperationslimit", "nsconnectionlife"};
        LDAPEntry lDAPEntry = lDAPConnection.read(this._databaseDn, stringArray);
        this._saveReturnReferral = this.getValue(lDAPEntry, "nsreferralonscopedsearch").equalsIgnoreCase("on");
        this._saveCheckACI = this.getValue(lDAPEntry, "nschecklocalaci").equalsIgnoreCase("on");
        this._lastReadAttribute = "nsslapd-sizelimit";
        this._saveSizeLimit = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim());
        this._lastReadAttribute = "nsslapd-timelimit";
        this._saveTimeLimit = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim());
        this._lastReadAttribute = "nshoplimit";
        this._saveMaxHops = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim());
        this._lastReadAttribute = "nsbindconnectionslimit";
        this._saveMaxTCPConnections = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim());
        this._lastReadAttribute = "nsbindtimeout";
        this._saveBindTimeout = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim());
        this._lastReadAttribute = "nsconcurrentbindlimit";
        this._saveMaxBinds = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim());
        this._lastReadAttribute = "nsbindretrylimit";
        this._saveMaxBindRetries = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim());
        this._lastReadAttribute = "nsabandonedsearchcheckinterval";
        this._saveTimeoutBeforeAbandon = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim());
        this._lastReadAttribute = "nsoperationconnectionslimit";
        this._saveMaxLDAPConnections = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim());
        this._lastReadAttribute = "nsconcurrentoperationslimit";
        this._saveMaxOperations = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim());
        this._lastReadAttribute = "nsconnectionlife";
        this._saveConnectionLifetime = Integer.parseInt(this.getValue(lDAPEntry, this._lastReadAttribute).trim());
    }

    private void initComponentsWithValuesFromServer() {
        this._isInitializingComponents = true;
        this._cbReturnReferral.setSelected(this._saveReturnReferral);
        this._cbCheckACI.setSelected(this._saveCheckACI);
        this._cbUnlimitedSizeLimit.setSelected(this._saveSizeLimit == -1);
        this._cbUnlimitedTimeLimit.setSelected(this._saveTimeLimit == -1);
        this._cbUnlimitedTimeout.setSelected(this._saveBindTimeout == 0);
        this._cbUnlimitedTimeoutBeforeAbandon.setSelected(this._saveTimeoutBeforeAbandon == 0);
        this._cbUnlimitedConnectionLifetime.setSelected(this._saveConnectionLifetime == 0);
        this._tfSizeLimit.setText(String.valueOf(this._saveSizeLimit));
        this._tfTimeLimit.setText(String.valueOf(this._saveTimeLimit));
        this._tfMaxHops.setText(String.valueOf(this._saveMaxHops));
        this._tfMaxTCPConnections.setText(String.valueOf(this._saveMaxTCPConnections));
        this._tfBindTimeout.setText(String.valueOf(this._saveBindTimeout));
        this._tfMaxBinds.setText(String.valueOf(this._saveMaxBinds));
        this._tfMaxBindRetries.setText(String.valueOf(this._saveMaxBindRetries));
        this._tfTimeoutBeforeAbandon.setText(String.valueOf(this._saveTimeoutBeforeAbandon));
        this._tfMaxLDAPConnections.setText(String.valueOf(this._saveMaxLDAPConnections));
        this._tfMaxOperations.setText(String.valueOf(this._saveMaxOperations));
        this._tfConnectionLifetime.setText(String.valueOf(this._saveConnectionLifetime));
        this._isReturnReferralDirty = false;
        this._isCheckACIDirty = false;
        this._isSizeLimitValidDirty[0] = true;
        this._isSizeLimitValidDirty[1] = false;
        this._isTimeLimitValidDirty[0] = true;
        this._isTimeLimitValidDirty[1] = false;
        this._isMaxHopsValidDirty[0] = true;
        this._isMaxHopsValidDirty[1] = false;
        this._isMaxTCPConnectionsValidDirty[0] = true;
        this._isMaxTCPConnectionsValidDirty[1] = false;
        this._isBindTimeoutValidDirty[0] = true;
        this._isBindTimeoutValidDirty[1] = false;
        this._isMaxBindsValidDirty[0] = true;
        this._isMaxBindsValidDirty[1] = false;
        this._isMaxBindRetriesValidDirty[0] = true;
        this._isMaxBindRetriesValidDirty[1] = false;
        this._isTimeoutBeforeAbandonValidDirty[0] = true;
        this._isTimeoutBeforeAbandonValidDirty[1] = false;
        this._isMaxLDAPConnectionsValidDirty[0] = true;
        this._isMaxLDAPConnectionsValidDirty[1] = false;
        this._isMaxOperationsValidDirty[0] = true;
        this._isMaxOperationsValidDirty[1] = false;
        this._isConnectionLifetimeValidDirty[0] = true;
        this._isConnectionLifetimeValidDirty[1] = false;
        BlankPanel.setChangeState(this._cbReturnReferral, 1);
        BlankPanel.setChangeState(this._cbCheckACI, 1);
        BlankPanel.setChangeState(this._lSizeLimit, 1);
        BlankPanel.setChangeState(this._lTimeLimit, 1);
        BlankPanel.setChangeState(this._lMaxHops, 1);
        BlankPanel.setChangeState(this._lMaxTCPConnections, 1);
        BlankPanel.setChangeState(this._lBindTimeout, 1);
        BlankPanel.setChangeState(this._lMaxBinds, 1);
        BlankPanel.setChangeState(this._lMaxBindRetries, 1);
        BlankPanel.setChangeState(this._lTimeoutBeforeAbandon, 1);
        BlankPanel.setChangeState(this._lMaxLDAPConnections, 1);
        BlankPanel.setChangeState(this._lMaxOperations, 1);
        BlankPanel.setChangeState(this._lConnectionLifetime, 1);
        this._tfSizeLimit.setEnabled(!this._cbUnlimitedSizeLimit.isSelected());
        this._tfTimeLimit.setEnabled(!this._cbUnlimitedTimeLimit.isSelected());
        this._tfBindTimeout.setEnabled(!this._cbUnlimitedTimeout.isSelected());
        this._tfTimeoutBeforeAbandon.setEnabled(!this._cbUnlimitedTimeoutBeforeAbandon.isSelected());
        this._tfConnectionLifetime.setEnabled(!this._cbUnlimitedConnectionLifetime.isSelected());
        this._isInitializingComponents = false;
    }

    private void actionUnlimitedCheckBox(JCheckBox jCheckBox, JLabel jLabel, JTextField jTextField, int n, boolean[] blArray, int n2, int n3, int n4) {
        boolean bl = jCheckBox.isSelected();
        jTextField.setEnabled(!bl);
        if (bl) {
            blArray[0] = true;
            blArray[1] = n != n2;
        } else {
            try {
                int n5 = Integer.parseInt(jTextField.getText());
                blArray[0] = n5 >= n3 && n5 <= n4;
                blArray[1] = n5 != n;
            }
            catch (NumberFormatException numberFormatException) {
                blArray[0] = false;
                blArray[1] = true;
            }
        }
        if (!blArray[0]) {
            BlankPanel.setChangeState(jLabel, 3);
        } else if (blArray[1]) {
            BlankPanel.setChangeState(jLabel, 2);
        } else {
            BlankPanel.setChangeState(jLabel, 1);
        }
        this.fireValidDirtyChange();
    }

    private void checkField(JTextField jTextField, int n, boolean[] blArray, JLabel jLabel, int n2, int n3) {
        try {
            int n4 = Integer.parseInt(jTextField.getText());
            blArray[0] = n4 >= n2 && n4 <= n3;
            blArray[1] = n4 != n;
        }
        catch (NumberFormatException numberFormatException) {
            blArray[0] = false;
            blArray[1] = true;
        }
        if (!blArray[0]) {
            BlankPanel.setChangeState(jLabel, 3);
        } else if (blArray[1]) {
            BlankPanel.setChangeState(jLabel, 2);
        } else {
            BlankPanel.setChangeState(jLabel, 1);
        }
        this.fireValidDirtyChange();
    }

    private void addLine(Container container, JComponent[] jComponentArray) {
        this.addLine(container, jComponentArray, false);
    }

    private void addLine(Container container, JComponent[] jComponentArray, boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, UIFactory.getComponentSpace(), UIFactory.getComponentSpace(), 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = bl ? jComponentArray.length : jComponentArray.length + 1;
        container.add((Component)jComponentArray[0], gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        int n = 1;
        while (n < jComponentArray.length - 1) {
            --gridBagConstraints.gridwidth;
            container.add((Component)jComponentArray[n], gridBagConstraints);
            ++n;
        }
        gridBagConstraints.insets.right = UIFactory.getComponentSpace();
        int n2 = gridBagConstraints.gridwidth = bl ? 0 : -1;
        if (bl) {
            gridBagConstraints.weightx = 1.0;
        }
        container.add((Component)jComponentArray[jComponentArray.length - 1], gridBagConstraints);
        if (!bl) {
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets.left = 0;
            gridBagConstraints.insets.right = 0;
            gridBagConstraints.gridwidth = 0;
            container.add(Box.createHorizontalGlue(), gridBagConstraints);
        }
    }

    private void fireValidDirtyChange() {
        boolean bl;
        boolean bl2;
        boolean bl3 = bl2 = this._isReturnReferralDirty || this._isCheckACIDirty || this._isSizeLimitValidDirty[1] || this._isTimeLimitValidDirty[1] || this._isMaxHopsValidDirty[1] || this._isMaxTCPConnectionsValidDirty[1] || this._isBindTimeoutValidDirty[1] || this._isMaxBindsValidDirty[1] || this._isMaxBindRetriesValidDirty[1] || this._isTimeoutBeforeAbandonValidDirty[1] || this._isMaxLDAPConnectionsValidDirty[1] || this._isMaxOperationsValidDirty[1] || this._isConnectionLifetimeValidDirty[1];
        if (bl2) {
            this.setDirtyFlag();
        } else {
            this.clearDirtyFlag();
        }
        boolean bl4 = bl = this._isSizeLimitValidDirty[0] && this._isTimeLimitValidDirty[0] && this._isMaxHopsValidDirty[0] && this._isMaxTCPConnectionsValidDirty[0] && this._isBindTimeoutValidDirty[0] && this._isMaxBindsValidDirty[0] && this._isMaxBindRetriesValidDirty[0] && this._isTimeoutBeforeAbandonValidDirty[0] && this._isMaxLDAPConnectionsValidDirty[0] && this._isMaxOperationsValidDirty[0] && this._isConnectionLifetimeValidDirty[0];
        if (bl) {
            this.setValidFlag();
        } else {
            this.clearValidFlag();
        }
    }

    static /* synthetic */ String access$700(ConfigChainingLimitControlsPanel configChainingLimitControlsPanel) {
        return configChainingLimitControlsPanel._databaseDn;
    }
}

